/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.CommentRule;

public final class CommentSupport {
    private final @Nullable CommentRule comments;

    public CommentSupport(@Nullable CommentRule comments) {
        this.comments = comments;
    }

    private boolean isInComment(IDocument document, int offset) {
        block3: {
            try {
                if (!this.isInBlockComment(document.get(0, offset))) break block3;
                return true;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        int line = document.getLineOfOffset(offset);
        int lineOffset = document.getLineOffset(line);
        return this.isInLineComment(document.get(lineOffset, offset - lineOffset));
    }

    public @Nullable String getLineComment() {
        CommentRule comments = this.comments;
        return comments == null ? null : comments.lineComment;
    }

    public @Nullable CharacterPair getBlockComment() {
        CommentRule comments = this.comments;
        return comments == null ? null : comments.blockComment;
    }

    private boolean isInLineComment(String indexLinePrefix) {
        CommentRule comments = this.comments;
        if (comments == null) {
            return false;
        }
        String lineComment = comments.lineComment;
        if (lineComment == null) {
            return false;
        }
        return indexLinePrefix.indexOf(lineComment) != -1;
    }

    private boolean isInBlockComment(String indexPrefix) {
        CommentRule comments = this.comments;
        if (comments == null) {
            return false;
        }
        CharacterPair blockComment = comments.blockComment;
        if (blockComment == null) {
            return false;
        }
        String commentOpen = blockComment.open;
        String commentClose = blockComment.close;
        int index = indexPrefix.indexOf(commentOpen);
        while (index != -1 && index < indexPrefix.length()) {
            int closeIndex = indexPrefix.indexOf(commentClose, index + commentOpen.length());
            if (closeIndex == -1) {
                return true;
            }
            index = indexPrefix.indexOf(commentOpen, closeIndex + commentClose.length());
        }
        return false;
    }
}

