/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.MavenCli;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.MavenSettingsLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProperties {
    private static final String MVN_MAVEN_CONFIG = ".mvn/maven.config";
    private static final Logger log = LoggerFactory.getLogger(MavenProperties.class);
    private static final String BUILD_VERSION_PROPERTY = "version";
    private static final String BUILD_VERSION_UNKNOWN_PROPERTY = "<version unknown>";
    private static String mavenVersion;
    private static String mavenBuildVersion;
    private static Map<File, MavenProperties> mavenProperties;
    private File configFile;
    private CommandLine commandline;
    private long lastModified;
    private long lastSize;

    static {
        mavenProperties = new ConcurrentHashMap<File, MavenProperties>();
        Properties properties = MavenProperties.getMavenRuntimeProperties();
        mavenVersion = properties.getProperty(BUILD_VERSION_PROPERTY, BUILD_VERSION_UNKNOWN_PROPERTY);
        mavenBuildVersion = MavenProperties.createMavenVersionString(properties);
    }

    private MavenProperties(File configFile) {
        this.configFile = configFile;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    private synchronized boolean checkForUpdate() throws IOException {
        if (this.configFile.isFile()) {
            long modified = this.configFile.lastModified();
            long size = this.configFile.length();
            if (this.commandline == null || this.lastModified != modified || size != this.lastSize) {
                ArrayList<String> args = new ArrayList<String>();
                String[] stringArray = new String(Files.readAllBytes(this.configFile.toPath())).split("\\s+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    if (!arg.isEmpty()) {
                        args.add(arg);
                    }
                    ++n2;
                }
                CLIManager manager = new CLIManager();
                try {
                    this.commandline = manager.parse((String[])args.toArray(String[]::new));
                }
                catch (ParseException ex) {
                    throw new IOException("Couldn't parse file " + String.valueOf(this.configFile), ex);
                }
            }
            this.lastModified = modified;
            this.lastSize = size;
            return true;
        }
        this.commandline = null;
        this.lastModified = -1L;
        this.lastSize = -1L;
        return false;
    }

    private synchronized CommandLine getCommandline() {
        return this.commandline;
    }

    static Properties getMavenRuntimeProperties() {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream resourceAsStream = MavenCli.class.getResourceAsStream("/org/apache/maven/messages/build.properties");){
                if (resourceAsStream != null) {
                    properties.load(resourceAsStream);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Unable to read Maven properties from JAR file: {}", (Object)e.getMessage());
        }
        return properties;
    }

    static String createMavenVersionString(Properties buildProperties) {
        String timestamp = MavenProperties.reduce(buildProperties.getProperty("timestamp"));
        String version = MavenProperties.reduce(buildProperties.getProperty(BUILD_VERSION_PROPERTY));
        String rev = MavenProperties.reduce(buildProperties.getProperty("buildNumber"));
        String distributionName = MavenProperties.reduce(buildProperties.getProperty("distributionName"));
        String msg = distributionName + " ";
        msg = msg + (version != null ? version : BUILD_VERSION_UNKNOWN_PROPERTY);
        if (rev != null || timestamp != null) {
            msg = msg + " (";
            msg = msg + (rev != null ? rev : "");
            if (timestamp != null && !timestamp.isBlank()) {
                String ts = MavenProperties.formatTimestamp(Long.parseLong(timestamp));
                msg = msg + (rev != null ? "; " : "") + ts;
            }
            msg = msg + ")";
        }
        return msg;
    }

    private static String reduce(String s) {
        return s != null ? (s.startsWith("${") && s.endsWith("}") ? null : s) : null;
    }

    private static String formatTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        return sdf.format(new Date(timestamp));
    }

    public static String getMavenBuildVersion() {
        return mavenBuildVersion;
    }

    public static String getMavenVersion() {
        return mavenVersion;
    }

    public static void setProperties(Properties properties) {
        if (properties != null) {
            properties.setProperty("maven.version", mavenVersion);
            properties.setProperty("maven.build.version", mavenBuildVersion);
        }
    }

    public static File computeMultiModuleProjectDirectory(IResource resource) {
        if (resource == null) {
            return null;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return MavenProperties.computeMultiModuleProjectDirectory(location.toFile());
    }

    public static File computeMultiModuleProjectDirectory(File file) {
        if (file == null) {
            return null;
        }
        File basedir = file.isDirectory() ? file : file.getParentFile();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceRoot = workspace.getRoot().getLocation().toFile();
        File root = basedir;
        while (root != null && !root.equals(workspaceRoot)) {
            if (new File(root, ".mvn").isDirectory()) {
                return root;
            }
            root = root.getParentFile();
        }
        return null;
    }

    public static Optional<MavenProperties> getMavenArgs(File multiModuleProjectDirectory) throws IOException {
        MavenProperties properties;
        File configFile;
        if (multiModuleProjectDirectory != null && (configFile = new File(multiModuleProjectDirectory, MVN_MAVEN_CONFIG)).isFile() && (properties = mavenProperties.computeIfAbsent(configFile, MavenProperties::new)).checkForUpdate()) {
            return Optional.of(properties);
        }
        return Optional.empty();
    }

    public void getProfiles(Consumer<String> activeProfilesConsumer, Consumer<String> inactiveProfilesConsumer) {
        String[] profileOptionValues;
        CommandLine commandline = this.getCommandline();
        if (commandline != null && commandline.hasOption('P') && (profileOptionValues = commandline.getOptionValues('P')) != null) {
            String[] stringArray = profileOptionValues;
            int n = profileOptionValues.length;
            int n2 = 0;
            while (n2 < n) {
                String profileOptionValue = stringArray[n2];
                StringTokenizer tokenizer = new StringTokenizer(profileOptionValue, ",");
                while (tokenizer.hasMoreTokens()) {
                    MavenProperties.getProfile(tokenizer.nextToken().trim(), activeProfilesConsumer, inactiveProfilesConsumer);
                }
                ++n2;
            }
        }
    }

    public static void getProfile(String profile, Consumer<String> activeProfilesConsumer, Consumer<String> inactiveProfilesConsumer) {
        if (profile.startsWith("-") || profile.startsWith("!")) {
            inactiveProfilesConsumer.accept(profile.substring(1));
        } else if (profile.startsWith("+")) {
            activeProfilesConsumer.accept(profile.substring(1));
        } else {
            activeProfilesConsumer.accept(profile);
        }
    }

    public void getCliProperties(BiConsumer<String, String> consumer) {
        String[] defStrs;
        CommandLine commandline = this.getCommandline();
        if (commandline != null && commandline.hasOption('D') && (defStrs = commandline.getOptionValues('D')) != null) {
            String[] stringArray = defStrs;
            int n = defStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String defStr = stringArray[n2];
                MavenProperties.getCliProperty(defStr, consumer);
                ++n2;
            }
        }
    }

    public String getAlternateGlobalSettingsFile() {
        CommandLine commandline = this.getCommandline();
        if (commandline != null && commandline.hasOption("gs")) {
            return commandline.getOptionValue("gs");
        }
        return null;
    }

    public String getAlternateUserSettingsFile() {
        CommandLine commandline = this.getCommandline();
        if (commandline != null && commandline.hasOption('s')) {
            return commandline.getOptionValue('s');
        }
        return null;
    }

    public String getAlternateGlobalToolchainsFile() {
        CommandLine commandline = this.getCommandline();
        if (commandline != null && commandline.hasOption("gt")) {
            return commandline.getOptionValue('s');
        }
        return null;
    }

    public String getAlternateUserToolchainsFile() {
        CommandLine commandline = this.getCommandline();
        if (commandline != null && commandline.hasOption('t')) {
            return commandline.getOptionValue('t');
        }
        return null;
    }

    public MavenSettingsLocations getSettingsLocations(IMavenConfiguration configuration) {
        File s;
        File gs;
        MavenSettingsLocations configurationLocations = configuration.getSettingsLocations();
        String alternateGlobalSettingsFile = this.getAlternateGlobalSettingsFile();
        String alternateUserSettingsFile = this.getAlternateUserSettingsFile();
        if (alternateGlobalSettingsFile == null && alternateUserSettingsFile == null) {
            return configurationLocations;
        }
        File baseDir = this.configFile.getParentFile().getParentFile();
        File global = alternateGlobalSettingsFile == null ? configurationLocations.globalSettings() : ((gs = new File(alternateGlobalSettingsFile)).isAbsolute() ? gs : new File(baseDir, alternateGlobalSettingsFile));
        File user = alternateUserSettingsFile == null ? configurationLocations.userSettings() : ((s = new File(alternateUserSettingsFile)).isAbsolute() ? s : new File(baseDir, alternateUserSettingsFile));
        return new MavenSettingsLocations(global, user);
    }

    public static void getCliProperty(String property, BiConsumer<String, String> consumer) {
        int index = property.indexOf(61);
        if (index <= 0) {
            consumer.accept(property.trim(), "true");
        } else {
            consumer.accept(property.substring(0, index).trim(), property.substring(index + 1).trim());
        }
    }
}

