/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.nio.charset.Charset;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.utils.CharsInputStream;

public final class DocumentInputStream
extends CharsInputStream {
    private static Charset getCharset(IDocument document) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        if (bufferManager == null) {
            return Charset.defaultCharset();
        }
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(document);
        if (buffer == null) {
            return Charset.defaultCharset();
        }
        try {
            String charsetName = buffer.getEncoding();
            if (charsetName != null) {
                return Charset.forName(charsetName);
            }
        }
        catch (Exception ex) {
            TMUIPlugin.logError(ex);
        }
        return Charset.defaultCharset();
    }

    public DocumentInputStream(IDocument doc) {
        super(arg_0 -> ((IDocument)doc).getChar(arg_0), () -> ((IDocument)doc).getLength(), DocumentInputStream.getCharset(doc));
    }
}

