/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaDtdDetailsSection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.PDESourceViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractSchemaDetails
extends PDEDetails {
    protected static final String[] BOOLS = new String[]{Boolean.toString(true), Boolean.toString(false)};
    protected int minLabelWeight;
    private Section fSection;
    private SchemaDtdDetailsSection fDtdSection = null;
    private final ElementSection fElementSection;
    private final boolean fShowDTD;
    private final boolean fShowDescription;
    private Spinner fMinOccurSpinner;
    private Spinner fMaxOccurSpinner;
    private Button fUnboundSelect;
    private Label fMinLabel;
    private Label fMaxLabel;
    private PDESourceViewer fDescriptionViewer = null;
    private boolean fBlockListeners = false;
    private ISchemaObject fSchemaObject;

    public AbstractSchemaDetails(ElementSection section, boolean showDTD, boolean showDescription) {
        this.fElementSection = section;
        this.fShowDTD = showDTD;
        this.fShowDescription = showDescription;
    }

    public void modelChanged(IModelChangedEvent event) {
        Object[] objects;
        if (event.getChangeType() == 2 || !this.fShowDTD || this.fDtdSection == null) {
            return;
        }
        Object[] objectArray = objects = event.getChangedObjects();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ISchemaCompositor) {
                this.fDtdSection.updateDTDLabel(object);
            }
            ++n2;
        }
    }

    public final void createContents(Composite parent) {
        GC gc = new GC((Drawable)parent);
        this.minLabelWeight = gc.textExtent((String)PDEUIMessages.SchemaDetails_translatable).x + 11;
        gc.dispose();
        gc = null;
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout(false, 1));
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.fSection = toolkit.createSection(parent, 384);
        this.fSection.clientVerticalSpacing = 6;
        this.fSection.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData gd = this.fShowDescription ? new GridData(1808) : new GridData(768);
        this.fSection.setLayoutData((Object)gd);
        this.getPage().alignSectionHeaders(this.fElementSection.getSection(), this.fSection);
        Composite client = toolkit.createComposite((Composite)this.fSection);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        this.createDetails(client);
        if (this.fShowDescription) {
            this.createDescription(client, toolkit);
        }
        if (this.fShowDTD) {
            this.fDtdSection = new SchemaDtdDetailsSection();
            this.fDtdSection.initialize(this.getManagedForm());
            this.fDtdSection.createContents(parent);
        }
        toolkit.paintBordersFor(client);
        this.fSection.setClient((Control)client);
        this.markDetailsPart((Control)this.fSection);
        if (this.fShowDescription) {
            this.fDescriptionViewer.createUIListeners();
        }
        this.hookListeners();
    }

    private void createDescription(Composite container, FormToolkit toolkit) {
        Label label = toolkit.createLabel(container, PDEUIMessages.AbstractSchemaDetails_descriptionLabel);
        GridData gd = new GridData(2);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fDescriptionViewer = new PDESourceViewer(this.getPage());
        gd = new GridData(1808);
        gd.heightHint = 75;
        gd.widthHint = 60;
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 1;
        this.fDescriptionViewer.createUI(container, gd);
        this.fDescriptionViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (AbstractSchemaDetails.this.blockListeners()) {
                    return;
                }
                if (AbstractSchemaDetails.this.fSchemaObject != null) {
                    IDocument document = event.getDocument();
                    if (document == null) {
                        return;
                    }
                    String text = document.get().trim();
                    AbstractSchemaDetails.this.updateObjectDescription(text);
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    public abstract void createDetails(Composite var1);

    public abstract void updateFields(ISchemaObject var1);

    public abstract void hookListeners();

    public boolean isEditableElement() {
        return this.fElementSection.isEditable();
    }

    protected void setDecription(String desc) {
        this.fSection.setDescription(desc);
    }

    protected void setText(String title) {
        this.fSection.setText(title);
    }

    @Override
    public String getContextId() {
        return "schema-context";
    }

    @Override
    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    @Override
    public boolean isEditable() {
        IBaseModel model = this.getPage().getPDEEditor().getAggregateModel();
        return model != null && model.isEditable();
    }

    @Override
    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        if (this.fShowDescription && this.fDescriptionViewer != null && this.fDescriptionViewer.getViewer().getTextWidget().isFocusControl()) {
            return this.fDescriptionViewer.canPaste();
        }
        return super.canPaste(clipboard);
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (this.fShowDescription && this.fDescriptionViewer != null && this.fDescriptionViewer.getViewer().getTextWidget().isFocusControl()) {
            return this.fDescriptionViewer.doGlobalAction(actionId);
        }
        return super.doGlobalAction(actionId);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!(part instanceof ElementSection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof ISchemaObject) {
            ISchemaObject sObj = (ISchemaObject)obj;
            this.setBlockListeners(true);
            this.fSchemaObject = sObj;
            if (this.fShowDTD && this.fDtdSection != null) {
                this.fDtdSection.updateDTDLabel(obj);
            }
            if (this.fShowDescription && this.fDescriptionViewer != null) {
                this.updateDescriptionViewer(sObj);
            }
            this.updateFields(sObj);
            this.setBlockListeners(false);
        }
    }

    public void updateDescriptionViewer(ISchemaObject obj) {
        if (obj != null) {
            String text = obj.getDescription();
            this.fDescriptionViewer.getDocument().set(text == null ? "" : text);
            this.fDescriptionViewer.getViewer().setEditable(obj.getSchema().isEditable());
        }
    }

    private void updateObjectDescription(String text) {
        if (this.fSchemaObject instanceof SchemaObject) {
            ((SchemaObject)this.fSchemaObject).setDescription(text);
        }
    }

    protected void fireSelectionChange() {
        this.fElementSection.fireSelection(this.fElementSection.getTreeViewer().getSelection());
    }

    protected void fireMasterSelection(ISelection selection) {
        this.fElementSection.fireSelection(selection);
    }

    protected ComboPart createComboPart(Composite parent, FormToolkit toolkit, String[] items, int colspan, int style) {
        ComboPart cp = new ComboPart();
        cp.createControl(parent, toolkit, 8);
        GridData gd = new GridData(style);
        gd.horizontalSpan = colspan;
        gd.horizontalIndent = 3;
        cp.getControl().setLayoutData((Object)gd);
        cp.setItems(items);
        cp.getControl().setEnabled(this.isEditable());
        return cp;
    }

    protected ComboPart createComboPart(Composite parent, FormToolkit toolkit, String[] items, int colspan) {
        return this.createComboPart(parent, toolkit, items, colspan, 768);
    }

    protected Button[] createTrueFalseButtons(Composite parent, FormToolkit toolkit, int colSpan) {
        Composite comp = toolkit.createComposite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        gd.horizontalIndent = 3;
        comp.setLayoutData((Object)gd);
        Button tButton = toolkit.createButton(comp, BOOLS[0], 16);
        Button fButton = toolkit.createButton(comp, BOOLS[1], 16);
        gd = new GridData();
        gd.horizontalIndent = 20;
        fButton.setLayoutData((Object)gd);
        return new Button[]{tButton, fButton};
    }

    protected Composite createMinOccurComp(Composite parent, FormToolkit toolkit) {
        this.fMinLabel = toolkit.createLabel(parent, PDEUIMessages.AbstractSchemaDetails_minOccurLabel);
        this.fMinLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite comp = toolkit.createComposite(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)gd);
        this.fMinOccurSpinner = new Spinner(comp, 2048);
        this.fMinOccurSpinner.setMinimum(0);
        this.fMinOccurSpinner.setMaximum(999);
        return comp;
    }

    protected Composite createMaxOccurComp(Composite parent, FormToolkit toolkit) {
        this.fMaxLabel = toolkit.createLabel(parent, PDEUIMessages.AbstractSchemaDetails_maxOccurLabel);
        this.fMaxLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite comp = toolkit.createComposite(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)gd);
        this.fMaxOccurSpinner = new Spinner(comp, 2048);
        this.fMaxOccurSpinner.setMinimum(1);
        this.fMaxOccurSpinner.setMaximum(999);
        this.fMaxOccurSpinner.setIncrement(1);
        this.fUnboundSelect = toolkit.createButton(comp, PDEUIMessages.AbstractSchemaDetails_unboundedButton, 32);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.fUnboundSelect.setLayoutData((Object)gd);
        this.fUnboundSelect.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.blockListeners()) {
                return;
            }
            this.fMaxOccurSpinner.setEnabled(!this.fUnboundSelect.getSelection() && this.isEditableElement());
        }));
        return comp;
    }

    protected int getMinOccur() {
        if (this.fMinOccurSpinner != null) {
            return this.fMinOccurSpinner.getSelection();
        }
        return 0;
    }

    protected int getMaxOccur() {
        if (this.fMaxOccurSpinner != null) {
            if (this.fMaxOccurSpinner.isEnabled()) {
                return this.fMaxOccurSpinner.getSelection();
            }
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    protected void updateMinOccur(int min) {
        if (this.fMinOccurSpinner != null) {
            this.fMinOccurSpinner.setSelection(min);
        }
    }

    protected void updateMaxOccur(int max) {
        if (this.fMaxOccurSpinner == null) {
            return;
        }
        boolean isMax = max == Integer.MAX_VALUE;
        this.fUnboundSelect.setSelection(isMax);
        this.fMaxOccurSpinner.setEnabled(!isMax);
        if (!isMax) {
            this.fMaxOccurSpinner.setSelection(max);
        }
    }

    protected void hookMinOccur(SelectionListener adapter) {
        this.fMinOccurSpinner.addSelectionListener(adapter);
        this.fMinOccurSpinner.addModifyListener(e -> {
            if (this.blockListeners()) {
                return;
            }
            int minOccur = this.fMinOccurSpinner.getSelection();
            if (minOccur > this.getMaxOccur()) {
                this.fMinOccurSpinner.setSelection(minOccur - 1);
            }
        });
    }

    protected void hookMaxOccur(SelectionListener adapter) {
        this.fUnboundSelect.addSelectionListener(adapter);
        this.fMaxOccurSpinner.addSelectionListener(adapter);
        this.fMaxOccurSpinner.addModifyListener(e -> {
            if (this.blockListeners()) {
                return;
            }
            int maxValue = this.fMaxOccurSpinner.getSelection();
            if (maxValue < this.getMinOccur()) {
                this.fMaxOccurSpinner.setSelection(maxValue + 1);
            }
        });
    }

    protected void enableMinMax(boolean enable) {
        this.fMinOccurSpinner.setEnabled(enable);
        this.fMaxOccurSpinner.setEnabled(!this.fUnboundSelect.getSelection() && enable);
        this.fUnboundSelect.setEnabled(enable);
        this.fMinLabel.setEnabled(enable);
        this.fMaxLabel.setEnabled(enable);
    }

    protected boolean blockListeners() {
        return this.fBlockListeners;
    }

    protected void setBlockListeners(boolean blockListeners) {
        this.fBlockListeners = blockListeners;
    }

    public void dispose() {
        if (this.fDescriptionViewer != null) {
            this.fDescriptionViewer.unsetMenu();
            this.fDescriptionViewer = null;
        }
        super.dispose();
    }
}

