/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;

public class WindowUtil {
    private static Monitor getClosestMonitor(Display toSearch, Point toFind) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = toSearch.getMonitors();
        Monitor result = monitors[0];
        Monitor[] monitorArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor current = monitorArray[n2];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(toFind)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++n2;
        }
        return result;
    }

    public static Rectangle getConstrainedShellBounds(Window window, Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Monitor mon = WindowUtil.getClosestMonitor(window.getShell().getDisplay(), Geometry.centerPoint((Rectangle)result));
        Rectangle bounds = mon.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }
}

