/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.actions.Messages;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.EditorPart;

public class RPMHandlerUtils {
    private RPMHandlerUtils() {
    }

    public static IResource getResource(ExecutionEvent event) {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null) {
            return null;
        }
        if (part instanceof EditorPart) {
            EditorPart editorPart = (EditorPart)part;
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fei = (IFileEditorInput)input;
                return fei.getFile();
            }
            return null;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return null;
        }
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection selection = provider.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object element = structured.getFirstElement();
            if (element instanceof IResource) {
                IResource r = (IResource)element;
                return r;
            }
            if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                return (IResource)adaptable.getAdapter(IResource.class);
            }
            return null;
        }
        return null;
    }

    public static RPMProject getRPMProject(IResource resource) {
        RPMProject rc = null;
        try {
            IProject parentProject = resource.getProject();
            rc = parentProject.hasNature("org.eclipse.linuxtools.rpm.core.rpmnature") ? (parentProject.getPersistentProperty(new QualifiedName("org.eclipse.linuxtools.rpm.core", "SPECS")) != null ? new RPMProject(parentProject, RPMProjectLayout.RPMBUILD) : new RPMProject(parentProject, RPMProjectLayout.FLAT)) : new RPMProject(parentProject, RPMProjectLayout.FLAT);
        }
        catch (CoreException e) {
            SpecfileLog.logError(Messages.RPMHandlerUtils_cannotCreateRPMProject, e);
        }
        return rc;
    }
}

