/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindCommand;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindCoreParser;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindError;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindInfo;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindStackFrame;
import org.eclipse.linuxtools.internal.valgrind.launch.LaunchConfigurationConstants;
import org.eclipse.linuxtools.internal.valgrind.launch.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.ProjectBuildListener;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindLaunchPlugin;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindViewPart;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.linuxtools.valgrind.launch.IValgrindLaunchDelegate;
import org.eclipse.linuxtools.valgrind.launch.IValgrindOutputDirectoryProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Version;

public class ValgrindLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    private static final String NO = "no";
    private static final String YES = "yes";
    private static final String EQUALS = "=";
    private static final String LOG_FILE = "valgrind_%p.txt";
    private static final Pattern CORE_PATTERN = Pattern.compile("^.*\\.txt\\.core\\.[0-9]+$");
    private static final FileFilter LOG_FILTER = pathname -> pathname.getName().startsWith("valgrind_") && !CORE_PATTERN.matcher(pathname.getName()).matches();
    protected String toolID;
    protected ValgrindCommand command;
    protected IPath outputPath;
    protected IValgrindLaunchDelegate dynamicDelegate;
    protected ILaunchConfiguration config;
    protected ILaunch launch;
    protected IProcess process;
    protected String launchStr;
    protected Version valgrindVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor m) throws CoreException {
        SubMonitor monitor;
        if (m == null) {
            m = new NullProgressMonitor();
        }
        if ((monitor = SubMonitor.convert((IProgressMonitor)m, (String)Messages.getString("ValgrindLaunchConfigurationDelegate.Profiling_Local_CCPP_Application"), (int)10)).isCanceled()) {
            return;
        }
        this.config = config;
        this.launch = launch;
        try {
            IProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config).getProject();
            ValgrindUIPlugin.getDefault().setProfiledProject(project);
            this.command = this.getValgrindCommand();
            ValgrindUIPlugin.getDefault().resetView();
            this.getPlugin().setCurrentLaunchConfiguration(null);
            this.getPlugin().setCurrentLaunch(null);
            String valgrindCommand = this.getValgrindCommand().getValgrindCommand();
            try {
                this.valgrindVersion = this.getPlugin().getValgrindVersion(project);
            }
            catch (CoreException e) {
                this.errorDialog(Messages.getString("ValgrindLaunchConfigurationDelegate.Valgrind_version_failed_msg"), e.getMessage());
                m.done();
                return;
            }
            monitor.worked(1);
            IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
            String[] arguments = this.getProgramArgumentsArray(config);
            File workDir = this.getWorkingDirectory(config);
            if (workDir == null) {
                workDir = new File(System.getProperty("user.home", "."));
            }
            IValgrindOutputDirectoryProvider provider = this.getPlugin().getOutputDirectoryProvider();
            this.setOutputPath(config, provider.getOutputPath());
            this.outputPath = this.verifyOutputPath(config);
            this.createDirectory(this.outputPath);
            this.toolID = this.getTool(config);
            this.dynamicDelegate = this.getDynamicDelegate(this.toolID);
            String[] opts = this.getValgrindArgumentsArray(config);
            this.setDefaultSourceLocator(launch, config);
            ArrayList<String> cmdLine = new ArrayList<String>(1 + arguments.length);
            cmdLine.add(valgrindCommand);
            cmdLine.addAll(Arrays.asList(opts));
            cmdLine.add(exePath.toPortableString());
            cmdLine.addAll(Arrays.asList(arguments));
            String[] commandArray = cmdLine.toArray(new String[cmdLine.size()]);
            boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            this.command.execute(commandArray, this.getEnvironment(config), workDir, usePty, project);
            monitor.worked(3);
            this.process = this.createNewProcess(launch, this.command.getProcess(), commandArray[0]);
            this.process.setAttribute(IProcess.ATTR_CMDLINE, this.command.getCommandLine());
            while (!this.process.isTerminated()) {
                Thread.sleep(100L);
            }
            this.getPlugin().setCurrentLaunchConfiguration(config);
            this.getPlugin().setCurrentLaunch(launch);
            IValgrindMessage[] messages = this.parseLogs(this.outputPath);
            this.launchStr = this.createLaunchStr();
            ValgrindUIPlugin.getDefault().createView(this.launchStr, this.toolID);
            ValgrindViewPart view = ValgrindUIPlugin.getDefault().getView();
            view.setMessages(messages);
            monitor.worked(1);
            this.dynamicDelegate.handleLaunch(config, launch, this.outputPath, (IProgressMonitor)monitor.newChild(2));
            this.dynamicDelegate.initializeView(view.getDynamicView(), this.launchStr, (IProgressMonitor)monitor.newChild(1));
            ValgrindUIPlugin.getDefault().refreshView();
            ValgrindUIPlugin.getDefault().showView();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ProjectBuildListener(project), 16);
            monitor.worked(1);
        }
        catch (IOException e) {
            this.abort(Messages.getString("ValgrindLaunchConfigurationDelegate.Error_starting_process"), e, 150);
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            m.done();
        }
    }

    protected IValgrindMessage[] parseLogs(IPath outputPath) throws IOException, CoreException {
        ArrayList<IValgrindMessage> messages = new ArrayList<IValgrindMessage>();
        for (File log : outputPath.toFile().listFiles(LOG_FILTER)) {
            ValgrindCoreParser parser = new ValgrindCoreParser(log, this.launch);
            IValgrindMessage[] results = parser.getMessages();
            if (results.length == 0) {
                results = new IValgrindMessage[]{new ValgrindInfo(null, Messages.getString("ValgrindOutputView.No_output"), this.launch)};
            }
            messages.addAll(Arrays.asList(results));
            this.createMarkers(results);
        }
        return messages.toArray(new IValgrindMessage[messages.size()]);
    }

    private void createMarkers(IValgrindMessage[] messages) throws CoreException {
        Stack<IValgrindMessage> messageStack = new Stack<IValgrindMessage>();
        messageStack.addAll(Arrays.asList(messages));
        while (!messageStack.isEmpty()) {
            IValgrindMessage message = (IValgrindMessage)messageStack.pop();
            IMarker marker = null;
            IValgrindMessage[] children = message.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof ValgrindStackFrame && marker == null) {
                    ValgrindStackFrame frame = (ValgrindStackFrame)children[i];
                    if (frame.getLine() <= 0) continue;
                    ISourceLocator locator = frame.getSourceLocator();
                    ISourceLookupResult result = DebugUITools.lookupSource((Object)frame.getFile(), (ISourceLocator)locator);
                    Object sourceElement = result.getSourceElement();
                    if (sourceElement == null) continue;
                    if (sourceElement instanceof LocalFileStorage) {
                        IPath filePath = ((LocalFileStorage)sourceElement).getFullPath();
                        URI fileURI = URIUtil.toURI((IPath)filePath);
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IFile[] files = root.findFilesForLocationURI(fileURI);
                        if (files.length > 0) {
                            sourceElement = files[0];
                        }
                    }
                    if (!(sourceElement instanceof IResource)) continue;
                    IResource resource = (IResource)sourceElement;
                    marker = resource.createMarker("org.eclipse.linuxtools.valgrind.launch.marker");
                    marker.setAttribute("message", (Object)message.getText());
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("lineNumber", frame.getLine());
                    continue;
                }
                if (!(children[i] instanceof ValgrindError)) continue;
                messageStack.push(children[i]);
            }
        }
    }

    protected IProcess createNewProcess(ILaunch launch, Process systemProcess, String programName) {
        return DebugPlugin.newProcess((ILaunch)launch, (Process)systemProcess, (String)this.renderProcessLabel(programName));
    }

    protected ValgrindCommand getValgrindCommand() {
        return this.getPlugin().getValgrindCommand();
    }

    protected ValgrindLaunchPlugin getPlugin() {
        return ValgrindLaunchPlugin.getDefault();
    }

    protected IValgrindLaunchDelegate getDynamicDelegate(String toolID) throws CoreException {
        return this.getPlugin().getToolDelegate(toolID);
    }

    private IPath verifyOutputPath(ILaunchConfiguration config) throws CoreException {
        IPath result = null;
        String strPath = config.getAttribute("org.eclipse.linuxtools.valgrind.launch.OUTPUT_DIR", (String)null);
        if (strPath != null) {
            result = Path.fromPortableString((String)strPath);
        }
        if (result == null) {
            this.abort(Messages.getString("ValgrindLaunchConfigurationDelegate.Retrieving_location_failed"), null, 150);
        }
        return result;
    }

    protected void setOutputPath(ILaunchConfiguration config, IPath outputPath) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.linuxtools.valgrind.launch.OUTPUT_DIR", outputPath.toPortableString());
        wc.doSave();
    }

    protected void createDirectory(IPath path) throws IOException {
        File outputDir = path.toFile();
        if (outputDir.exists()) {
            for (File outputFile : outputDir.listFiles()) {
                if (!outputFile.isFile() || outputFile.delete()) continue;
                throw new IOException(NLS.bind((String)Messages.getString("ValgrindOutputDirectory.Couldnt_delete"), (Object)outputFile.getAbsolutePath()));
            }
        } else if (!outputDir.mkdir()) {
            throw new IOException(NLS.bind((String)Messages.getString("ValgrindOutputDirectory.Couldnt_create"), (Object)outputDir.getAbsolutePath()));
        }
    }

    private String createLaunchStr() {
        return this.config.getName() + " [" + this.getPlugin().getToolName(this.toolID) + "] " + this.process.getLabel();
    }

    protected String[] getValgrindArgumentsArray(ILaunchConfiguration config) throws CoreException {
        boolean useMainStack;
        ArrayList<Object> opts = new ArrayList<Object>();
        opts.add("--tool=" + this.getPlugin().getToolName(this.toolID));
        opts.add("-q");
        opts.add("--log-file=" + this.outputPath.append(LOG_FILE).toPortableString());
        opts.add("--trace-children=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_TRACECHILD", false) ? YES : NO));
        opts.add("--child-silent-after-fork=yes");
        opts.add("--run-libc-freeres=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_FREERES", true) ? YES : NO));
        opts.add("--demangle=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DEMANGLE", true) ? YES : NO));
        opts.add("--num-callers=" + config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_NUMCALLERS", 12));
        opts.add("--error-limit=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_ERRLIMIT", true) ? YES : NO));
        opts.add("--show-below-main=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_BELOWMAIN", false) ? YES : NO));
        opts.add("--max-stackframe=" + config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAXFRAME", 2000000));
        if ((this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_4_0) >= 0) && (useMainStack = config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAINSTACK_BOOL", false))) {
            opts.add("--main-stacksize=" + config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAINSTACK", 0));
        }
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(ValgrindLaunchPlugin.VER_3_6_0) >= 0) {
            if (config.getAttribute("org.eclipse.linuxtools.valgrind.launch.FULLPATH_AFTER", true)) {
                opts.add("--fullpath-after=");
            }
            if (!config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DSYMUTIL", true)) {
                opts.add("--dsymutil=" + (config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DSYMUTIL", true) ? YES : NO));
            }
        }
        List suppFiles = config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_SUPPFILES", LaunchConfigurationConstants.DEFAULT_GENERAL_SUPPFILES);
        for (Object strpath : suppFiles) {
            IPath suppfile = this.getPlugin().parseWSPath((String)strpath);
            if (suppfile == null) continue;
            opts.add("--suppressions=" + suppfile.toPortableString());
        }
        opts.addAll(Arrays.asList(this.dynamicDelegate.getCommandArray(config, this.valgrindVersion, this.outputPath)));
        String otherOptions = config.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_OTHER_OPTIONS", "").trim();
        if (!otherOptions.isEmpty()) {
            opts.addAll(Arrays.asList(otherOptions.split("\\s+")));
        }
        String[] ret = new String[opts.size()];
        return opts.toArray(ret);
    }

    protected String getTool(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", "org.eclipse.linuxtools.valgrind.launch.memcheck");
    }

    protected String getPluginID() {
        return "org.eclipse.linuxtools.valgrind.launch";
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        root.deleteMarkers("org.eclipse.linuxtools.valgrind.launch.marker", true, 2);
        return super.finalLaunchCheck(configuration, mode, monitor);
    }

    private void errorDialog(String title, String message) {
        ValgrindLaunchPlugin.getShell().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)ValgrindLaunchPlugin.getShell(), (String)title, (String)message));
    }
}

