/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Optional;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IPragma;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;

public class Pragma
extends SourceManipulation
implements IPragma {
    private boolean isPragmaOperator = false;
    private Optional<IPragma.PragmaMarkInfo> pragmaMarkInfo = null;

    public Pragma(ICElement parent, String name) {
        super(parent, name, 95);
    }

    private IPragma.PragmaMarkInfo calculateMarkInfo(String name) {
        block15: {
            String nameTrimmed = name.trim();
            StringTokenizer tokenizer = new StringTokenizer(nameTrimmed);
            if (!tokenizer.hasMoreTokens()) break block15;
            boolean dividerBeforeMark = false;
            boolean dividerAfterMark = false;
            String markName = "";
            String pragmaName = tokenizer.nextToken();
            String restOfLine = tokenizer.hasMoreTokens() ? tokenizer.nextToken("").trim() : "";
            switch (pragmaName) {
                case "mark": {
                    if (restOfLine.startsWith("-")) {
                        dividerBeforeMark = true;
                        restOfLine = restOfLine.substring(1);
                    }
                    if (restOfLine.endsWith("-")) {
                        dividerAfterMark = true;
                        restOfLine = restOfLine.substring(0, restOfLine.length() - 1);
                    }
                    markName = restOfLine.trim();
                    break;
                }
                case "endregion": 
                case "region": {
                    if (restOfLine.isEmpty()) {
                        dividerBeforeMark = true;
                        dividerAfterMark = false;
                        break;
                    }
                    dividerBeforeMark = true;
                    dividerAfterMark = true;
                    markName = restOfLine;
                    break;
                }
                default: {
                    return null;
                }
            }
            final boolean finalDividerBeforeMark = dividerBeforeMark;
            final boolean finalDividerAfterMark = dividerAfterMark;
            final String finalMarkName = markName;
            return new IPragma.PragmaMarkInfo(){

                @Override
                public boolean isDividerBeforeMark() {
                    return finalDividerBeforeMark;
                }

                @Override
                public boolean isDividerAfterMark() {
                    return finalDividerAfterMark;
                }

                @Override
                public String getMarkName() {
                    return finalMarkName;
                }
            };
        }
        return null;
    }

    @Override
    protected CElementInfo createElementInfo() {
        return new SourceManipulationInfo(this);
    }

    public void setPragmaOperator(boolean isPragmaOperator) {
        this.isPragmaOperator = isPragmaOperator;
    }

    @Override
    public boolean isPragmaOperator() {
        return this.isPragmaOperator;
    }

    @Override
    public Optional<IPragma.PragmaMarkInfo> getPragmaMarkInfo() {
        if (this.pragmaMarkInfo == null) {
            this.pragmaMarkInfo = Optional.ofNullable(this.calculateMarkInfo(this.getElementName()));
        }
        return this.pragmaMarkInfo;
    }
}

