/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.editor.IMakefileDocumentProvider;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.cdt.make.ui.IWorkingCopyManagerExtension;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private IMakefileDocumentProvider fDocumentProvider;
    private Map<IEditorInput, IMakefile> fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(IMakefileDocumentProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fDocumentProvider = provider;
    }

    @Override
    public void connect(IEditorInput input) throws CoreException {
        this.fDocumentProvider.connect(input);
    }

    @Override
    public void disconnect(IEditorInput input) {
        this.fDocumentProvider.disconnect(input);
    }

    @Override
    public void shutdown() {
        if (!this.fIsShuttingDown) {
            this.fIsShuttingDown = true;
            try {
                if (this.fMap != null) {
                    this.fMap.clear();
                    this.fMap = null;
                }
                this.fDocumentProvider.shutdown();
            }
            finally {
                this.fIsShuttingDown = false;
            }
        }
    }

    @Override
    public IMakefile getWorkingCopy(IEditorInput input) {
        IMakefile unit = this.fMap == null ? null : this.fMap.get(input);
        return unit != null ? unit : this.fDocumentProvider.getWorkingCopy(input);
    }

    @Override
    public void setWorkingCopy(IEditorInput input, IMakefile workingCopy) {
        if (this.fDocumentProvider.getDocument(input) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap<IEditorInput, IMakefile>();
            }
            this.fMap.put(input, workingCopy);
        }
    }

    @Override
    public void removeWorkingCopy(IEditorInput input) {
        this.fMap.remove(input);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

