/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.html;

import java.io.Reader;
import java.net.URL;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.html.HTMLBuilder;
import org.eclipse.text.html.RGB;

public class HTMLPrinter {
    private static final HTMLBuilder CORE;

    static {
        block3: {
            CORE = new HTMLBuilder();
            Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                try {
                    display.asyncExec(() -> {
                        HTMLPrinter.cacheColors(display);
                        HTMLPrinter.installColorUpdater(display);
                    });
                }
                catch (SWTError err) {
                    if (err.code == 45) break block3;
                    throw err;
                }
            }
        }
    }

    private HTMLPrinter() {
    }

    private static void installColorUpdater(Display display) {
        display.addListener(39, event -> HTMLPrinter.cacheColors(display));
        JFaceResources.getColorRegistry().addListener(event -> HTMLPrinter.cacheColors(display));
    }

    private static RGB fromRGB(org.eclipse.swt.graphics.RGB val) {
        if (val == null) {
            return null;
        }
        return new RGB(val.red, val.green, val.blue);
    }

    private static void cacheColors(Display display) {
        RGB bg = HTMLPrinter.fromRGB(JFaceColors.getInformationViewerBackgroundColor((Display)display).getRGB());
        RGB fg = HTMLPrinter.fromRGB(JFaceColors.getInformationViewerForegroundColor((Display)display).getRGB());
        Color hyperlinkText = JFaceColors.getHyperlinkText((Display)display);
        Color activeHyperlinkText = JFaceColors.getActiveHyperlinkText((Display)display);
        RGB link = hyperlinkText == null ? null : HTMLPrinter.fromRGB(hyperlinkText.getRGB());
        RGB alink = activeHyperlinkText == null ? null : HTMLPrinter.fromRGB(activeHyperlinkText.getRGB());
        CORE.setColors(bg, fg, link, alink);
    }

    public static String convertToHTMLContent(String content) {
        return HTMLBuilder.convertToHTMLContent((String)content);
    }

    public static String convertToHTMLContentWithWhitespace(String content) {
        return HTMLBuilder.convertToHTMLContentWithWhitespace((String)content);
    }

    public static String read(Reader rd) {
        return HTMLBuilder.read((Reader)rd);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void insertPageProlog(StringBuffer buffer, int position, org.eclipse.swt.graphics.RGB fgRGB, org.eclipse.swt.graphics.RGB bgRGB, String styleSheet) {
        HTMLPrinter.runOp(buffer, sb -> CORE.insertPageProlog(sb, position, HTMLPrinter.fromRGB(fgRGB), HTMLPrinter.fromRGB(bgRGB), styleSheet));
    }

    public static void insertPageProlog(StringBuilder buffer, int position, org.eclipse.swt.graphics.RGB fgRGB, org.eclipse.swt.graphics.RGB bgRGB, String styleSheet) {
        CORE.insertPageProlog(buffer, position, HTMLPrinter.fromRGB(fgRGB), HTMLPrinter.fromRGB(bgRGB), styleSheet);
    }

    public static void insertStyles(StringBuilder buffer, String[] styles) {
        CORE.insertStyles(buffer, styles);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void insertStyles(StringBuffer buffer, String[] styles) {
        HTMLPrinter.runOp(buffer, sb -> CORE.insertStyles(sb, styles));
    }

    public static void insertPageProlog(StringBuilder buffer, int position) {
        CORE.insertPageProlog(buffer, position);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void insertPageProlog(StringBuffer buffer, int position) {
        HTMLPrinter.runOp(buffer, sb -> CORE.insertPageProlog(sb, position));
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void insertPageProlog(StringBuffer buffer, int position, URL styleSheetURL) {
        HTMLPrinter.runOp(buffer, sb -> CORE.insertPageProlog(sb, position, styleSheetURL));
    }

    public static void insertPageProlog(StringBuilder buffer, int position, URL styleSheetURL) {
        CORE.insertPageProlog(buffer, position, styleSheetURL);
    }

    public static void insertPageProlog(StringBuilder buffer, int position, String styleSheet) {
        CORE.insertPageProlog(buffer, position, styleSheet);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void insertPageProlog(StringBuffer buffer, int position, String styleSheet) {
        HTMLPrinter.runOp(buffer, sb -> CORE.insertPageProlog(sb, position, styleSheet));
    }

    public static void addPageProlog(StringBuilder buffer) {
        CORE.addPageProlog(buffer);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void addPageProlog(StringBuffer buffer) {
        HTMLPrinter.runOp(buffer, arg_0 -> ((HTMLBuilder)CORE).addPageProlog(arg_0));
    }

    public static void addPageEpilog(StringBuilder buffer) {
        CORE.addPageEpilog(buffer);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void addPageEpilog(StringBuffer buffer) {
        HTMLPrinter.runOp(buffer, arg_0 -> ((HTMLBuilder)CORE).addPageEpilog(arg_0));
    }

    public static void startBulletList(StringBuilder buffer) {
        CORE.startBulletList(buffer);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void startBulletList(StringBuffer buffer) {
        HTMLPrinter.runOp(buffer, arg_0 -> ((HTMLBuilder)CORE).startBulletList(arg_0));
    }

    public static void endBulletList(StringBuilder buffer) {
        CORE.endBulletList(buffer);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void endBulletList(StringBuffer buffer) {
        HTMLPrinter.runOp(buffer, arg_0 -> ((HTMLBuilder)CORE).endBulletList(arg_0));
    }

    public static void addBullet(StringBuilder buffer, String bullet) {
        CORE.addBullet(buffer, bullet);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void addBullet(StringBuffer buffer, String bullet) {
        HTMLPrinter.runOp(buffer, sb -> CORE.addBullet(sb, bullet));
    }

    public static void addSmallHeader(StringBuilder buffer, String header) {
        CORE.addSmallHeader(buffer, header);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void addSmallHeader(StringBuffer buffer, String header) {
        HTMLPrinter.runOp(buffer, sb -> CORE.addSmallHeader(sb, header));
    }

    public static void addParagraph(StringBuilder buffer, String paragraph) {
        CORE.addParagraph(buffer, paragraph);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void addParagraph(StringBuffer buffer, String paragraph) {
        HTMLPrinter.runOp(buffer, sb -> CORE.addParagraph(sb, paragraph));
    }

    public static void addPreFormatted(StringBuilder buffer, String preFormatted) {
        CORE.addPreFormatted(buffer, preFormatted);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void addPreFormatted(StringBuffer buffer, String preFormatted) {
        HTMLPrinter.runOp(buffer, sb -> CORE.addPreFormatted(sb, preFormatted));
    }

    public static void addParagraph(StringBuilder buffer, Reader paragraphReader) {
        CORE.addParagraph(buffer, paragraphReader);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static void addParagraph(StringBuffer buffer, Reader paragraphReader) {
        HTMLPrinter.runOp(buffer, sb -> CORE.addParagraph(sb, paragraphReader));
    }

    private static void runOp(StringBuffer buffer, BuilderBuffer bf) {
        StringBuilder sb = new StringBuilder();
        bf.run(sb);
        buffer.append(sb.toString());
    }

    public static String convertTopLevelFont(String styles, FontData fontData) {
        boolean bold = (fontData.getStyle() & 1) != 0;
        boolean italic = (fontData.getStyle() & 2) != 0;
        return HTMLBuilder.convertTopLevelFont((String)styles, (boolean)bold, (boolean)italic, (int)fontData.getHeight(), (String)fontData.getName());
    }

    private static interface BuilderBuffer {
        public void run(StringBuilder var1);
    }
}

