/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class NewRuntimeLibraryDialog
extends SelectionStatusDialog {
    private Text libraryText;
    private final IPluginLibrary[] libraries;
    private final DuplicateStatusValidator validator;
    private String libraryName;
    private final Set<IPath> librarySet;

    public NewRuntimeLibraryDialog(Shell parent, IPluginLibrary[] libraries) {
        super(parent);
        this.libraries = libraries;
        this.validator = new DuplicateStatusValidator();
        this.librarySet = new HashSet<IPath>();
        IPluginLibrary[] iPluginLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary library = iPluginLibraryArray[n2];
            this.librarySet.add(IPath.fromOSString((String)ClasspathUtilCore.expandLibraryName((String)library.getName())));
            ++n2;
        }
        this.setStatusLineAboveButtons(true);
    }

    protected void computeResult() {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.new_library");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 8;
        layout.marginHeight = 8;
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label libraryLabel = new Label(container, 0);
        gd = new GridData(768);
        libraryLabel.setLayoutData((Object)gd);
        libraryLabel.setText(PDEUIMessages.ManifestEditor_RuntimeLibraryDialog_label);
        this.libraryText = new Text(container, 2052);
        gd = new GridData(768);
        this.libraryText.setLayoutData((Object)gd);
        this.libraryText.setText(PDEUIMessages.ManifestEditor_RuntimeLibraryDialog_default);
        this.libraryText.addModifyListener(e -> this.updateStatus(this.validator.validate(this.libraryText.getText())));
        NewRuntimeLibraryDialog.applyDialogFont((Control)container);
        return container;
    }

    public int open() {
        this.libraryText.setText("library.jar");
        this.libraryText.setSelection(0, this.libraryText.getText().length() - 4);
        return super.open();
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    protected void okPressed() {
        this.libraryName = this.libraryText.getText();
        super.okPressed();
    }

    class DuplicateStatusValidator {
        DuplicateStatusValidator() {
        }

        public IStatus validate(String text) {
            if (text.length() == 0) {
                return Status.error((String)PDEUIMessages.AddLibraryDialog_emptyLibraries);
            }
            if (text.indexOf(32) != -1) {
                return Status.error((String)PDEUIMessages.AddLibraryDialog_nospaces);
            }
            if (NewRuntimeLibraryDialog.this.libraries == null || NewRuntimeLibraryDialog.this.libraries.length == 0) {
                return Status.OK_STATUS;
            }
            if (NewRuntimeLibraryDialog.this.librarySet.contains(IPath.fromOSString((String)ClasspathUtilCore.expandLibraryName((String)text)))) {
                return Status.error((String)PDEUIMessages.ManifestEditor_RuntimeLibraryDialog_validationError);
            }
            return Status.OK_STATUS;
        }
    }
}

