/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.dialect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUI;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.business.api.dialect.ExportResult;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.audit.provider.AuditItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.style.provider.StyleItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.tool.provider.ToolItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.validation.provider.ValidationItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.ui.IEditorPart;

public class DialectUIManagerImpl
implements DialectUIManager {
    Map<String, DialectUI> dialects = new HashMap<String, DialectUI>();

    public static DialectUIManager init() {
        DialectUIManagerImpl manager = new DialectUIManagerImpl();
        if (SiriusPlugin.IS_ECLIPSE_RUNNING) {
            List parsedDialects = EclipseUtil.getExtensionPlugins(DialectUI.class, (String)"org.eclipse.sirius.ui.dialectui", (String)"class");
            for (DialectUI dialect : parsedDialects) {
                manager.enableDialectUI(dialect);
            }
        }
        return manager;
    }

    @Override
    public void disableDialectUI(DialectUI dialect) {
        this.dialects.remove(dialect.getName());
    }

    @Override
    public void enableDialectUI(DialectUI dialect) {
        this.dialects.put(dialect.getName(), dialect);
    }

    @Override
    public IEditorPart openEditor(Session session, DRepresentation dRepresentation, IProgressMonitor monitor) {
        for (DialectUI dialect : this.dialects.values()) {
            IEditorPart editor = dialect.getServices().openEditor(session, dRepresentation, monitor);
            if (editor == null) continue;
            return editor;
        }
        return null;
    }

    @Override
    public Collection<CommandParameter> provideNewChildDescriptors() {
        ArrayList<CommandParameter> result = new ArrayList<CommandParameter>();
        for (DialectUI dialect : this.dialects.values()) {
            result.addAll(dialect.getServices().provideNewChildDescriptors());
        }
        return result;
    }

    @Override
    public Collection<CommandParameter> provideRepresentationCreationToolDescriptors(Object feature) {
        ArrayList<CommandParameter> result = new ArrayList<CommandParameter>();
        for (DialectUI dialect : this.dialects.values()) {
            result.addAll(dialect.getServices().provideRepresentationCreationToolDescriptors(feature));
        }
        return result;
    }

    @Override
    public Collection<CommandParameter> provideRepresentationNavigationToolDescriptors(Object feature) {
        ArrayList<CommandParameter> result = new ArrayList<CommandParameter>();
        for (DialectUI dialect : this.dialects.values()) {
            result.addAll(dialect.getServices().provideRepresentationNavigationToolDescriptors(feature));
        }
        return result;
    }

    @Override
    public Collection<CommandParameter> provideAdditionalMappings(EObject object) {
        ArrayList<CommandParameter> result = new ArrayList<CommandParameter>();
        for (DialectUI dialect : this.dialects.values()) {
            result.addAll(dialect.getServices().provideAdditionalMappings(object));
        }
        return result;
    }

    @Override
    public AdapterFactory createAdapterFactory() {
        ComposedAdapterFactory composed = new ComposedAdapterFactory();
        composed.addAdapterFactory((AdapterFactory)new DescriptionItemProviderAdapterFactory());
        composed.addAdapterFactory((AdapterFactory)new ViewpointItemProviderAdapterFactory());
        composed.addAdapterFactory((AdapterFactory)new StyleItemProviderAdapterFactory());
        composed.addAdapterFactory((AdapterFactory)new ToolItemProviderAdapterFactory());
        composed.addAdapterFactory((AdapterFactory)new ValidationItemProviderAdapterFactory());
        composed.addAdapterFactory((AdapterFactory)new AuditItemProviderAdapterFactory());
        for (DialectUI dialect : this.dialects.values()) {
            composed.addAdapterFactory(dialect.getServices().createAdapterFactory());
        }
        return composed;
    }

    @Override
    public boolean canHandleEditor(IEditorPart editorPart) {
        boolean result = false;
        for (DialectUI dialect : this.dialects.values()) {
            boolean bl = result = result || dialect.getServices().canHandleEditor(editorPart);
        }
        return result;
    }

    @Override
    public boolean closeEditor(IEditorPart editorPart, boolean save) {
        boolean result = false;
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandleEditor(editorPart)) continue;
            boolean bl = result = result || dialect.getServices().closeEditor(editorPart, save);
        }
        return result;
    }

    @Override
    public boolean isRepresentationManagedByEditor(DRepresentation representation, IEditorPart editorPart) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().isRepresentationManagedByEditor(representation, editorPart)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRepresentationDescriptionManagedByEditor(RepresentationDescription representationDescription, IEditorPart editor) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().isRepresentationDescriptionManagedByEditor(representationDescription, editor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getEditorName(DRepresentation representation) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandle(representation)) continue;
            return dialect.getServices().getEditorName(representation);
        }
        return "";
    }

    @Override
    public boolean canHandle(DRepresentation representation) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandle(representation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandle(DRepresentationDescriptor repDescriptor) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandle(repDescriptor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandle(RepresentationDescription description) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandle(description)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandle(RepresentationExtensionDescription description) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandle(description)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canExport(ExportFormat format) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canExport(format)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void export(DRepresentation representation, Session session, IPath path, ExportFormat format, IProgressMonitor monitor) throws SizeTooLargeException {
        this.export(representation, session, path, format, monitor, true);
    }

    @Override
    public void export(DRepresentation representation, Session session, IPath path, ExportFormat format, IProgressMonitor monitor, boolean exportDecorations) throws SizeTooLargeException {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandle(representation)) continue;
            dialect.getServices().export(representation, session, path, format, monitor, exportDecorations);
        }
    }

    @Override
    public ExportResult exportWithResult(DRepresentation representation, Session session, IPath path, ExportFormat format, IProgressMonitor monitor) throws SizeTooLargeException {
        return this.exportWithResult(representation, session, path, format, monitor, true);
    }

    @Override
    public ExportResult exportWithResult(DRepresentation representation, Session session, IPath path, ExportFormat format, IProgressMonitor monitor, boolean exportDecorations) throws SizeTooLargeException {
        ExportResult result = null;
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandle(representation)) continue;
            result = dialect.getServices().exportWithResult(representation, session, path, format, monitor, exportDecorations);
        }
        return result;
    }

    @Override
    public void setSelection(DialectEditor dialectEditor, List<DRepresentationElement> selection) {
        for (DialectUI dialect : this.dialects.values()) {
            dialect.getServices().setSelection(dialectEditor, selection);
        }
    }

    @Override
    public void selectAndReveal(DialectEditor dialectEditor, List<DRepresentationElement> selection) {
        for (DialectUI dialect : this.dialects.values()) {
            dialect.getServices().selectAndReveal(dialectEditor, selection);
        }
    }

    @Override
    public Collection<DSemanticDecorator> getSelection(DialectEditor editor) {
        for (DialectUI dialect : this.dialects.values()) {
            Collection<DSemanticDecorator> selection = dialect.getServices().getSelection(editor);
            if (selection.isEmpty()) continue;
            return selection;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<CommandParameter> provideTools(EObject cur) {
        ArrayList<CommandParameter> result = new ArrayList<CommandParameter>();
        for (DialectUI dialect : this.dialects.values()) {
            result.addAll(dialect.getServices().provideTools(cur));
        }
        return result;
    }

    @Override
    @Deprecated
    public ILabelProvider getHierarchyLabelProvider(ILabelProvider currentLabelProvider) {
        ILabelProvider result = currentLabelProvider;
        for (DialectUI dialect : this.dialects.values()) {
            ILabelProvider hierarchyLabelProvider = dialect.getServices().getHierarchyLabelProvider(result);
            if (hierarchyLabelProvider == null) continue;
            result = hierarchyLabelProvider;
        }
        return result;
    }

    @Override
    public boolean canExport(DRepresentation representation, ExportFormat format) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandle(representation) || !dialect.getServices().canExport(format)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canExport(DRepresentationDescriptor repDescriptor, ExportFormat format) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandle(repDescriptor) || !dialect.getServices().canExport(format)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String completeToolTipText(String toolTipText, EObject eObject) {
        return this.completeToolTipText(toolTipText, eObject, null);
    }

    @Override
    public String completeToolTipText(String toolTipText, EObject eObject, EStructuralFeature feature) {
        String toolTip;
        block3: {
            Option parentRepresentationDescription;
            block2: {
                toolTip = toolTipText;
                parentRepresentationDescription = new EObjectQuery(eObject).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getRepresentationDescription());
                if (!parentRepresentationDescription.some()) break block2;
                for (DialectUI dialect : this.dialects.values()) {
                    if (!dialect.getServices().canHandle((RepresentationDescription)parentRepresentationDescription.get())) continue;
                    toolTip = dialect.getServices().completeToolTipText(toolTipText, eObject, feature);
                }
                break block3;
            }
            Option parentRepresentationExtensionDescription = new EObjectQuery(eObject).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getRepresentationExtensionDescription());
            if (!parentRepresentationDescription.some()) break block3;
            for (DialectUI dialect : this.dialects.values()) {
                if (!dialect.getServices().canHandle((RepresentationExtensionDescription)parentRepresentationExtensionDescription.get())) continue;
                toolTip = dialect.getServices().completeToolTipText(toolTipText, eObject, feature);
            }
        }
        return toolTip;
    }

    @Override
    public void refreshEditor(DialectEditor dialectEditor, IProgressMonitor monitor) {
        for (DialectUI dialect : this.dialects.values()) {
            if (!dialect.getServices().canHandleEditor(dialectEditor)) continue;
            dialect.getServices().refreshEditor(dialectEditor, monitor);
        }
    }
}

