/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.catalog.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CatalogLoadUtil {
    public static final String EMPTY = "";
    private static final String CONTEXT_GET_USERNAME = "getUserName";

    public static void load(EObject obj, IProgressMonitor monitor, int task) {
        CatalogLoadUtil.loadInternal(obj, monitor, task, true);
        for (EStructuralFeature feature : obj.eClass().getEAllStructuralFeatures()) {
            if (!CatalogLoadUtil.isRequired(feature)) continue;
            obj.eGet(feature);
        }
    }

    public static void loadWithoutAttributes(EObject obj, IProgressMonitor monitor, int task) {
        CatalogLoadUtil.loadInternal(obj, monitor, task, false);
        Iterator it = obj.eClass().getEAllReferences().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            EStructuralFeature feature = (EStructuralFeature)it.next();
            if (!CatalogLoadUtil.isRequired(feature)) continue;
            obj.eGet(feature);
        }
    }

    public static double loadInternal(EObject object, IProgressMonitor monitor, double task, boolean includingAttributes) {
        ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
        Collection c = containmentService.getContainedElements(object);
        if (object instanceof ICatalogObject) {
            ((ICatalogObject)object).getConnection();
        }
        double acc = 0.0;
        if (c.size() != 0) {
            double delta = task / (double)c.size();
            Iterator it = c.iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                String name;
                EObject child = (EObject)it.next();
                if (containmentService.isDisplayableElement(child) && child instanceof ENamedElement && (name = ((ENamedElement)child).getName()) != null) {
                    String type = child.eClass().getName();
                    name = "<" + type + "> " + name;
                }
                acc += CatalogLoadUtil.loadInternal(child, monitor, delta, includingAttributes);
            }
        } else {
            acc = task;
        }
        if (includingAttributes) {
            for (EStructuralFeature feature : object.eClass().getEAllStructuralFeatures()) {
                if (!CatalogLoadUtil.isRequired(feature)) continue;
                object.eGet(feature);
            }
        } else {
            for (EStructuralFeature feature : object.eClass().getEAllReferences()) {
                if (!CatalogLoadUtil.isRequired(feature)) continue;
                object.eGet(feature);
            }
        }
        return acc;
    }

    public static void generateImplicitPK(Database database) {
        for (Schema schema : database.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (!(table instanceof BaseTable)) continue;
                CatalogLoadUtil.generateImplicitPK((BaseTable)table);
            }
        }
    }

    private static boolean isRequired(EStructuralFeature feature) {
        if (feature.getEContainingClass().getName().equals("LUWNickname") && feature.getName().equals("remoteDataSet")) {
            return false;
        }
        return !feature.isDerived() && !feature.isTransient();
    }

    private static void generateImplicitPK(BaseTable table) {
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null) {
            return;
        }
        for (Index index : table.getIndex()) {
            if (!index.isUnique()) continue;
            CatalogLoadUtil.generateImplictPK(table, index);
            break;
        }
    }

    private static void generateImplictPK(BaseTable table, Index index) {
        Schema schema = table.getSchema();
        Database database = ModelHelper.getDatabase(schema);
        DatabaseDefinition databaseDefinition = IBMPluginActivator.getInstance().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        PrimaryKey pk = (PrimaryKey)factory.create(SQLConstraintsPackage.eINSTANCE.getPrimaryKey());
        pk.setEnforced(false);
        EList pkMember = pk.getMembers();
        Iterator iter = index.getMembers().iterator();
        while (iter.hasNext()) {
            Column column = ((IndexMember)iter.next()).getColumn();
            if (column == null) {
                return;
            }
            pkMember.add((Object)column);
        }
        table.getConstraints().add((Object)pk);
    }

    public static String getFilterString(String predicate, String parameter) {
        String filter = EMPTY;
        String pattern = "\\{";
        int occurrences = predicate.length() - predicate.toLowerCase().replaceAll(pattern.toLowerCase(), EMPTY).length();
        if (occurrences > 0) {
            Object[] params = new Object[occurrences];
            int i = 0;
            while (i < params.length) {
                params[i] = parameter;
                ++i;
            }
            filter = MessageFormat.format(predicate.replaceAll("'", "''"), params);
        } else {
            filter = String.valueOf(parameter) + " " + predicate;
        }
        return "(" + filter + ")";
    }

    public static String parsePredicateFromReqList(String reqList, String schemaCol, String nameCol, String filterVal) {
        HashMap<String, Set<String>> objectMap = new HashMap<String, Set<String>>();
        StringTokenizer listTokenizer = new StringTokenizer(reqList, "||");
        while (listTokenizer.hasMoreTokens()) {
            String fromList = listTokenizer.nextToken();
            fromList = CatalogLoadUtil.removeTag(fromList);
            StringTokenizer objTokenizer = new StringTokenizer(fromList, ",");
            while (objTokenizer.hasMoreTokens()) {
                CatalogLoadUtil.addObjectToMap(objTokenizer.nextToken(), objectMap);
            }
        }
        if (objectMap.size() == 0) {
            return EMPTY;
        }
        StringBuilder predicate = new StringBuilder();
        Set schemas = objectMap.keySet();
        for (String schema : schemas) {
            predicate.append("(");
            predicate.append(String.valueOf(schemaCol) + "='" + schema + "' AND " + nameCol + " IN (");
            for (String name : (Set)objectMap.get(schema)) {
                predicate.append("'" + name + "',");
            }
            predicate.setLength(predicate.length() - 1);
            predicate.append(")) OR ");
        }
        if (predicate.length() == 0) {
            return EMPTY;
        }
        predicate.setLength(predicate.length() - 4);
        return predicate.toString();
    }

    private static void addObjectToMap(String obj, Map<String, Set<String>> objectMap) {
        String[] elms = obj.split("\\.");
        if (elms.length != 2) {
            return;
        }
        String schema = elms[0];
        String name = elms[1];
        Set<String> objectSet = objectMap.get(schema);
        if (objectSet == null) {
            objectSet = new HashSet<String>();
            objectMap.put(schema, objectSet);
        }
        objectSet.add(name);
    }

    private static String removeTag(String fromList) {
        return fromList.substring(fromList.indexOf(93) + 1);
    }

    public static void safeClose(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    public static void safeClose(Statement stmt, ResultSet rs) {
        CatalogLoadUtil.safeClose(rs);
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    public static String safeGetString(ResultSet r, String name) throws SQLException {
        String s = r.getString(name);
        return s != null ? s : EMPTY;
    }

    public static String safeGetTrimmedString(ResultSet r, String name) throws SQLException {
        String s = r.getString(name);
        return s != null ? s.trim() : EMPTY;
    }

    public static void safeClose(LineNumberReader lnr) {
        if (lnr != null) {
            try {
                lnr.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void safeClose(PrintWriter pw) {
        if (pw != null) {
            pw.close();
        }
    }
}

