/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.ITrinidadConstants;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractLabelAndHelpOperation
extends AbstractTrinidadTransformOperation {
    private static final String STYLECLASS_OUTERELEMENT = "af_inputText p_AFRequired";
    private static final String STYLECLASS_LABELTD = "af_inputText_label";
    private static final String STYLECLASS_REQUIREDSPAN = "AFRequiredIconStyle";
    private static final String STYLECLASS_CONTROLTD = "AFContentCell";
    protected static final String STYLECLASS_CONTROLELEMENT = "af_inputText_content";
    private static final String STYLECLASS_HELPTD = "AFComponentMessageCell";
    private static final String STYLECLASS_HELPSPAN = "OraInlineInfoText";

    protected abstract void appendControl(Element var1, Element var2);

    public Element transform(Element srcElement, Element curElement) {
        Element outerElement;
        String simple = srcElement.getAttribute("simple");
        if (Boolean.valueOf(simple).booleanValue()) {
            outerElement = this.createElement("span");
        } else {
            outerElement = this.createElement("table");
            this.appendAttribute(outerElement, "cellpadding", "0");
            this.appendAttribute(outerElement, "cellspacing", "0");
            this.appendAttribute(outerElement, "border", "0");
        }
        this.appendAttribute(outerElement, "class", this.calculateStyleClass(STYLECLASS_OUTERELEMENT, srcElement, "styleClass"));
        String inlineStyle = this.calculateStyle(null, srcElement, "inlineStyle");
        if (inlineStyle != null) {
            this.appendAttribute(outerElement, "style", inlineStyle);
        }
        if (Boolean.valueOf(simple).booleanValue()) {
            this.appendControl(srcElement, outerElement);
        } else {
            Element tdElement;
            Element trElement = this.appendChildElement("tr", outerElement);
            if (this.isRequired(srcElement) || this.getLabel(srcElement) != null) {
                tdElement = this.appendChildElement("td", trElement);
                this.appendAttribute(tdElement, "class", STYLECLASS_LABELTD);
                this.appendAttribute(tdElement, "valign", "top");
                this.appendAttribute(tdElement, "nowrap", "");
                if (this.isRequired(srcElement)) {
                    Element spanElement = this.appendChildElement("span", tdElement);
                    this.appendAttribute(spanElement, "title", "Required");
                    this.appendAttribute(spanElement, "class", STYLECLASS_REQUIREDSPAN);
                    this.appendChildText("* ", spanElement);
                }
                if (this.getLabel(srcElement) != null) {
                    Element labelElement = this.appendChildElement("label", tdElement);
                    this.appendChildText(this.getLabel(srcElement), labelElement);
                }
            }
            tdElement = this.appendChildElement("td", trElement);
            this.appendAttribute(tdElement, "class", STYLECLASS_CONTROLTD);
            this.appendAttribute(tdElement, "valign", "top");
            this.appendAttribute(tdElement, "nowrap", "");
            this.appendControl(srcElement, tdElement);
            List<Node> helpFacetChildNodes = this.getHelpFacetChildNodes(srcElement);
            if (helpFacetChildNodes.size() > 0) {
                trElement = this.appendChildElement("tr", outerElement);
                if (this.isRequired(srcElement) || this.getLabel(srcElement) != null) {
                    tdElement = this.appendChildElement("td", trElement);
                }
                tdElement = this.appendChildElement("td", trElement);
                this.appendAttribute(tdElement, "class", STYLECLASS_HELPTD);
                Element spanElement = this.appendChildElement("span", tdElement);
                this.appendAttribute(spanElement, "class", this.calculateStyle(STYLECLASS_HELPSPAN, srcElement, "styleClass"));
                if (inlineStyle != null) {
                    this.appendAttribute(spanElement, "style", inlineStyle);
                }
                Iterator<Node> itHelpFacetChildNodes = helpFacetChildNodes.iterator();
                int curPos = 0;
                while (itHelpFacetChildNodes.hasNext()) {
                    Node curNode = itHelpFacetChildNodes.next();
                    if (curNode instanceof Text) {
                        if (curNode.getNodeValue() != null && curNode.getNodeValue().length() > 0) {
                            this.tagConverterContext.addChild(curNode, new ConvertPosition((Node)spanElement, curPos));
                        }
                    } else {
                        this.tagConverterContext.addChild(curNode, new ConvertPosition((Node)spanElement, curPos));
                    }
                    ++curPos;
                }
            }
        }
        return outerElement;
    }

    protected String calculateStyle(String baseStyle, Element srcElement, String styleAttributeName) {
        String srcElementStyle;
        Object style = baseStyle;
        if (srcElement != null && styleAttributeName != null && (srcElementStyle = srcElement.getAttribute(styleAttributeName)) != null && srcElementStyle.length() > 0) {
            if (style != null) {
                if (!((String)style).endsWith(";")) {
                    style = (String)style + ";";
                }
                style = (String)style + srcElementStyle;
            } else {
                style = srcElementStyle;
            }
        }
        return style;
    }

    protected String calculateStyleClass(String baseStyleClass, Element srcElement, String styleClassAttributeName) {
        String srcElementStyleClass;
        Object styleClass = baseStyleClass;
        if (srcElement != null && styleClassAttributeName != null && (srcElementStyleClass = srcElement.getAttribute(styleClassAttributeName)) != null && srcElementStyleClass.length() > 0) {
            if (styleClass != null) {
                if (!((String)styleClass).endsWith(",")) {
                    styleClass = (String)styleClass + ",";
                }
                styleClass = (String)styleClass + srcElementStyleClass;
            } else {
                styleClass = srcElementStyleClass;
            }
        }
        return styleClass;
    }

    protected boolean isRequired(Element srcElement) {
        boolean required = false;
        if (!this.isChildOfPanelFormLayout(srcElement) && srcElement != null) {
            String requiredVal = srcElement.getAttribute("required");
            String showRequiredVal = srcElement.getAttribute("showRequired");
            required = Boolean.parseBoolean(requiredVal) || Boolean.parseBoolean(showRequiredVal);
        }
        return required;
    }

    protected String getLabel(Element srcElement) {
        String label = null;
        if (!this.isChildOfPanelFormLayout(srcElement) && srcElement != null) {
            String labelAndAccessKeyVal = srcElement.getAttribute("labelAndAccessKey");
            if (labelAndAccessKeyVal != null && labelAndAccessKeyVal.length() > 0) {
                label = labelAndAccessKeyVal;
            } else {
                String labelVal = srcElement.getAttribute("label");
                if (labelVal != null && labelVal.length() > 0) {
                    label = labelVal;
                }
            }
        }
        return label;
    }

    protected List<Node> getHelpFacetChildNodes(Element srcElement) {
        List<Node> children = Collections.EMPTY_LIST;
        Element helpFacet = this.getChildFacetByName(srcElement, "help");
        if (helpFacet != null) {
            children = this.getCopyChildrenNodes(helpFacet);
        }
        return children;
    }

    protected int getColumns(Element srcElement) {
        String columnsValue;
        int columns = 30;
        if (srcElement != null && (columnsValue = srcElement.getAttribute("columns")) != null && columnsValue.length() > 0) {
            try {
                columns = Integer.parseInt(columnsValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return columns;
    }

    protected boolean isChildOfPanelFormLayout(Element srcElement) {
        Node parent;
        boolean isChild = false;
        if (srcElement != null && (parent = srcElement.getParentNode()) instanceof Element) {
            TagIdentifier tagID = TagIdentifierFactory.createDocumentTagWrapper((Element)((Element)parent));
            if (ITrinidadConstants.TAG_IDENTIFIER_PANELFORMLAYOUT.isSameTagType(tagID)) {
                isChild = true;
            } else if (ITrinidadConstants.TAG_IDENTIFIER_GROUP.isSameTagType(tagID)) {
                isChild = this.isChildOfPanelFormLayout((Element)parent);
            } else if (IJSFConstants.TAG_IDENTIFIER_FACET.isSameTagType(tagID)) {
                isChild = this.isChildOfPanelFormLayout((Element)parent);
            }
        }
        return isChild;
    }
}

