/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.jaxrsappconfig.internal;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JAXRSAppConfigUtils {
    public static boolean isValidJAXRSProject(IProject project) {
        boolean isValid = false;
        IProjectFacetVersion projectFacet = JAXRSAppConfigUtils.getProjectFacet(project);
        if (projectFacet != null) {
            isValid = true;
        }
        return isValid;
    }

    public static IProjectFacetVersion getProjectFacet(IProject project) {
        if (project != null && project.isAccessible()) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null) {
                    Set projectFacets = facetedProject.getProjectFacets();
                    for (IProjectFacetVersion projectFacetVersion : projectFacets) {
                        if (!"jst.jaxrs".equals(projectFacetVersion.getProjectFacet().getId())) continue;
                        return projectFacetVersion;
                    }
                }
            }
            catch (CoreException ce) {
                JAXRSCorePlugin.log(4, ce.getLocalizedMessage(), ce);
            }
        }
        return null;
    }

    public static IVirtualFolder getWebContentFolder(IProject project) {
        IVirtualFolder folder = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            folder = component.getRootFolder();
        }
        return folder;
    }

    public static IPath getWebContentFolderRelativePath(IFile file) {
        IVirtualFolder webContentFolder;
        IPath path = null;
        if (file != null && (webContentFolder = JAXRSAppConfigUtils.getWebContentFolder(file.getProject())) != null) {
            IPath webContentPath = webContentFolder.getProjectRelativePath();
            IPath filePath = file.getProjectRelativePath();
            int matchingFirstSegments = webContentPath.matchingFirstSegments(filePath);
            path = filePath.removeFirstSegments(matchingFirstSegments);
        }
        return path;
    }
}

