/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.engine.support.MethodReflectionUtils;

class MethodInvocation<T>
implements InvocationInterceptor.Invocation<T>,
ReflectiveInvocationContext<Method> {
    private final Method method;
    private final Optional<Object> target;
    private final @Nullable Object[] arguments;

    MethodInvocation(Method method, Optional<Object> target, @Nullable Object[] arguments) {
        this.method = method;
        this.target = target;
        this.arguments = arguments;
    }

    public Class<?> getTargetClass() {
        return this.target.map(Object::getClass).orElseGet(this.method::getDeclaringClass);
    }

    public Optional<Object> getTarget() {
        return this.target;
    }

    public Method getExecutable() {
        return this.method;
    }

    public List<Object> getArguments() {
        return Collections.unmodifiableList(Arrays.asList(this.arguments));
    }

    public T proceed() {
        Object actualTarget = this.target.orElse(null);
        return (T)MethodReflectionUtils.invoke(this.method, actualTarget, this.arguments);
    }
}

