/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.process.internal;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;

public class Env {
    private static Properties envVars;
    private static List<String> toUppercaseEnvironmentVars;

    static {
        toUppercaseEnvironmentVars = Arrays.asList("PATH", "CYGWIN_HOME", "LANG");
        boolean isWindows = "win32".equals(Platform.getOS());
        envVars = new Properties();
        Map<String, String> envMap = System.getenv();
        for (Map.Entry<String, String> curEnvVar : envMap.entrySet()) {
            String key = curEnvVar.getKey();
            String value = curEnvVar.getValue();
            if (isWindows && toUppercaseEnvironmentVars.contains(key.toUpperCase())) {
                key = key.toUpperCase();
            }
            envVars.setProperty(key, value);
        }
    }

    public static String[] getEnvironment(String[] envp, boolean terminal) {
        Properties environmentVariables = Env.getEnvVars();
        if (envp != null) {
            String[] stringArray = envp;
            int n = envp.length;
            int n2 = 0;
            while (n2 < n) {
                String keyValue = stringArray[n2];
                String[] parts = keyValue.split("=", 2);
                if (parts.length == 2) {
                    String name = parts[0];
                    String value = parts[1];
                    if ("<unset>".equals(value)) {
                        environmentVariables.remove(name);
                    } else {
                        environmentVariables.put(name, value);
                    }
                }
                ++n2;
            }
        }
        if (terminal) {
            environmentVariables.put("TERM", "xterm");
        }
        ArrayList<String> keys = new ArrayList<String>(environmentVariables.stringPropertyNames());
        if ("win32".equals(Platform.getOS())) {
            Collections.sort(keys);
        }
        ArrayList<CallSite> strings = new ArrayList<CallSite>(keys.size());
        for (String key : keys) {
            String value = environmentVariables.getProperty(key);
            strings.add((CallSite)((Object)(key + "=" + value)));
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static Properties getEnvVars() {
        return (Properties)envVars.clone();
    }
}

