/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.SynchronizationJob;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelectionProvider;
import org.eclipse.buildship.ui.internal.util.nodeselection.SelectionHistoryManager;
import org.eclipse.buildship.ui.internal.util.widget.FilteredTree;
import org.eclipse.buildship.ui.internal.util.widget.PatternFilter;
import org.eclipse.buildship.ui.internal.view.task.ReloadTaskViewJob;
import org.eclipse.buildship.ui.internal.view.task.TaskDescriptionLabelProvider;
import org.eclipse.buildship.ui.internal.view.task.TaskNameLabelProvider;
import org.eclipse.buildship.ui.internal.view.task.TaskNodeViewerFilter;
import org.eclipse.buildship.ui.internal.view.task.TaskNodeViewerSorter;
import org.eclipse.buildship.ui.internal.view.task.TaskViewContent;
import org.eclipse.buildship.ui.internal.view.task.TaskViewContentProvider;
import org.eclipse.buildship.ui.internal.view.task.TaskViewMessages;
import org.eclipse.buildship.ui.internal.view.task.TaskViewState;
import org.eclipse.buildship.ui.internal.view.task.UiContributionManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.wizards.IWizardDescriptor;

public final class TaskView
extends ViewPart
implements NodeSelectionProvider {
    public static final String ID = "org.eclipse.buildship.ui.views.taskview";
    private TaskViewState state;
    private UiContributionManager uiContributionManager;
    private SelectionHistoryManager selectionHistoryManager;
    private PageBook pages;
    private Link emptyInputPage;
    private Label errorInputPage;
    private Composite nonEmptyInputPage;
    private TreeViewer treeViewer;
    private FilteredTree filteredTree;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.state = new TaskViewState();
        this.state.load();
    }

    public void createPartControl(Composite parent) {
        this.pages = new PageBook(parent, 0);
        this.emptyInputPage = new Link((Composite)this.pages, 0);
        this.emptyInputPage.setText(TaskViewMessages.Label_No_Gradle_Projects);
        this.errorInputPage = new Label((Composite)this.pages, 0);
        this.errorInputPage.setText(TaskViewMessages.Label_Reload_Error);
        this.errorInputPage.setForeground(parent.getDisplay().getSystemColor(3));
        this.nonEmptyInputPage = new Composite((Composite)this.pages, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.nonEmptyInputPage.setLayout((Layout)gridLayout);
        this.filteredTree = new FilteredTree(this.nonEmptyInputPage, 770, new PatternFilter(true));
        this.filteredTree.setShowFilterControls(false);
        this.treeViewer = this.filteredTree.getViewer();
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addFilter(TaskNodeViewerFilter.createFor(this.getState()));
        this.treeViewer.setComparator((ViewerComparator)TaskNodeViewerSorter.createFor(this.state));
        this.treeViewer.setContentProvider((IContentProvider)new TaskViewContentProvider(this));
        TreeViewerColumn treeViewerNameColumn = new TreeViewerColumn(this.treeViewer, 16384);
        treeViewerNameColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TaskNameLabelProvider()));
        final TreeColumn taskNameColumn = treeViewerNameColumn.getColumn();
        taskNameColumn.setText(TaskViewMessages.Tree_Column_Name_Text);
        taskNameColumn.setWidth(this.state.getHeaderNameColumnWidth());
        TreeViewerColumn treeViewerDescriptionColumn = new TreeViewerColumn(this.treeViewer, 16384);
        treeViewerDescriptionColumn.setLabelProvider((CellLabelProvider)new TaskDescriptionLabelProvider());
        final TreeColumn taskDescriptionColumn = treeViewerDescriptionColumn.getColumn();
        taskDescriptionColumn.setText(TaskViewMessages.Tree_Column_Description_Text);
        taskDescriptionColumn.setWidth(this.state.getHeaderDescriptionColumnWidth());
        this.emptyInputPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    IWizardDescriptor descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard("org.eclipse.buildship.ui.wizards.project.import");
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    dialog.open();
                }
                catch (CoreException e) {
                    throw new GradlePluginsRuntimeException((Throwable)e);
                }
            }
        });
        taskNameColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TaskView.this.state.setHeaderNameColumnWidth(taskNameColumn.getWidth());
            }
        });
        taskDescriptionColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TaskView.this.state.setHeaderDescriptionColumnWidth(taskDescriptionColumn.getWidth());
            }
        });
        this.selectionHistoryManager = new SelectionHistoryManager(this.treeViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionHistoryManager);
        this.uiContributionManager = new UiContributionManager(this);
        this.uiContributionManager.wire();
        this.reload(FetchStrategy.FROM_CACHE_ONLY);
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob() instanceof SynchronizationJob) {
                    TaskView.this.reload(FetchStrategy.FROM_CACHE_ONLY);
                }
            }
        });
    }

    public void refresh() {
        if (!this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.refresh(true);
        }
    }

    public void setContent(TaskViewContent content) {
        if (!this.pages.isDisposed() && !this.treeViewer.getControl().isDisposed()) {
            this.pages.showPage((Control)(content.isEmpty() ? this.emptyInputPage : this.nonEmptyInputPage));
            this.treeViewer.setInput((Object)content);
        }
    }

    public void reload(FetchStrategy fetchStrategy) {
        new ReloadTaskViewJob(this, fetchStrategy).schedule();
    }

    public void setFocus() {
        this.pages.setFocus();
    }

    public TaskViewState getState() {
        return this.state;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public FilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    @Override
    public NodeSelection getSelection() {
        return this.selectionHistoryManager.getSelectionHistory();
    }

    public void dispose() {
        if (this.state != null) {
            this.state.dispose();
        }
        if (this.selectionHistoryManager != null) {
            this.selectionHistoryManager.dispose();
        }
        if (this.uiContributionManager != null) {
            this.uiContributionManager.dispose();
        }
        super.dispose();
    }
}

