/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.util.TimerTask;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.MonitorProgressRequest;
import org.eclipse.net4j.signal.Signal;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.ExceptionHandler;
import org.eclipse.net4j.util.RunnableWithException;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.TimeoutMonitor;

public abstract class SignalReactor
extends Signal {
    private ReportingMonitor monitor;

    public SignalReactor(SignalProtocol<?> protocol, short id, String name) {
        super(protocol, id, name);
    }

    public SignalReactor(SignalProtocol<?> protocol, short signalID) {
        super(protocol, signalID);
    }

    public SignalReactor(SignalProtocol<?> protocol, Enum<?> literal) {
        super(protocol, literal);
    }

    protected final OMMonitor createMonitor(int monitorProgressSeconds, int monitorTimeoutSeconds) {
        if (this.monitor != null) {
            throw new IllegalStateException("Illegal attempt to create a second monitor");
        }
        this.monitor = new ReportingMonitor(monitorProgressSeconds, monitorTimeoutSeconds);
        return this.monitor;
    }

    protected final void monitor(int monitorProgressSeconds, int monitorTimeoutSeconds, RunnableWithException runnable) throws Exception {
        OMMonitor monitor = this.createMonitor(monitorProgressSeconds, monitorTimeoutSeconds);
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            runnable.run();
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    @Override
    void runSync() throws Exception {
        try {
            super.runSync();
        }
        finally {
            if (this.monitor != null) {
                this.monitor.done();
            }
        }
    }

    void setMonitorCanceled() {
        this.monitor.cancel();
    }

    @Override
    String getInputMeaning() {
        return "Indicating";
    }

    @Override
    String getOutputMeaning() {
        return "Responding";
    }

    private final class ReportingMonitor
    extends TimeoutMonitor {
        private TimerTask sendProgressTask;

        public ReportingMonitor(int monitorProgressSeconds, int monitorTimeoutSeconds) {
            super(1000L * (long)monitorTimeoutSeconds);
            this.sendProgressTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        ReportingMonitor.this.sendProgress();
                    }
                    catch (Throwable ex) {
                        ExceptionHandler.Factory.handle((IManagedContainerProvider)SignalReactor.this, (Throwable)ex, (String)"ReportingMonitorTask failed", (OMLogger)OM.LOG);
                        this.cancel();
                    }
                }
            };
            long period = 1000L * (long)monitorProgressSeconds;
            this.scheduleAtFixedRate(this.sendProgressTask, period, period);
        }

        public void cancel(RuntimeException cancelException) {
            this.sendProgressTask.cancel();
            super.cancel(cancelException);
        }

        public void done() {
            try {
                this.sendProgressTask.cancel();
                super.done();
            }
            finally {
                SignalReactor.this.monitor = null;
            }
        }

        private void sendProgress() {
            block2: {
                SignalProtocol<?> protocol = SignalReactor.this.getProtocol();
                try {
                    int correlationID = -SignalReactor.this.getCorrelationID();
                    double totalWork = this.getTotalWork();
                    double work = this.getWork();
                    new MonitorProgressRequest(protocol, correlationID, totalWork, work).sendAsync();
                }
                catch (Exception ex) {
                    IChannel channel = protocol.getChannel();
                    if (!LifecycleUtil.isActive((Object)channel)) break block2;
                    ExceptionHandler.Factory.handle((IManagedContainerProvider)SignalReactor.this, (Throwable)ex, (String)"MonitorProgressRequest failed", (OMLogger)OM.LOG);
                }
            }
        }
    }
}

