/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.internal.page.propertylist;

import org.eclipse.eef.properties.ui.api.IEEFTabItem;
import org.eclipse.eef.properties.ui.internal.page.EEFTabbedPropertyComposite;
import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFTabbedPropertyList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class EEFListElement
extends Canvas {
    private IEEFTabItem tab;
    private int index;
    private EEFTabbedPropertyList tabbedPropertyList;
    private boolean selected;
    private boolean hover;
    private Image[] dynamicImages;
    private Color textColor;

    public EEFListElement(Composite parent, IEEFTabItem tab, int index, EEFTabbedPropertyList tabbedPropertyList) {
        super(parent, 524288);
        this.tab = tab;
        this.index = index;
        this.tabbedPropertyList = tabbedPropertyList;
        this.textColor = this.tabbedPropertyList.getColorHolder().getWidgetForeground();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                EEFListElement.this.paint(event);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                EEFListElement.this.mouseUp(event);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (!EEFListElement.this.hover) {
                    EEFListElement.this.hover = true;
                    EEFListElement.this.redraw();
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent event) {
                EEFListElement.this.hover = false;
                EEFListElement.this.redraw();
            }
        });
    }

    public EEFListElement(Composite parent, IEEFTabItem tab, int dynamicImageCount, int index, EEFTabbedPropertyList tabbedPropertyList) {
        this(parent, tab, index, tabbedPropertyList);
        this.dynamicImages = new Image[dynamicImageCount];
        int i = 0;
        while (i < dynamicImageCount) {
            this.dynamicImages[i] = null;
            ++i;
        }
    }

    protected void mouseUp(MouseEvent event) {
        if (!this.selected) {
            this.tabbedPropertyList.select(this.index);
            Composite tabbedPropertyComposite = this.getParent();
            while (!(tabbedPropertyComposite instanceof EEFTabbedPropertyComposite)) {
                tabbedPropertyComposite = tabbedPropertyComposite.getParent();
            }
            tabbedPropertyComposite.setFocus();
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.redraw();
    }

    public void showDynamicImage(int i, Image image) {
        if (i >= 0 && i < this.dynamicImages.length && this.dynamicImages[i] != image) {
            this.dynamicImages[i] = image;
            this.redraw();
        }
    }

    public void hideDynamicImage(int i) {
        if (i >= 0 && i < this.dynamicImages.length && this.dynamicImages[i] != null) {
            this.dynamicImages[i] = null;
            this.redraw();
        }
    }

    public void setTextColor(Color textColor) {
        if (textColor != null && !this.textColor.equals((Object)textColor)) {
            this.textColor = textColor;
            this.redraw();
        }
    }

    public void setDefaultTextColor() {
        Color widgetForeground = this.tabbedPropertyList.getColorHolder().getWidgetForeground();
        if (!this.textColor.equals((Object)widgetForeground)) {
            this.textColor = widgetForeground;
            this.redraw();
        }
    }

    private void paint(PaintEvent e) {
        Rectangle bounds = this.getBounds();
        e.gc.setForeground(this.tabbedPropertyList.getColorHolder().getWidgetNormalShadow());
        e.gc.drawLine(0, 0, bounds.width - 1, 0);
        e.gc.setForeground(this.tabbedPropertyList.getColorHolder().getListBackground());
        e.gc.drawLine(0, 1, bounds.width - 1, 1);
        if (this.selected) {
            e.gc.setBackground(this.tabbedPropertyList.getColorHolder().getListBackground());
            e.gc.fillRectangle(0, 2, bounds.width, bounds.height - 1);
        } else if (this.hover && this.tab.isIndented()) {
            e.gc.setBackground(this.tabbedPropertyList.getColorHolder().getIndentedHoverBackground());
            e.gc.fillRectangle(0, 2, bounds.width - 1, bounds.height - 1);
        } else if (this.hover) {
            e.gc.setForeground(this.tabbedPropertyList.getColorHolder().getHoverGradientStart());
            e.gc.setBackground(this.tabbedPropertyList.getColorHolder().getHoverGradientEnd());
            e.gc.fillGradientRectangle(0, 2, bounds.width - 1, bounds.height - 1, true);
        } else if (this.tab.isIndented()) {
            e.gc.setBackground(this.tabbedPropertyList.getColorHolder().getIndentedDefaultBackground());
            e.gc.fillRectangle(0, 2, bounds.width - 1, bounds.height - 1);
        } else {
            e.gc.setForeground(this.tabbedPropertyList.getColorHolder().getDefaultGradientStart());
            e.gc.setBackground(this.tabbedPropertyList.getColorHolder().getDefaultGradientEnd());
            e.gc.fillGradientRectangle(0, 2, bounds.width - 1, bounds.height - 1, true);
        }
        if (!this.selected) {
            e.gc.setForeground(this.tabbedPropertyList.getColorHolder().getWidgetNormalShadow());
            e.gc.drawLine(bounds.width - 1, 1, bounds.width - 1, bounds.height + 1);
        }
        int textIndent = 7;
        FontMetrics fm = e.gc.getFontMetrics();
        int height = fm.getHeight();
        int textMiddle = (bounds.height - height) / 2;
        if (this.selected && this.tab.getImage() != null && !this.tab.getImage().isDisposed()) {
            textIndent = this.tab.isIndented() ? (textIndent += 7) : (textIndent -= 3);
            e.gc.drawImage(this.tab.getImage(), textIndent, textMiddle - 1);
            textIndent = textIndent + 16 + 4;
        } else if (this.tab.isIndented()) {
            textIndent += 7;
        }
        e.gc.setForeground(this.textColor);
        if (this.selected) {
            e.gc.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        }
        e.gc.drawText(this.tab.getText(), textIndent, textMiddle, true);
        if (((EEFTabbedPropertyList)this.getParent()).getFocus() && this.selected) {
            Point point = e.gc.textExtent(this.tab.getText());
            e.gc.drawLine(textIndent, bounds.height - 4, textIndent + point.x, bounds.height - 4);
        }
        boolean hasDynamicImage = false;
        int i = 0;
        while (i < this.dynamicImages.length) {
            Image dynamicImage = this.dynamicImages[i];
            if (dynamicImage != null && !dynamicImage.isDisposed()) {
                hasDynamicImage = true;
                break;
            }
            ++i;
        }
        if (hasDynamicImage) {
            int drawPosition = textIndent + e.gc.textExtent((String)this.tab.getText()).x + 4;
            boolean addSpace = false;
            int i2 = 0;
            while (i2 < this.dynamicImages.length) {
                Image dynamicImage = this.dynamicImages[i2];
                if (dynamicImage != null && !dynamicImage.isDisposed()) {
                    if (addSpace) {
                        drawPosition += 3;
                    }
                    e.gc.drawImage(dynamicImage, drawPosition, textMiddle - 1);
                    drawPosition += 16;
                    addSpace = true;
                }
                ++i2;
            }
        }
        if (!this.hover) {
            e.gc.setForeground(this.tabbedPropertyList.getColorHolder().getListBackground());
            e.gc.drawLine(0, bounds.height - 1, bounds.width - 2, bounds.height - 1);
        }
    }

    public IEEFTabItem getTabItem() {
        return this.tab;
    }

    public String toString() {
        return this.tab.getText();
    }
}

