/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.om.OMPlatform;

public class ThreadPool
extends ThreadPoolExecutor
implements RejectedExecutionHandler {
    public static final String DEFAULT_THREAD_GROUP_NAME = "net4j";
    public static final int DEFAULT_CORE_POOL_SIZE = 10;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = Integer.MAX_VALUE;
    public static final long DEFAULT_KEEP_ALIVE_SECONDS = 60L;
    private static final Class<?> LINKED_BLOCKING_DEQUE_CLASS;
    private static final Method OFFER_LAST_METHOD;
    private static final int NO_DEADLOCK_DETECTION = 0;
    private static final int deadlockDetectionInterval;
    private final AtomicInteger runningTasks = new AtomicInteger();
    private final AtomicInteger runTasks = new AtomicInteger();
    private int lastRunTasks = -1;
    private RejectedExecutionHandler userHandler;

    static {
        deadlockDetectionInterval = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.util.concurrent.ThreadPool.deadlockDetectionInterval", 0);
        Class<?> c = null;
        Method m = null;
        try {
            c = Class.forName("java.util.concurrent.LinkedBlockingDeque");
            m = c.getMethod("offerLast", Object.class);
        }
        catch (Throwable ex) {
            c = null;
            m = null;
        }
        LINKED_BLOCKING_DEQUE_CLASS = c;
        OFFER_LAST_METHOD = m;
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveSeconds, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveSeconds, TimeUnit.SECONDS, (BlockingQueue<Runnable>)ThreadPool.createWorkQueue(), threadFactory);
        ((WorkQueue)this.getQueue()).setThreadPool(this);
        super.setRejectedExecutionHandler(this);
        if (deadlockDetectionInterval != 0) {
            DeadlockDetector.INSTANCE.register(this);
        }
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        this.userHandler = handler;
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.userHandler;
    }

    @Override
    public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
        WorkQueue queue = (WorkQueue)this.getQueue();
        if (!queue.offerLast(task)) {
            if (this.userHandler != null) {
                this.userHandler.rejectedExecution(task, this);
            } else {
                OM.LOG.error("Thread pool has rejected the task " + task);
            }
        }
    }

    @Override
    public int getActiveCount() {
        return this.runningTasks.get();
    }

    @Override
    protected void beforeExecute(Thread worker, Runnable task) {
        this.runningTasks.incrementAndGet();
        this.incrementRunTasks();
    }

    @Override
    protected void afterExecute(Runnable task, Throwable ex) {
        this.runningTasks.decrementAndGet();
    }

    protected void potentialDeadlockDetected() {
        BlockingQueue<Runnable> queue = this.getQueue();
        int size = queue.size();
        if (size > 0) {
            String poolName = this.toString();
            ExecutorService executor = null;
            try {
                Runnable task;
                executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 100L, TimeUnit.MICROSECONDS, new SynchronousQueue<Runnable>());
                boolean first = true;
                while ((task = (Runnable)queue.poll()) != null) {
                    if (first) {
                        OM.LOG.warn("Potential deadlock detected in " + poolName + ". Executing " + size + " tasks...");
                        first = false;
                    }
                    this.incrementRunTasks();
                    executor.execute(task);
                }
            }
            finally {
                if (executor != null) {
                    executor.shutdown();
                }
            }
        }
    }

    private void incrementRunTasks() {
        int next;
        int current;
        while (!this.runTasks.compareAndSet(current, next = (current = this.runTasks.get()) == Integer.MAX_VALUE ? 0 : current + 1)) {
        }
    }

    private boolean shallEnqueue() {
        int poolSize = this.getPoolSize();
        if (this.getQueue().size() < poolSize - this.getActiveCount()) {
            return true;
        }
        return poolSize >= this.getMaximumPoolSize();
    }

    public static ThreadPool create() {
        return ThreadPool.create(null, 10, Integer.MAX_VALUE, 60L);
    }

    public static ThreadPool create(String description) {
        String[] tokens;
        String threadGroupName = null;
        int corePoolSize = 10;
        int maximumPoolSize = Integer.MAX_VALUE;
        long keepAliveSeconds = 60L;
        if (!StringUtil.isEmpty(description) && (tokens = description.split(":")).length > 0) {
            threadGroupName = tokens[0];
            if (tokens.length > 1) {
                try {
                    corePoolSize = Integer.parseInt(tokens[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (tokens.length > 2) {
                    try {
                        maximumPoolSize = Integer.parseInt(tokens[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (tokens.length > 3) {
                        try {
                            keepAliveSeconds = Long.parseLong(tokens[3]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return ThreadPool.create(threadGroupName, corePoolSize, maximumPoolSize, keepAliveSeconds);
    }

    public static ThreadPool create(String threadGroupName, int corePoolSize, int maximumPoolSize, long keepAliveSeconds) {
        ThreadFactory threadFactory = ThreadPool.createThreadFactory(threadGroupName);
        return new ThreadPool(corePoolSize, maximumPoolSize, keepAliveSeconds, threadFactory);
    }

    private static ThreadFactory createThreadFactory(String threadGroupName) {
        if (threadGroupName == null) {
            threadGroupName = DEFAULT_THREAD_GROUP_NAME;
        }
        final ThreadGroup threadGroup = new ThreadGroup(threadGroupName);
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger num = new AtomicInteger();

            @Override
            public Thread newThread(Runnable task) {
                Thread thread = new Thread(threadGroup, task, String.valueOf(threadGroup.getName()) + "-thread-" + this.num.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        };
        return threadFactory;
    }

    private static WorkQueue createWorkQueue() {
        if (LINKED_BLOCKING_DEQUE_CLASS != null) {
            try {
                return new WorkQueueJRE16();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new WorkQueueJRE15();
    }

    private static final class DeadlockDetector
    extends Worker {
        public static final DeadlockDetector INSTANCE = new DeadlockDetector();
        private volatile ArrayList<ThreadPool> pools = new ArrayList();

        private DeadlockDetector() {
            this.setDaemon(true);
            this.activate();
        }

        public void register(ThreadPool pool) {
            ArrayList<ThreadPool> newList = new ArrayList<ThreadPool>(this.pools);
            newList.add(pool);
            this.pools = newList;
        }

        private void unregister(ThreadPool pool) {
            ArrayList<ThreadPool> newList = new ArrayList<ThreadPool>(this.pools);
            newList.remove(pool);
            this.pools = newList;
        }

        @Override
        protected String getThreadName() {
            return DeadlockDetector.class.getSimpleName();
        }

        @Override
        protected void work(Worker.WorkContext context) throws Exception {
            ArrayList<ThreadPool> list = this.pools;
            int size = list.size();
            int i = 0;
            while (i < size) {
                ThreadPool pool = list.get(i);
                if (pool.isShutdown()) {
                    this.unregister(pool);
                } else {
                    this.work(pool);
                }
                ++i;
            }
            context.nextWork(deadlockDetectionInterval);
        }

        private void work(ThreadPool pool) {
            int lastRunTasks = pool.runTasks.get();
            if (lastRunTasks != pool.lastRunTasks) {
                pool.lastRunTasks = lastRunTasks;
            } else if (pool.getPoolSize() == pool.getMaximumPoolSize()) {
                pool.potentialDeadlockDetected();
            }
        }
    }

    private static interface WorkQueue
    extends BlockingQueue<Runnable> {
        public void setThreadPool(ThreadPool var1);

        public boolean offerLast(Runnable var1);
    }

    private static final class WorkQueueJRE15
    extends LinkedBlockingQueue<Runnable>
    implements WorkQueue {
        private static final long serialVersionUID = 1L;
        private ThreadPool threadPool;

        @Override
        public void setThreadPool(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public boolean offerLast(Runnable task) {
            return super.offer(task);
        }

        @Override
        public boolean offer(Runnable task) {
            if (this.threadPool.shallEnqueue()) {
                return super.offer(task);
            }
            return false;
        }
    }

    private static final class WorkQueueJRE16
    extends AbstractQueue<Runnable>
    implements WorkQueue {
        private final BlockingQueue<Runnable> delegate = WorkQueueJRE16.createDelegate();
        private ThreadPool threadPool;

        @Override
        public void setThreadPool(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public boolean offerLast(Runnable task) {
            try {
                return (Boolean)OFFER_LAST_METHOD.invoke(this.delegate, task);
            }
            catch (Throwable ex) {
                return false;
            }
        }

        @Override
        public boolean offer(Runnable task) {
            if (this.threadPool.shallEnqueue()) {
                return this.delegate.offer(task);
            }
            return false;
        }

        @Override
        public boolean offer(Runnable taske, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.offer(taske, timeout, unit);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Runnable take() throws InterruptedException {
            return this.delegate.take();
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.poll(timeout, unit);
        }

        @Override
        public Runnable poll() {
            return (Runnable)this.delegate.poll();
        }

        @Override
        public Iterator<Runnable> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.delegate.peek();
        }

        @Override
        public void put(Runnable task) throws InterruptedException {
            this.delegate.put(task);
        }

        @Override
        public int remainingCapacity() {
            return this.delegate.remainingCapacity();
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            return this.delegate.drainTo(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            return this.delegate.drainTo(c, maxElements);
        }

        private static BlockingQueue<Runnable> createDelegate() {
            try {
                Constructor constructor = LINKED_BLOCKING_DEQUE_CLASS.getConstructor(new Class[0]);
                return (BlockingQueue)constructor.newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                return new LinkedBlockingQueue<Runnable>();
            }
        }
    }
}

