package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

           93,   93,  113,  113,  113,  230,   93,  393,  191,  191, 
          110,  110,  231,  243,  243,  580,  204,  243,  240,  240, 
          110,  190,  240,  422,  254,  286,  591,  552,   61,  191, 
          617,  250,  497,  239,  239,  267,  204,  239,  569,  236, 
          236,  449,  497,  236,  758,   93,  251,  243,  243,  284, 
          255,  217,  283,  278,  242,  242,  191,  110,  242,  519, 
          209,  209,  209,   72,  601,  463,  617,  276,  277,  293, 
          230,  793,   72,  271,  438,  449,  458,  252,  363,  737, 
           62,  497,  217,  498,  497,  445,  551,  284,  364,   62, 
          449,  497,  302,  511,  516,  110,  522,  523,  217,  269, 
          218,   41,  664,  220,  588,  355,   93,  458,  344,  217, 
          458,  250,  261,  255,  463,  446,  458,  469,   96,  606, 
          356,  549,  446,  492,  355,  458,  363,  363,  653,  391, 
          598,  218,  657,  305,  497,  217,  446,  666,  511,  516, 
          791,  492,  794,  302,  497,  358,  384,  218,  345,  445, 
          660,  262,  263,  458,  549,  346,  448,  361,  218,  532, 
          308,  362,   85,  216,  219,  363,  220,  459,  460,  461, 
          450,   70,  649,  497,  445,  303,  459,  460,  652,  470, 
          770,   87,  374,  661,   90,  549,  774,   88,  246,  375, 
          497,  391,  536,  497,  312,  313,   84,   84,  112,  112, 
          689,  368,   84,  191,  371,  249,  793,  549,  227,  308, 
           85,   85,  497,  459,  460,  654,  293,  249,  575,  696, 
          569,  458,  497,  445,  655,  721,  303,  312,  313,   87, 
           87,  255,   90,   90,  258,   88,   88,  264,  497,  497, 
          389,   84,  297,  477,  243,  282,  243,  243,  299,  240, 
          425,  240,  240,  267,  426,  427,   93,  404,  314,  359, 
          360,  497,  478,   93,  239,  273,  239,  424,  279,   65, 
          236,  497,  236,  420,  209,  209,  340,  863,  394,   68, 
          747,  459,  460,  282,   55,  242,  347,  242,  242,  329, 
          348,   66,  497,  331,  332,  356,  389,  365,  349,  235, 
          235,  353,   84,  235,   93,  354,  395,   62,  396,   93, 
           63,  220,  362,  362,  443,  579,  779,  396,  362,  524, 
          497,  527,  378,  759,  458,  535,  538,  259,  261,  379, 
          312,  313,  390,  235,  235,  363,  285,  287,  267,  398, 
          497,  497,  243,  356,  356,  518,  382,  342,   93,  284, 
          617,  550,  533,  597,  343,  383,  617,  110,  209,  209, 
          209,  209,   64,  479,  480,  497,  381,  531,  271,  243, 
           93,  531,  518,  391,  449,  408,  399,  400,  401,  742, 
          743,   41,   41,   93,  459,  460,  726,  243,   62,   70, 
          518,   93,  392,   93,  810,  271,  497,  531,  463,  366, 
          276,   80,  243,  230,  497,  518,  746,  243,  363,  458, 
          243,  497,  613,  271,  594,  243,  498,  497,  445,   85, 
          624,  473,   73,  497,  553,  633,  478,  497,  271,   93, 
          191,  217,  477,  628,   41,  832,  518,  204,   87,  848, 
          629,   90,  846,  369,   88,  569,  243,  497,  279,  497, 
          370,  478,   84,   70,  405,  243,  625,  543,  518,   84, 
          474,  475,  476,  477,  627,  630,  497,  266,  269,  408, 
           70,  497,  497,  497,  617,   82,   80,  457,  409,  387, 
          634,  271,  477,  414,  641,  642,  388,   65,  862,  477, 
          412,  599,  599,   80,  477,  431,  402,   68,  497,  800, 
           84,  478,  617,  403,  273,   84,  314,  279,  478,   66, 
          486,  273,  486,  478,  279,  477,  235,  235,  287,  478, 
          497,  437,  273,  279,  497,  497,  675,  487,  266,  487, 
          235,  435,  235,  235,  478,  433,  670,  444,  486,  436, 
          430,  676,  434,   93,   84,  282,  439,  678,  680,  497, 
          440,   65,  356,  453,  442,  454,  191,  868,  466,  675, 
          468,   68,   93,  714,  579,    6,   84,  534,   65,  693, 
          540,  706,  579,   66,  429,    6,  191,   93,   68,   84, 
          842,  753,  754,  204,  755,   39,   40,   84,  583,   84, 
           66,  396,  549,  844,  497,  209,  692,   75,  481,  482, 
          483,  484,  485,  486,  487,  488,  489,  490,  491,  492, 
          493,  494,  495,  496,  497,  498,  499,  500,  501,  502, 
          503,  504,  505,  506,    6,   84,  497,  497,  235,  487, 
          243,  525,  596,  528,  687,  613,   88,  235,  539,  766, 
          768,  679,  681,  497,  427,  771,  464,  465,   93,  608, 
          701,  619,  230,  703,  631,  235,  745,  697,  209,  231, 
           93,  632,   93,  235,   93,  562,  563,  110,  307,  308, 
          309,  310,  311,  235,  525,  589,  539,  497,  432,  636, 
          235,  497,  497,  458,  640,  266,  659,  279,  235,  667, 
          677,  668,  235,  235,  279,  673,  235,  688,  235,  478, 
          674,  621,  684,  497,   83,  799,   87,   87,  497,   93, 
           90,   80,   87,  110,  691,  685,  455,   88,  229,  637, 
          638,  639,  395,  456,   93,   93,   93,  690,  694,  235, 
          243,  698,  235,  700,  235,  243,  243,  702,  786,   84, 
          818,  235,  704,  459,  460,  656,  705,  828,  707,   82, 
          711,   87,   83,   83,  717,  817,  718,   81,   84,  413, 
          730,  273,  279,  383,  720,  209,   82,  719,  273,  279, 
          266,   76,  722,   84,  478,   80,  819,   93,   93,  723, 
          781,  161,  395,  395,  395,  427,  725,  729,  233,  821, 
           89,   90,   80,  822,  732,  738,  273,  740,   93,  741, 
          486,  486,  486,  744,  280,  582,  486,  486,  748,  486, 
          235,  749,   87,  590,  449,  592,  451,  452,  281,  840, 
          751,  775,  599,  383,  383,  383,  841,    6,    6,    6, 
          161,   93,   83,    6,    6,  782,    6,   86,   89,   89, 
          243,  783,   93,  518,   84,  757,  497,  497,  497,   93, 
          787,  635,  243,  497,  243,  227,   84,  875,   84,  803, 
           84,  679,  681,  804,  805,  815,  271,  802,  823,  824, 
          836,  280,  825,  837,   92,   92,  838,  235,  826,  827, 
           92,  486,  243,  427,  834,   86,   86,  835,  839,  849, 
          427,  487,  487,  487,  850,  235,  854,  487,  487,  235, 
          487,  797,  486,  856,  235,   84,  859,  860,    6,   75, 
          880,  861,  878,   83,  882,  884,  235,  488,  481,   92, 
           84,   84,   84,  497,  497,  609,   75,  750,  314,    6, 
           80,   80,  111,  111,  486,  497,   80,  211,  211,  211, 
          488,  254,  226,  211,  211,  879,  490,  211,  490,  764, 
          792,  767,  769,  488,  211,  492,  427,  772,  773,  329, 
          492,   83,   87,  331,  332,  333,  334,  776,  235,   87, 
           84,  497,  487,   84,   84,   80,  211,  211,  235,  281, 
           92,  211,  498,  301,   82,  273,  276,  116,  881,  189, 
          833,  352,   89,  487,   84,  560,  561,  562,  563,  710, 
          761,  767,  769,  772,  695,  788,   84,  304,  869,  235, 
           87,  790,  306,    0,    0,   87,  235,  281,   84,   84, 
            0,  235,  235,    0,  427,    0,  244,   84,    0,  245, 
            0,  427,    0,    0,  211,  273,   80,    0,   84,    0, 
            0,    0,  273,  280,    0,   84,    0,   89,   82,    0, 
          280,  281,    0,    0,   87,    0,    0,  281,    0,  829, 
            0,  235,    0,    0,  281,   82,    0,    0,    0,    0, 
          752,    0,    0,   89,    0,  161,   87,    0,  161,  161, 
          161,    0,  762,    0,  763,    0,  765,   84,  829,   87, 
          235,    0,    0,    0,   86,    0,  852,   87,    0,   87, 
          235,  422,    0,    0,  235,    0,    0,  481,  422,    0, 
          280,    0,    0,  161,    0,    0,    0,  280,    0,    0, 
          161,  161,  161,  161,    0,    0,  235,    0,    0,    0, 
           92,  801,  733,    0,    0,   87,    0,   92,  235,    0, 
          235,    0,    0,  739,   75,    0,  807,  808,  809,    0, 
            0,  211,  211,    0,    0,    0,    0,  481,  235,    0, 
          235,    0,    0,    0,  481,    0,    0,    0,  235,  477, 
            0,    0,  235,    0,  211,    0,  211,  211,   92,    0, 
            0,    0,    0,   92,    0,  423,   80,    0,    0,    0, 
          481,    0,    0,   80,    0,  427,    0,    0,    0,  831, 
          555,    0,  427,  556,  557,  558,    0,  173,   75,    0, 
            0,    0,    0,   77,    0,    0,    0,  173,    0,    0, 
          843,    0,   92,    0,    0,   75,    0,   84,    0,    0, 
           77,    0,    0,    0,   80,  211,  211,  211,  211,   80, 
          211,  211,    0,    0,   92,  560,  561,  562,  563,   87, 
          811,  217,    0,  813,  814,    0,  416,   92,  418,  421, 
          477,    0,    0,    0,  870,   92,  173,   92,   87,    0, 
            0,  871,  211,    0,    0,  211,    0,  211,   80,  281, 
          273,  211,  211,   87,    0,    0,    0,    0,    0,    0, 
          281,    0,    0,  314,    8,    0,    0,  281,    0,  211, 
           80,  211,    0,   92,    8,    0,    0,  273,    0,  327, 
          328,    0,    0,   80,    0,  578,  581,  211,    0,    0, 
            0,   80,    0,   80,  329,  273,  330,    0,  331,  332, 
          333,  334,  211,    0,   81,    0,  855,  857,    0,    0, 
          273,    0,    0,    0,    0,  211,    0,    0,    0,    0, 
            0,   81,    0,    8,   87,    0,    0,  211,    0,   80, 
            0,    0,    0,    0,    0,  229,   87,    0,   87,    0, 
           87,  872,  873,    0,    0,  555,    0,  877,  556,  557, 
          558,  280,   95,   95,    0,  211,    0,    0,   95,   95, 
           95,   95,    0,  273,  885,   95,   95,    0,    0,   95, 
            0,    0,  887,    0,    0,  889,   95,  663,  663,  891, 
            0,  798,    0,  559,    0,   87,    0,   92,    0,    0, 
          560,  561,  562,  563,    0,    0,    0,   95,   95,   95, 
           87,   87,   87,   95,    0,    0,   92,    0,    0,    0, 
            0,    0,    0,  663,    0,    0,    0,  672,   77,  477, 
            7,   92,    0,    0,    0,    0,    0,    0,  672,  672, 
            7,    0,    0,    0,    0,    0,    0,    0,    0,  173, 
          173,  173,  211,   80,    0,  173,  173,    0,  173,    0, 
            0,    0,  672,   87,   87,    0,   95,    0,   95,    0, 
            0,    0,   80,    0,    0,  173,    0,  173,  173,  477, 
          173,  173,  173,  173,   87,  173,  477,   80,    0,    7, 
            0,  477,   77,  709,   79,    0,  713,    0,  581,    0, 
            0,    0,   92,    0,    0,    0,  581,    0,    0,   77, 
            0,   79,  477,    0,   92,  211,   92,   87,   92,  173, 
            0,    0,    0,    0,    0,    0,    0,    0,   87,    0, 
          173,    0,    0,  173,  173,   87,    8,    8,    8,    0, 
          211,  478,    8,    8,    0,    8,    0,    0,   78,   81, 
            0,  173,    0,    0,    0,    0,    0,    0,   80,    0, 
            0,  154,    0,   92,    0,   78,    0,    0,    0,  226, 
           80,    0,   80,    0,   80,  211,  211,    0,   92,   92, 
           92,  211,    0,   95,   95,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  481,    0,    0,    0,    0, 
          280,    0,  663,    0,    0,    0,   95,  280,   95,   95, 
          154,  314,    0,   81,    0,  796,  198,    8,   95,   80, 
            0,    0,  211,    0,    0,   95,  198,  327,  328,    0, 
           81,   92,   92,  164,   80,   80,   80,    0,    8,    0, 
            0,    0,  329,    0,    0,    0,  331,  332,  333,  334, 
            0,    0,   92,    0,    0,  406,  407,    0,  672,  672, 
          198,    0,    0,    0,    0,    0,   95,   95,   95,   95, 
           95,   95,   95,   95,  198,  198,    0,    0,    0,  198, 
            0,    0,  164,  211,    0,   92,    0,   80,   80,    0, 
            0,    0,    7,    7,    7,    0,   92,    0,    7,    7, 
            0,    7,    0,   92,   95,    0,    0,   95,   80,   95, 
           95,    0,    0,   95,   95,    0,   77,    0,    0,    0, 
            0,    0,    0,  581,    0,    0,    0,    0,    0,   79, 
          478,   95,   95,   95,    0,    0,    0,  173,  173,  173, 
            0,   80,  173,  173,  173,   95,  173,    0,    0,   95, 
          211,    0,   80,   95,    0,   95,  173,  173,  273,   80, 
            0,    0,    0,  477,   95,  173,  173,    0,  173,  173, 
          173,  173,  530,    7,    0,    0,  537,   95,    0,    0, 
          478,    0,    0,   78,  481,  183,  581,  478,    0,   95, 
            0,   95,  478,   79,    7,  183,    0,    0,    0,    0, 
            0,    0,  576,    0,    0,    0,    0,    0,    0,    0, 
           79,    0,    0,  478,    0,  173,    0,   95,  173,  530, 
            0,  173,   79,  173,    0,  149,    0,    0,    0,  183, 
            0,  610,  612,    0,  481,  616,    0,  618,    0,  173, 
          623,  481,    0,  183,  183,    0,  477,   78,  183,    0, 
            0,    0,    0,    0,    0,  154,    0,    0,  154,  154, 
          154,   78,    0,    0,   78,    0,    0,  481,  644,  478, 
            0,  616,    0,  644,  149,    0,    0,    0,  198,  198, 
          198,  421,    0,  198,  198,  198,    0,  198,  421,    0, 
            0,    0,    0,  154,    0,    0,    0,  198,  198,   76, 
          154,  154,  154,  154,   95,   95,  198,  198,  481,  198, 
          198,  198,  198,  198,    0,    0,   76,    0,    0,    0, 
            0,    0,    0,    0,   95,    0,  427,  164,    0,    0, 
          164,  164,  164,    0,    0,    0,  427,    0,    0,   95, 
            0,    0,  198,  198,    0,    0,  281,  198,  198,  682, 
            0,   85,  477,  423,    0,    0,  198,    0,    0,  198, 
          423,    0,  198,    0,  198,  164,    0,   95,    0,    0, 
           75,    0,  164,  164,  164,  164,    0,    0,    0,    0, 
          198,    0,    0,    0,    0,  427,    0,   83,    0,  427, 
            0,    0,   95,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  477,    0,    0,    0,    0,    0,    0,  477, 
           95,    0,    0,    0,  477,    0,  724,  427,    0,    0, 
            0,    0,   95,    0,   95,    0,   95,   95,   95,    0, 
            0,    0,   85,   95,  731,  477,    0,    0,  734,    0, 
            0,    0,    0,  735,    0,    0,    0,  183,  183,  183, 
            0,  416,  183,  183,  183,  612,  183,   87,  478,    0, 
            0,  416,    0,    0,    0,    0,  183,  183,    0,    0, 
            0,   95,    0,    0,   95,  183,  183,    0,  183,  183, 
          183,  183,  183,    0,    0,    0,   95,   95,   95,    0, 
            0,    0,    0,    0,    0,  416,   86,  481,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  778,  478,  416, 
          416,    0,  416,    0,  416,  478,    0,  785,    0,  149, 
          478,    0,  149,  149,  149,  183,    0,    0,  183,    0, 
            0,  183,    0,  183,   76,   95,    0,    0,   87,   95, 
           95,  478,  416,    0,    0,  424,    0,  481,  644,  183, 
            0,    0,  424,    0,  481,  616,    0,  149,    0,  477, 
           95,  616,    0,    0,  149,  149,  149,  149,    0,  419, 
            0,    0,    0,    0,    0,    0,    0,   86,    0,  419, 
          481,    0,    0,    0,    0,  281,    0,    0,  427,  427, 
          427,    0,  281,   95,  427,  427,    0,  427,   76,    0, 
          830,    0,   95,    0,   95,    0,    0,    0,    0,    0, 
            0,   95,    0,  419,    0,   76,  427,  427,    0,  427, 
          427,  427,  427,  427,    0,    0,    0,  419,  419,  845, 
          419,    0,  419,    0,    0,    0,    0,    0,    0,  853, 
            0,    0,    0,  858,    0,  427,  427,  427,  427,  427, 
          427,  427,  427,  427,  427,  427,  427,  427,  427,    0, 
          419,  427,  427,  427,    0,  428,    0,    0,    0,  427, 
            0,    0,    0,    0,    0,    0,  427,  612,  427,  616, 
          427,  427,  427,  427,  427,  427,  427,    0,  427,    0, 
          427,    0,    0,  498,    0,    0,    0,  883,    0,  886, 
            0,    0,    0,  498,    0,    0,    0,  616,  474,  474, 
          474,  890,  474,  416,  416,  416,  474,  474,  416,  416, 
          416,  474,  416,  474,  474,  474,  474,  474,  474,  474, 
          416,  474,  416,  416,  474,  474,  474,  474,  474,  474, 
          474,  416,  416,    0,  416,  416,  416,  416,  416,    0, 
          474,  498,  498,  474,  474,  474,  474,  474,  474,  474, 
          474,  474,  474,    0,  474,  474,    0,  474,  474,  474, 
          416,  416,  416,  416,  416,  416,  416,  416,  416,  416, 
          416,  416,  416,  416,    0,    0,  416,  416,  416,  474, 
          416,  416,  474,  474,  416,  474,  474,  416,  474,  416, 
          474,  416,  474,  416,  474,  416,  416,  416,  416,  416, 
          416,  416,  474,  416,  474,  416,  255,  474,  474,  474, 
          474,  474,  474,    0,    0,    0,  475,  475,  475,    0, 
          475,  419,  419,  419,  475,  475,  419,  419,  419,  475, 
          419,  475,  475,  475,  475,  475,  475,  475,  419,  475, 
          419,  419,  475,  475,  475,  475,  475,  475,  475,  419, 
          419,    0,  419,  419,  419,  419,  419,    0,  475,  339, 
            0,  475,  475,  475,  475,  475,  475,  475,  475,  475, 
          475,    0,  475,  475,    0,  475,  475,  475,  419,  419, 
          419,  419,  419,  419,  419,  419,  419,  419,  419,  419, 
          419,  419,    0,    0,  419,  419,  419,  475,  419,  419, 
          475,  475,  419,  475,  475,  419,  475,  419,  475,  419, 
          475,  419,  475,  419,  419,  419,  419,  419,  419,  419, 
          475,  419,  475,  419,  477,  475,  475,  475,  475,  475, 
          475,    0,    0,    0,  477,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  498,  498,  498,    0,    0, 
          498,  498,  498,  314,  498,    0,    0,    0,  319,  320, 
            0,    0,    0,    0,  498,  498,    0,    0,  477,  327, 
          328,    0,    0,  498,  498,    0,  498,  498,  498,  498, 
          498,    0,  477,  477,  329,   85,  330,  477,  331,  332, 
          333,  334,  335,  336,  337,    0,  338,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,    0,    0, 
            0,    0,    0,  327,  328,  477,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  498,    0,  329,  498, 
          330,  498,  331,  332,  333,  334,  335,  336,  337,  478, 
          338,    0,    0,    0,    0,    0,    0,  498,    0,  478, 
            0,  314,  315,  316,  317,  318,  319,  320,  321,    0, 
          323,  324,    0,    0,    0,    0,    0,  327,  328,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  329,  478,  330,    0,  331,  332,  333,  334, 
          335,  336,  337,    0,  338,    0,    0,  478,  478,    0, 
           87,    0,  478,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,    0,  325,  326,    0, 
          478,  327,  328,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  329,    0,  330,    0, 
          331,  332,  333,  334,  335,  336,  337,   35,  338,    0, 
            0,    0,    0,    0,    0,    0,    0,   35,    0,    0, 
            0,    0,    0,    0,    0,    0,  132,    0,    0,    0, 
            0,  477,  477,  477,    0,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,    0,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,   35,  477,  477,  477, 
          477,  477,    0,  477,    0,  132,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,    0,  477,  477,    0, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,    0,    0,  477, 
          477,  477,  477,    0,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,    0, 
          477,  477,  477,  477,  477,  477,  478,  478,  478,    0, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,    0,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,  478, 
          478,  339,  478,  478,  478,  478,  478,    0,  478,    0, 
            0,  478,  478,  478,  478,  478,  478,  478,  478,  478, 
          478,    0,  478,  478,    0,  478,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,  478, 
          478,  478,    0,    0,  478,  478,  478,  478,    0,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,  478, 
          478,  478,  478,  478,  481,  478,  478,  478,  478,  478, 
          478,    0,    0,    0,  481,    0,    0,    0,    0,   35, 
           35,   35,    0,    0,    0,   35,   35,    0,   35,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  481,    0, 
           35,   35,   35,   35,   35,    0,    0,    0,    0,    0, 
            0,    0,  481,  481,    0,   86,    0,  481,    0,    0, 
          132,    0,    0,  132,  132,  132,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  481,  426,    0,    0,    0, 
           35,    0,    0,  426,    0,    0,    0,    0,  132,    0, 
            0,    0,    0,    0,    0,  132,  132,  132,  132,  274, 
            0,   35,    0,    0,    0,    0,    0,    0,    0,  274, 
            0,  314,  315,  316,  317,  318,  319,  320,    0,    0, 
          323,  324,    0,    0,    0,    0,    0,  327,  328,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  329,  274,  330,  683,  331,  332,  333,  334, 
          335,  336,  337,    0,  338,    0,    0,  274,  274,    0, 
            0,    0,  274,    0,    0,    0,    0,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  314,  325, 
          326,    0,    0,  327,  328,    0,    0,    0,    0,    0, 
          274,    0,    0,    0,  327,  328,    0,    0,  329,    0, 
          330,    0,  331,  332,  333,  334,  335,  336,  337,  329, 
          338,  330,    0,  331,  332,  333,  334,   14,    0,  337, 
            0,  338,    0,    0,    0,    0,    0,   14,    0,    0, 
            0,    0,    0,    0,    0,    0,  133,    0,    0,    0, 
            0,  477,  477,  477,    0,  477,  481,  481,  481,  477, 
          477,  481,  481,  481,  477,  481,  477,  477,  477,  477, 
          477,  477,  477,    0,  481,  481,  481,  477,  477,  477, 
          477,  477,  477,  477,  481,  481,   14,  481,  481,  481, 
          481,  481,    0,  477,    0,  133,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,    0,  477,  477,    0, 
          477,  477,  477,  481,  481,  481,  481,  481,  481,  481, 
          481,  481,  481,  481,  481,  481,  481,    0,    0,  481, 
          481,  481,  477,    0,  481,  477,  477,  481,  477,  477, 
          481,  477,  481,  477,  481,  477,  481,  477,  481,  481, 
          481,  481,  481,  481,  481,  477,  481,  481,  481,    0, 
          477,  477,  477,  477,  477,  477,  476,  476,  476,    0, 
          476,  274,  274,  274,  476,  476,  274,  274,  274,  476, 
          274,  476,  476,  476,  476,  476,  476,  476,    0,  476, 
          274,  274,  476,  476,  476,  476,  476,  476,  476,  274, 
          274,  339,  274,  274,  274,  274,  274,    0,  476,    0, 
            0,  476,  476,  476,  476,  476,  476,  476,  476,  476, 
          476,    0,  476,  476,    0,  476,  476,  476,  274,  274, 
          274,  274,  274,  274,  274,  274,  274,  274,  274,  274, 
          274,  274,    0,    0,  274,  274,  274,  476,    0,  274, 
          476,  476,  274,  476,  476,  274,  476,  274,  476,  274, 
          476,  274,  476,  274,  274,  274,  274,  274,  274,  274, 
          476,  274,  476,  274,  482,  476,  476,  476,  476,  476, 
          476,    0,    0,    0,  482,    0,    0,    0,    0,   14, 
           14,   14,    0,    0,    0,   14,   14,    0,   14,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  482,    0, 
           14,   14,   14,   14,   14,    0,    0,    0,    0,    0, 
            0,    0,  482,  482,    0,    0,    0,  482,    0,    0, 
          133,    0,    0,  133,  133,  133,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  482,  425,    0,    0,    0, 
           14,    0,    0,  425,    0,    0,    0,    0,  133,    0, 
            0,    0,    0,    0,    0,  133,  133,  133,  133,  483, 
            0,   14,    0,    0,    0,    0,    0,    0,    0,  483, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  483,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  483,  483,    0, 
            0,    0,  483,    0,    0,    0,    0,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,   96,  325, 
          326,    0,    0,  327,  328,    0,    0,    0,    0,   97, 
          483,    0,    0,    0,    0,    0,    0,    0,  329,    0, 
          330,    0,  331,  332,  333,  334,  335,  336,  337,    0, 
          338,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   96,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   97,    0, 
            0,  479,  479,  479,    0,  479,  482,  482,  482,  479, 
          479,  482,  482,  482,  479,  482,  479,  479,  479,  479, 
          479,  479,  479,    0,  482,  482,  482,  479,  479,  479, 
          479,  479,  479,  479,  482,  482,    0,  482,  482,  482, 
          482,  482,    0,  479,    0,    0,  479,  479,  479,  479, 
          479,  479,  479,  479,  479,  479,    0,  479,  479,    0, 
          479,  479,  479,  482,  482,  482,  482,  482,  482,  482, 
          482,  482,  482,  482,  482,  482,  482,    0,    0,  482, 
          482,  482,  479,    0,  482,  479,  479,  482,  479,  479, 
          482,  479,  482,  479,  482,  479,  482,  479,  482,  482, 
          482,  482,  482,  482,  482,  479,  482,  482,  482,    0, 
          479,  479,  479,  479,  479,  479,  480,  480,  480,    0, 
          480,  483,  483,  483,  480,  480,  483,  483,  483,  480, 
          483,  480,  480,  480,  480,  480,  480,  480,    0,  483, 
          483,  483,  480,  480,  480,  480,  480,  480,  480,  483, 
          483,    0,  483,  483,  483,  483,  483,    0,  480,    0, 
            0,  480,  480,  480,  480,  480,  480,  480,  480,  480, 
          480,    0,  480,  480,    0,  480,  480,  480,  483,  483, 
          483,  483,  483,  483,  483,  483,  483,  483,  483,  483, 
          483,  483,    0,    0,  483,  483,  483,  480,    0,  483, 
          480,  480,  483,  480,  480,  483,  480,  483,  480,  483, 
          480,  483,  480,  483,  483,  483,  483,  483,  483,  483, 
          480,  483,  483,  483,  350,  480,  480,  480,  480,  480, 
          480,    0,   96,    0,  350,   96,   96,   96,    0,    0, 
            0,    0,    0,   97,    0,    0,   97,   97,   97,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  416,    0, 
            0,    0,    0,    0,    0,  416,    0,    0,  350,  419, 
           96,    0,    0,    0,    0,    0,  419,   96,   96,   96, 
           96,   97,  350,  350,    0,    0,    0,  350,   97,   97, 
           97,   97,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  350,    0,    0,    0,    0, 
            0,    0,    0,    0,    3,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,  497, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,  497, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,  497,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  497,  497,    0, 
            0,    0,  497,    0,    0,    0,   46,    0,    0,   47, 
            0,    0,   48,   49,    0,   50,    0,   51,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,   53, 
          497,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            0,  608,    0,   60,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          339,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  251,  251,  251,    0,  251,  350,  350,  350,  251, 
          251,  350,  350,  350,  251,  350,  251,  251,  251,  251, 
          251,  251,  251,    0,  350,  350,  350,  251,  251,  251, 
          251,  251,  251,  251,  350,  350,    0,  350,  350,  350, 
          350,  350,    0,  251,    0,    0,  251,  251,  251,  251, 
          251,  251,  251,  251,  251,  251,    0,  251,  251,    0, 
          251,  251,  251,  350,  350,  350,  350,  350,  350,  350, 
          350,  350,  350,  350,  350,  350,  350,    0,    0,  350, 
          350,  350,  251,    0,  350,  251,    0,  350,  251,  251, 
          350,  251,  350,  251,  350,  251,  350,  251,  350,  350, 
          350,  350,  350,  350,  350,  251,  350,  350,  350,    0, 
          251,  251,  251,  251,  251,  251,  251,  251,  251,    0, 
          251,  497,  497,  497,  251,  251,  497,  497,  497,  251, 
          497,  251,  251,  251,  251,  251,  251,  251,    0,  497, 
          497,  497,  251,  251,  251,  251,  251,  251,  251,  497, 
          497,    0,  497,  497,  497,  497,  497,    0,  251,    0, 
            0,  251,  251,  251,  251,  251,  251,  251,  251,  251, 
          251,    0,  251,  251,    0,  251,  251,  251,  497,  497, 
          497,  497,  497,  497,  497,  497,  497,  497,  497,  497, 
          497,  497,    0,    0,  497,  497,  497,  251,    0,  497, 
          251,    0,  497,  251,  251,  497,  251,  497,  251,  497, 
          251,  497,  251,  497,  497,  497,  497,  497,  497,  497, 
          251,  497,  497,  497,  279,  251,  251,  251,  251,  251, 
          251,    0,    0,    0,  279,    0,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,    0,  325,  326, 
            0,    0,  327,  328,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  329,  279,  330, 
            0,  331,  332,  333,  334,  335,  336,  337,    0,  338, 
            0,    0,  279,  279,    0,   88,    0,  279,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  279,    0,    0,    0,    0, 
            0,    0,    0,    0,    3,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,  287, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,  287, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,  287,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  287,  287,    0, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

            0,    0,  287,    0,    0,    0,   46,    0,    0,  265, 
            0,    0,   48,   49,    0,   50,    0,   51,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,   53, 
          287,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            0,    0,    0,   60,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  217,    0,    0,    0,    0, 
            0,  478,  478,  478,    0,  478,  279,  279,  279,  478, 
          478,  279,  279,  279,  478,  279,  478,  478,  478,  478, 
          478,  478,  478,    0,    0,  279,  279,  478,  478,  478, 
          478,  478,  478,  478,  279,  279,    0,  279,  279,  279, 
          279,  279,    0,  478,  218,    0,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,  478,    0,  478,  478,    0, 
          478,  478,  478,  279,  279,  279,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,  279,    0,    0,  279, 
          279,  279,  478,    0,  279,  478,  478,  279,  478,  478, 
          279,  478,  279,  478,  279,  478,  279,  478,  279,  279, 
          279,  279,  279,  279,  279,  478,  279,    0,  279,    0, 
          478,  478,  478,  478,  478,  478,  251,  251,  251,    0, 
          251,  287,  287,  287,  251,  251,  287,  287,  287,  251, 
          287,  251,  251,  251,  251,  251,  251,  251,    0,    0, 
          287,  287,  251,  251,  251,  251,  251,  251,  251,  287, 
          287,    0,  287,  287,  287,  287,  287,    0,  251,    0, 
            0,  251,  251,  251,  251,  251,  251,  251,  251,  251, 
          251,    0,  251,  251,    0,  251,  251,  251,  287,  287, 
          287,  287,  287,  287,  287,  287,  287,  287,  287,  287, 
          287,  287,    0,    0,  287,  287,  287,  251,    0,  287, 
          251,    0,  287,  251,  251,  287,  251,  287,  251,  287, 
          251,  287,  251,  287,  287,  287,  287,  287,  287,  287, 
          251,  287,  477,  287,    0,  251,  251,  251,  251,  251, 
          251,    0,  477,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,   77,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,  477,    0,   85,   28,  477,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,   39,   40,    0,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  477,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  208,    0,    0,  108,    0,    0,   48, 
           49,    0,   50,    0,    0,    0,    0,  478,   52,    0, 
            0,    0,    0,    0,    0,    0,   53,  478,    0,    0, 
            0,   54,   55,   56,   57,   58,   59,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,   79,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,  478,    0,   87,    0, 
          478,   28,    0,    0,   31,   32,   33,   34,   35,   36, 
           37,   38,   39,   40,    0,   41,   42,    0,   43,   44, 
           45,    0,    0,    0,    0,    0,    0,    0,  478,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  108,    0,    0,   48,   49,    0,   50, 
            0,    0,    0,  665,    0,   52,    0,    0,  339,    0, 
            0,    0,    0,   53,    0,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,    0,    0,    0,    0,    0,  477, 
          477,  477,    0,  477,  477,  477,  477,  477,  477,    0, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,    0,  477,    0,    0,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,    0,  477,  477,  477,  477,  477, 
            0,  477,    0,    0,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,    0,  477,  477,    0,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,    0,    0,  477,  477,  477, 
          477,    0,    0,  477,  477,  477,  477,  477,    0,  477, 
            0,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,    0,  477,  477, 
          477,  477,  477,  477,  478,  478,  478,    0,  478,  478, 
          478,  478,  478,  478,    0,  478,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,  478,    0,  478,    0,    0, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,    0, 
          478,  478,  478,  478,  478,    0,  478,    0,    0,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,    0, 
          478,  478,    0,  478,  478,  478,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,  478, 
            0,    0,  478,  478,  478,  478,    0,    0,  478,  478, 
          478,  478,  478,    0,  478,    0,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,  478, 
          478,  478,  481,  478,  478,  478,  478,  478,  478,    0, 
            0,    0,  481,    0,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,    0,  325,  326,    0,    0, 
          327,  328,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  329,   78,  330,    0,  331, 
          332,  333,  334,  335,  336,  337,    0,  338,    0,    0, 
            0,  481,    0,   86,    0,  481,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  481,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    4,    5,    6,    7,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,  279,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,  279,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,   27,   28,   29,   30,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,   80,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  279,    0,   88,    0, 
          279,    0,    0,    0,   46,    0,    0,   47,    0,    0, 
           48,   49,    0,   50,    0,   51,    0,    0,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,   53,  279,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    0,    0, 
            0,   60,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  497,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  497,    0,    0,    0,    0,  477, 
          477,  477,    0,  477,  481,  481,  481,  477,  477,    0, 
          481,  481,  477,  481,  477,  477,  477,  477,  477,  477, 
          477,    0,  481,    0,    0,  477,  477,  477,  477,  477, 
          477,  477,  481,  481,    0,  481,  481,  481,  481,  481, 
            0,  477,  497,  497,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,    0,  477,  477,    0,  477,  477, 
          477,  481,  481,  481,  481,  481,  481,  481,  481,  481, 
          481,  481,  481,  481,  481,    0,    0,  481,  481,  481, 
          477,    0,    0,  477,  477,  481,  477,  477,    0,  477, 
            0,  477,  481,  477,  481,  477,  481,  481,  481,  481, 
          481,  481,  481,  477,  481,  481,  481,    0,  477,  477, 
          477,  477,  477,  477,  478,  478,  478,    0,  478,  279, 
          279,  279,  478,  478,    0,  279,  279,  478,  279,  478, 
          478,  478,  478,  478,  478,  478,    0,    0,    0,    0, 
          478,  478,  478,  478,  478,  478,  478,  279,  279,    0, 
          279,  279,  279,  279,  279,    0,  478,    0,    0,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,    0, 
          478,  478,    0,  478,  478,  478,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
            0,    0,  279,  279,  279,  478,    0,    0,  478,  478, 
          279,  478,  478,    0,  478,    0,  478,  279,  478,  279, 
          478,  279,  279,  279,  279,  279,  279,  279,  478,  279, 
            0,  279,    0,  478,  478,  478,  478,  478,  478,    0, 
            0,    0,    0,    0,    0,   91,    0,    0,    0,    0, 
            0,  251,  251,  251,    0,  251,  497,  497,  497,  251, 
          251,  497,  497,  497,  251,  497,  251,  251,  251,  251, 
          251,  251,  251,    0,    0,  497,    0,  251,  251,  251, 
          251,  251,  251,  251,  497,  497,    0,  497,  497,  497, 
          497,  497,    0,  251,   91,    0,  251,  251,  251,  251, 
          251,  251,  251,  251,  251,  251,    0,  251,  251,    0, 
          251,  251,  251,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  497,    0,  416,    0,    0,    0, 
            0,  497,  251,    0,    0,  251,    0,  497,  251,  251, 
            0,  251,    0,  251,    0,  251,    0,  251,    0,    0, 
            0,    0,    0,    0,    0,  251,    0,    0,  497,    0, 
          251,  251,  251,  251,  251,  251,   92,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,   20,   21, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,   92,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  419,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,  415,   48,   49, 
            0,   50,    0,  232,    0,  233,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    0,    0,    0,    0, 
            0,   91,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,    0,    0,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,    0,  474,    0,    0,   91,   91, 
           91,   91,   91,   91,   91,    0,    0,   91,    0,    0, 
            0,    0,    0,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,    0,   91,   91, 
            0,   91,   91,   91,    0,   91,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  416,    0,    0,    0,    0, 
            0,    0,  416,   91,    0,    0,   91,  474,    0,   91, 
           91,    0,   91,    0,   91,    0,    0,  481,   91,    0, 
            0,    0,    0,   91,    0,    0,   91,    0,  474,    0, 
            0,   91,   91,   91,   91,   91,   91,    0,    0,    0, 
           91,    0,   92,   92,   92,   92,   92,   92,   92,   92, 
           92,   92,   92,    0,    0,   92,   92,   92,   92,   92, 
           92,   92,   92,   92,   92,    0,  475,    0,    0,   92, 
           92,   92,   92,   92,   92,   92,    0,    0,   92,    0, 
            0,    0,    0,    0,   92,   92,   92,   92,   92,   92, 
           92,   92,   92,   92,   92,   92,   92,   92,    0,   92, 
           92,    0,   92,   92,   92,    0,   92,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  419,    0,    0,    0, 
            0,    0,    0,  419,   92,    0,    0,   92,  475,    0, 
           92,   92,    0,   92,    0,   92,    0,    0,  279,   92, 
            0,    0,    0,    0,   92,    0,    0,   92,    0,  475, 
            0,    0,   92,   92,   92,   92,   92,   92,    0,    0, 
            0,   92,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,    0,    0,   91,   91,   92,   91,   91, 
           91,   91,   91,   91,   91,    0,  481,    0,    0,   91, 
           91,   91,   91,   91,   91,   91,    0,    0,   91,    0, 
            0,    0,    0,    0,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,    0,   91, 
           91,    0,   91,   91,   91,    0,   92,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  481,    0,    0,    0, 
            0,    0,    0,  481,   91,    0,    0,   91,  477,    0, 
           91,   91,    0,   91,    0,   91,    0,    0,  280,   91, 
            0,    0,    0,    0,   91,    0,    0,   91,    0,  481, 
            0,    0,   91,   91,   91,   91,   91,   91,    0,    0, 
            0,   91,    0,   92,   92,   92,   92,   92,   92,   92, 
           92,   92,   92,   92,    0,    0,   92,   92,  323,   92, 
           92,   92,   92,   92,   92,   92,    0,    0,    0,    0, 
           92,   92,   92,   92,   92,   92,   92,    0,    0,   92, 
            0,    0,    0,    0,    0,   92,   92,   92,   92,   92, 
           92,   92,   92,   92,   92,   92,   92,   92,   92,    0, 
           92,   92,    0,   92,   92,   92,    0,  323,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  279,    0,    0, 
            0,    0,    0,    0,  279,   92,    0,    0,   92,  478, 
            0,   92,   92,    0,   92,    0,   92,    0,    0,    0, 
           92,    0,    0,    0,    0,   92,    0,    0,   92,    0, 
            0,    0,    0,   92,   92,   92,   92,   92,   92,    0, 
            0,    0,   92,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   92,   92,   92,   92,   92,   92,   92, 
           92,   92,   92,   92,    0,    0,   92,   92,  497,   92, 
           92,   92,   92,   92,   92,   92,    0,    0,    0,    0, 
           92,   92,   92,   92,   92,   92,   92,    0,    0,   92, 
            0,    0,    0,    0,    0,   92,   92,   92,   92,   92, 
           92,   92,   92,   92,   92,   92,   92,   92,   92,    0, 
           92,   92,    0,   92,   92,   92,    0,  497,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  280,    0,    0, 
            0,    0,    0,    0,  280,   92,    0,    0,   92,    0, 
            0,   92,   92,    0,   92,    0,   92,    0,    0,    0, 
           92,    0,    0,    0,    0,   92,    0,    0,   92,    0, 
            0,    0,    0,   92,   92,   92,   92,   92,   92,    0, 
            0,    0,   92,    0,  323,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,    0,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,  323,  323,  497,    0,    0, 
            0,  323,  323,  323,  323,  323,  323,  323,    0,    0, 
          323,    0,    0,    0,    0,    0,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
            0,  323,  323,    0,  323,  323,  323,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  497,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  323,    0,    0,  323, 
            0,    0,  323,  323,    0,  323,    0,  323,    0,    0, 
            0,  323,    0,    0,    0,    0,    0,    0,    0,  323, 
            0,    0,    0,    0,  323,  323,  323,  323,  323,  323, 
            0,    0,    0,  323,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  497,  497,  497,  497,  497,  497, 
            0,    0,  497,  497,  497,    0,    0,    0,  497,  350, 
          497,  497,  497,  497,  497,  497,  497,    0,    0,  350, 
            0,  497,  497,  497,  497,  497,  497,  497,    0,    0, 
          497,    0,    0,    0,    0,    0,  497,  497,  497,  497, 
          497,  497,  497,  497,  497,  497,  497,  497,  497,  497, 
            0,  497,  497,  350,  497,  497,  497,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  350,  350,    0, 
            0,    0,  350,    0,    0,    0,  497,    0,    0,  497, 
            0,    0,  497,  497,    0,  497,    0,  497,    0,    0, 
            0,  497,    0,    0,    0,    0,    0,    0,    0,  497, 
          350,    0,    0,    0,  497,  497,  497,  497,  497,  497, 
            0,    0,    0,  497,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  497,  497,  497,  497,  497,  497,    0, 
            0,    0,  497,  497,    0,    0,    0,  497,  427,  497, 
          497,  497,  497,  497,  497,  497,    0,    0,  427,    0, 
          497,  497,  497,  497,  497,  497,  497,    0,    0,  497, 
            0,    0,    0,    0,    0,  497,  497,  497,  497,  497, 
          497,  497,  497,  497,  497,  497,  497,  497,  497,    0, 
          497,  497,  427,  497,  497,  497,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  427,  427,    0,   83, 
            0,  427,    0,    0,    0,  497,    0,    0,  497,    0, 
            0,  497,  497,    0,  497,    0,  497,    0,    0,    0, 
          497,    0,    0,    0,    0,    0,    0,    0,  497,  427, 
            0,  497,    0,  497,  497,  497,  497,  497,  497,    0, 
            0,    0,  497,    0,    0,    0,    0,    0,    0,    0, 
            0,  497,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  497,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  350,  350,  350,    0,    0,  350,  350,  350,    0, 
          350,    0,    0,    0,    0,    0,    0,    0,    0,  350, 
          350,  350,    0,    0,    0,  497,    0,    0,    0,  350, 
          350,    0,  350,  350,  350,  350,  350,    0,    0,  497, 
          497,    0,    0,    0,  497,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  350,  350, 
          350,  350,  350,  350,  350,  350,  350,  350,  350,  350, 
          350,  350,  497,    0,  350,  350,  350,    0,    0,  350, 
            0,    0,  350,    0,    0,  350,    0,  350,    0,  350, 
            0,  350,    0,  350,  350,  350,  350,  350,  350,  350, 
            0,  350,  350,  350,    0,    0,    0,    0,    0,    0, 
          273,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          273,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          427,  427,  427,    0,    0,  427,  427,  427,    0,  427, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  427, 
          427,    0,    0,    0,  273,    0,    0,    0,  427,  427, 
            0,  427,  427,  427,  427,  427,    0,    0,  273,  273, 
            0,   90,    0,  273,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  427,  427,  427, 
          427,  427,  427,  427,  427,  427,  427,  427,  427,  427, 
          427,  273,    0,  427,  427,  427,    0,  428,  427,    0, 
            0,  427,    0,    0,  427,    0,  427,    0,  427,    0, 
          427,    0,  427,  427,  427,  427,  427,  427,  427,  427, 
          427,    0,  427,    0,    0,    0,    0,    0,    0,  427, 
            0,    0,    0,  497,  497,  497,    0,    0,  497,  497, 
          497,    0,  497,    0,    0,    0,    0,    0,    0,    0, 
            0,  497,  497,  497,    0,    0,    0,    0,    0,    0, 
            0,  497,  497,  427,  497,  497,  497,  497,  497,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  427,    0, 
           83,    0,  427,    0,    0,    0,    0,    0,    0,    0, 
          497,  497,  497,  497,  497,  497,  497,  497,  497,  497, 
          497,  497,  497,  497,    0,    0,  497,  497,  497,    0, 
          427,  497,    0,    0,  497,    0,    0,  497,    0,  497, 
            0,  497,    0,  497,    0,  497,  497,  497,  497,  497, 
          497,  497,    0,  497,  497,  497,    0,    0,    0,    0, 
            0,    0,  280,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  280,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  273,  273,  273,    0,    0,  273,  273,  273, 
            0,  273,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  273,  273,    0,    0,    0,  280,    0,    0,    0, 
          273,  273,    0,  273,  273,  273,  273,  273,    0,    0, 
          280,  280,    0,   89,    0,  280,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  273, 
          273,  273,  273,  273,  273,  273,  273,  273,  273,  273, 
          273,  273,  273,  280,    0,  273,  273,  273,    0,    0, 
          273,    0,    0,  273,    0,    0,  273,    0,  273,    0, 
          273,    0,  273,    0,  273,  273,  273,  273,  273,  273, 
          273,  281,  273,    0,  273,    0,    0,    0,    0,    0, 
            0,  281,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  427,  427,  427,    0,    0,  427,  427,  427,    0, 
          427,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          427,  427,    0,    0,    0,  281,    0,    0,    0,  427, 
          427,    0,  427,  427,  427,  427,  427,    0,    0,  281, 
          281,    0,   84,    0,  281,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  427,  427, 
          427,  427,  427,  427,  427,  427,  427,  427,  427,  427, 
          427,  427,  281,    0,  427,  427,  427,    0,  428,  427, 
            0,    0,  427,    0,    0,  427,    0,  427,    0,  427, 
            0,  427,    0,  427,  427,  427,  427,  427,  427,  427, 
            0,  427,    0,  427,  373,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  373,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  280,  280,  280,    0,    0,  280, 
          280,  280,    0,  280,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  280,  280,    0,    0,    0,  373,    0, 
            0,    0,  280,  280,    0,  280,  280,  280,  280,  280, 
            0,    0,  373,  373,    0,    0,    0,  373,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,  373,    0,  280,  280,  280, 
            0,    0,  280,    0,    0,  280,    0,    0,  280,    0, 
          280,    0,  280,    0,  280,    0,  280,  280,  280,  280, 
          280,  280,  280,  290,  280,    0,  280,    0,    0,    0, 
            0,    0,    0,  290,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  281,  281,  281,    0,    0,  281,  281, 
          281,    0,  281,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  281,  281,    0,    0,    0,  290,    0,    0, 
            0,  281,  281,    0,  281,  281,  281,  281,  281,    0, 
            0,  290,  290,    0,    0,    0,  290,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,  281, 
          281,  281,  281,  281,  290,    0,  281,  281,  281,    0, 
            0,  281,    0,    0,  281,    0,    0,  281,    0,  281, 
            0,  281,    0,  281,    0,  281,  281,  281,  281,  281, 
          281,  281,    0,  281,    0,  281,  216,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  216,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  373,  373,  373,    0, 
            0,  373,  373,  373,    0,  373,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  373,  373,    0,    0,    0, 
          216,    0,    0,    0,  373,  373,    0,  373,  373,  373, 
          373,  373,    0,    0,  216,  216,    0,    0,    0,  216, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  373,  373,  373,  373,  373,  373,  373, 
          373,  373,  373,  373,  373,  373,  373,  322,    0,  373, 
          373,  373,    0,    0,  373,    0,    0,  373,    0,    0, 
          373,    0,  373,    0,  373,    0,  373,    0,  373,  373, 
          373,  373,  373,  373,  373,  287,  373,    0,  373,    0, 
            0,    0,    0,    0,    0,  287,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  290,  290,  290,    0,    0, 
          290,  290,  290,    0,  290,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  290,  290,    0,    0,    0,  287, 
            0,    0,    0,  290,  290,    0,  290,  290,  290,  290, 
          290,    0,    0,  287,  287,    0,    0,    0,  287,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  290,  290,  290,  290,  290,  290,  290,  290, 
          290,  290,  290,  290,  290,  290,  287,    0,  290,  290, 
          290,    0,    0,  290,    0,    0,  290,    0,    0,  290, 
            0,  290,    0,  290,    0,  290,    0,  290,  290,  290, 
          290,  290,  290,  290,    0,  290,    0,  290,  414,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  414,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  216,  216, 
          216,    0,    0,  216,  216,  216,    0,  216,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  216,  216,    0, 
            0,    0,  414,    0,    0,    0,  216,  216,    0,  216, 
          216,  216,  216,  216,    0,    0,  414,  414,    0,    0, 
            0,  414,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  216,  216,  216,  216,  216, 
          216,  216,  216,  216,  216,  216,  322,  216,  216,  414, 
            0,  216,  216,  322,    0,    0,  216,    0,    0,  216, 
            0,    0,  216,    0,  216,    0,  216,    0,  216,    0, 
          216,  216,  216,  216,  216,  216,  216,  415,  216,    0, 
          216,    0,    0,    0,    0,    0,    0,  415,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  287,  287,  287, 
            0,    0,  287,  287,  287,    0,  287,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  287,  287,    0,    0, 
            0,  415,    0,    0,    0,  287,  287,    0,  287,  287, 
          287,  287,  287,    0,    0,  415,  415,    0,    0,    0, 
          415,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  287,  287,  287,  287,  287,  287, 
          287,  287,  287,  287,  287,  287,  287,  287,  415,    0, 
          287,  287,  287,    0,    0,  287,    0,    0,  287,    0, 
            0,  287,    0,  287,    0,  287,    0,  287,    0,  287, 
          287,  287,  287,  287,  287,  287,    0,  287,    0,  287, 
          318,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          318,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          414,  414,  414,    0,    0,  414,  414,  414,    0,  414, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  414, 
          414,    0,    0,    0,  318,    0,    0,    0,  414,  414, 
            0,  414,  414,  414,  414,  414,    0,    0,  318,  318, 
            0,    0,    0,  318,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  414,  414, 
          414,  414,  414,  414,  414,  414,  414,  414,  414,  414, 
          414,  318,    0,  414,  414,  414,    0,    0,  414,    0, 
            0,  414,    0,    0,  414,    0,  414,    0,  414,    0, 
          414,    0,  414,  414,  414,  414,  414,  414,  414,  319, 
          414,    0,  414,    0,    0,    0,    0,    0,    0,  319, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  415, 
          415,  415,    0,    0,  415,  415,  415,    0,  415,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  415,  415, 
            0,    0,    0,  319,    0,    0,    0,  415,  415,    0, 
          415,  415,  415,  415,  415,    0,    0,  319,  319,    0, 
            0,    0,  319,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  415,  415,  415, 
          415,  415,  415,  415,  415,  415,  415,  415,  415,  415, 
          319,    0,  415,  415,  415,    0,    0,  415,    0,    0, 
          415,    0,    0,  415,    0,  415,    0,  415,    0,  415, 
            0,  415,  415,  415,  415,  415,  415,  415,    0,  415, 
            0,  415,  284,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  284,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  318,  318,  318,    0,    0,  318,  318,  318, 
            0,  318,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  318,    0,    0,    0,    0,  284,    0,    0,    0, 
          318,  318,    0,  318,  318,  318,  318,  318,    0,    0, 
          284,  284,    0,    0,    0,  284,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  318, 
          318,  318,  318,  318,  318,  318,  318,  318,  318,  318, 
          318,  318,  318,  284,    0,  318,  318,  318,    0,    0, 
          318,    0,    0,  318,    0,    0,    0,    0,    0,    0, 
          318,    0,  318,    0,  318,  318,  318,  318,  318,  318, 
          318,  194,  318,    0,  318,    0,    0,    0,    0,    0, 
            0,  194,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  319,  319,  319,    0,    0,  319,  319,  319,    0, 
          319,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          319,    0,    0,    0,    0,  194,    0,    0,    0,  319, 
          319,    0,  319,  319,  319,  319,  319,    0,    0,  194, 
          194,    0,    0,    0,  194,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  319,  319, 
          319,  319,  319,  319,  319,  319,  319,  319,  319,  319, 
          319,  319,    0,    0,  319,  319,  319,    0,    0,  319, 
            0,    0,  319,    0,    0,    0,    0,    0,    0,  319, 
            0,  319,    0,  319,  319,  319,  319,  319,  319,  319, 
            0,  319,  190,  319,    0,    0,    0,    0,    0,    0, 
            0,    0,  190,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  284,  284,  284,    0,    0,  284, 
          284,  284,    0,  284,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  284,    0,    0,  190,    0,    0,    0, 
            0,    0,  284,  284,    0,  284,  284,  284,  284,  284, 
          190,  190,    0,    0,    0,  190,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  284,  284,  284,  284,  284,  284,  284,  284,  284, 
          284,  284,  284,  284,  284,    0,    0,  284,  284,  284, 
            0,    0,  284,    0,    0,  284,    0,    0,    0,    0, 
            0,    0,  284,    0,  284,    0,  284,  284,  284,  284, 
          284,  284,  284,  187,  284,    0,  284,    0,    0,    0, 
            0,    0,    0,  187,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  194,  194,  194,    0,    0,  194,  194, 
          194,    0,  194,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  194,  194,    0,    0,    0,  187,    0,    0, 
            0,  194,  194,    0,  194,  194,  194,  194,  194,    0, 
            0,  187,  187,    0,    0,    0,  187,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  194,  194,  194,  194,  194,  194,  194,  194,  194, 
          194,    0,  194,  194,    0,    0,  194,  194,    0,    0, 
            0,  194,    0,    0,  194,    0,    0,  194,    0,  194, 
            0,  194,    0,  194,    0,  194,  194,  194,  194,  194, 
          194,  194,  189,  194,    0,  194,    0,    0,    0,    0, 
            0,    0,  189,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  190,  190,  190,    0,    0,  190, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          190,  190,    0,  190,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  190,  190,    0,  189,    0,    0,    0, 
            0,    0,  190,  190,    0,  190,  190,  190,  190,  190, 
          189,  189,    0,    0,    0,  189,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  190,  190,  190,  190,  190,  190,  190,  190, 
          190,  190,    0,  190,  190,    0,    0,  190,  190,    0, 
            0,    0,  190,    0,    0,  190,    0,    0,  190,    0, 
          190,    0,  190,    0,  190,    0,  190,  190,  190,  190, 
          190,  190,  190,  188,  190,    0,  190,    0,    0,    0, 
            0,    0,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  187,  187,  187,    0,    0, 
          187,  187,  187,    0,  187,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  187,  187,    0,  188,    0,    0, 
            0,    0,    0,  187,  187,    0,  187,  187,  187,  187, 
          187,  188,  188,    0,    0,    0,  188,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  187,  187,  187,  187,  187,  187,  187, 
          187,  187,  187,    0,  187,  187,    0,    0,  187,  187, 
            0,    0,    0,  187,    0,    0,  187,    0,    0,  187, 
            0,  187,    0,  187,    0,  187,    0,  187,  187,  187, 
          187,  187,  187,  187,  191,  187,    0,  187,    0,    0, 
            0,    0,    0,    0,  191,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  189,  189,  189,    0,    0,  189, 
          189,  189,    0,  189,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  189,  189,    0,    0,    0,  191,    0, 
            0,    0,  189,  189,    0,  189,  189,  189,  189,  189, 
            0,    0,  191,  191,    0,    0,    0,  191,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  189,  189,  189,  189,  189,  189,  189,  189, 
          189,  189,    0,  189,  189,    0,    0,  189,  189,    0, 
            0,    0,  189,    0,    0,  189,    0,    0,  189,    0, 
          189,    0,  189,    0,  189,    0,  189,  189,  189,  189, 
          189,  189,  189,  192,  189,    0,  189,    0,    0,    0, 
            0,    0,    0,  192,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  188,  188,  188,    0,    0, 
          188,  188,  188,    0,  188,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  188,  188,    0,  192,    0,    0, 
            0,    0,    0,  188,  188,    0,  188,  188,  188,  188, 
          188,  192,  192,    0,    0,    0,  192,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  188,  188,  188,  188,  188,  188,  188, 
          188,  188,  188,    0,  188,  188,    0,    0,  188,  188, 
            0,    0,    0,  188,    0,    0,  188,    0,    0,  188, 
            0,  188,    0,  188,    0,  188,    0,  188,  188,  188, 
          188,  188,  188,  188,    0,  188,  273,  188,    0,    0, 
            0,    0,    0,    0,    0,    0,  273,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  191,  191,  191,    0, 
            0,  191,  191,  191,    0,  191,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  191,  191,    0,    0,    0, 
           82,    0,    0,    0,  191,  191,    0,  191,  191,  191, 
          191,  191,    0,    0,    0,  273,    0,   90,    0,  273, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  191,  191,  191,  191,  191,  191, 
          191,  191,  191,  191,    0,  191,  191,  273,    0,  191, 
          191,    0,    0,    0,  191,    0,    0,  191,    0,    0, 
          191,    0,  191,    0,  191,    0,  191,    0,  191,  191, 
          191,  191,  191,  191,  191,  280,  191,    0,  191,    0, 
            0,    0,    0,    0,    0,  280,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  192,  192,  192,    0,    0, 
          192,  192,  192,    0,  192,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  192,  192,    0,    0,    0,   81, 
            0,    0,    0,  192,  192,    0,  192,  192,  192,  192, 
          192,    0,    0,    0,  280,    0,   89,    0,  280,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  192,  192,  192,  192,  192,  192,  192, 
          192,  192,  192,    0,  192,  192,  280,    0,  192,  192, 
            0,    0,    0,  192,    0,    0,  192,    0,    0,  192, 
            0,  192,    0,  192,    0,  192,    0,  192,  192,  192, 
          192,  192,  192,  192,    0,  192,    0,  192,  281,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  281,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  273,  273, 
          273,    0,    0,    0,  273,  273,    0,  273,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   76,    0,    0,    0,  273,  273,    0,  273, 
          273,  273,  273,  273,    0,    0,    0,  281,    0,   84, 
            0,  281,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  273,  273,  273,  273,  273, 
          273,  273,  273,  273,  273,  273,  273,  273,  273,  281, 
            0,  273,  273,  273,    0,    0,    0,    0,    0,  273, 
            0,    0,    0,    0,    0,    0,  273,    0,  273,    0, 
          273,  273,  273,  273,  273,  273,  273,  185,  273,    0, 
          273,    0,    0,    0,    0,    0,    0,  185,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  280,  280,  280, 
            0,    0,    0,  280,  280,    0,  280,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  185,    0,    0,    0,  280,  280,    0,  280,  280, 
          280,  280,  280,    0,    0,  185,  185,    0,    0,    0, 
          185,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,    0,    0, 
          280,  280,  280,    0,    0,    0,    0,    0,  280,    0, 
            0,    0,    0,    0,    0,  280,    0,  280,    0,  280, 
          280,  280,  280,  280,  280,  280,    0,  280,  186,  280, 
            0,    0,    0,    0,    0,    0,    0,    0,  186,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          281,  281,  281,    0,    0,    0,  281,  281,    0,  281, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  186,    0,    0,    0,    0,    0,  281,  281, 
            0,  281,  281,  281,  281,  281,  186,  186,    0,    0, 
            0,  186,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  281,  281,  281, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,  281, 
          281,    0,    0,  281,  281,  281,    0,    0,    0,    0, 
            0,  281,    0,    0,    0,    0,    0,    0,  281,    0, 
          281,    0,  281,  281,  281,  281,  281,  281,  281,  210, 
          281,    0,  281,    0,    0,    0,    0,    0,    0,  210, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  185, 
          185,  185,    0,    0,  185,  185,  185,    0,  185,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  185,  185, 
            0,    0,    0,  210,    0,    0,    0,  185,  185,    0, 
          185,  185,  185,  185,  185,    0,    0,  210,  210,    0, 
            0,    0,  210,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  185,  185,  185, 
          185,  185,  185,  185,  185,  185,  185,    0,  185,  185, 
            0,    0,  185,  185,    0,    0,    0,  185,    0,    0, 
          185,    0,    0,  185,    0,  185,    0,    0,    0,  185, 
            0,    0,    0,  185,  185,  185,  185,  185,  211,  185, 
            0,  185,    0,    0,    0,    0,    0,    0,  211,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          186,  186,  186,    0,    0,  186,  186,  186,    0,  186, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  186, 
          186,    0,  211,    0,    0,    0,    0,    0,  186,  186, 
            0,  186,  186,  186,  186,  186,  211,  211,    0,    0, 
            0,  211,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  186,  186, 
          186,  186,  186,  186,  186,  186,  186,  186,    0,  186, 
          186,    0,    0,  186,  186,    0,    0,    0,  186,    0, 
            0,  186,    0,    0,  186,    0,  186,    0,    0,    0, 
          186,    0,    0,    0,  186,  186,  186,  186,  186,  197, 
          186,    0,  186,    0,    0,    0,    0,    0,    0,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  210,  210,  210,    0,    0,  210,  210,  210,    0, 
          210,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          210,  210,    0,  197,    0,    0,    0,    0,    0,  210, 
          210,    0,  210,  210,  210,  210,  210,  197,  197,    0, 
            0,    0,  197,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  210, 
          210,  210,  210,  210,  210,  210,  210,  210,  210,    0, 
          210,  210,    0,    0,  210,  210,    0,    0,    0,  210, 
            0,    0,  210,    0,  195,  210,    0,  210,    0,    0, 
            0,  210,    0,    0,  195,    0,    0,  210,  210,  210, 
            0,  210,    0,  210,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          211,  211,  211,    0,    0,  211,  211,  211,  195,  211, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  211, 
          211,    0,  195,  195,    0,    0,    0,  195,  211,  211, 
            0,  211,  211,  211,  211,  211,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  211,  211, 
          211,  211,  211,  211,  211,  211,  211,  211,    0,  211, 
          211,    0,    0,  211,  211,  196,    0,    0,  211,    0, 
            0,  211,    0,    0,  211,  196,  211,    0,    0,    0, 
          211,    0,    0,    0,    0,    0,  211,  211,  211,    0, 
          211,    0,  211,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  196, 
            0,  197,  197,  197,    0,    0,  197,  197,  197,    0, 
          197,    0,    0,  196,  196,    0,    0,    0,  196,    0, 
          197,  197,    0,    0,    0,    0,    0,    0,    0,  197, 
          197,    0,  197,  197,  197,  197,  197,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  197, 
          197,  197,  197,  197,  197,  197,  197,  197,  197,    0, 
          197,  197,    0,  200,    0,    0,    0,    0,    0,  197, 
            0,    0,  197,  200,    0,  197,    0,  197,    0,    0, 
            0,  197,    0,    0,    0,    0,    0,  197,  197,  197, 
            0,  197,    0,  197,    0,    0,  195,  195,  195,    0, 
            0,  195,  195,  195,    0,  195,    0,  200,    0,    0, 
            0,    0,    0,    0,    0,  195,  195,    0,    0,    0, 
            0,  200,  200,    0,  195,  195,  200,  195,  195,  195, 
          195,  195,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  195,  195,  195,  195,  195,  195, 
          195,  195,  195,  195,    0,  195,  195,    0,    0,    0, 
            0,  202,    0,    0,  195,    0,    0,  195,    0,    0, 
          195,  202,  195,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  195,  195,  195,    0,  195,    0,  195,    0, 
            0,    0,    0,    0,    0,    0,    0,  196,  196,  196, 
            0,    0,  196,  196,  196,  202,  196,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  196,  196,    0,  202, 
          202,    0,    0,    0,  202,  196,  196,    0,  196,  196, 
          196,  196,  196,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  196,  196,  196,  196,  196, 
          196,  196,  196,  196,  196,    0,  196,  196,    0,  201, 
            0,    0,    0,    0,    0,  196,    0,    0,  196,  201, 
            0,  196,    0,  196,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  196,  196,  196,    0,  196,    0,  196, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  201,    0,  200,  200,  200,    0,    0, 
          200,  200,  200,    0,  200,    0,    0,  201,  201,    0, 
            0,    0,  201,    0,  200,  200,    0,    0,    0,    0, 
            0,    0,    0,  200,  200,    0,  200,  200,  200,  200, 
          200,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  200,  200,  200,  200,  200,  200,  200, 
          200,  200,  200,    0,  200,  200,    0,  199,    0,    0, 
            0,    0,    0,  200,    0,    0,  200,  199,    0,  200, 
            0,  200,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  200,  200,    0,    0,    0,    0,  200,    0,    0, 
            0,    0,    0,  202,  202,  202,    0,    0,  202,  202, 
          202,  199,  202,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  202,  202,    0,  199,  199,    0,    0,    0, 
          199,  202,  202,    0,  202,  202,  202,  202,  202,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  202,  202,  202,  202,  202,  202,  202,  202,  202, 
          202,    0,  202,  202,    0,  203,    0,    0,    0,    0, 
            0,  202,    0,    0,  202,  203,    0,  202,    0,  202, 
            0,   33,    0,    0,    0,    0,    0,    0,    0,  202, 
          202,   33,    0,    0,    0,  202,    0,    0,    0,    0, 
            0,  201,  201,  201,    0,    0,  201,  201,  201,  203, 
          201,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          201,  201,    0,  203,  203,  261,    0,    0,  203,  201, 
          201,    0,  201,  201,  201,  201,  201,    0,    0,    0, 
           33,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  201, 
          201,  201,  201,  201,  201,  201,  201,  201,  201,    0, 
          201,  201,    0,  204,    0,    0,    0,    0,    0,  201, 
            0,    0,  201,  204,    0,  201,    0,  201,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  201,  201,    0, 
            0,    0,    0,  201,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  204,    0,  199, 
          199,  199,    0,    0,  199,  199,  199,    0,  199,    0, 
            0,  204,  204,    0,    0,    0,  204,    0,  199,  199, 
            0,    0,    0,    0,    0,    0,    0,  199,  199,    0, 
          199,  199,  199,  199,  199,    0,    0,    0,    0,    0, 
          205,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          205,    0,    0,    0,    0,    0,    0,  199,  199,  199, 
          199,  199,  199,  199,  199,  199,  199,    0,  199,  199, 
            0,    0,    0,    0,    0,    0,    0,  199,    0,    0, 
          199,    0,    0,  199,  205,  199,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  199,  199,    0,  205,  205, 
            0,  199,    0,  205,    0,    0,    0,  203,  203,  203, 
            0,    0,  203,  203,  203,    0,  203,    0,    0,    0, 
            0,    0,    0,   33,   33,   33,  203,  203,    0,   33, 
           33,    0,   33,    0,    0,  203,  203,    0,  203,  203, 
          203,  203,  203,  212,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  212,   33,   33,   33,   33,   33,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  203,  203,    0,    0,    0,  203,  203,    0,    0, 
            0,    0,    0,    0,    0,  203,    0,  212,  203,    0, 
            0,  203,    0,  203,    0,    0,    0,    0,    0,    0, 
            0,  212,  212,    0,   33,    0,  212,    0,    0,  203, 
            0,    0,    0,    0,    0,  204,  204,  204,    0,    0, 
          204,  204,  204,    0,  204,   33,    0,    0,    0,    0, 
            0,  206,    0,    0,  204,  204,    0,    0,    0,    0, 
            0,  206,    0,  204,  204,    0,  204,  204,  204,  204, 
          204,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  206,    0,    0,    0,  204, 
          204,    0,    0,    0,  204,  204,    0,    0,    0,  206, 
          206,    0,    0,  204,  206,    0,  204,    0,    0,  204, 
            0,  204,  205,  205,  205,    0,    0,  205,  205,  205, 
            0,  205,    0,    0,    0,    0,    0,  204,  207,    0, 
            0,  205,  205,    0,    0,    0,    0,    0,  207,    0, 
          205,  205,    0,  205,  205,  205,  205,  205,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  207,    0,    0,    0,  205,  205,    0,    0, 
            0,  205,  205,    0,    0,    0,  207,  207,    0,    0, 
          205,  207,    0,  205,    0,    0,  205,    0,  205,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  205,  212,  212,  212,  213,    0, 
          212,  212,  212,    0,  212,    0,    0,    0,  213,    0, 
            0,    0,    0,    0,  212,  212,    0,    0,    0,    0, 
            0,    0,    0,  212,  212,    0,  212,  212,  212,  212, 
          212,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  213,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  213,  213,    0,  212, 
          212,  213,    0,    0,  212,  212,    0,    0,    0,    0, 
            0,    0,    0,  212,    0,    0,  212,    0,    0,  212, 
            0,  212,    0,  206,  206,  206,  184,    0,  206,  206, 
          206,    0,  206,    0,    0,    0,  184,  212,    0,    0, 
            0,    0,  206,  206,    0,    0,    0,    0,    0,    0, 
            0,  206,  206,    0,  206,  206,  206,  206,  206,    0, 
            0,    0,  217,    0,    0,    0,    0,    0,    0,    0, 
          184,    0,  217,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  184,  184,    0,  206,  206,  184, 
            0,    0,  206,  206,    0,    0,    0,    0,    0,    0, 
            0,  206,    0,    0,  206,    0,  217,  206,    0,  206, 
          207,  207,  207,    0,    0,  207,  207,  207,    0,  207, 
          217,  217,    0,    0,    0,  206,    0,    0,    0,  207, 
          207,    0,    0,    0,    0,    0,    0,    0,  207,  207, 
            0,  207,  207,  207,  207,  207,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  214,    0,    0,    0, 
            0,    0,    0,    0,  207,  207,  214,    0,    0,  207, 
          207,    0,    0,    0,    0,    0,    0,    0,  207,    0, 
            0,  207,    0,    0,  207,    0,  207,    0,    0,    0, 
          213,  213,  213,  182,    0,  213,  213,  213,    0,  213, 
          214,    0,  207,  182,    0,    0,    0,    0,    0,  213, 
          213,    0,    0,    0,  214,  214,    0,    0,  213,  213, 
            0,  213,  213,  213,  213,  213,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  182,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  182,  182,    0,    0,  213,    0,    0,    0,  213, 
          213,    0,    0,    0,    0,    0,    0,    0,  213,    0, 
            0,  213,    0,    0,  213,    0,  213,    0,  184,  184, 
          184,  175,    0,  184,  184,  184,    0,  184,    0,    0, 
            0,  175,  213,    0,    0,    0,    0,  184,  184,    0, 
            0,    0,    0,    0,    0,    0,  184,  184,    0,  184, 
          184,  184,  184,  184,  217,  217,  217,  181,    0,  217, 
          217,  217,    0,  217,    0,  175,    0,  181,    0,    0, 
            0,    0,    0,  217,  217,    0,    0,    0,    0,  175, 
          175,    0,  217,  217,    0,  217,  217,  217,  217,  217, 
            0,    0,    0,    0,    0,    0,  184,    0,    0,  184, 
            0,  181,  184,    0,  184,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  181,  181,    0,    0,    0, 
          184,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  217,    0,    0,  217,    0,    0,  217,    0, 
          217,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  217,    0,  214,  214, 
          214,  215,    0,  214,  214,  214,    0,  214,    0,    0, 
            0,  215,    0,    0,    0,    0,    0,  214,  214,    0, 
            0,    0,    0,    0,    0,    0,  214,  214,    0,  214, 
          214,  214,  214,  214,    0,  182,  182,  182,    0,  177, 
          182,  182,  182,    0,  182,  215,    0,    0,    0,  177, 
            0,    0,    0,    0,  182,  182,    0,    0,    0,  215, 
          215,    0,    0,  182,  182,    0,  182,  182,  182,  182, 
          182,    0,    0,    0,    0,    0,  214,    0,    0,  214, 
            0,    0,  214,  177,  214,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  177,  177,    0, 
          214,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  182,    0,    0,  182,    0,    0,  182, 
            0,  182,    0,  175,  175,  175,  178,    0,  175,  175, 
          175,    0,  175,    0,    0,    0,  178,  182,    0,    0, 
            0,    0,  175,  175,    0,    0,    0,    0,    0,    0, 
            0,  175,  175,    0,  175,  175,  175,  175,  175,  181, 
          181,  181,  179,    0,  181,  181,  181,    0,  181,    0, 
          178,    0,  179,    0,    0,    0,    0,    0,  181,  181, 
            0,    0,    0,    0,  178,  178,    0,  181,  181,    0, 
          181,  181,  181,  181,  181,    0,    0,    0,    0,    0, 
            0,  175,    0,    0,  175,    0,  179,  175,    0,  175, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          179,  179,    0,    0,    0,  175,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  181,    0,    0, 
          181,    0,    0,  181,    0,  181,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  180,    0,    0,    0, 
            0,  181,    0,  215,  215,  215,  180,    0,  215,  215, 
          215,    0,  215,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  215,  215,    0,    0,    0,    0,    0,    0, 
            0,  215,  215,    0,  215,  215,  215,  215,  215,    0, 
          180,  177,  177,  177,    0,    0,  177,  177,  177,    0, 
          177,    0,    0,    0,  180,  180,  174,    0,    0,    0, 
          177,  177,    0,    0,    0,    0,  174,    0,    0,  177, 
          177,    0,  177,  177,  177,  177,  177,    0,    0,    0, 
            0,  215,    0,    0,  215,    0,    0,  215,    0,  215, 
            0,    0,    0,    0,  176,    0,    0,    0,    0,    0, 
          174,    0,    0,    0,  176,  215,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  174,    0,    0,    0,  177, 
            0,    0,  177,    0,    0,  177,    0,  177,  178,  178, 
          178,    0,    0,  178,  178,  178,    0,  178,  176,    0, 
            0,    0,    0,  177,    0,    0,    0,  178,  178,    0, 
            0,    0,  176,  176,    0,    0,  178,  178,    0,  178, 
          178,  178,  178,  178,  179,  179,  179,    0,    0,  179, 
          179,  179,    0,  179,    0,    0,    0,    0,    0,    0, 
            0,  261,    0,  179,  179,    0,    0,    0,    0,    0, 
            0,  261,  179,  179,    0,  179,  179,  179,  179,  179, 
            0,    0,    0,    0,    0,    0,  178,    0,    0,  178, 
            0,    0,  178,    0,  178,    0,    0,  262,    0,    0, 
            0,    0,    0,    0,    0,  261,    0,  262,    0,    0, 
          178,    0,    0,    0,    0,    0,    0,    0,    0,  261, 
          261,    0,  179,    0,    0,  179,    0,    0,  179,    0, 
          179,    0,    0,    0,    0,    0,    0,    0,  180,  180, 
          180,  262,    0,  180,  180,  180,  179,  180,    0,    0, 
            0,    0,    0,    0,    0,  262,  262,  180,  180,    0, 
            0,    0,    0,    0,    0,    0,  180,  180,    0,  180, 
          180,  180,  180,  180,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   53,    0,    0,    0,    0,    0,    0,  174,  174, 
          174,   53,    0,  174,  174,  174,    0,  174,    0,    0, 
            0,    0,    0,    0,    0,    0,  180,  174,  174,  180, 
            0,    0,  180,    0,  180,    0,  174,  174,    0,  174, 
          174,  174,  174,  174,   55,    0,  176,  176,  176,    0, 
          180,  176,  176,  176,   55,  176,    0,    0,    0,   53, 
           53,    0,    0,    0,    0,  176,  176,    0,    0,    0, 
            0,    0,    0,    0,  176,  176,    0,  176,  176,  176, 
          176,  176,    0,    0,    0,    0,  174,   57,    0,  174, 
            0,    0,  174,    0,  174,    0,    0,   57,    0,    0, 
            0,    0,   55,   55,    0,    0,    0,    0,    0,    0, 
          174,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  176,    0,    0,  176,    0,    0, 
          176,    0,  176,  261,  261,  261,    0,    0,  261,  261, 
          261,    0,  261,    0,    0,   57,   57,   41,  176,    0, 
            0,    0,  261,  261,    0,    0,    0,   41,    0,    0, 
            0,  261,  261,    0,  261,  261,  261,  261,  261,  262, 
          262,  262,    0,    0,  262,  262,  262,    0,  262,    0, 
            0,    0,    0,    0,    0,   43,    0,    0,  262,  262, 
            0,    0,    0,    0,    0,   43,    0,  262,  262,    0, 
          262,  262,  262,  262,  262,   41,   41,    0,    0,    0, 
            0,    0,    0,    0,  261,    0,    0,  261,    0,  261, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   48, 
            0,    0,    0,    0,    0,  261,    0,    0,    0,   48, 
            0,    0,    0,   43,   43,    0,    0,    0,    0,    0, 
          262,    0,    0,  262,    0,  262,    0,    0,    0,    0, 
            0,    0,    0,   53,   53,   53,    0,    0,   53,   53, 
           53,  262,   53,    0,  263,    0,    0,    0,    0,    0, 
            0,    0,   53,   53,  263,    0,    0,   48,   48,    0, 
            0,   53,   53,    0,   53,   53,   53,   53,   53,    0, 
            0,    0,    0,    0,    0,    0,   55,   55,   55,    0, 
            0,   55,   55,   55,   42,   55,    0,    0,  262,    0, 
            0,    0,    0,    0,   42,   55,   55,    0,    0,    0, 
            0,    0,  263,  263,   55,   55,    0,   55,   55,   55, 
           55,   55,    0,    0,   53,    0,    0,   53,    0,   57, 
           57,   57,    0,    0,   57,   57,   57,    0,   57,    0, 
            0,    0,    0,    0,    0,   53,    0,    0,   57,   57, 
            0,    0,   42,   42,    0,    0,    0,   57,   57,    0, 
           57,   57,   57,   57,   57,    0,    0,   55,    0,    0, 
           55,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   55,   41, 
           41,   41,    0,    0,   41,   41,   41,    0,   41,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   41,    0, 
           57,    0,    0,   57,    0,    0,    0,   41,   41,    0, 
           41,   41,   41,   41,   41,    0,    0,   43,   43,   43, 
            0,   57,   43,   43,   43,    0,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   43,    0,  398,    0, 
            0,    0,    0,    0,    0,   43,   43,    0,   43,   43, 
           43,   43,   43,    0,    0,    0,    0,    0,    0,    0, 
           41,   48,   48,   48,    0,    0,   48,   48,   48,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           48,   41,    0,    0,    0,    0,    0,    0,    0,   48, 
           48,    0,   48,   48,   48,   48,   48,    0,   43,    0, 
            0,    0,    0,    0,    0,    0,  263,  263,  263,    0, 
            0,  263,  263,  263,    0,  263,    0,    0,    0,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  263,  263,  263, 
          263,  263,   48,    0,    0,    0,   42,   42,   42,    0, 
            0,   42,   42,   42,    0,   42,    0,    0,    0,    0, 
            0,    0,    0,   48,    0,   42,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   42,   42,   42, 
           42,   42,    0,    0,  263,    0,    0,  263,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  263,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   42,    0,    0, 
            0,    0,    0,    0,    0,    0,    4,    5,    6,    7, 
            8,    0,    0,    0,    9,   10,    0,    0,   42,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,   29, 
           30,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   46,    0,    0, 
           47,    0,    0,   48,   49,    0,   50,    0,   51,    0, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
           53,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,   60,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,  620,    0,  233,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,   53,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,   20,   21,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  232,    0, 
          233,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,   20,   21, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,  417,   49, 
            0,   50,    0,  232,    0,  233,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,  100,  101,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  611,    0, 
          233,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,  615,    0,  233,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,   20,   21,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  611,    0, 
          233,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,  812,    0,  233,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,  100,  101,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  816,    0, 
          233,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,  820,    0,  233,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,  100,  101,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  874,    0, 
          233,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,  876,    0,  233,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,  100,  101,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  888,    0, 
          233,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,  251,  251,  251,    0,  251,    0,    0,    0,  251, 
          251,    0,    0,    0,  251,    0,  251,  251,  251,  251, 
          251,  251,  251,    0,    0,    0,    0,  251,  251,  251, 
          251,  251,  251,  251,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,    0,    0,  251,  251,  251,  251, 
          251,  251,  251,  251,  251,  251,    0,  251,  251,    0, 
          251,  251,  251,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  251,    0,    0,  251,    0,    0,  251,  251, 
            0,  251,    0,  251,    0,  251,    0,  251,    0,    0, 
            0,    0,    0,    0,    0,  251,    0,    0,    0,    0, 
          251,  251,  251,  251,  251,  251,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,   20,   21,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  270,    0, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,  429,    0,   48,   49, 
            0,   50,    0,    0,    0,    0,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  526,    0, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,  526,    0,    0,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,  100,  101,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  593,    0, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,  643,    0,    0,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,  100,  101,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,  777,    0, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,  806,    0,    0,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,  488,  488,  488,    0, 
          488,    0,    0,    0,  488,  488,    0,    0,    0,  488, 
            0,  488,  488,  488,  488,  488,  488,  488,    0,    0, 
            0,    0,  488,  488,  488,  488,  488,  488,  488,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  488,    0, 
            0,  488,  488,  488,  488,  488,  488,  488,  488,  488, 
          488,    0,  488,  488,    0,  488,  488,  488,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  488,    0,    0, 
          488,  488,    0,  488,  488,    0,  488,    0,    0,    0, 
            0,    0,  488,    0,    0,    0,    0,    0,    0,    0, 
          488,    0,    0,    0,    0,  488,  488,  488,  488,  488, 
          488,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,    0,    0,    0,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,    0,    0, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  102,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
            0,    0,  105,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  225,    0,    0,   47,    0,    0,   48,   49, 
            0,   50,    0,   51,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  760,    0,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,  100,  101,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  102,    0, 
            0,   31,   32,  103,   34,   35,   36,  104,   38,   39, 
           40,    0,   41,   42,    0,    0,    0,  105,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  106,    0,    0,  107,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  102,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
            0,    0,  105,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  225,    0,    0,   47,    0,    0,   48,   49, 
            0,   50,    0,   51,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,  100,  101,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  102,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,    0,    0,  105,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  280,    0,    0, 
          350,    0,    0,   48,   49,    0,   50,    0,  351,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  102,    0,    0,   31,   32,  103,   34, 
           35,   36,  104,   38,   39,   40,    0,   41,   42,    0, 
            0,    0,  105,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  107,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,  100,  101,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  102,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,    0,    0,  105,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  280,    0,    0, 
          108,    0,    0,   48,   49,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   97, 
           98,   17,   18,    0,    0,    0,    0,   99,  100,  101, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  102,    0,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
            0,    0,  105,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  795,    0,    0,  108,    0,    0,   48,   49, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,  117,  118,  119,  120, 
          121,  122,  123,  124,    0,    0,  125,  126,  127,  128, 
          129,    0,    0,  130,  131,  132,  133,  134,  135,  136, 
            0,    0,  137,  138,  139,  193,  194,  195,  196,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  197,  198,  199,  159,  253,    0,  200,    0,    0, 
            0,    0,    0,    0,    0,  161,  162,    0,  163,  164, 
          165,  166,    0,  167,  168,    0,    0,  169,    0,    0, 
            0,    0,  170,  171,  172,  173,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  175,  176, 
            0,  177,  178,  179,  180,  181,  182,  183,  184,  185, 
            0,  186,    0,    0,  187,  201,  117,  118,  119,  120, 
          121,  122,  123,  124,    0,    0,  125,  126,  127,  128, 
          129,    0,    0,  130,  131,  132,  133,  134,  135,  136, 
            0,    0,  137,  138,  139,  193,  194,  195,  196,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  197,  198,  199,  159,    0,    0,  200,    0,    0, 
            0,    0,    0,    0,    0,  161,  162,    0,  163,  164, 
          165,  166,    0,  167,  168,    0,    0,  169,    0,    0, 
            0,    0,  170,  171,  172,  173,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  175,  176, 
            0,  177,  178,  179,  180,  181,  182,  183,  184,  185, 
            0,  186,    0,    0,  187,  201,  117,  118,  119,  120, 
          121,  122,  123,  124,    0,    0,  125,  126,  127,  128, 
          129,    0,    0,  130,  131,  132,  133,  134,  135,  136, 
            0,    0,  137,  138,  139,  140,  141,  142,  143,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,   35,   36,  160,   38,    0, 
            0,    0,    0,    0,    0,  161,  162,    0,  163,  164, 
          165,  166,    0,  167,  168,    0,    0,  169,    0,    0, 
            0,    0,  170,  171,  172,  173,    0,    0,    0,    0, 
            0,  174,    0,    0,    0,    0,    0,    0,  175,  176, 
            0,  177,  178,  179,  180,  181,  182,  183,  184,  185, 
            0,  186,    0,    0,  187,  117,  118,  119,  120,  121, 
          122,  123,  124,    0,    0,  125,  126,  127,  128,  129, 
            0,    0,  130,  131,  132,  133,  134,  135,  136,    0, 
            0,  137,  138,  139,  193,  194,  195,  196,  144,  145, 
          146,  147,  148,  149,  150,  151,  152,  153,  154,  155, 
          197,  198,  199,  159,  288,  289,  200,  290,    0,    0, 
            0,    0,    0,    0,  161,  162,    0,  163,  164,  165, 
          166,    0,  167,  168,    0,    0,  169,    0,    0,    0, 
            0,  170,  171,  172,  173,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  175,  176,    0, 
          177,  178,  179,  180,  181,  182,  183,  184,  185,    0, 
          186,    0,    0,  187,  117,  118,  119,  120,  121,  122, 
          123,  124,    0,    0,  125,  126,  127,  128,  129,    0, 
            0,  130,  131,  132,  133,  134,  135,  136,    0,    0, 
          137,  138,  139,  193,  194,  195,  196,  144,  145,  146, 
          147,  148,  149,  150,  151,  152,  153,  154,  155,  197, 
          198,  199,  159,    0,    0,  200,    0,    0,    0,    0, 
            0,    0,    0,  161,  162,    0,  163,  164,  165,  166, 
            0,  167,  168,    0,    0,  169,    0,    0,    0,    0, 
          170,  171,  172,  173,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  175,  176,    0,  177, 
          178,  179,  180,  181,  182,  183,  184,  185,    0,  186, 
          508,  509,  187,    0,  510,    0,    0,    0,    0,    0, 
            0,    0,  161,  162,    0,  163,  164,  165,  166,    0, 
          167,  168,    0,    0,  169,    0,    0,    0,    0,  170, 
          171,  172,  173,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  175,  176,    0,  177,  178, 
          179,  180,  181,  182,  183,  184,  185,    0,  186,  513, 
          514,  187,    0,  515,    0,    0,    0,    0,    0,    0, 
            0,  161,  162,    0,  163,  164,  165,  166,    0,  167, 
          168,    0,    0,  169,    0,    0,    0,    0,  170,  171, 
          172,  173,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  175,  176,    0,  177,  178,  179, 
          180,  181,  182,  183,  184,  185,    0,  186,  520,  509, 
          187,    0,  521,    0,    0,    0,    0,    0,    0,    0, 
          161,  162,    0,  163,  164,  165,  166,    0,  167,  168, 
            0,    0,  169,    0,    0,    0,    0,  170,  171,  172, 
          173,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  175,  176,    0,  177,  178,  179,  180, 
          181,  182,  183,  184,  185,    0,  186,  547,  514,  187, 
            0,  548,    0,    0,    0,    0,    0,    0,    0,  161, 
          162,    0,  163,  164,  165,  166,    0,  167,  168,    0, 
            0,  169,    0,    0,    0,    0,  170,  171,  172,  173, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  175,  176,    0,  177,  178,  179,  180,  181, 
          182,  183,  184,  185,    0,  186,  584,  509,  187,    0, 
          585,    0,    0,    0,    0,    0,    0,    0,  161,  162, 
            0,  163,  164,  165,  166,    0,  167,  168,    0,    0, 
          169,    0,    0,    0,    0,  170,  171,  172,  173,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  175,  176,    0,  177,  178,  179,  180,  181,  182, 
          183,  184,  185,    0,  186,  586,  514,  187,    0,  587, 
            0,    0,    0,    0,    0,    0,    0,  161,  162,    0, 
          163,  164,  165,  166,    0,  167,  168,    0,    0,  169, 
            0,    0,    0,    0,  170,  171,  172,  173,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          175,  176,    0,  177,  178,  179,  180,  181,  182,  183, 
          184,  185,    0,  186,  602,  509,  187,    0,  603,    0, 
            0,    0,    0,    0,    0,    0,  161,  162,    0,  163, 
          164,  165,  166,    0,  167,  168,    0,    0,  169,    0, 
            0,    0,    0,  170,  171,  172,  173,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  175, 
          176,    0,  177,  178,  179,  180,  181,  182,  183,  184, 
          185,    0,  186,  604,  514,  187,    0,  605,    0,    0, 
            0,    0,    0,    0,    0,  161,  162,    0,  163,  164, 
          165,  166,    0,  167,  168,    0,    0,  169,    0,    0, 
            0,    0,  170,  171,  172,  173,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  175,  176, 
            0,  177,  178,  179,  180,  181,  182,  183,  184,  185, 
            0,  186,  645,  509,  187,    0,  646,    0,    0,    0, 
            0,    0,    0,    0,  161,  162,    0,  163,  164,  165, 
          166,    0,  167,  168,    0,    0,  169,    0,    0,    0, 
            0,  170,  171,  172,  173,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  175,  176,    0, 
          177,  178,  179,  180,  181,  182,  183,  184,  185,    0, 
          186,  647,  514,  187,    0,  648,    0,    0,    0,    0, 
            0,    0,    0,  161,  162,    0,  163,  164,  165,  166, 
            0,  167,  168,    0,    0,  169,    0,    0,    0,    0, 
          170,  171,  172,  173,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  175,  176,    0,  177, 
          178,  179,  180,  181,  182,  183,  184,  185,    0,  186, 
          864,  509,  187,    0,  865,    0,    0,    0,    0,    0, 
            0,    0,  161,  162,    0,  163,  164,  165,  166,    0, 
          167,  168,    0,    0,  169,    0,    0,    0,    0,  170, 
          171,  172,  173,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  175,  176,    0,  177,  178, 
          179,  180,  181,  182,  183,  184,  185,    0,  186,  866, 
          514,  187,    0,  867,    0,    0,    0,    0,    0,    0, 
            0,  161,  162,    0,  163,  164,  165,  166,    0,  167, 
          168,    0,    0,  169,    0,    0,    0,    0,  170,  171, 
          172,  173,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  175,  176,    0,  177,  178,  179, 
          180,  181,  182,  183,  184,  185,    0,  186,    0,    0, 
          187, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            2,    3,    4,    5,    6,   14,    8,  216,    6,    7, 
            4,    5,   14,   15,   16,  380,    7,   19,   15,   16, 
           14,    6,   19,  249,   27,   53,  394,  372,   61,   27, 
          412,   21,   10,   15,   16,   47,   27,   19,  377,   15, 
           16,   10,   10,   19,   32,   47,   21,   49,   50,   51, 
           10,   10,   51,   50,   15,   16,   54,   51,   19,  344, 
            9,   10,   11,   44,  400,   10,  448,   10,   50,   54, 
           10,  700,   44,   49,  265,   44,   10,   26,   10,   44, 
           61,   59,   10,   10,   10,   10,  371,   89,  107,   61, 
           59,   59,  280,  342,  343,   89,  345,  346,   10,   48, 
           59,   10,  472,   11,  389,   95,  108,  312,   91,   10, 
           44,  101,   44,   10,   59,   10,  312,  312,    3,  404, 
           95,  370,   10,  346,  114,   59,   58,   59,  463,  312, 
           58,   59,  467,   74,    0,   44,   10,  507,  387,  388, 
          698,  364,  700,  280,   10,  102,   58,   59,  330,   44, 
          327,  313,  314,  312,  403,  337,   44,  106,   59,  350, 
           10,  304,   10,   10,   11,  308,   74,  372,  373,  374, 
           44,   61,  457,   10,   10,  363,  372,  373,  374,  374, 
          670,   10,  330,  360,   10,  434,  676,   10,  342,  337, 
           10,  374,  353,   59,  290,  291,    2,    3,    4,    5, 
          545,  109,    8,  201,   91,  342,  835,  456,   14,   59, 
           58,   59,   10,  372,  373,  374,  201,  342,  379,  564, 
          559,  312,   59,   59,  315,  590,  363,  290,  291,   58, 
           59,   10,   58,   59,  363,   58,   59,  308,   58,   59, 
           91,   47,   32,   91,  246,   51,  248,  249,   32,  246, 
          306,  248,  249,  265,  310,  311,  258,   91,  319,  313, 
          314,   59,   91,  265,  246,   91,  248,  249,   91,   61, 
          246,   10,  248,  249,  223,  224,  282,  835,  219,   61, 
          343,  372,  373,   89,  367,  246,  339,  248,  249,  350, 
           44,   61,   10,  354,  355,   10,   91,  256,   61,   15, 
           16,   61,  108,   19,  306,  339,  269,  279,  271,  311, 
          343,  219,  263,  264,  271,  269,  686,  271,  269,  347, 
           59,  349,   44,  658,  312,  353,  354,   43,   44,  262, 
          290,  291,  339,   49,   50,  267,   52,   53,  350,   59, 
           58,   59,  344,   58,   59,  343,  308,  330,  350,  351, 
          732,  370,  351,  281,  337,  267,  738,  351,  307,  308, 
          309,  310,  343,  312,  313,  343,  264,  349,  344,  371, 
          372,  353,  370,   61,  343,  340,  223,  224,  308,  628, 
          629,  290,  291,  385,  372,  373,  595,  389,  360,  279, 
          388,  393,  339,  395,  730,  371,  364,  379,  343,  358, 
          343,   44,  404,  343,  330,  403,  632,  409,  340,  343, 
          412,  337,  409,  389,  396,  417,  343,  343,  343,  267, 
          417,  306,    2,   10,  373,  428,  311,  264,  404,  431, 
          428,  340,  280,  330,  343,  780,  434,  428,  267,  807, 
          337,  267,  807,  330,  267,  784,  448,  267,   91,   10, 
          337,  280,  258,  343,  279,  457,  417,  365,  456,  265, 
          307,  308,  309,  310,  421,  422,  264,   47,  417,  340, 
          360,  269,   59,  271,  856,   44,   44,   91,   44,  330, 
          429,  457,  330,   58,  441,  442,  337,  279,  833,  337, 
           44,  399,  400,   61,  342,  363,  330,  279,   59,  708, 
          306,  330,  884,  337,  330,  311,  319,  330,  337,  279, 
          269,  337,  271,  342,  337,  363,  232,  233,  234,  342, 
          340,  339,   91,   91,  263,  264,  516,  269,  108,  271, 
          246,  319,  248,  249,  363,  330,  511,  346,    0,  319, 
          256,  516,  337,  545,  350,  351,  343,  522,  523,  267, 
          343,  343,  267,  364,  270,  308,  554,  842,  374,  549, 
          374,  343,  564,  268,  269,    0,  372,   44,  360,  554, 
          348,  574,  269,  343,  342,   10,  574,  579,  360,  385, 
           91,  306,  307,  574,  309,  310,  311,  393,  267,  395, 
          360,  271,  841,  802,   10,  544,  553,   44,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,   59,  431,  263,  264,  344,    0, 
          632,  347,  264,  349,  542,  632,  279,  353,  354,  667, 
          668,  522,  523,   59,   91,  673,  295,  296,  650,   44, 
          568,  343,  661,  571,  343,  371,  632,  565,  607,  661, 
          662,   44,  664,  379,  666,  351,  352,  661,  293,  294, 
          295,  296,  297,  389,  390,  391,  392,  264,  258,  364, 
          396,  268,  269,  312,  343,  265,   32,  330,  404,  339, 
          346,  339,  408,  409,  337,  339,  412,  544,  414,  342, 
          339,  417,   44,  264,   10,  707,    2,    3,  269,  711, 
          279,  279,    8,  707,  264,  343,  330,  360,   14,  435, 
          436,  437,  312,  337,  726,  727,  728,  346,   61,  445, 
          732,   44,  448,   44,  450,  737,  738,   44,  695,  545, 
          737,  457,  304,  372,  373,  374,  304,  775,  340,   44, 
          263,   47,   58,   59,  339,  737,  339,   44,  564,  240, 
          607,  330,  330,  312,  346,  714,   61,  339,  337,  337, 
          350,   44,  264,  579,  342,  343,  737,  779,  780,  264, 
          688,   10,  372,  373,  374,   91,   44,  346,  351,  746, 
           10,  360,  360,  750,   44,   44,   91,  343,  800,  343, 
          262,  263,  264,  343,   91,  385,  268,  269,  364,  271, 
          526,  343,  108,  393,  275,  395,  277,  278,   91,  330, 
          346,  339,  730,  372,  373,  374,  337,  262,  263,  264, 
           59,  833,  279,  268,  269,  264,  271,   10,   58,   59, 
          842,  343,  844,  841,  650,  651,  262,  263,  264,  851, 
          264,  431,  854,  269,  856,  661,  662,  854,  664,  264, 
          666,  742,  743,  339,  264,  343,  842,  714,  364,  360, 
          788,   91,  264,  791,    2,    3,  794,  593,  364,  264, 
            8,  343,  884,  330,  343,   58,   59,   44,  308,  264, 
          337,  262,  263,  264,  264,  611,   44,  268,  269,  615, 
          271,  707,  364,   44,  620,  711,  343,  364,  343,   44, 
          346,  264,  264,  360,  264,   44,  632,  342,   91,   47, 
          726,  727,  728,  346,  364,  406,   61,  643,  319,  364, 
            2,    3,    4,    5,  271,  343,    8,    9,   10,   11, 
          346,  343,   14,   15,   16,  863,  364,   19,  346,  665, 
          304,  667,  668,  343,   26,  364,   91,  673,  674,  350, 
          346,  267,  258,  354,  355,  356,  357,  683,  684,  265, 
           10,  264,  343,  779,  780,   47,   48,   49,  694,   51, 
          108,   53,  343,   62,  279,   49,   50,    5,  870,    6, 
          784,   89,  279,  364,  800,  349,  350,  351,  352,  579, 
          661,  717,  718,  719,  559,  698,  279,   66,  843,  725, 
          306,  698,   74,   -1,   -1,  311,  732,   89,   58,   59, 
           -1,  737,  738,   -1,  330,   -1,   16,  833,   -1,   19, 
           -1,  337,   -1,   -1,  106,  330,  108,   -1,  844,   -1, 
           -1,   -1,  337,  330,   -1,  851,   -1,  267,  343,   -1, 
          337,   91,   -1,   -1,  350,   -1,   -1,  330,   -1,  775, 
           -1,  777,   -1,   -1,  337,  360,   -1,   -1,   -1,   -1, 
          650,   -1,   -1,  360,   -1,  304,  372,   -1,  307,  308, 
          309,   -1,  662,   -1,  664,   -1,  666,  360,  804,  385, 
          806,   -1,   -1,   -1,  267,   -1,  812,  393,   -1,  395, 
          816,  330,   -1,   -1,  820,   -1,   -1,  280,  337,   -1, 
          330,   -1,   -1,  342,   -1,   -1,   -1,  337,   -1,   -1, 
          349,  350,  351,  352,   -1,   -1,  842,   -1,   -1,   -1, 
          258,  711,  613,   -1,   -1,  431,   -1,  265,  854,   -1, 
          856,   -1,   -1,  624,  279,   -1,  726,  727,  728,   -1, 
           -1,  223,  224,   -1,   -1,   -1,   -1,  330,  874,   -1, 
          876,   -1,   -1,   -1,  337,   -1,   -1,   -1,  884,  342, 
           -1,   -1,  888,   -1,  246,   -1,  248,  249,  306,   -1, 
           -1,   -1,   -1,  311,   -1,  249,  258,   -1,   -1,   -1, 
          363,   -1,   -1,  265,   -1,  330,   -1,   -1,   -1,  779, 
          304,   -1,  337,  307,  308,  309,   -1,    0,  343,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   10,   -1,   -1, 
          800,   -1,  350,   -1,   -1,  360,   -1,  267,   -1,   -1, 
           61,   -1,   -1,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,   -1,   -1,  372,  349,  350,  351,  352,  545, 
          731,   44,   -1,  734,  735,   -1,  246,  385,  248,  249, 
           91,   -1,   -1,   -1,  844,  393,   59,  395,  564,   -1, 
           -1,  851,  344,   -1,   -1,  347,   -1,  349,  350,  351, 
          344,  353,  354,  579,   -1,   -1,   -1,   -1,   -1,   -1, 
          330,   -1,   -1,  319,    0,   -1,   -1,  337,   -1,  371, 
          372,  373,   -1,  431,   10,   -1,   -1,  371,   -1,  335, 
          336,   -1,   -1,  385,   -1,  379,  380,  389,   -1,   -1, 
           -1,  393,   -1,  395,  350,  389,  352,   -1,  354,  355, 
          356,  357,  404,   -1,   44,   -1,  817,  818,   -1,   -1, 
          404,   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,   -1, 
           -1,   61,   -1,   59,  650,   -1,   -1,  429,   -1,  431, 
           -1,   -1,   -1,   -1,   -1,  661,  662,   -1,  664,   -1, 
          666,  852,  853,   -1,   -1,  304,   -1,  858,  307,  308, 
          309,   91,    2,    3,   -1,  457,   -1,   -1,    8,    9, 
           10,   11,   -1,  457,  875,   15,   16,   -1,   -1,   19, 
           -1,   -1,  883,   -1,   -1,  886,   26,  471,  472,  890, 
           -1,  707,   -1,  342,   -1,  711,   -1,  545,   -1,   -1, 
          349,  350,  351,  352,   -1,   -1,   -1,   47,   48,   49, 
          726,  727,  728,   53,   -1,   -1,  564,   -1,   -1,   -1, 
           -1,   -1,   -1,  507,   -1,   -1,   -1,  511,  279,  280, 
            0,  579,   -1,   -1,   -1,   -1,   -1,   -1,  522,  523, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  544,  545,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,  546,  779,  780,   -1,  106,   -1,  108,   -1, 
           -1,   -1,  564,   -1,   -1,    0,   -1,  290,  291,  330, 
          293,  294,  295,  296,  800,   10,  337,  579,   -1,   59, 
           -1,  342,  343,  577,   44,   -1,  580,   -1,  582,   -1, 
           -1,   -1,  650,   -1,   -1,   -1,  590,   -1,   -1,  360, 
           -1,   61,  363,   -1,  662,  607,  664,  833,  666,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  844,   -1, 
          343,   -1,   -1,   58,   59,  851,  262,  263,  264,   -1, 
          632,   91,  268,  269,   -1,  271,   -1,   -1,   44,  279, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,  650,   -1, 
           -1,   10,   -1,  711,   -1,   61,   -1,   -1,   -1,  661, 
          662,   -1,  664,   -1,  666,  667,  668,   -1,  726,  727, 
          728,  673,   -1,  223,  224,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
          330,   -1,  686,   -1,   -1,   -1,  246,  337,  248,  249, 
           59,  319,   -1,  343,   -1,  707,    0,  343,  258,  711, 
           -1,   -1,  714,   -1,   -1,  265,   10,  335,  336,   -1, 
          360,  779,  780,   10,  726,  727,  728,   -1,  364,   -1, 
           -1,   -1,  350,   -1,   -1,   -1,  354,  355,  356,  357, 
           -1,   -1,  800,   -1,   -1,  232,  233,   -1,  742,  743, 
           44,   -1,   -1,   -1,   -1,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   59,  775,   -1,  833,   -1,  779,  780,   -1, 
           -1,   -1,  262,  263,  264,   -1,  844,   -1,  268,  269, 
           -1,  271,   -1,  851,  344,   -1,   -1,  347,  800,  349, 
          350,   -1,   -1,  353,  354,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,  807,   -1,   -1,   -1,   -1,   -1,  279, 
          280,  371,  372,  373,   -1,   -1,   -1,  262,  263,  264, 
           -1,  833,  267,  268,  269,  385,  271,   -1,   -1,  389, 
          842,   -1,  844,  393,   -1,  395,  281,  282,  842,  851, 
           -1,   -1,   -1,   91,  404,  290,  291,   -1,  293,  294, 
          295,  296,  349,  343,   -1,   -1,  353,  417,   -1,   -1, 
          330,   -1,   -1,  279,  280,    0,  870,  337,   -1,  429, 
           -1,  431,  342,  343,  364,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,  363,   -1,  340,   -1,  457,  343,  396, 
           -1,  346,   44,  348,   -1,   10,   -1,   -1,   -1,   44, 
           -1,  408,  409,   -1,  330,  412,   -1,  414,   -1,  364, 
          417,  337,   -1,   58,   59,   -1,  342,  343,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,  304,   -1,   -1,  307,  308, 
          309,   44,   -1,   -1,  360,   -1,   -1,  363,  445,   91, 
           -1,  448,   -1,  450,   59,   -1,   -1,   -1,  262,  263, 
          264,  330,   -1,  267,  268,  269,   -1,  271,  337,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,   -1,  281,  282,   44, 
          349,  350,  351,  352,  544,  545,  290,  291,   91,  293, 
          294,  295,  296,  297,   -1,   -1,   61,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  564,   -1,    0,  304,   -1,   -1, 
          307,  308,  309,   -1,   -1,   -1,   10,   -1,   -1,  579, 
           -1,   -1,  326,  327,   -1,   -1,   91,  331,  332,  526, 
           -1,  279,  280,  330,   -1,   -1,  340,   -1,   -1,  343, 
          337,   -1,  346,   -1,  348,  342,   -1,  607,   -1,   -1, 
           44,   -1,  349,  350,  351,  352,   -1,   -1,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,  632,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  330,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
          650,   -1,   -1,   -1,  342,   -1,  593,   91,   -1,   -1, 
           -1,   -1,  662,   -1,  664,   -1,  666,  667,  668,   -1, 
           -1,   -1,  360,  673,  611,  363,   -1,   -1,  615,   -1, 
           -1,   -1,   -1,  620,   -1,   -1,   -1,  262,  263,  264, 
           -1,    0,  267,  268,  269,  632,  271,  279,  280,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,  711,   -1,   -1,  714,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  726,  727,  728,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  279,  280,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  684,  330,   58, 
           59,   -1,   61,   -1,   63,  337,   -1,  694,   -1,  304, 
          342,   -1,  307,  308,  309,  340,   -1,   -1,  343,   -1, 
           -1,  346,   -1,  348,  279,  775,   -1,   -1,  360,  779, 
          780,  363,   91,   -1,   -1,  330,   -1,  330,  725,  364, 
           -1,   -1,  337,   -1,  337,  732,   -1,  342,   -1,  342, 
          800,  738,   -1,   -1,  349,  350,  351,  352,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   10, 
          363,   -1,   -1,   -1,   -1,  330,   -1,   -1,  262,  263, 
          264,   -1,  337,  833,  268,  269,   -1,  271,  343,   -1, 
          777,   -1,  842,   -1,  844,   -1,   -1,   -1,   -1,   -1, 
           -1,  851,   -1,   44,   -1,  360,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   58,   59,  806, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,  816, 
           -1,   -1,   -1,  820,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           91,  335,  336,  337,   -1,  339,   -1,   -1,   -1,  343, 
           -1,   -1,   -1,   -1,   -1,   -1,  350,  854,  352,  856, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,   -1, 
          364,   -1,   -1,    0,   -1,   -1,   -1,  874,   -1,  876, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,  884,  257,  258, 
          259,  888,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   58,   59,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,  364,   10,  366,  367,  368, 
          369,  370,  371,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   63, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  319,  271,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44,  335, 
          336,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   58,   59,  350,   61,  352,   63,  354,  355, 
          356,  357,  358,  359,  360,   -1,  362,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  343,   -1,  350,  346, 
          352,  348,  354,  355,  356,  357,  358,  359,  360,    0, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,  364,   -1,   10, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,   -1, 
          328,  329,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  350,   44,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,   -1,   -1,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,   -1,  331,  332,   -1, 
           91,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,    0,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   59,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   59,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   63,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
          304,   -1,   -1,  307,  308,  309,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,  330,   -1,   -1,   -1, 
          343,   -1,   -1,  337,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,  350,  351,  352,    0, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  319,  320,  321,  322,  323,  324,  325,   -1,   -1, 
          328,  329,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  350,   44,  352,  297,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  319,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,  335,  336,   -1,   -1,  350,   -1, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,  350, 
          362,  352,   -1,  354,  355,  356,  357,    0,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   59,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   59,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   63,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
          304,   -1,   -1,  307,  308,  309,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,  330,   -1,   -1,   -1, 
          343,   -1,   -1,  337,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,  350,  351,  352,    0, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,   10,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   10, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,  304,   -1,   10,  307,  308,  309,   -1,   -1, 
           -1,   -1,   -1,  304,   -1,   -1,  307,  308,  309,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,   44,  330, 
          342,   -1,   -1,   -1,   -1,   -1,  337,  349,  350,  351, 
          352,  342,   58,   59,   -1,   -1,   -1,   63,  349,  350, 
          351,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   44,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           91,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
           -1,   44,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,   -1,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,   -1,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,   -1,   -1,   10,   -1,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   44,  352, 
           -1,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
           -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   44,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

           -1,   -1,   63,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           91,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   59,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,   -1,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,    0,  364,   -1,  366,  367,  368,  369,  370, 
          371,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   44,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   59,   -1,   61,  299,   63,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
          345,   -1,  347,   -1,   -1,   -1,   -1,    0,  353,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  361,   10,   -1,   -1, 
           -1,  366,  367,  368,  369,  370,  371,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   44,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   59,   -1,   61,   -1, 
           63,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   -1,  316,  317, 
          318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347, 
           -1,   -1,   -1,   58,   -1,  353,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367, 
          368,  369,  370,  371,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   -1,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
          338,   -1,   -1,  341,  342,  343,  344,  345,   -1,  347, 
           -1,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,   -1,  366,  367, 
          368,  369,  370,  371,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,  338,   -1,   -1,  341,  342, 
          343,  344,  345,   -1,  347,   -1,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,  364,    0,  366,  367,  368,  369,  370,  371,   -1, 
           -1,   -1,   10,   -1,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  350,   44,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   -1,   -1, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,  260,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,    0,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   10,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   44,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   91,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  299,   58,   59,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   -1,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
          338,   -1,   -1,  341,  342,  343,  344,  345,   -1,  347, 
           -1,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,   -1,  366,  367, 
          368,  369,  370,  371,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,  338,   -1,   -1,  341,  342, 
          343,  344,  345,   -1,  347,   -1,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,   -1,  366,  367,  368,  369,  370,  371,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,  281,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   59,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  330,   -1,   91,   -1,   -1,   -1, 
           -1,  337,  338,   -1,   -1,  341,   -1,  343,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,  364,   -1, 
          366,  367,  368,  369,  370,  371,   10,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   59,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   10,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
           -1,  316,  317,  318,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,  338,   -1,   -1,  341,  342,   -1,  344, 
          345,   -1,  347,   -1,  349,   -1,   -1,   91,  353,   -1, 
           -1,   -1,   -1,  358,   -1,   -1,  361,   -1,  363,   -1, 
           -1,  366,  367,  368,  369,  370,  371,   -1,   -1,   -1, 
          375,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   10,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,  338,   -1,   -1,  341,  342,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,   -1,   91,  353, 
           -1,   -1,   -1,   -1,  358,   -1,   -1,  361,   -1,  363, 
           -1,   -1,  366,  367,  368,  369,  370,  371,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   10,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,  338,   -1,   -1,  341,  342,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,   -1,   91,  353, 
           -1,   -1,   -1,   -1,  358,   -1,   -1,  361,   -1,  363, 
           -1,   -1,  366,  367,  368,  369,  370,  371,   -1,   -1, 
           -1,  375,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   10,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,  338,   -1,   -1,  341,  342, 
           -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1, 
          353,   -1,   -1,   -1,   -1,  358,   -1,   -1,  361,   -1, 
           -1,   -1,   -1,  366,  367,  368,  369,  370,  371,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   10,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,  338,   -1,   -1,  341,   -1, 
           -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1, 
          353,   -1,   -1,   -1,   -1,  358,   -1,   -1,  361,   -1, 
           -1,   -1,   -1,  366,  367,  368,  369,  370,  371,   -1, 
           -1,   -1,  375,   -1,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   10,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,   -1,  264,  265,  266,   -1,   -1,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   44,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           91,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,    0,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   10,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   44,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1, 
          353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   91, 
           -1,  364,   -1,  366,  367,  368,  369,  370,  371,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  280, 
          281,  282,   -1,   -1,   -1,   44,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   91,   -1,  335,  336,  337,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,  363,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   44,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   91,   -1,  335,  336,  337,   -1,  339,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,    0, 
          362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  280,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,   -1, 
           91,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,   -1,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,  363,  364,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   91,   -1,  335,  336,  337,   -1,   -1, 
          340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,   -1,  354,  355,  356,  357,  358,  359, 
          360,    0,  362,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   44,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   91,   -1,  335,  336,  337,   -1,  339,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   -1,  364,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   91,   -1,  335,  336,  337, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,    0,  362,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   91,   -1,  335,  336,  337,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,   -1,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,   -1,  364,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   91,   -1,  335, 
          336,  337,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,    0,  362,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   91,   -1,  335,  336, 
          337,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,  364,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   91, 
           -1,  335,  336,  337,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,    0,  362,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   91,   -1, 
          335,  336,  337,   -1,   -1,  340,   -1,   -1,  343,   -1, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   -1,  364, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   44,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   91,   -1,  335,  336,  337,   -1,   -1,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,    0, 
          362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           91,   -1,  335,  336,  337,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
           -1,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
           -1,  364,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   91,   -1,  335,  336,  337,   -1,   -1, 
          340,   -1,   -1,  343,   -1,   -1,   -1,   -1,   -1,   -1, 
          350,   -1,  352,   -1,  354,  355,  356,  357,  358,  359, 
          360,    0,  362,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,   -1,   -1,   -1,   -1,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,    0,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,   -1,   -1, 
           -1,   -1,  350,   -1,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,    0,  362,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,   -1,  331,  332,   -1,   -1,  335,  336,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,   -1,  354,  355,  356,  357,  358, 
          359,  360,    0,  362,   -1,  364,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,   -1,  331,  332,   -1,   -1,  335,  336,   -1, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,    0,  362,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,    0,  362,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,   -1,  331,  332,   -1,   -1,  335,  336,   -1, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,    0,  362,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,    0,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,   -1,  331,  332,   91,   -1,  335, 
          336,   -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,    0,  362,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,  331,  332,   91,   -1,  335,  336, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,  364,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   91, 
           -1,  335,  336,  337,   -1,   -1,   -1,   -1,   -1,  343, 
           -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,    0,  362,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,  337,   -1,   -1,   -1,   -1,   -1,  343,   -1, 
           -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,    0,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,  337,   -1,   -1,   -1,   -1, 
           -1,  343,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,    0, 
          362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,   -1,  335,  336,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,  356,  357,  358,  359,  360,    0,  362, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,   -1,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,   -1,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,  356,  357,  358,  359,  360,    0, 
          362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   -1,    0,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   10,   -1,   -1,  358,  359,  360, 
           -1,  362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   44,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   58,   59,   -1,   -1,   -1,   63,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,   -1,  331, 
          332,   -1,   -1,  335,  336,    0,   -1,   -1,  340,   -1, 
           -1,  343,   -1,   -1,  346,   10,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,  358,  359,  360,   -1, 
          362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,    0,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   10,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,  358,  359,  360, 
           -1,  362,   -1,  364,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   58,   59,   -1,  290,  291,   63,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,   -1,  331,  332,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
          346,   10,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  358,  359,  360,   -1,  362,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   44,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   58, 
           59,   -1,   -1,   -1,   63,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  343,   10, 
           -1,  346,   -1,  348,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  358,  359,  360,   -1,  362,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,  331,  332,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   10,   -1,  346, 
           -1,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  358,  359,   -1,   -1,   -1,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   44,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   58,   59,   -1,   -1,   -1, 
           63,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,   -1,  331,  332,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   10,   -1,  346,   -1,  348, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  358, 
          359,   10,   -1,   -1,   -1,  364,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   44, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   58,   59,   44,   -1,   -1,   63,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,    0,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   10,   -1,  346,   -1,  348,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  358,  359,   -1, 
           -1,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   44,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  358,  359,   -1,   58,   59, 
           -1,  364,   -1,   63,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  281,  282,   -1,  268, 
          269,   -1,  271,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,   44,  343,   -1, 
           -1,  346,   -1,  348,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,  343,   -1,   63,   -1,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,  364,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  340,   63,   -1,  343,   -1,   -1,  346, 
           -1,  348,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  364,    0,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,   -1,   -1,   -1,   58,   59,   -1,   -1, 
          340,   63,   -1,  343,   -1,   -1,  346,   -1,  348,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  262,  263,  264,    0,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,  326, 
          327,   63,   -1,   -1,  331,  332,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  262,  263,  264,    0,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   10,  364,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,  326,  327,   63, 
           -1,   -1,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   44,  346,   -1,  348, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           58,   59,   -1,   -1,   -1,  364,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  326,  327,   10,   -1,   -1,  331, 
          332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          262,  263,  264,    0,   -1,  267,  268,  269,   -1,  271, 
           44,   -1,  364,   10,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   58,   59,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,  327,   -1,   -1,   -1,  331, 
          332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,  262,  263, 
          264,    0,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   10,  364,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,  262,  263,  264,    0,   -1,  267, 
          268,  269,   -1,  271,   -1,   44,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   44,  346,   -1,  348,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  364,   -1,  262,  263, 
          264,    0,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  262,  263,  264,   -1,    0, 
          267,  268,  269,   -1,  271,   44,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   44,  348,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  262,  263,  264,    0,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   10,  364,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,  262, 
          263,  264,    0,   -1,  267,  268,  269,   -1,  271,   -1, 
           44,   -1,   10,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   58,   59,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   44,  346,   -1,  348, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,  364,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,  364,   -1,  262,  263,  264,   10,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           44,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   58,   59,    0,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   10,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   10,  364,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   44,   -1, 
           -1,   -1,   -1,  364,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   58,   59,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   10,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   44,   -1,  267,  268,  269,  364,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   10,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  340,  281,  282,  343, 
           -1,   -1,  346,   -1,  348,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,    0,   -1,  262,  263,  264,   -1, 
          364,  267,  268,  269,   10,  271,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,  340,    0,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
          346,   -1,  348,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   58,   59,    0,  364,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  364,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  364,  271,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   10,   -1,   -1,   58,   59,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,    0,  271,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   10,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   58,   59,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,  343,   -1,   -1,  346,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,   -1,   -1,  281,  282, 
           -1,   -1,   58,   59,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  343,   -1,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,   -1, 
          343,   -1,   -1,  346,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  262,  263,  264, 
           -1,  364,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          343,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  343,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  293,  294,  295, 
          296,  297,  343,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  364,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  343,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,  364,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,  375,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,  342,   -1,  344,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,  342,   -1,  344,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
           -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,   -1,   -1,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
           -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,  349,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,   -1,   -1,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
           -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,   -1,   -1,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
           -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,  260, 
          261,  262,  263,  264,   -1,   -1,  267,  268,  269,  270, 
          271,   -1,   -1,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,  305,  306,   -1,  308,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320, 
          321,  322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   -1,   -1,  365,  366,  257,  258,  259,  260, 
          261,  262,  263,  264,   -1,   -1,  267,  268,  269,  270, 
          271,   -1,   -1,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,  305,   -1,   -1,  308,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320, 
          321,  322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   -1,   -1,  365,  366,  257,  258,  259,  260, 
          261,  262,  263,  264,   -1,   -1,  267,  268,  269,  270, 
          271,   -1,   -1,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
           -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320, 
          321,  322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1, 
           -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   -1,   -1,  365,  257,  258,  259,  260,  261, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  270,  271, 
           -1,   -1,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1, 
           -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320,  321, 
          322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,   -1,   -1,  365,  257,  258,  259,  260,  261,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  270,  271,   -1, 
           -1,  274,  275,  276,  277,  278,  279,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,  299,  300,  301,  302, 
          303,  304,  305,   -1,   -1,  308,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  316,  317,   -1,  319,  320,  321,  322, 
           -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
          304,  305,  365,   -1,  308,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  316,  317,   -1,  319,  320,  321,  322,   -1, 
          324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,  304, 
          305,  365,   -1,  308,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  316,  317,   -1,  319,  320,  321,  322,   -1,  324, 
          325,   -1,   -1,  328,   -1,   -1,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,  304,  305, 
          365,   -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          316,  317,   -1,  319,  320,  321,  322,   -1,  324,  325, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,  362,  304,  305,  365, 
           -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,  304,  305,  365,   -1, 
          308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317, 
           -1,  319,  320,  321,  322,   -1,  324,  325,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,  304,  305,  365,   -1,  308, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   -1,  324,  325,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,  304,  305,  365,   -1,  308,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319, 
          320,  321,  322,   -1,  324,  325,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,  304,  305,  365,   -1,  308,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320, 
          321,  322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,  304,  305,  365,   -1,  308,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320,  321, 
          322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,  304,  305,  365,   -1,  308,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  316,  317,   -1,  319,  320,  321,  322, 
           -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
          304,  305,  365,   -1,  308,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  316,  317,   -1,  319,  320,  321,  322,   -1, 
          324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,  304, 
          305,  365,   -1,  308,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  316,  317,   -1,  319,  320,  321,  322,   -1,  324, 
          325,   -1,   -1,  328,   -1,   -1,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   -1,   -1, 
          365, 
      };
   }

}
