/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.core.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.sh.internal.core.parser.FunctionInfo;

public class ShellModuleDeclaration
extends ModuleDeclaration {
    private List<FunctionInfo> functionsInfo = new ArrayList<FunctionInfo>();
    private List<IElementRequestor.FieldInfo> variablesInfo = new ArrayList<IElementRequestor.FieldInfo>();

    public ShellModuleDeclaration(int sourceLength) {
        super(sourceLength);
    }

    public void setFunctions(List<MethodDeclaration> functions) {
        this.getFunctionList().addAll(functions);
        for (MethodDeclaration method : functions) {
            FunctionInfo mInfo = new FunctionInfo();
            mInfo.name = method.getName();
            mInfo.nameSourceStart = method.getNameStart();
            mInfo.nameSourceEnd = method.getNameEnd();
            mInfo.declarationStart = method.sourceStart();
            mInfo.declarationEnd = method.sourceEnd();
            this.functionsInfo.add(mInfo);
        }
    }

    public void setVariables(List<FieldDeclaration> variables) {
        this.getVariablesList().addAll(variables);
        for (FieldDeclaration method : variables) {
            IElementRequestor.FieldInfo vInfo = new IElementRequestor.FieldInfo();
            vInfo.name = method.getName();
            vInfo.nameSourceStart = method.getNameStart();
            vInfo.nameSourceEnd = method.getNameEnd();
            vInfo.declarationStart = method.sourceStart();
            this.variablesInfo.add(vInfo);
        }
    }

    public List<FunctionInfo> getFunctionsInfo() {
        return this.functionsInfo;
    }

    public List<IElementRequestor.FieldInfo> getFieldsInfo() {
        return this.variablesInfo;
    }
}

