/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model.impl;

import java.util.Collection;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelPackage;
import org.eclipse.dltk.javascript.typeinfo.model.impl.SimpleTypeImpl;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ParameterizedTypeImpl
extends SimpleTypeImpl
implements ParameterizedType {
    protected EList<JSType> actualTypeArguments;

    protected ParameterizedTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TypeInfoModelPackage.Literals.PARAMETERIZED_TYPE;
    }

    @Override
    public EList<JSType> getActualTypeArguments() {
        if (this.actualTypeArguments == null) {
            this.actualTypeArguments = new EObjectContainmentEList(JSType.class, (InternalEObject)this, 1);
        }
        return this.actualTypeArguments;
    }

    @Override
    public String getRawName() {
        return super.getName();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getActualTypeArguments()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getActualTypeArguments();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getActualTypeArguments().clear();
                this.getActualTypeArguments().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getActualTypeArguments().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.actualTypeArguments != null && !this.actualTypeArguments.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String getName() {
        if (!this.getActualTypeArguments().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getName());
            sb.append('<');
            boolean first = true;
            for (JSType typeParameter : this.getActualTypeArguments()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                sb.append(typeParameter.getName());
            }
            sb.append('>');
            return sb.toString();
        }
        return super.getName();
    }

    @Override
    public IRType toRType(ITypeSystem typeSystem) {
        Type t = this.getTarget();
        if (t == null) {
            return RTypes.any();
        }
        return RTypes.simple(typeSystem.parameterize(t, RTypes.convert(typeSystem, this.getActualTypeArguments())));
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

