/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.Comparator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public class VariableNameComparator
implements Comparator<IVariable> {
    @Override
    public int compare(IVariable v1, IVariable v2) {
        int result = 0;
        try {
            boolean v2IsInt;
            boolean v1IsInt;
            String v1Str = v1 != null ? v1.getName() : "";
            v1Str = v1Str.replaceAll("\\[", "").replaceAll("\\]", "");
            int v1Int = 0;
            String v2Str = v2 != null ? v2.getName() : "";
            v2Str = v2Str.replaceAll("\\[", "").replaceAll("\\]", "");
            int v2Int = 0;
            try {
                v1Int = Integer.parseInt(v1Str);
                v1IsInt = true;
            }
            catch (NumberFormatException nxcn) {
                v1IsInt = false;
            }
            try {
                v2Int = Integer.parseInt(v2Str);
                v2IsInt = true;
            }
            catch (NumberFormatException nxcn) {
                v2IsInt = false;
            }
            if (v1IsInt != v2IsInt) {
                return v1IsInt ? -1 : 1;
            }
            result = v1IsInt ? (v1Int > v2Int ? 1 : (v1Int < v2Int ? -1 : 0)) : v1Str.compareTo(v2Str);
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return result;
    }
}

