/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.PriorityClassDLTKExtensionManager;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IHotCodeReplaceListener;
import org.eclipse.dltk.debug.core.IHotCodeReplaceProvider;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.internal.debug.core.model.Messages;
import org.eclipse.osgi.util.NLS;

public class HotCodeReplaceManager
implements IResourceChangeListener,
ILaunchListener,
IDebugEventSetListener {
    private static final String HOT_CODE_REPLACE_PROVIDER_EXTENSION = "org.eclipse.dltk.debug.hotCodeReplaceProvider";
    private static PriorityClassDLTKExtensionManager providerManager = new PriorityClassDLTKExtensionManager("org.eclipse.dltk.debug.hotCodeReplaceProvider", "nature");
    private static HotCodeReplaceManager instance = null;
    private ArrayList fHotSwapTargets = new ArrayList();
    private ArrayList fNoHotSwapTargets = new ArrayList();
    private ListenerList fHotCodeReplaceListeners = new ListenerList();

    public static synchronized HotCodeReplaceManager getDefault() {
        if (instance == null) {
            instance = new HotCodeReplaceManager();
        }
        return instance;
    }

    private HotCodeReplaceManager() {
    }

    public void startup() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
    }

    public void addHotCodeReplaceListener(IHotCodeReplaceListener listener) {
        this.fHotCodeReplaceListeners.add((Object)listener);
    }

    public void removeHotCodeReplaceListener(IHotCodeReplaceListener listener) {
        this.fHotCodeReplaceListeners.remove((Object)listener);
    }

    private void fireHCRSucceeded(IScriptDebugTarget target) {
        Object[] listeners = this.fHotCodeReplaceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IHotCodeReplaceListener)listeners[i]).hotCodeReplaceSucceeded(target);
            ++i;
        }
    }

    private void fireHCRFailed(IScriptDebugTarget target, DebugException exception) {
        Object[] listeners = this.fHotCodeReplaceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IHotCodeReplaceListener)listeners[i]).hotCodeReplaceFailed(target, exception);
            ++i;
        }
    }

    public void launchAdded(ILaunch launch) {
        IDebugTarget[] debugTargets = launch.getDebugTargets();
        int i = 0;
        while (i < debugTargets.length) {
            IScriptDebugTarget target = (IScriptDebugTarget)debugTargets[i].getAdapter(IScriptDebugTarget.class);
            if (target != null) {
                if (this.supportsHotCodeReplace(target)) {
                    this.addHotSwapTarget(target);
                } else {
                    this.addNonHotSwapTarget(target);
                }
            }
            ++i;
        }
    }

    public boolean supportsHotCodeReplace(IScriptDebugTarget target) {
        IDLTKLanguageToolkit toolkit = target.getLanguageToolkit();
        return toolkit != null && this.getHotCodeReplaceProvider(toolkit.getNatureId()) != null;
    }

    public void launchChanged(ILaunch launch) {
        this.launchAdded(launch);
    }

    public void launchRemoved(ILaunch launch) {
        IDebugTarget[] debugTargets = launch.getDebugTargets();
        int i = 0;
        while (i < debugTargets.length) {
            IScriptDebugTarget target = (IScriptDebugTarget)debugTargets[i].getAdapter(IScriptDebugTarget.class);
            if (target != null) {
                this.deregisterTarget(target);
            }
            ++i;
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IScriptDebugTarget target;
            Object source;
            DebugEvent event = events[i];
            if (event.getKind() == 8 && (source = event.getSource()) instanceof IAdaptable && source instanceof IDebugTarget && (target = (IScriptDebugTarget)((IAdaptable)source).getAdapter(IScriptDebugTarget.class)) != null) {
                this.deregisterTarget(target);
            }
            ++i;
        }
    }

    private void addHotSwapTarget(IScriptDebugTarget target) {
        if (!this.fHotSwapTargets.contains(target)) {
            this.fHotSwapTargets.add(target);
        }
    }

    private void addNonHotSwapTarget(IScriptDebugTarget target) {
        if (!this.fNoHotSwapTargets.contains(target)) {
            this.fNoHotSwapTargets.add(target);
        }
    }

    private void deregisterTarget(IScriptDebugTarget target) {
        if (!this.fHotSwapTargets.remove(target)) {
            this.fNoHotSwapTargets.remove(target);
        }
    }

    private IScriptDebugTarget[] getHotSwapTargets() {
        return this.fHotSwapTargets.toArray(new IScriptDebugTarget[this.fHotSwapTargets.size()]);
    }

    private IScriptDebugTarget[] getNoHotSwapTargets() {
        return this.fNoHotSwapTargets.toArray(new IScriptDebugTarget[this.fNoHotSwapTargets.size()]);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fHotSwapTargets.isEmpty() && this.fNoHotSwapTargets.isEmpty()) {
            return;
        }
        IResource[] resources = this.getChangedFiles(event);
        if (resources.length != 0) {
            this.notifyTargets(resources);
        }
    }

    private void notifyTargets(IResource[] resources) {
        Runnable runnable;
        IScriptDebugTarget[] hotSwapTargets = this.getHotSwapTargets();
        IScriptDebugTarget[] noHotSwapTargets = this.getNoHotSwapTargets();
        if (hotSwapTargets.length != 0) {
            runnable = () -> this.doHotCodeReplace(hotSwapTargets, resources);
            DebugPlugin.getDefault().asyncExec(runnable);
        }
        if (noHotSwapTargets.length != 0) {
            runnable = () -> this.notifyUnsupportedHCR(noHotSwapTargets, resources);
            DebugPlugin.getDefault().asyncExec(runnable);
        }
    }

    protected void notifyUnsupportedHCR(IScriptDebugTarget[] noHotSwapTargets, IResource[] resources) {
        int i = 0;
        while (i < noHotSwapTargets.length) {
            IScriptDebugTarget target = noHotSwapTargets[i];
            this.fireHCRFailed(target, null);
            ++i;
        }
    }

    protected void doHotCodeReplace(IScriptDebugTarget[] hotSwapTargets, IResource[] resources) {
        int i = 0;
        while (i < hotSwapTargets.length) {
            IScriptDebugTarget target = hotSwapTargets[i];
            String natureId = target.getLanguageToolkit().getNatureId();
            IHotCodeReplaceProvider provider = this.getHotCodeReplaceProvider(natureId);
            try {
                if (provider != null) {
                    provider.performCodeReplace(target, resources);
                    this.fireHCRSucceeded(target);
                } else {
                    this.fail(NLS.bind((String)Messages.HotCodeReplaceManager_hotCodeReplaceProviderForNotFound, (Object)natureId));
                }
            }
            catch (DebugException e) {
                this.fireHCRFailed(target, e);
            }
            ++i;
        }
    }

    private void fail(String message) throws DebugException {
        this.fail(message, null);
    }

    private void fail(String message, Throwable e) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.dltk.debug", 120, message, e));
    }

    private IHotCodeReplaceProvider getHotCodeReplaceProvider(String natureId) {
        return (IHotCodeReplaceProvider)providerManager.getObject(natureId);
    }

    private IResource[] getChangedFiles(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (event.getType() != 16 || delta == null) {
            return null;
        }
        ChangedFilesVisitor changedFilesVisitor = new ChangedFilesVisitor();
        try {
            delta.accept((IResourceDeltaVisitor)changedFilesVisitor);
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
            return new IResource[0];
        }
        return changedFilesVisitor.getChangedFiles();
    }

    class ChangedFilesVisitor
    implements IResourceDeltaVisitor {
        protected ArrayList fFiles = new ArrayList();

        ChangedFilesVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || (delta.getKind() & 4) == 0) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource != null) {
                switch (resource.getType()) {
                    case 1: {
                        if ((delta.getFlags() & 0x100) == 0) {
                            return false;
                        }
                        this.fFiles.add(resource);
                        return false;
                    }
                }
                return true;
            }
            return true;
        }

        public IResource[] getChangedFiles() {
            return this.fFiles.toArray(new IResource[this.fFiles.size()]);
        }
    }
}

