/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.ruby.testing.internal.Messages;
import org.eclipse.dltk.ruby.testing.internal.RubyTestingPlugin;
import org.eclipse.dltk.testing.AbstractTestingEngine;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public abstract class AbstractRubyTestingEngine
extends AbstractTestingEngine {
    protected static final String RUBY_TESTING_PORT = "RUBY_TESTING_PORT";
    protected static final String RUBY_TESTING_PATH = "RUBY_TESTING_PATH";
    protected static final String RUNNER_PATH = "/testing/";

    protected Bundle getBundle() {
        return RubyTestingPlugin.getDefault().getBundle();
    }

    protected File getRunnerFile(Bundle bundle, String runnerPath, String runnerName) throws CoreException {
        URL runnerScript = bundle.getEntry(String.valueOf(runnerPath) + runnerName);
        if (runnerScript == null) {
            String msg = NLS.bind((String)Messages.Delegate_runnerNotFound, (Object)runnerName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ruby.testing", msg, null));
        }
        try {
            return Util.toFile((URL)runnerScript);
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.Delegate_errorExtractingRunner, (Object)runnerName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ruby.testing", msg, (Throwable)e));
        }
    }

    protected boolean isDevelopmentMode(InterpreterConfig config, String runnerName) {
        return config.getScriptFilePath() != null && config.getScriptFilePath().lastSegment().equals(runnerName);
    }

    private static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    protected int allocatePort() throws CoreException {
        int port = AbstractRubyTestingEngine.findFreePort();
        if (port == -1) {
            this.informAndAbort("No socket available", null, 110);
        }
        return port;
    }

    protected void informAndAbort(String message, Throwable exception, int code) throws CoreException {
        Status status = new Status(1, "org.eclipse.dltk.ruby.testing", code, message, exception);
        if (this.showStatusMessage((IStatus)status)) {
            throw new CoreException((IStatus)status);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ruby.testing", code, message, exception));
    }

    protected boolean showStatusMessage(final IStatus status) {
        final boolean[] success = new boolean[1];
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = DLTKTestingPlugin.getActiveWorkbenchShell();
                if (shell == null) {
                    shell = AbstractRubyTestingEngine.this.getDisplay().getActiveShell();
                }
                if (shell != null) {
                    MessageDialog.openInformation((Shell)shell, (String)"Problems Launching Unit Tests", (String)status.getMessage());
                    success[0] = true;
                }
            }
        });
        return success[0];
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected static IStatus createStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.dltk.ruby.testing", message);
    }
}

