/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.launching.InterpreterContainerInitializer;
import org.eclipse.dltk.internal.launching.InterpreterDefinitionsContainer;
import org.eclipse.dltk.internal.launching.execution.DeploymentManager;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry2;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.utils.DLTKLoggingOption;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

public class DLTKLaunchingPlugin
extends Plugin
implements Preferences.IPropertyChangeListener,
IInterpreterInstallChangedListener {
    public static final String PLUGIN_ID = "org.eclipse.dltk.launching";
    public static final String ID_EXTENSION_POINT_RUNTIME_BUILDPATH_ENTRIES = "runtimeBuildpathEntries";
    public static final String LAUNCH_COMMAND_LINE = "org.eclipse.dltk.launching.LAUNCH_COMMAND_LINE";
    public static final boolean TRACE_EXECUTION = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.launching/traceExecution"));
    public static final DLTKLoggingOption LOGGING_CATCH_OUTPUT = new DLTKLoggingOption("org.eclipse.dltk.launching", "catchOutput");
    private HashMap<String, IConfigurationElement> fBuildpathEntryExtensions = null;
    private String fOldInterpreterPrefString = "";
    private static final String EMPTY_STRING = "";
    private boolean fIgnoreInterpreterDefPropertyChangeEvents = false;
    private boolean fBatchingChanges = false;
    private static DocumentBuilder fgXMLParser = null;
    private static DLTKLaunchingPlugin fgLaunchingPlugin;

    public DLTKLaunchingPlugin() {
        fgLaunchingPlugin = this;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static DLTKLaunchingPlugin getDefault() {
        return fgLaunchingPlugin;
    }

    public static void log(IStatus status) {
        DLTKLaunchingPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        DLTKLaunchingPlugin.log((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void logWarning(String message) {
        DLTKLaunchingPlugin.log((IStatus)new Status(2, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void logWarning(Throwable t) {
        DLTKLaunchingPlugin.log((IStatus)new Status(2, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, t.getMessage(), t));
    }

    public static void logWarning(String message, Throwable t) {
        DLTKLaunchingPlugin.log((IStatus)new Status(2, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, message, t));
    }

    public static void log(Throwable e) {
        DLTKLaunchingPlugin.log((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static void log(String message, Throwable e) {
        DLTKLaunchingPlugin.log((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, message, e));
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static String serializeDocument(Document doc) throws IOException, TransformerException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static DocumentBuilder getParser() throws CoreException {
        if (fgXMLParser == null) {
            try {
                fgXMLParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                fgXMLParser.setErrorHandler(new DefaultHandler());
            }
            catch (ParserConfigurationException e) {
                DLTKLaunchingPlugin.abort(LaunchingMessages.LaunchingPlugin_33, e);
            }
            catch (FactoryConfigurationError e) {
                DLTKLaunchingPlugin.abort(LaunchingMessages.LaunchingPlugin_34, e);
            }
        }
        return fgXMLParser;
    }

    protected static void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 0, message, exception);
        throw new CoreException((IStatus)status);
    }

    public IRuntimeBuildpathEntry2 newRuntimeBuildpathEntry(String id) throws CoreException {
        IConfigurationElement config;
        if (this.fBuildpathEntryExtensions == null) {
            this.initializeRuntimeBuildpathExtensions();
        }
        if ((config = this.fBuildpathEntryExtensions.get(id)) == null) {
            DLTKLaunchingPlugin.abort(MessageFormat.format((String)LaunchingMessages.LaunchingPlugin_32, (Object[])new Object[]{id}), null);
        }
        return (IRuntimeBuildpathEntry2)config.createExecutableExtension("class");
    }

    private void initializeRuntimeBuildpathExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, ID_EXTENSION_POINT_RUNTIME_BUILDPATH_ENTRIES);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        this.fBuildpathEntryExtensions = new HashMap(configs.length);
        int i = 0;
        while (i < configs.length) {
            this.fBuildpathEntryExtensions.put(configs[i].getAttribute("id"), configs[i]);
            ++i;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        String launchFilter = "*.launch";
        Hashtable optionsMap = DLTKCore.getOptions();
        String filters = (String)optionsMap.get("org.eclipse.dltk.core.builder.resourceCopyExclusionFilter");
        boolean modified = false;
        if (filters == null || filters.length() == 0) {
            filters = launchFilter;
            modified = true;
        } else if (filters.indexOf(launchFilter) == -1) {
            filters = String.valueOf(filters) + ',' + launchFilter;
            modified = true;
        }
        if (modified) {
            optionsMap.put("org.eclipse.dltk.core.builder.resourceCopyExclusionFilter", filters);
            DLTKCore.setOptions((Hashtable)optionsMap);
        }
        this.getPluginPreferences().setDefault(ScriptRuntime.PREF_CONNECT_TIMEOUT, 20000);
        this.getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        ScriptRuntime.addInterpreterInstallChangedListener(this);
        DeploymentManager.getInstance().startup();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            DeploymentManager.getInstance().shutdown();
            this.getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            ScriptRuntime.removeInterpreterInstallChangedListener(this);
            ScriptRuntime.saveInterpreterConfiguration();
            this.savePluginPreferences();
            fgXMLParser = null;
        }
        finally {
            super.stop(context);
        }
    }

    public void setIgnoreInterpreterDefPropertyChangeEvents(boolean ignore) {
        this.fIgnoreInterpreterDefPropertyChangeEvents = ignore;
    }

    public boolean isIgnoreInterpreterDefPropertyChangeEvents() {
        return this.fIgnoreInterpreterDefPropertyChangeEvents;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(ScriptRuntime.PREF_CONNECT_TIMEOUT)) {
            this.savePluginPreferences();
        } else if (property.equals(ScriptRuntime.PREF_INTERPRETER_XML) && !this.isIgnoreInterpreterDefPropertyChangeEvents()) {
            this.processInterpreterPrefsChanged((String)event.getOldValue(), (String)event.getNewValue());
        }
    }

    protected void processInterpreterPrefsChanged(String oldValue, String newValue) {
        InterpreterChanges InterpreterChanges2;
        block19: {
            block20: {
                this.fBatchingChanges = true;
                InterpreterChanges2 = null;
                if (newValue != null && !newValue.equals(EMPTY_STRING)) break block19;
                this.fOldInterpreterPrefString = oldValue;
                this.fBatchingChanges = false;
                if (InterpreterChanges2 == null) break block20;
                ScriptRuntime.removeInterpreterInstallChangedListener(InterpreterChanges2);
                try {
                    InterpreterChanges2.process();
                }
                catch (CoreException e) {
                    DLTKLaunchingPlugin.log(e);
                }
            }
            return;
        }
        try {
            String newPrefString;
            String oldPrefString;
            if (oldValue == null || oldValue.equals(EMPTY_STRING)) {
                oldPrefString = this.fOldInterpreterPrefString;
                newPrefString = newValue;
            } else {
                oldPrefString = oldValue;
                newPrefString = newValue;
            }
            InterpreterChanges2 = new InterpreterChanges();
            ScriptRuntime.addInterpreterInstallChangedListener(InterpreterChanges2);
            InterpreterDefinitionsContainer oldResults = this.getInterpreterDefinitions(oldPrefString);
            InterpreterDefinitionsContainer newResults = this.getInterpreterDefinitions(newPrefString);
            List<IInterpreterInstall> deleted = oldResults.getInterpreterList();
            List<IInterpreterInstall> current = newResults.getValidInterpreterList();
            deleted.removeAll(current);
            for (InterpreterStandin interpreterStandin : deleted) {
                interpreterStandin.getInterpreterInstallType().disposeInterpreterInstall(interpreterStandin.getId());
            }
            for (InterpreterStandin interpreterStandin : current) {
                interpreterStandin.convertToRealInterpreter();
            }
            String[] stringArray = newResults.getDefaultInterpreterInstallCompositeID();
            int i = 0;
            while (i < stringArray.length) {
                IInterpreterInstall newDefaultInterpreter;
                if (stringArray[i] != null && (newDefaultInterpreter = ScriptRuntime.getInterpreterFromCompositeId(stringArray[i])) != null) {
                    try {
                        ScriptRuntime.setDefaultInterpreterInstall(newDefaultInterpreter, null, false);
                    }
                    catch (CoreException ce) {
                        DLTKLaunchingPlugin.log(ce);
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            this.fBatchingChanges = false;
            if (InterpreterChanges2 != null) {
                ScriptRuntime.removeInterpreterInstallChangedListener(InterpreterChanges2);
                try {
                    InterpreterChanges2.process();
                }
                catch (CoreException e) {
                    DLTKLaunchingPlugin.log(e);
                }
            }
            throw throwable;
        }
        this.fBatchingChanges = false;
        if (InterpreterChanges2 != null) {
            ScriptRuntime.removeInterpreterInstallChangedListener(InterpreterChanges2);
            try {
                InterpreterChanges2.process();
            }
            catch (CoreException e) {
                DLTKLaunchingPlugin.log(e);
            }
        }
    }

    private InterpreterDefinitionsContainer getInterpreterDefinitions(String xml) {
        if (xml.length() > 0) {
            try {
                StringReader stream = new StringReader(xml);
                return InterpreterDefinitionsContainer.parseXMLIntoContainer(stream);
            }
            catch (IOException e) {
                DLTKLaunchingPlugin.log(e);
            }
        }
        return new InterpreterDefinitionsContainer();
    }

    @Override
    public void defaultInterpreterInstallChanged(IInterpreterInstall previous, IInterpreterInstall current) {
        if (!this.fBatchingChanges) {
            try {
                InterpreterChanges changes = new InterpreterChanges();
                changes.defaultInterpreterInstallChanged(previous, current);
                changes.process();
            }
            catch (CoreException e) {
                DLTKLaunchingPlugin.log(e);
            }
        }
    }

    @Override
    public void interpreterAdded(IInterpreterInstall Interpreter) {
    }

    @Override
    public void interpreterChanged(PropertyChangeEvent event) {
        if (!this.fBatchingChanges) {
            try {
                InterpreterChanges changes = new InterpreterChanges();
                changes.interpreterChanged(event);
                changes.process();
            }
            catch (CoreException e) {
                DLTKLaunchingPlugin.log(e);
            }
        }
    }

    @Override
    public void interpreterRemoved(IInterpreterInstall Interpreter) {
        if (!this.fBatchingChanges) {
            try {
                InterpreterChanges changes = new InterpreterChanges();
                changes.interpreterRemoved(Interpreter);
                changes.process();
            }
            catch (CoreException e) {
                DLTKLaunchingPlugin.log(e);
            }
        }
    }

    public void rebind(IProgressMonitor monitor, IScriptProject[] projects, Map renamedContainerIds) throws CoreException {
        monitor.worked(1);
        int i = 0;
        while (i < projects.length) {
            IScriptProject project = projects[i];
            IBuildpathEntry[] entries = project.getRawBuildpath();
            boolean replace = false;
            int j = 0;
            while (j < entries.length) {
                IBuildpathEntry entry = entries[j];
                switch (entry.getEntryKind()) {
                    case 5: {
                        IBuildpathEntry newEntry;
                        IPath renamed;
                        IPath reference = entry.getPath();
                        IPath newBinding = null;
                        String firstSegment = reference.segment(0);
                        if (!ScriptRuntime.INTERPRETER_CONTAINER.equals(firstSegment)) break;
                        if (reference.segmentCount() > 1 && (renamed = (IPath)renamedContainerIds.get(reference)) != null) {
                            newBinding = renamed;
                        }
                        InterpreterContainerInitializer initializer = new InterpreterContainerInitializer();
                        if (newBinding == null) {
                            initializer.initialize(reference, project);
                            break;
                        }
                        entries[j] = newEntry = DLTKCore.newContainerEntry((IPath)newBinding, (boolean)entry.isExported());
                        replace = true;
                        break;
                    }
                }
                ++j;
            }
            if (replace) {
                project.setRawBuildpath(entries, null);
            }
            monitor.worked(1);
            ++i;
        }
    }

    class InterpreterChanges
    implements IInterpreterInstallChangedListener {
        private HashMap<IPath, IPath> fRenamedContainerIds = new HashMap();

        InterpreterChanges() {
        }

        @Override
        public void defaultInterpreterInstallChanged(IInterpreterInstall previous, IInterpreterInstall current) {
        }

        @Override
        public void interpreterAdded(IInterpreterInstall Interpreter) {
        }

        @Override
        public void interpreterChanged(PropertyChangeEvent event) {
            String property = event.getProperty();
            IInterpreterInstall Interpreter = (IInterpreterInstall)event.getSource();
            if (property.equals(IInterpreterInstallChangedListener.PROPERTY_NAME)) {
                IPath newId = ScriptRuntime.newInterpreterContainerPath(Interpreter);
                String oldName = (String)event.getOldValue();
                String oldTypeId = Interpreter.getInterpreterInstallType().getId();
                IPath oldId = ScriptRuntime.newInterpreterContainerPath(oldTypeId, oldName);
                if (oldId != null) {
                    this.fRenamedContainerIds.put(oldId, newId);
                }
            }
        }

        @Override
        public void interpreterRemoved(IInterpreterInstall Interpreter) {
        }

        public void process() throws CoreException {
            InterpreterUpdateJob job = new InterpreterUpdateJob(this);
            job.schedule();
        }

        protected void doit(IProgressMonitor monitor) throws CoreException {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor1) throws CoreException {
                    IScriptProject[] projects = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects();
                    monitor1.beginTask(LaunchingMessages.LaunchingPlugin_0, projects.length + 1);
                    DLTKLaunchingPlugin.this.rebind(monitor1, projects, InterpreterChanges.this.fRenamedContainerIds);
                    monitor1.done();
                }
            };
            DLTKCore.run((IWorkspaceRunnable)runnable, null, (IProgressMonitor)monitor);
        }
    }

    class InterpreterUpdateJob
    extends Job {
        private InterpreterChanges fChanges;

        public InterpreterUpdateJob(InterpreterChanges changes) {
            super(LaunchingMessages.LaunchingPlugin_1);
            this.fChanges = changes;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.fChanges.doit(monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

