/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.search.matching.PossibleMatch;

public class PossibleMatchSet {
    private Map<IPath, List<PossibleMatch>> rootsToMatches = new HashMap<IPath, List<PossibleMatch>>(5);
    private int elementCount = 0;

    public void add(PossibleMatch possibleMatch) {
        IPath path = possibleMatch.openable.getProjectFragment().getPath();
        List<PossibleMatch> possibleMatches = this.rootsToMatches.get(path);
        if (possibleMatches != null) {
            if (possibleMatches.contains(possibleMatch)) {
                return;
            }
        } else {
            possibleMatches = new ArrayList<PossibleMatch>();
            this.rootsToMatches.put(path, possibleMatches);
        }
        possibleMatches.add(possibleMatch);
        ++this.elementCount;
    }

    public PossibleMatch[] getPossibleMatches(IProjectFragment[] roots) {
        PossibleMatch[] result = new PossibleMatch[this.elementCount];
        int index = 0;
        int i = 0;
        int length = roots.length;
        while (i < length) {
            List<PossibleMatch> possibleMatches = this.rootsToMatches.get(roots[i].getPath());
            if (possibleMatches != null) {
                int j = 0;
                int size = possibleMatches.size();
                while (j < size) {
                    result[index++] = possibleMatches.get(j);
                    ++j;
                }
            }
            ++i;
        }
        if (index < this.elementCount) {
            PossibleMatch[] possibleMatchArray = result;
            result = new PossibleMatch[index];
            System.arraycopy(possibleMatchArray, 0, result, 0, index);
        }
        return result;
    }

    public void reset() {
        this.rootsToMatches.clear();
        this.elementCount = 0;
    }
}

