/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;

public class BPUserLibraryElement {
    private String fName;
    private List fChildren;
    private boolean fIsSystemLibrary;
    private Map<String, String> fAttributes;

    public BPUserLibraryElement(String name, IBuildpathContainer container, IScriptProject project) {
        this(name, container, project, null);
    }

    public BPUserLibraryElement(String name, IBuildpathContainer container, IScriptProject project, Map<String, String> attributes) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (container != null) {
            IBuildpathEntry[] entries = container.getBuildpathEntries();
            BPListElement[] res = new BPListElement[entries.length];
            int i = 0;
            while (i < res.length) {
                IBuildpathEntry curr = entries[i];
                BPListElement elem = BPListElement.createFromExisting(this, curr, project);
                this.fChildren.add(elem);
                ++i;
            }
            this.fIsSystemLibrary = container.getKind() == 2;
        } else {
            this.fIsSystemLibrary = false;
        }
        this.fAttributes = attributes;
    }

    public BPUserLibraryElement(String name, boolean isSystemLibrary, BPListElement[] children) {
        this(name, isSystemLibrary, children, null);
    }

    public BPUserLibraryElement(String name, boolean isSystemLibrary, BPListElement[] children, Map<String, String> attributes) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.fChildren.add(children[i]);
                ++i;
            }
        }
        this.fIsSystemLibrary = isSystemLibrary;
        this.fAttributes = attributes;
    }

    public BPListElement[] getChildren() {
        return this.fChildren.toArray(new BPListElement[this.fChildren.size()]);
    }

    public String getName() {
        return this.fName;
    }

    public IPath getPath() {
        return new Path("org.eclipse.dltk.USER_LIBRARY").append(this.fName);
    }

    public boolean isSystemLibrary() {
        return this.fIsSystemLibrary;
    }

    public String getAttribute(String name) {
        if (this.fAttributes == null) {
            return null;
        }
        return this.fAttributes.get(name);
    }

    public void add(BPListElement element) {
        if (!this.fChildren.contains(element)) {
            this.fChildren.add(element);
        }
    }

    private List moveUp(List elements, List move) {
        int nElements = elements.size();
        ArrayList res = new ArrayList(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            Object curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    public void moveUp(List toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.fChildren = this.moveUp(this.fChildren, toMoveUp);
        }
    }

    public void moveDown(List toMoveDown) {
        if (toMoveDown.size() > 0) {
            Collections.reverse(this.fChildren);
            this.fChildren = this.moveUp(this.fChildren, toMoveDown);
            Collections.reverse(this.fChildren);
        }
    }

    public void remove(BPListElement element) {
        this.fChildren.remove(element);
    }

    public void replace(BPListElement existingElement, BPListElement element) {
        if (this.fChildren.contains(element)) {
            this.fChildren.remove(existingElement);
        } else {
            int index = this.fChildren.indexOf(existingElement);
            if (index != -1) {
                this.fChildren.set(index, element);
            } else {
                this.fChildren.add(element);
            }
            this.copyAttribute(existingElement, element, "accessrules");
        }
    }

    private void copyAttribute(BPListElement source, BPListElement target, String attributeName) {
        Object value = source.getAttribute(attributeName);
        if (value != null) {
            target.setAttribute(attributeName, value);
        }
    }

    public IBuildpathContainer getUpdatedContainer() {
        return new UpdatedBuildpathContainer();
    }

    public boolean hasChanges(IBuildpathContainer oldContainer, IScriptProject project) {
        if (oldContainer == null || oldContainer.getKind() == 2 != this.fIsSystemLibrary) {
            return true;
        }
        IBuildpathEntry[] oldEntries = oldContainer.getBuildpathEntries();
        if (this.fChildren.size() != oldEntries.length) {
            return true;
        }
        int i = 0;
        while (i < oldEntries.length) {
            BPListElement child = (BPListElement)this.fChildren.get(i);
            if (!child.getBuildpathEntry().equals(oldEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class UpdatedBuildpathContainer
    implements IBuildpathContainer {
        private UpdatedBuildpathContainer() {
        }

        public IBuildpathEntry[] getBuildpathEntries() {
            BPListElement[] children = BPUserLibraryElement.this.getChildren();
            IBuildpathEntry[] entries = new IBuildpathEntry[children.length];
            int i = 0;
            while (i < entries.length) {
                entries[i] = children[i].getBuildpathEntry();
                ++i;
            }
            return entries;
        }

        public String getDescription() {
            return BPUserLibraryElement.this.getName();
        }

        public int getKind() {
            return BPUserLibraryElement.this.isSystemLibrary() ? 2 : 1;
        }

        public IPath getPath() {
            return BPUserLibraryElement.this.getPath();
        }
    }
}

