/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.manipulation.IRefactoringEngine;
import org.eclipse.dltk.core.manipulation.RefactoringEngineManager;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ModelTextSelection;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;

public class RenameModelElementAction
extends SelectionDispatchAction {
    private ScriptEditor fEditor;

    public RenameModelElementAction(IWorkbenchSite site) {
        super(site);
    }

    public RenameModelElementAction(ScriptEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn((IEditorPart)this.fEditor));
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            if (selection.size() == 1) {
                this.setEnabled(RenameModelElementAction.canEnable(selection));
                return;
            }
        }
        catch (ModelException e) {
            if (ScriptModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                DLTKUIPlugin.log(e);
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
        }
        this.setEnabled(false);
    }

    private static boolean canEnable(IStructuredSelection selection) throws CoreException {
        IModelElement element = RenameModelElementAction.getModelElement(selection);
        if (element == null) {
            return false;
        }
        return RenameModelElementAction.isRenameAvailable(element);
    }

    private static IModelElement getModelElement(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IModelElement)) {
            return null;
        }
        return (IModelElement)first;
    }

    @Override
    public void run(IStructuredSelection selection) {
        IModelElement element = RenameModelElementAction.getModelElement(selection);
        if (element == null) {
            return;
        }
        try {
            this.run(element);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.RenameScriptElementAction_name, RefactoringMessages.RenameScriptElementAction_exception);
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        block5: {
            if (selection instanceof ModelTextSelection) {
                try {
                    IModelElement[] elements = ((ModelTextSelection)selection).resolveElementAtOffset();
                    if (elements.length == 1) {
                        this.setEnabled(RenameModelElementAction.isRenameAvailable(elements[0]));
                        break block5;
                    }
                    this.setEnabled(false);
                }
                catch (CoreException coreException) {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(true);
            }
        }
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            IModelElement element = this.getScriptElement();
            if (element != null && RenameModelElementAction.isRenameAvailable(element)) {
                this.run(element);
                return;
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.RenameScriptElementAction_name, RefactoringMessages.RenameScriptElementAction_exception);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameScriptElementAction_name, (String)RefactoringMessages.RenameScriptElementAction_not_available);
    }

    public boolean canRun() {
        IModelElement element;
        block5: {
            element = this.getScriptElement();
            if (element != null) break block5;
            return false;
        }
        try {
            return RenameModelElementAction.isRenameAvailable(element);
        }
        catch (ModelException e) {
            if (ScriptModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                DLTKUIPlugin.log(e);
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
        }
        return false;
    }

    private IModelElement getScriptElement() throws ModelException {
        IModelElement[] elements = SelectionConverter.codeResolve((IEditorPart)this.fEditor);
        if (elements == null || elements.length != 1) {
            return null;
        }
        return elements[0];
    }

    private void run(IModelElement element) throws CoreException {
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        if (ActionUtil.mustDisableScriptModelAction(this.getShell(), element)) {
            return;
        }
        RefactoringExecutionStarter.startRenameRefactoring(element, this.getShell());
    }

    private static boolean isRenameAvailable(IModelElement element) throws CoreException {
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add other kind of rename refactoring support...");
        }
        switch (element.getElementType()) {
            case 2: {
                return RefactoringAvailabilityTester.isRenameAvailable((IScriptProject)element);
            }
            case 3: {
                return RefactoringAvailabilityTester.isRenameAvailable((IProjectFragment)element);
            }
            case 4: {
                return RefactoringAvailabilityTester.isRenameAvailable((IScriptFolder)element);
            }
            case 5: {
                return RefactoringAvailabilityTester.isRenameAvailable((ISourceModule)element);
            }
        }
        IRefactoringEngine engine = RefactoringEngineManager.getInstance().findRefactoringEngine(element);
        if (engine != null) {
            return engine.isRenameAvailable(element);
        }
        return false;
    }
}

