/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.ui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.dltk.validators.internal.externalchecker.core.Rule;
import org.eclipse.dltk.validators.internal.externalchecker.ui.IRulesListViewer;
import org.eclipse.dltk.validators.internal.externalchecker.ui.Messages;

public class RulesList {
    private Vector rules = new Vector();
    private Set changeListeners = new HashSet();
    private String[] types = new String[]{Messages.RulesList_error, Messages.RulesList_warning};

    public void addRule() {
        Rule r = new Rule("%f:%n:%m", Messages.RulesList_error);
        this.rules.add(r);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRulesListViewer)iterator.next()).addRule(r);
        }
    }

    public void removeChangeListener(IRulesListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IRulesListViewer viewer) {
        this.changeListeners.add(viewer);
    }

    public Vector getRules() {
        return this.rules;
    }

    public void ruleChanged(Rule r) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRulesListViewer)iterator.next()).updateRule(r);
        }
    }

    public void addRule(Rule r) {
        this.rules.add(r);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRulesListViewer)iterator.next()).addRule(r);
        }
    }

    public void removeRule(Rule task) {
        this.rules.remove(task);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRulesListViewer)iterator.next()).removeRule(task);
        }
    }

    public String[] getTypes() {
        return this.types;
    }
}

