/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class ScriptStreamProxy
implements IScriptStreamProxy {
    private IOConsoleInputStream input;
    private IOConsoleOutputStream stdOut;
    private IOConsoleOutputStream stdErr;
    private boolean closed = false;
    private boolean needsEncoding = false;
    private String encoding = null;

    public ScriptStreamProxy(IOConsole console) {
        this.input = console.getInputStream();
        this.stdOut = console.newOutputStream();
        this.stdErr = console.newOutputStream();
        final IPreferenceStore debugUIStore = DebugUIPlugin.getDefault().getPreferenceStore();
        this.stdOut.setActivateOnWrite(debugUIStore.getBoolean("DEBUG.consoleOpenOnOut"));
        this.stdErr.setActivateOnWrite(debugUIStore.getBoolean("DEBUG.consoleOpenOnErr"));
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DLTKDebugUIPlugin colors = DLTKDebugUIPlugin.getDefault();
                ScriptStreamProxy.this.stdOut.setColor(colors.getColor(PreferenceConverter.getColor((IPreferenceStore)debugUIStore, (String)"org.eclipse.debug.ui.outColor")));
                ScriptStreamProxy.this.stdErr.setColor(colors.getColor(PreferenceConverter.getColor((IPreferenceStore)debugUIStore, (String)"org.eclipse.debug.ui.errorColor")));
            }
        });
    }

    private Display getDisplay() {
        if (Display.getCurrent() != null) {
            return Display.getCurrent();
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return Display.getDefault();
    }

    public OutputStream getStderr() {
        return this.stdErr;
    }

    public OutputStream getStdout() {
        return this.stdOut;
    }

    public InputStream getStdin() {
        return this.input;
    }

    public synchronized void close() {
        block3: {
            if (!this.closed) {
                try {
                    this.stdOut.close();
                    this.stdErr.close();
                    this.input.close();
                    this.closed = true;
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.needsEncoding = encoding != null && !encoding.equals(WorkbenchEncoding.getWorkbenchDefaultEncoding());
    }

    public void writeStdout(String value) {
        this.write(this.stdOut, value);
    }

    public void writeStderr(String value) {
        this.write(this.stdErr, value);
    }

    private void write(IOConsoleOutputStream stream, String value) {
        try {
            if (this.needsEncoding) {
                stream.write(value.getBytes(this.encoding));
            } else {
                stream.write(value);
            }
            stream.flush();
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            DLTKDebugUIPlugin.log(e);
        }
    }
}

