/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelProvider;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.CopyProjectFragmentOperation;
import org.eclipse.dltk.internal.core.CreateScriptFolderOperation;
import org.eclipse.dltk.internal.core.DeleteProjectFragmentOperation;
import org.eclipse.dltk.internal.core.MementoModelElementUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelProviderManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.MoveProjectFragmentOperation;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragmentInfo;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;

public class ProjectFragment
extends Openable
implements IProjectFragment {
    protected Object resource;

    protected ProjectFragment(IResource resource, ScriptProject project) {
        super(project);
        this.resource = resource;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    protected Object createElementInfo() {
        return new ProjectFragmentInfo();
    }

    @Override
    public int getElementType() {
        return 3;
    }

    @Override
    public IResource getResource() {
        return (IResource)this.resource;
    }

    @Override
    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    @Override
    public int getKind() throws ModelException {
        Object elementInfo = this.getElementInfo();
        return ((ProjectFragmentInfo)elementInfo).getRootKind();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectFragment)) {
            return false;
        }
        ProjectFragment other = (ProjectFragment)o;
        if (this.resource == null && other.resource != null) {
            return false;
        }
        if (this.resource != null && other.resource == null) {
            return false;
        }
        if (this.resource != null && other.resource != null && !this.resource.equals(other.resource)) {
            return false;
        }
        return this.parent.equals(other.parent);
    }

    @Override
    public int hashCode() {
        return this.resource.hashCode();
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        IStatus status = this.validateOnBuildpath();
        if (!status.isOK()) {
            throw this.newModelException(status);
        }
        if (!this.resourceExists()) {
            throw this.newNotPresentException();
        }
        return this.computeChildren(info, newElements);
    }

    protected IStatus validateOnBuildpath() {
        IPath path = this.getPath();
        try {
            ScriptProject project = (ScriptProject)this.getScriptProject();
            IBuildpathEntry[] buildpath = null;
            buildpath = this.getResource() != null ? project.getResourceOnlyResolvedBuildpath() : project.getResolvedBuildpath();
            int i = 0;
            int length = buildpath.length;
            while (i < length) {
                IBuildpathEntry entry = buildpath[i];
                if (entry.getPath().equals((Object)path)) {
                    return Status.OK_STATUS;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            return e.getModelStatus();
        }
        return new ModelStatus(1006, this);
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws ModelException {
        try {
            IResource underlyingResource = this.getResource();
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                IModelProvider[] providers;
                char[][] exclusionPatterns;
                IContainer rootFolder;
                ArrayList<IModelElement> vChildren = new ArrayList<IModelElement>(5);
                char[][] inclusionPatterns = this.fullInclusionPatternChars();
                this.computeFolderChildren(rootFolder, !Util.isExcluded((IResource)(rootFolder = (IContainer)underlyingResource), inclusionPatterns, exclusionPatterns = this.fullExclusionPatternChars()), (IPath)Path.EMPTY, vChildren, inclusionPatterns, exclusionPatterns);
                ArrayList<IModelElement> childrenSet = vChildren;
                IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
                if (toolkit != null && (providers = ModelProviderManager.getProviders(toolkit.getNatureId())) != null) {
                    int i = 0;
                    while (i < providers.length) {
                        providers[i].provideModelChanges(this, childrenSet);
                        ++i;
                    }
                }
                info.setChildren(childrenSet.toArray(new IModelElement[childrenSet.size()]));
            }
        }
        catch (ModelException e) {
            info.setChildren(new IModelElement[0]);
            throw e;
        }
        return true;
    }

    protected void computeFolderChildren(IContainer folder, boolean isIncluded, IPath path, ArrayList vChildren, char[][] inclusionPatterns, char[][] exclusionPatterns) throws ModelException {
        if (isIncluded) {
            IScriptFolder pkg = this.getScriptFolder(path);
            vChildren.add(pkg);
        }
        try {
            ScriptProject scriptProject = (ScriptProject)this.getScriptProject();
            ModelManager manager = ModelManager.getModelManager();
            IResource[] members = folder.members();
            boolean hasIncluded = isIncluded;
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                String memberName = member.getName();
                switch (member.getType()) {
                    case 2: {
                        if (!Util.isValidFolderNameForPackage(folder, memberName) || !scriptProject.contains(member)) break;
                        IPath newPath = path.append(manager.intern(memberName));
                        boolean isMemberIncluded = !Util.isExcluded(member, inclusionPatterns, exclusionPatterns);
                        this.computeFolderChildren((IContainer)((IFolder)member), isMemberIncluded, newPath, vChildren, inclusionPatterns, exclusionPatterns);
                        break;
                    }
                    case 1: {
                        if (hasIncluded || !Util.isValidSourceModule((IModelElement)this, member) || Util.isExcluded(member, inclusionPatterns, exclusionPatterns)) break;
                        hasIncluded = true;
                        IScriptFolder pkg = this.getScriptFolder(path);
                        vChildren.add(pkg);
                    }
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new ModelException(e, 969);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    @Override
    public IScriptFolder getScriptFolder(IPath path) {
        IModelProvider[] providers;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        if (toolkit != null && (providers = ModelProviderManager.getProviders(toolkit.getNatureId())) != null) {
            boolean provides = false;
            int i = 0;
            while (i < providers.length) {
                if (providers[i].isModelChangesProvidedFor(this, path.segment(0))) {
                    provides = true;
                    break;
                }
                ++i;
            }
            if (provides) {
                try {
                    IModelElement[] children = this.getChildren();
                    IPath fullPath = this.getPath().append(path);
                    int i2 = 0;
                    while (i2 < children.length) {
                        IPath childPath;
                        IModelElement child = children[i2];
                        if (child instanceof IScriptFolder && fullPath.equals((Object)(childPath = child.getPath()))) {
                            return (IScriptFolder)child;
                        }
                        ++i2;
                    }
                }
                catch (ModelException e) {
                    DLTKCore.error("Could not obtain model element childrens.", (Throwable)((Object)e));
                }
            }
        }
        return new ScriptFolder(this, path);
    }

    @Override
    public String getElementName() {
        if (this.resource instanceof IFolder) {
            return ((IFolder)this.resource).getName();
        }
        return super.getElementName();
    }

    @Override
    public boolean exists() {
        return super.exists() && this.validateOnBuildpath().isOK();
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getResource();
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        IPath path = EnvironmentPathUtils.getLocalPath(this.getPath());
        if (this.getScriptProject().getElementName().equals(path.segment(0))) {
            if (path.segmentCount() == 1) {
                buffer.append("<project root>");
            } else {
                buffer.append(path.removeFirstSegments(1).makeRelative());
            }
        } else if (this.isExternal()) {
            buffer.append(path.toOSString());
        } else {
            buffer.append(path);
        }
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint("ScriptProject fragment:" + this.getPath().toOSString());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    @Override
    public IScriptFolder getScriptFolder(String path) {
        return this.getScriptFolder((IPath)new Path(path));
    }

    @Override
    public Object[] getForeignResources() throws ModelException {
        return ((ProjectFragmentInfo)this.getElementInfo()).getForeignResources(this.getScriptProject(), this.getResource(), this);
    }

    public char[][] fullExclusionPatternChars() {
        BuildpathEntry entry;
        block5: {
            block4: {
                try {
                    if (!this.isOpen() || this.getKind() == 1) break block4;
                    return null;
                }
                catch (ModelException modelException) {
                    return null;
                }
            }
            entry = (BuildpathEntry)this.getBuildpathEntry();
            if (entry != null) break block5;
            return null;
        }
        return entry.fullExclusionPatternChars();
    }

    public char[][] fullInclusionPatternChars() {
        BuildpathEntry entry;
        block5: {
            block4: {
                try {
                    if (!this.isOpen() || this.getKind() == 1) break block4;
                    return null;
                }
                catch (ModelException modelException) {
                    return null;
                }
            }
            entry = (BuildpathEntry)this.getBuildpathEntry();
            if (entry != null) break block5;
            return null;
        }
        return entry.fullInclusionPatternChars();
    }

    @Override
    public IBuildpathEntry getRawBuildpathEntry() throws ModelException {
        IBuildpathEntry rawEntry = null;
        ScriptProject project = (ScriptProject)this.getScriptProject();
        project.getResolvedBuildpath();
        Map<IPath, IBuildpathEntry> rootPathToRawEntries = project.getPerProjectInfo().rootPathToRawEntries;
        if (rootPathToRawEntries != null) {
            rawEntry = rootPathToRawEntries.get(this.getPath());
        }
        if (rawEntry == null) {
            throw new ModelException(new ModelStatus(1006, this));
        }
        return rawEntry;
    }

    public IBuildpathEntry getBuildpathEntry() throws ModelException {
        return this.getRawBuildpathEntry();
    }

    @Override
    public void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        IPath path = ((IResource)this.resource).getProjectRelativePath();
        this.escapeMementoName(buff, path.toString());
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = "";
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = "";
                    token = null;
                }
                ModelElement pkg = (ModelElement)((Object)this.getScriptFolder(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
            case '}': {
                return MementoModelElementUtil.getHandleFromMemento(memento, this, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '/';
    }

    @Override
    public IScriptFolder createScriptFolder(String pkgName, boolean force, IProgressMonitor monitor) throws ModelException {
        CreateScriptFolderOperation op = new CreateScriptFolderOperation(this, pkgName, force);
        op.runOperation(monitor);
        return this.getScriptFolder(op.pkgName);
    }

    @Override
    public void delete(int updateResourceFlags, int updateModelFlags, IProgressMonitor monitor) throws ModelException {
        DeleteProjectFragmentOperation op = new DeleteProjectFragmentOperation(this, updateResourceFlags, updateModelFlags);
        op.runOperation(monitor);
    }

    @Override
    public void copy(IPath destination, int updateResourceFlags, int updateModelFlags, IBuildpathEntry sibling, IProgressMonitor monitor) throws ModelException {
        CopyProjectFragmentOperation op = new CopyProjectFragmentOperation(this, destination, updateResourceFlags, updateModelFlags, sibling);
        op.runOperation(monitor);
    }

    @Override
    public void move(IPath destination, int updateResourceFlags, int updateModelFlags, IBuildpathEntry sibling, IProgressMonitor monitor) throws ModelException {
        MoveProjectFragmentOperation op = new MoveProjectFragmentOperation(this, destination, updateResourceFlags, updateModelFlags, sibling);
        op.runOperation(monitor);
    }

    public IScriptFolder getScriptFolder(String[] pkgName) {
        return this.getScriptFolder(ScriptModelUtil.toPath(pkgName));
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

