/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.AbstractJob;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.core.SourceIndexUtil;
import org.eclipse.dltk.internal.core.ModelManager;

public abstract class IndexRequest
extends AbstractJob {
    private IProjectIndexer indexer;

    public IndexRequest(IProjectIndexer indexer) {
        this.indexer = indexer;
    }

    public IProjectIndexer.Internal getIndexer() {
        return (IProjectIndexer.Internal)this.indexer;
    }

    protected String[] queryDocumentNames(Index index) throws IOException {
        ReadWriteMonitor monitor = index.monitor;
        monitor.enterRead();
        try {
            String[] stringArray = index.queryDocumentNames(null);
            return stringArray;
        }
        finally {
            monitor.exitRead();
        }
    }

    protected Map<String, ISourceModule> collectSourceModulePaths(Collection<ISourceModule> modules, IPath containerPath) {
        HashMap<String, ISourceModule> paths = new HashMap<String, ISourceModule>();
        for (ISourceModule module : modules) {
            paths.put(SourceIndexUtil.containerRelativePath(containerPath, module), module);
        }
        return paths;
    }

    protected List<Object> checkChanges(Index index, Collection<ISourceModule> modules, IPath containerPath, IEnvironment environment, Set<IFileHandle> parentFolders) throws ModelException, IOException {
        IContentCache coreCache = ModelManager.getModelManager().getCoreCache();
        String[] documents = this.queryDocumentNames(index);
        if (documents != null && documents.length != 0) {
            ArrayList<Object> changes = new ArrayList<Object>();
            Map<String, ISourceModule> m = this.collectSourceModulePaths(modules, containerPath);
            int i = 0;
            while (i < documents.length) {
                String indexed;
                IFileHandle handle;
                String document = documents[i];
                ISourceModule module = m.remove(document);
                if (module == null) {
                    changes.add(document);
                } else if (environment != null && (handle = EnvironmentPathUtils.getFile(module, false)) != null && (indexed = coreCache.getCacheEntryAttributeString(handle, "indexed", true)) == null) {
                    IFileHandle parent = handle.getParent();
                    if (parentFolders.add(parent) && documents.length > 1) {
                        coreCache.updateFolderTimestamps(parent);
                    }
                    changes.add(module);
                    coreCache.setCacheEntryAttribute(handle, "indexed", "");
                }
                ++i;
            }
            if (!m.isEmpty()) {
                changes.addAll(m.values());
            }
            return changes;
        }
        return new ArrayList<Object>(modules);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.indexer == null ? 0 : this.indexer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRequest other = (IndexRequest)obj;
        return !(this.indexer == null ? other.indexer != null : !this.indexer.equals(other.indexer));
    }
}

