/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.parser;

import java.util.ArrayList;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.NodeTransformer;
import org.eclipse.dltk.utils.SimpleExtensionManager;

public class NodeTransformerManager
extends SimpleExtensionManager<NodeTransformer.Factory> {
    private static NodeTransformerManager instance;
    public static final NodeTransformer[] NO_TRANSFORMERS;

    static {
        NO_TRANSFORMERS = new NodeTransformer[0];
    }

    private NodeTransformerManager() {
        super(NodeTransformer.Factory.class, "org.eclipse.dltk.javascript.parser.transformer");
    }

    public static NodeTransformerManager getManager() {
        if (instance == null) {
            instance = new NodeTransformerManager();
        }
        return instance;
    }

    public static NodeTransformer[] createTransformers(IModelElement element, JSProblemReporter reporter) {
        NodeTransformer.Factory[] factories = (NodeTransformer.Factory[])NodeTransformerManager.getManager().getInstances();
        if (factories.length == 0) {
            return NO_TRANSFORMERS;
        }
        ArrayList<NodeTransformer> result = new ArrayList<NodeTransformer>(factories.length);
        NodeTransformer.Factory[] factoryArray = factories;
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            NodeTransformer.Factory factory = factoryArray[n2];
            NodeTransformer transformer = factory.create(element, reporter);
            if (transformer != null) {
                result.add(transformer);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return NO_TRANSFORMERS;
        }
        return result.toArray(new NodeTransformer[result.size()]);
    }
}

