/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;

public abstract class CompletionRequestor {
    private int ignoreSet = 0;
    public static final int ALL = Integer.MIN_VALUE;
    private static final int ALL_BITSET = Integer.MAX_VALUE;
    private CompletionProposalFilter[] filters;

    public final boolean isIgnored(int completionProposalKind) {
        if (completionProposalKind == Integer.MIN_VALUE) {
            return this.ignoreSet == Integer.MAX_VALUE;
        }
        if (completionProposalKind < 1 || completionProposalKind > 22) {
            throw new IllegalArgumentException("Unknown kind of completion proposal: " + completionProposalKind);
        }
        return (this.ignoreSet & 1 << completionProposalKind) != 0;
    }

    public final void setIgnored(int completionProposalKind, boolean ignore) {
        if (completionProposalKind == Integer.MIN_VALUE) {
            this.ignoreSet = ignore ? Integer.MAX_VALUE : 0;
            return;
        }
        if (completionProposalKind < 1 || completionProposalKind > 22) {
            throw new IllegalArgumentException("Unknown kind of completion proposal: " + completionProposalKind);
        }
        this.ignoreSet = ignore ? (this.ignoreSet |= 1 << completionProposalKind) : (this.ignoreSet &= ~(1 << completionProposalKind));
    }

    public void beginReporting() {
    }

    public void endReporting() {
    }

    public void completionFailure(IProblem problem) {
    }

    public abstract void accept(CompletionProposal var1);

    public void acceptContext(CompletionContext context) {
    }

    public boolean isContextInformationMode() {
        return false;
    }

    public void addFilter(CompletionProposalFilter filter) {
        Assert.isNotNull((Object)filter);
        if (this.filters == null) {
            this.filters = new CompletionProposalFilter[]{filter};
        } else {
            CompletionProposalFilter[] newFilters = new CompletionProposalFilter[this.filters.length + 1];
            System.arraycopy(this.filters, 0, newFilters, 0, this.filters.length);
            newFilters[this.filters.length] = filter;
            this.filters = newFilters;
        }
    }

    protected int evaluateFilters(CompletionProposal completionProposal) {
        int result = 0;
        if (this.filters != null) {
            try {
                CompletionProposalFilter[] completionProposalFilterArray = this.filters;
                int n = this.filters.length;
                int n2 = 0;
                while (n2 < n) {
                    CompletionProposalFilter filter = completionProposalFilterArray[n2];
                    int value = filter.evaluate(completionProposal);
                    if (value == -1000) {
                        return value;
                    }
                    if (value > 0 && value > result || value < 0 && value < result) {
                        result = value;
                    }
                    ++n2;
                }
            }
            catch (RuntimeException e) {
                DLTKCore.error("Error while evaluating CompletionProposalFilter, continue without filters", e);
                this.filters = null;
                result = 0;
            }
        }
        return result;
    }

    public static interface CompletionProposalFilter {
        public static final int DEFAULT = 0;
        public static final int IGNORE = -1000;
        public static final int DISCOURAGED = -50;

        public int evaluate(CompletionProposal var1);
    }
}

