/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.ArrayList;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeAssistConfigurationBlock
extends AbstractConfigurationBlock {
    private Button fCompletionInsertsRadioButton;
    private Button fCompletionOverwritesRadioButton;
    Control autoActivation;

    public CodeAssistConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        super(store, mainPreferencePage);
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        this.getOverlayKeys(overlayKeys);
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    protected void getOverlayKeys(ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys) {
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoactivation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_autoactivation_delay"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoinsert"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_insert_completion"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_sorter"));
    }

    @Override
    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        Composite composite = this.createSubsection(control, null, PreferencesMessages.CodeAssistConfigurationBlock_insertionSection_title);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.addInsertionSection(composite);
        composite = this.createSubsection(control, null, PreferencesMessages.CodeAssistConfigurationBlock_autoactivationSection_title);
        composite.setLayout((Layout)layout);
        this.addAutoActivationSection(composite);
        return control;
    }

    protected void addAutoActivationSection(Composite composite) {
        String label = PreferencesMessages.DLTKEditorPreferencePage_enableAutoActivation;
        Button autoactivation = this.addCheckBox(composite, label, "content_assist_autoactivation", 2);
        autoactivation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeAssistConfigurationBlock.this.updateAutoactivationControls();
            }
        });
        label = PreferencesMessages.DLTKEditorPreferencePage_autoActivationDelay;
        Control[] ctrl = this.addLabelledTextField(composite, label, "content_assist_autoactivation_delay", 4, 2, true);
        this.autoActivation = ctrl[1];
    }

    private void updateAutoactivationControls() {
        boolean autoactivation = this.getPreferenceStore().getBoolean("content_assist_autoactivation");
        if (this.autoActivation != null) {
            this.autoActivation.setEnabled(autoactivation);
        }
    }

    protected void addInsertionSection(Composite composite) {
        this.addCompletionRadioButtons(composite);
        String label = PreferencesMessages.DLTKEditorPreferencePage_insertSingleProposalsAutomatically;
        this.addCheckBox(composite, label, "content_assist_autoinsert", 2);
    }

    protected void addCompletionRadioButtons(Composite contentAssistComposite) {
        Composite completionComposite = new Composite(contentAssistComposite, 0);
        GridData ccgd = new GridData();
        ccgd.horizontalSpan = 2;
        completionComposite.setLayoutData((Object)ccgd);
        GridLayout ccgl = new GridLayout();
        ccgl.marginWidth = 0;
        ccgl.numColumns = 2;
        completionComposite.setLayout((Layout)ccgl);
        SelectionAdapter completionSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean insert = CodeAssistConfigurationBlock.this.fCompletionInsertsRadioButton.getSelection();
                CodeAssistConfigurationBlock.this.getPreferenceStore().setValue("content_assist_insert_completion", insert);
            }
        };
        this.fCompletionInsertsRadioButton = new Button(completionComposite, 16400);
        this.fCompletionInsertsRadioButton.setText(PreferencesMessages.DLTKEditorPreferencePage_completionInserts);
        this.fCompletionInsertsRadioButton.setLayoutData((Object)new GridData());
        this.fCompletionInsertsRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
        this.fCompletionOverwritesRadioButton = new Button(completionComposite, 16400);
        this.fCompletionOverwritesRadioButton.setText(PreferencesMessages.DLTKEditorPreferencePage_completionOverwrites);
        this.fCompletionOverwritesRadioButton.setLayoutData((Object)new GridData());
        this.fCompletionOverwritesRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
        Label label = new Label(completionComposite, 0);
        label.setText(PreferencesMessages.DLTKEditorPreferencePage_completionToggleHint);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
    }

    @Override
    protected void initializeFields() {
        super.initializeFields();
        boolean completionInserts = this.getPreferenceStore().getBoolean("content_assist_insert_completion");
        this.fCompletionInsertsRadioButton.setSelection(completionInserts);
        this.fCompletionOverwritesRadioButton.setSelection(!completionInserts);
        this.updateAutoactivationControls();
    }
}

