/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.OpenActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.search.DLTKSearchQuery;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.IProgressService;

public abstract class FindAction
extends SelectionDispatchAction {
    private static final IModelElement RETURN_WITHOUT_BEEP = DLTKCore.create((IWorkspaceRoot)DLTKUIPlugin.getWorkspace().getRoot());
    private Class[] fValidTypes;
    private final IDLTKLanguageToolkit toolkit;
    private ScriptEditor fEditor;

    FindAction(IDLTKLanguageToolkit toolkit, IWorkbenchSite site) {
        super(site);
        this.toolkit = toolkit;
        this.fValidTypes = this.getValidTypes();
        this.init();
    }

    FindAction(IDLTKLanguageToolkit toolkit, ScriptEditor editor) {
        this(toolkit, (IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn((IEditorPart)this.fEditor));
    }

    abstract void init();

    abstract Class[] getValidTypes();

    private boolean canOperateOn(IStructuredSelection sel) {
        return sel != null && !sel.isEmpty() && this.canOperateOn(this.getModelElement(sel, true));
    }

    boolean canOperateOn(IModelElement element) {
        if (element == null || this.fValidTypes == null || this.fValidTypes.length == 0 || !ActionUtil.isOnBuildPath(element)) {
            return false;
        }
        int i = 0;
        while (i < this.fValidTypes.length) {
            if (this.fValidTypes[i].isInstance(element)) {
                if (element.getElementType() == 4) {
                    return this.hasChildren((IScriptFolder)element);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasChildren(IScriptFolder ScriptFolder) {
        try {
            return ScriptFolder.hasChildren();
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    private IModelElement getTypeIfPossible(IModelElement o, boolean silent) {
        switch (o.getElementType()) {
            case 5: {
                if (silent) {
                    return o;
                }
                return this.findType((ISourceModule)o, silent);
            }
        }
        return o;
    }

    IModelElement getModelElement(IStructuredSelection selection, boolean silent) {
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            IModelElement elem = null;
            if (firstElement instanceof IModelElement) {
                elem = (IModelElement)firstElement;
            } else if (firstElement instanceof IAdaptable) {
                elem = (IModelElement)((IAdaptable)firstElement).getAdapter(IModelElement.class);
            }
            if (elem != null) {
                return this.getTypeIfPossible(elem, silent);
            }
        }
        return null;
    }

    private void showOperationUnavailableDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)SearchMessages.DLTKElementAction_operationUnavailable_title, (String)this.getOperationUnavailableMessage());
    }

    String getOperationUnavailableMessage() {
        return NLS.bind((String)SearchMessages.DLTKElementAction_operationUnavailable_generic, (Object)this.fEditor.getLanguageToolkit().getLanguageName());
    }

    private IModelElement findType(ISourceModule cu, boolean silent) {
        Object[] types = null;
        try {
            types = cu.getTypes();
        }
        catch (ModelException ex) {
            if (ScriptModelUtil.isExceptionToBeLogged((CoreException)((Object)ex))) {
                ExceptionHandler.log(ex, SearchMessages.DLTKElementAction_error_open_message);
            }
            if (silent) {
                return RETURN_WITHOUT_BEEP;
            }
            return null;
        }
        if (types.length == 1 || silent && types.length > 0) {
            return types[0];
        }
        if (silent) {
            return RETURN_WITHOUT_BEEP;
        }
        if (types.length == 0) {
            return null;
        }
        String title = SearchMessages.DLTKElementAction_typeSelectionDialog_title;
        String message = SearchMessages.DLTKElementAction_typeSelectionDialog_message;
        int flags = ModelElementLabelProvider.SHOW_DEFAULT;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new ModelElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(types);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return RETURN_WITHOUT_BEEP;
    }

    public void run(IStructuredSelection selection) {
        IModelElement element = this.getModelElement(selection, false);
        if (element == null || !element.exists()) {
            this.showOperationUnavailableDialog();
            return;
        }
        if (element == RETURN_WITHOUT_BEEP) {
            return;
        }
        this.run(element);
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            String title = SearchMessages.SearchElementSelectionDialog_title;
            String message = SearchMessages.SearchElementSelectionDialog_message;
            IModelElement[] elements = SelectionConverter.codeResolveForked((IEditorPart)this.fEditor, true);
            if (elements.length > 0 && this.canOperateOn(elements[0])) {
                IModelElement element = elements[0];
                if (elements.length > 1) {
                    element = OpenActionUtil.selectModelElement(elements, this.getShell(), title, message);
                }
                if (element != null) {
                    this.run(element);
                }
            } else {
                this.showOperationUnavailableDialog();
            }
        }
        catch (InvocationTargetException ex) {
            String title = SearchMessages.Search_Error_search_title;
            String message = SearchMessages.Search_Error_codeResolve;
            ExceptionHandler.handle(ex, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canOperateOn(selection));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(IModelElement element) {
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        try {
            this.performNewSearch(element);
        }
        catch (ModelException ex) {
            ExceptionHandler.handle((CoreException)((Object)ex), this.getShell(), SearchMessages.Search_Error_search_notsuccessful_title, SearchMessages.Search_Error_search_notsuccessful_message);
        }
    }

    private void performNewSearch(IModelElement element) throws ModelException {
        DLTKSearchQuery query = new DLTKSearchQuery(this.createQuery(element));
        if (query.canRunInBackground()) {
            SearchUtil.runQueryInBackground(query);
        } else {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IStatus status = SearchUtil.runQueryInForeground((IRunnableContext)progressService, query);
            if (status.matches(7)) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.Search_Error_search_title, (String)SearchMessages.Search_Error_search_message, (IStatus)status);
            }
        }
    }

    protected final IDLTKLanguageToolkit getLanguageToolkit() {
        return this.toolkit;
    }

    QuerySpecification createQuery(IModelElement element) throws ModelException {
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        IDLTKSearchScope scope = factory.createWorkspaceScope(true, this.getLanguageToolkit());
        String description = factory.getWorkspaceScopeDescription(true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }

    abstract int getLimitTo();

    IType getType(IModelElement element) {
        if (element == null) {
            return null;
        }
        IType type = null;
        if (element.getElementType() == 7) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        return type;
    }

    ScriptEditor getEditor() {
        return this.fEditor;
    }
}

