/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDropAdapter;
import org.eclipse.dltk.internal.ui.scriptview.ScriptExplorerPart;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class WorkingSetDropAdapter
extends DLTKViewerDropAdapter
implements TransferDropTargetListener {
    private ScriptExplorerPart fPackageExplorer;
    private IStructuredSelection fSelection;
    private Object[] fElementsToAdds;
    private Set fCurrentElements;
    private IWorkingSet fWorkingSet;
    private int fLocation;

    public WorkingSetDropAdapter(ScriptExplorerPart part) {
        super((Viewer)part.getTreeViewer());
        this.fPackageExplorer = part;
        this.fLocation = -1;
        this.setScrollEnabled(true);
        this.setExpandEnabled(true);
        this.setFeedbackEnabled(false);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (!this.isValidSelection(selection)) {
            return false;
        }
        if (!this.isValidTarget(target)) {
            return false;
        }
        this.initializeState(target, selection);
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return this.determineOperation(target, operation, transferType, 7) != 0;
    }

    protected int determineOperation(Object target, int operation, TransferData transferType, int operations) {
        switch (operation) {
            case 1: 
            case 2: 
            case 16: {
                return this.validateTarget(target, operation);
            }
        }
        return 0;
    }

    private int validateTarget(Object target, int operation) {
        this.setFeedbackEnabled(false);
        this.setScrollEnabled(true);
        this.setExpandEnabled(true);
        if (!this.isValidTarget(target)) {
            return 0;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!this.isValidSelection(s)) {
            return 0;
        }
        this.initializeState(target, s);
        if (this.isWorkingSetSelection()) {
            this.setExpandEnabled(false);
            if (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2) {
                this.setFeedbackEnabled(true);
                return 2;
            }
            return 0;
        }
        if (this.isOthersWorkingSet(this.fWorkingSet) && operation == 1) {
            return 0;
        }
        ArrayList realScriptElements = new ArrayList();
        ArrayList realResource = new ArrayList();
        ReorgUtils.splitIntoModelElementsAndResources(this.fElementsToAdds, realScriptElements, realResource);
        if (this.fElementsToAdds.length != realScriptElements.size() + realResource.size()) {
            return 0;
        }
        for (IModelElement element : realScriptElements) {
            if (!ReorgUtils.containsElementOrParent(this.fCurrentElements, element)) continue;
            return 0;
        }
        for (IModelElement element : realResource) {
            if (!ReorgUtils.containsElementOrParent(this.fCurrentElements, (IResource)element)) continue;
            return 0;
        }
        if (!(this.fSelection instanceof ITreeSelection)) {
            return 1;
        }
        ITreeSelection treeSelection = (ITreeSelection)this.fSelection;
        TreePath[] paths = treeSelection.getPaths();
        int i = 0;
        while (i < paths.length) {
            IWorkingSet ws;
            TreePath path = paths[i];
            if (path.getSegmentCount() != 2) {
                return 1;
            }
            if (!(path.getSegment(0) instanceof IWorkingSet)) {
                return 1;
            }
            if (paths.length == 1 && "org.eclipse.dltk.internal.ui.OthersWorkingSet".equals((ws = (IWorkingSet)path.getSegment(0)).getId())) {
                return 2;
            }
            ++i;
        }
        if (operation == 16) {
            return 2;
        }
        return operation;
    }

    private boolean isValidTarget(Object target) {
        return target instanceof IWorkingSet;
    }

    private boolean isValidSelection(ISelection selection) {
        return selection instanceof IStructuredSelection;
    }

    private boolean isOthersWorkingSet(IWorkingSet ws) {
        return "org.eclipse.dltk.internal.ui.OthersWorkingSet".equals(ws.getId());
    }

    private void initializeState(Object target, ISelection s) {
        this.fWorkingSet = (IWorkingSet)target;
        this.fSelection = (IStructuredSelection)s;
        this.fElementsToAdds = this.fSelection.toArray();
        this.fCurrentElements = new HashSet<IAdaptable>(Arrays.asList(this.fWorkingSet.getElements()));
    }

    private boolean isWorkingSetSelection() {
        int i = 0;
        while (i < this.fElementsToAdds.length) {
            if (!(this.fElementsToAdds[i] instanceof IWorkingSet)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean performDrop(Object data) {
        if (this.isWorkingSetSelection()) {
            this.performWorkingSetReordering();
        } else {
            this.performElementRearrange(this.getCurrentOperation());
        }
        return false;
    }

    private void performWorkingSetReordering() {
        WorkingSetModel model = this.fPackageExplorer.getWorkingSetModel();
        ArrayList<IWorkingSet> activeWorkingSets = new ArrayList<IWorkingSet>(Arrays.asList(model.getActiveWorkingSets()));
        int index = activeWorkingSets.indexOf(this.fWorkingSet);
        if (index != -1) {
            if (this.getCurrentLocation() == 2) {
                ++index;
            }
            ArrayList<Object> result = new ArrayList<Object>(activeWorkingSets.size());
            ArrayList<Object> selected = new ArrayList<Object>(Arrays.asList(this.fElementsToAdds));
            int i = 0;
            while (i < activeWorkingSets.size()) {
                Object element;
                if (i == index) {
                    result.addAll(selected);
                }
                if (!selected.contains(element = activeWorkingSets.get(i))) {
                    result.add(element);
                }
                ++i;
            }
            if (index == activeWorkingSets.size()) {
                result.addAll(selected);
            }
            model.setActiveWorkingSets(result.toArray(new IWorkingSet[result.size()]));
        }
    }

    private void performElementRearrange(int eventDetail) {
        if (!this.isOthersWorkingSet(this.fWorkingSet)) {
            ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(Arrays.asList(this.fWorkingSet.getElements()));
            elements.addAll(Arrays.asList(this.fElementsToAdds));
            this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
        if (eventDetail == 2) {
            ITreeSelection treeSelection = (ITreeSelection)this.fSelection;
            Map workingSets = this.groupByWorkingSets(treeSelection.getPaths());
            for (IWorkingSet ws : workingSets.keySet()) {
                List toRemove = (List)workingSets.get(ws);
                ArrayList<IAdaptable> currentElements = new ArrayList<IAdaptable>(Arrays.asList(ws.getElements()));
                currentElements.removeAll(toRemove);
                ws.setElements(currentElements.toArray(new IAdaptable[currentElements.size()]));
            }
        }
    }

    private Map groupByWorkingSets(TreePath[] paths) {
        HashMap<IWorkingSet, ArrayList<Object>> result = new HashMap<IWorkingSet, ArrayList<Object>>();
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            IWorkingSet ws = (IWorkingSet)path.getSegment(0);
            ArrayList<Object> l = (ArrayList<Object>)result.get(ws);
            if (l == null) {
                l = new ArrayList<Object>();
                result.put(ws, l);
            }
            l.add(path.getSegment(1));
            ++i;
        }
        return result;
    }

    public int internalTestValidateTarget(Object target, int operation) {
        return this.validateTarget(target, operation);
    }

    public void internalTestDrop(Object target, int eventDetail) {
        if (this.isWorkingSetSelection()) {
            this.performWorkingSetReordering();
        } else {
            this.performElementRearrange(eventDetail);
        }
    }

    public void internalTestSetLocation(int location) {
        this.fLocation = location;
    }

    protected int getCurrentLocation() {
        if (this.fLocation == -1) {
            return super.getCurrentLocation();
        }
        return this.fLocation;
    }
}

