/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ProgressMonitoringJob;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.Messages;
import org.eclipse.dltk.tcl.core.RebuildProjectsJob;
import org.eclipse.dltk.tcl.core.TclLibpathUtils;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.dltk.tcl.core.packages.TclInterpreterInfo;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackagesFactory;
import org.eclipse.dltk.tcl.core.packages.TclPackagesPackage;
import org.eclipse.dltk.tcl.core.packages.TclProjectInfo;
import org.eclipse.dltk.tcl.core.packages.VariableMap;
import org.eclipse.dltk.tcl.core.packages.VariableValue;
import org.eclipse.dltk.tcl.internal.core.packages.ProcessOutputCollector;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclPackagesManager {
    private static final String DLTK_TCL = "scripts/dltk.tcl";
    public static final String END_OF_STREAM = "DLTK-TCL-HELPER-9E7A168E-5EEF-4a46-A86D-0C82E90686E4-END-OF-STREAM";
    private static final String PKG_VERSION = "v20090505";
    private static Resource infos = null;
    private static final Map<String, Resource> projectInfos = new HashMap<String, Resource>();
    private static IInterpreterInstallChangedListener installChangedListener = null;
    private static Set<IInterpreterInstall> packageFetchingSet = new HashSet<IInterpreterInstall>();
    private static Set<IInterpreterInstall> sourcesFetchingSet = new HashSet<IInterpreterInstall>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TclPackageInfo> getPackageInfos(IInterpreterInstall install, Set<String> packageNames, boolean fetchIfRequired) {
        TclPackagesManager.initialize();
        TclInterpreterInfo interpreterInfo = TclPackagesManager.getTclInterpreter(install);
        Class<TclPackagesManager> clazz = TclPackagesManager.class;
        synchronized (TclPackagesManager.class) {
            List<TclPackageInfo> collection = Collections.unmodifiableList(TclPackagesManager.getPackagesForInterpreter(packageNames, fetchIfRequired, interpreterInfo, install));
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TclPackageInfo> getPackageInfos(IInterpreterInstall install) {
        TclPackagesManager.initialize();
        TclInterpreterInfo interpreterInfo = TclPackagesManager.getTclInterpreter(install);
        List<TclPackageInfo> collection = null;
        Class<TclPackagesManager> clazz = TclPackagesManager.class;
        synchronized (TclPackagesManager.class) {
            collection = Collections.unmodifiableList(new ArrayList<TclPackageInfo>((Collection<TclPackageInfo>)interpreterInfo.getPackages()));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TclPackageInfo getPackageInfo(IInterpreterInstall install, String name, boolean fetchIfRequired) {
        TclPackagesManager.initialize();
        TclInterpreterInfo interpreterInfo = TclPackagesManager.getTclInterpreter(install);
        EList<TclPackageInfo> packages = interpreterInfo.getPackages();
        HashSet<TclPackageInfo> toFetch = new HashSet<TclPackageInfo>();
        TclPackageInfo result = null;
        Class<TclPackagesManager> clazz = TclPackagesManager.class;
        synchronized (TclPackagesManager.class) {
            for (TclPackageInfo tclPackageInfo : packages) {
                if (!name.equals(tclPackageInfo.getName())) continue;
                if (tclPackageInfo.isFetched() || !fetchIfRequired) {
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return tclPackageInfo;
                }
                toFetch.add(tclPackageInfo);
                TclPackagesManager.fetchSources(toFetch, install, interpreterInfo, null);
                result = tclPackageInfo;
                break;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return result;
        }
    }

    public static Set<TclPackageInfo> getDependencies(IInterpreterInstall install, String name, boolean fetchIfRequired) {
        TclPackagesManager.initialize();
        TclPackageInfo info = TclPackagesManager.getPackageInfo(install, name, fetchIfRequired);
        if (info != null) {
            HashSet<TclPackageInfo> result = new HashSet<TclPackageInfo>();
            HashSet<TclPackageInfo> toFetch = new HashSet<TclPackageInfo>();
            TclPackagesManager.processPackage(info, result, toFetch, fetchIfRequired);
            if (toFetch.size() > 0) {
                TclInterpreterInfo interpreter = TclPackagesManager.getTclInterpreter(install);
                TclPackagesManager.fetchSources(toFetch, install, interpreter, null);
                TclPackagesManager.processPackage(info, result, toFetch, fetchIfRequired);
            }
            result.remove(info);
            return result;
        }
        return null;
    }

    private static TclInterpreterInfo getTclInterpreter(IInterpreterInstall install) {
        return TclPackagesManager.getTclInterpreter(install, true);
    }

    public static long getTclInterpreterFetchDate(IInterpreterInstall install) {
        TclInterpreterInfo interpreter = TclPackagesManager.getTclInterpreter(install, true);
        if (interpreter != null) {
            return interpreter.getFetchedAt().getTime();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TclInterpreterInfo getTclInterpreter(IInterpreterInstall install, boolean allowCreate) {
        TclInterpreterInfo interpreterInfo = null;
        String interpreterLocation = install.getInstallLocation().getPath().toString();
        String environmentId = install.getInstallLocation().getEnvironmentId();
        Class<TclPackagesManager> clazz = TclPackagesManager.class;
        synchronized (TclPackagesManager.class) {
            for (EObject eObject : infos.getContents()) {
                if (!(eObject instanceof TclInterpreterInfo)) continue;
                TclInterpreterInfo info = (TclInterpreterInfo)eObject;
                String location = info.getInstallLocation();
                String name = info.getName();
                String env = info.getEnvironment();
                if (!interpreterLocation.equals(location) || !install.getName().equals(name) || env == null || !env.equals(environmentId)) continue;
                interpreterInfo = info;
                break;
            }
            if (interpreterInfo == null) {
                if (!allowCreate) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return null;
                }
                interpreterInfo = TclPackagesFactory.eINSTANCE.createTclInterpreterInfo();
                interpreterInfo.setInstallLocation(interpreterLocation);
                interpreterInfo.setName(install.getName());
                interpreterInfo.setEnvironment(environmentId);
                interpreterInfo.setFetched(false);
                infos.getContents().add((Object)interpreterInfo);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            TclPackagesManager.fetchPackagesForInterpreter(install, interpreterInfo);
            return interpreterInfo;
        }
    }

    private static long getPackagesRefreshInterval(IInterpreterInstall install) {
        if (install == null) {
            return 0L;
        }
        IEnvironment environment = install.getEnvironment();
        String refreshIntervalKey = environment != null && environment.isLocal() ? "packages.refreshInterval.local" : "packages.refreshInterval.remote";
        return Platform.getPreferencesService().getLong("org.eclipse.dltk.tcl.core", refreshIntervalKey, 900000L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TclProjectInfo getTclProject(String name) {
        Resource resource;
        Resource resource2 = resource = TclPackagesManager.getProjectInfoResource(name);
        synchronized (resource2) {
            TclProjectInfo info = null;
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof TclProjectInfo)) continue;
                TclProjectInfo pinfo = (TclProjectInfo)eObject;
                String pname = pinfo.getName();
                if (name == null || !name.equals(pname)) continue;
                info = pinfo;
            }
            if (info == null) {
                info = TclPackagesFactory.eINSTANCE.createTclProjectInfo();
                info.setName(name);
                resource.getContents().add((Object)info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void fetchPackagesForInterpreter(IInterpreterInstall install, TclInterpreterInfo interpreterInfo) {
        Class<TclPackagesManager> clazz = TclPackagesManager.class;
        synchronized (TclPackagesManager.class) {
            IExecutionEnvironment exeEnv;
            RuntimePerformanceMonitor.PerformanceNode p;
            block26: {
                while (true) {
                    if (!packageFetchingSet.contains(install)) {
                        if (!interpreterInfo.isFetched() || interpreterInfo.getFetchedAt() == null || interpreterInfo.getFetchedAt().getTime() + TclPackagesManager.getPackagesRefreshInterval(install) < System.currentTimeMillis()) break;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    try {
                        TclPackagesManager.class.wait(50L);
                    }
                    catch (InterruptedException e) {
                        TclPlugin.error(e);
                    }
                }
                packageFetchingSet.add(install);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                try {
                    p = RuntimePerformanceMonitor.begin();
                    exeEnv = install.getExecEnvironment();
                    if (exeEnv != null) break block26;
                    Class<TclPackagesManager> clazz2 = TclPackagesManager.class;
                }
                catch (Throwable throwable) {
                    Class<TclPackagesManager> clazz3 = TclPackagesManager.class;
                    synchronized (TclPackagesManager.class) {
                        packageFetchingSet.remove(install);
                        TclPackagesManager.class.notifyAll();
                        // ** MonitorExit[var9_6] (shouldn't be in output)
                        throw throwable;
                    }
                }
                synchronized (TclPackagesManager.class) {
                    packageFetchingSet.remove(install);
                    TclPackagesManager.class.notifyAll();
                    // ** MonitorExit[var9_5] (shouldn't be in output)
                    return;
                }
            }
            ProgressMonitoringJob monitor = new ProgressMonitoringJob(String.valueOf(Messages.TclInterpreterMessages_RetrieveListOfAvailablePackages) + " " + install.getName(), 100);
            try {
                List<String> content = TclPackagesManager.deployExecute(exeEnv, install, new String[]{"get-pkgs"}, install.getEnvironmentVariables(), monitor);
                Class<TclPackagesManager> clazz4 = TclPackagesManager.class;
                synchronized (TclPackagesManager.class) {
                    if (content != null) {
                        monitor.subTask(Messages.TclInterpreterMessages_ProcessingPackagesInfo);
                        TclPackagesManager.processContent(content, false, true, interpreterInfo);
                        monitor.worked(20);
                        interpreterInfo.setFetched(true);
                        interpreterInfo.setFetchedAt(new Date());
                        monitor.subTask(Messages.TclInterpreterMessages_SavePackagesInfo);
                        TclPackagesManager.save();
                        monitor.worked(10);
                    }
                    // ** MonitorExit[var6_10] (shouldn't be in output)
                    String msg = Messages.TclInterpreterMessages_FetchInterpreterPackagesInfo;
                    p.done("Tcl", msg, 0L);
                }
            }
            finally {
                monitor.done();
            }
            {
                Class<TclPackagesManager> clazz5 = TclPackagesManager.class;
                synchronized (TclPackagesManager.class) {
                    packageFetchingSet.remove(install);
                    TclPackagesManager.class.notifyAll();
                    // ** MonitorExit[var9_7] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (infos != null) {
            try {
                infos.save(null);
            }
            catch (IOException iOException) {
            }
        }
        Map<String, Resource> map = projectInfos;
        synchronized (map) {
            for (Map.Entry<String, Resource> entry : projectInfos.entrySet()) {
                try {
                    entry.getValue().save(null);
                }
                catch (IOException e) {
                    String msg = NLS.bind((String)Messages.TclInterpreterMessages_6, (Object)entry.getKey(), (Object)e.getMessage());
                    TclPlugin.error(msg, e);
                }
            }
        }
    }

    private static String getXMLContent(List<String> content) {
        StringBuffer newList = new StringBuffer();
        if (content != null) {
            for (String line : content) {
                if (!line.trim().startsWith("<")) continue;
                newList.append(line).append("\n");
            }
        }
        return newList.toString();
    }

    private static Document getDocument(String text) {
        block6: {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                InputSource source = new InputSource(new StringReader(text));
                Document document = parser.parse(source);
                return document;
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (ParserConfigurationException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (SAXException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    private static synchronized void processContent(List<String> content, boolean markAsFetched, boolean purgePackages, TclInterpreterInfo info) {
        String text = TclPackagesManager.getXMLContent(content);
        Document document = TclPackagesManager.getDocument(text);
        if (document != null) {
            HashSet<String> processedPackages = new HashSet<String>();
            Element element = document.getDocumentElement();
            NodeList childNodes = element.getChildNodes();
            int len = childNodes.getLength();
            int i = 0;
            while (i < len) {
                Node nde = childNodes.item(i);
                if (TclPackagesManager.isElementName(nde, "path")) {
                    Element el = (Element)nde;
                    NodeList elChilds = el.getChildNodes();
                    int j = 0;
                    while (j < elChilds.getLength()) {
                        Node pkgNde = elChilds.item(j);
                        if (TclPackagesManager.isElementName(pkgNde, "package")) {
                            Element pkgElement = (Element)pkgNde;
                            String name = pkgElement.getAttribute("name");
                            processedPackages.add(name);
                            TclPackageInfo pkg = TclPackagesManager.getCreatePackage(info, name);
                            if (markAsFetched) {
                                pkg.setFetched(markAsFetched);
                            }
                            TclPackagesManager.populatePackage(pkg, pkgNde, info);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (purgePackages) {
                Iterator i2 = info.getPackages().iterator();
                while (i2.hasNext()) {
                    TclPackageInfo packageInfo = (TclPackageInfo)i2.next();
                    if (processedPackages.contains(packageInfo.getName())) continue;
                    i2.remove();
                }
            }
        }
    }

    private static synchronized TclPackageInfo getCreatePackage(TclInterpreterInfo info, String name) {
        TclPackageInfo packageInfo = null;
        for (TclPackageInfo pkgInfo : info.getPackages()) {
            if (!pkgInfo.getName().equals(name)) continue;
            packageInfo = pkgInfo;
            break;
        }
        if (packageInfo == null) {
            packageInfo = TclPackagesFactory.eINSTANCE.createTclPackageInfo();
            packageInfo.setFetched(false);
            packageInfo.setName(name);
            info.getPackages().add((Object)packageInfo);
        }
        return packageInfo;
    }

    private static void populatePackage(TclPackageInfo info, Node pkgNde, TclInterpreterInfo interpreterInfo) {
        Element pkg = (Element)pkgNde;
        info.setVersion(pkg.getAttribute("version"));
        NodeList childs = pkg.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            String name;
            Element el;
            Node nde = childs.item(i);
            if (TclPackagesManager.isElementName(nde, "source")) {
                el = (Element)nde;
                name = el.getAttribute("name");
                info.getSources().add((Object)name);
            } else if (TclPackagesManager.isElementName(nde, "require")) {
                el = (Element)nde;
                name = el.getAttribute("name");
                info.getDependencies().add((Object)TclPackagesManager.getCreatePackage(interpreterInfo, name));
            } else if (TclPackagesManager.isElementName(nde, "load")) {
                el = (Element)nde;
                name = el.getAttribute("name");
                info.getLibraries().add((Object)name);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TclPackageInfo> getPackagesForInterpreter(Set<String> packageName, boolean fetchIfRequired, TclInterpreterInfo interpreterInfo, IInterpreterInstall install) {
        HashSet<TclPackageInfo> result = new HashSet<TclPackageInfo>();
        HashSet<TclPackageInfo> toFetch = new HashSet<TclPackageInfo>();
        Class<TclPackagesManager> clazz = TclPackagesManager.class;
        synchronized (TclPackagesManager.class) {
            for (TclPackageInfo tclPackageInfo : interpreterInfo.getPackages()) {
                if (!packageName.contains(tclPackageInfo.getName())) continue;
                TclPackagesManager.processPackage(tclPackageInfo, result, toFetch, fetchIfRequired);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            TclPackagesManager.fetchSources(toFetch, install, interpreterInfo, null);
            clazz = TclPackagesManager.class;
            synchronized (TclPackagesManager.class) {
                for (TclPackageInfo tclPackageInfo : interpreterInfo.getPackages()) {
                    if (!packageName.contains(tclPackageInfo.getName())) continue;
                    TclPackagesManager.processPackage(tclPackageInfo, result, toFetch, fetchIfRequired);
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return new ArrayList<TclPackageInfo>(result);
            }
        }
    }

    private static void processPackage(TclPackageInfo tclPackageInfo, Set<TclPackageInfo> result, Set<TclPackageInfo> toFetch, boolean fetchIfRequired) {
        if (tclPackageInfo.isFetched() || !fetchIfRequired) {
            result.add(tclPackageInfo);
        } else if (fetchIfRequired) {
            result.add(tclPackageInfo);
            toFetch.add(tclPackageInfo);
        }
        EList<TclPackageInfo> dependencies = tclPackageInfo.getDependencies();
        for (TclPackageInfo tclPackageInfo2 : dependencies) {
            if (result.contains(tclPackageInfo2)) continue;
            TclPackagesManager.processPackage(tclPackageInfo2, result, toFetch, fetchIfRequired);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void fetchSources(Set<TclPackageInfo> toFetch, IInterpreterInstall install, TclInterpreterInfo interpreterInfo, IProgressMonitor topMonitor) {
        var4_4 = TclPackagesManager.class;
        synchronized (TclPackagesManager.class) {
            while (true) {
                block37: {
                    if (TclPackagesManager.sourcesFetchingSet.contains(install)) break block37;
                    toRemove = new HashSet<TclPackageInfo>();
                    var7_7 = toFetch.iterator();
                    if (true) ** GOTO lbl23
                }
                try {
                    TclPackagesManager.class.wait(50L);
                }
                catch (InterruptedException e) {
                    TclPlugin.error(e);
                }
            }
            do {
                if (!(tclPackageInfo = var7_7.next()).isFetched()) continue;
                toRemove.add(tclPackageInfo);
lbl23:
                // 3 sources

            } while (var7_7.hasNext());
            toFetch.removeAll(toRemove);
            if (toFetch.size() == 0) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            TclPackagesManager.sourcesFetchingSet.add(install);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            monitor = topMonitor;
            if (monitor == null) {
                monitor = new ProgressMonitoringJob(String.valueOf(Messages.TclInterpreterMessages_RetrievePackageInformationSources) + " " + install.getName(), 100);
            }
            try {
                block39: {
                    block35: {
                        block38: {
                            p = RuntimePerformanceMonitor.begin();
                            exeEnv = install.getExecEnvironment();
                            if (exeEnv == null) break block35;
                            install.getEnvironment().getName();
                            monitor.subTask(Messages.TclInterpreterMessages_DeployingPackageInformationScript);
                            deployment = exeEnv.createDeployment();
                            if (deployment == null) break block35;
                            script = TclPackagesManager.deploy(deployment);
                            if (script != null) break block38;
                            deployment.dispose();
                            break block35;
                        }
                        monitor.worked(10);
                        workingDir = script.getParent();
                        config = ScriptLaunchUtil.createInterpreterConfig((IExecutionEnvironment)exeEnv, (IFileHandle)script, (IFileHandle)workingDir, (EnvironmentVariable[])install.getEnvironmentVariables());
                        TclLibpathUtils.addTclLibPath(config, install.getLibraryLocations(), install.getEnvironment());
                        buf = new StringBuffer();
                        var13_16 = toFetch.iterator();
                        while (true) {
                            if (!var13_16.hasNext()) {
                                names = buf.toString();
                                bais = new ByteArrayInputStream(names.getBytes());
                                monitor.subTask(Messages.TclInterpreterMessages_DeployingFileWithListOfPackages);
                                packagesPath = null;
                                ** try [egrp 5[TRYBLOCK] [6 : 458->475)] { 
lbl62:
                                // 1 sources

                                break;
                            }
                            tclPackageInfo = var13_16.next();
                            buf.append(tclPackageInfo.getName()).append(" ");
                        }
                        {
                            packagesPath = deployment.add((InputStream)bais, "packages.txt");
                        }
lbl69:
                        // 1 sources

                        catch (IOException e1) {
                            if (DLTKCore.DEBUG) {
                                e1.printStackTrace();
                            }
                            deployment.dispose();
                            break block35;
                        }
                        monitor.worked(10);
                        file = deployment.getFile(packagesPath);
                        config.removeEnvVar("DISPLAY");
                        arguments = new String[]{"get-srcs", "-fpkgs", file.toOSString()};
                        config.addScriptArgs(arguments);
                        monitor.subTask(Messages.TclInterpreterMessages_RunningPackageInfoScript);
                        process = null;
                        try {
                            process = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)install.getInstallLocation().toOSString(), (InterpreterConfig)config);
                        }
                        catch (CoreException e) {
                            if (DLTKCore.DEBUG) {
                                e.printStackTrace();
                            }
                            deployment.dispose();
                        }
                        if (process != null) break block39;
                        deployment.dispose();
                    }
                    monitor.done();
                    var22_9 = TclPackagesManager.class;
                    synchronized (TclPackagesManager.class) {
                        TclPackagesManager.sourcesFetchingSet.remove(install);
                        TclPackagesManager.class.notifyAll();
                        // ** MonitorExit[var22_9] (shouldn't be in output)
                        return;
                    }
                }
                monitor.worked(10);
                output = ProcessOutputCollector.execute(process);
                monitor.worked(40);
                monitor.subTask(Messages.TclInterpreterMessages_ProcessingPackagesInfo);
                TclPackagesManager.processContent(output, true, false, interpreterInfo);
                monitor.worked(20);
                var20_25 = toFetch.iterator();
                while (true) {
                    if (!var20_25.hasNext()) {
                        deployment.dispose();
                        monitor.subTask(Messages.TclInterpreterMessages_SavePackagesInfo);
                        TclPackagesManager.save();
                        monitor.worked(10);
                        p.done("Tcl", Messages.TclInterpreterMessages_FetchInterpreterSources, 0L);
                        break;
                    }
                    info = var20_25.next();
                    info.setFetched(true);
                }
            }
            catch (Throwable var21_27) {
                monitor.done();
                var22_10 = TclPackagesManager.class;
                synchronized (TclPackagesManager.class) {
                    TclPackagesManager.sourcesFetchingSet.remove(install);
                    TclPackagesManager.class.notifyAll();
                    // ** MonitorExit[var22_10] (shouldn't be in output)
                    throw var21_27;
                }
            }
            monitor.done();
            var22_11 = TclPackagesManager.class;
            synchronized (TclPackagesManager.class) {
                TclPackagesManager.sourcesFetchingSet.remove(install);
                TclPackagesManager.class.notifyAll();
                // ** MonitorExit[var22_11] (shouldn't be in output)
                return;
            }
        }
    }

    private static URI getInfoLocation() {
        IPath path = TclPlugin.getDefault().getStateLocation().append("tclPackages_v20090505.info");
        return URI.createFileURI((String)path.toOSString());
    }

    private static URI getProjectLocation(String projectName) {
        IPath path = TclPlugin.getDefault().getStateLocation().append("project-" + projectName + ".info");
        return URI.createFileURI((String)path.toOSString());
    }

    private static boolean canLoad(URI location) {
        if (location.isFile()) {
            return new File(location.toFileString()).exists();
        }
        return true;
    }

    private static synchronized void initialize() {
        if (installChangedListener == null) {
            installChangedListener = new InterpreterInstallChangedListener();
            ScriptRuntime.addInterpreterInstallChangedListener((IInterpreterInstallChangedListener)installChangedListener);
        }
        if (infos == null) {
            URI location = TclPackagesManager.getInfoLocation();
            infos = new XMIResourceImpl(location);
            try {
                if (TclPackagesManager.canLoad(location)) {
                    infos.load(null);
                }
            }
            catch (IOException e) {
                TclPlugin.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource getProjectInfoResource(String projectName) {
        Resource resource;
        Map<String, Resource> map = projectInfos;
        synchronized (map) {
            resource = projectInfos.get(projectName);
            if (resource != null) {
                return resource;
            }
        }
        URI location = TclPackagesManager.getProjectLocation(projectName);
        resource = new XMIResourceImpl(location);
        try {
            if (TclPackagesManager.canLoad(location)) {
                resource.load(null);
            }
        }
        catch (IOException e) {
            TclPlugin.error(e);
        }
        Map<String, Resource> map2 = projectInfos;
        synchronized (map2) {
            Resource r = projectInfos.get(projectName);
            if (r != null) {
                return r;
            }
            projectInfos.put(projectName, resource);
            return resource;
        }
    }

    private static List<String> deployExecute(IExecutionEnvironment exeEnv, IInterpreterInstall install, String[] arguments, EnvironmentVariable[] env, ProgressMonitoringJob monitor) {
        Process process;
        IDeployment deployment;
        block6: {
            monitor.subTask(Messages.TclInterpreterMessages_DeployingPackageInformationScript);
            deployment = exeEnv.createDeployment();
            if (deployment == null) {
                return null;
            }
            IFileHandle script = TclPackagesManager.deploy(deployment);
            if (script == null) {
                deployment.dispose();
                return null;
            }
            monitor.worked(10);
            monitor.subTask(Messages.TclInterpreterMessages_RunningPackageInfoScript);
            IFileHandle workingDir = script.getParent();
            InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig((IExecutionEnvironment)exeEnv, (IFileHandle)script, (IFileHandle)workingDir, (EnvironmentVariable[])env);
            TclLibpathUtils.addTclLibPath(config, install.getLibraryLocations(), install.getEnvironment());
            config.removeEnvVar("DISPLAY");
            if (arguments != null) {
                config.addScriptArgs(arguments);
            }
            process = null;
            try {
                process = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)install.getInstallLocation().toOSString(), (InterpreterConfig)config);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if (process == null) {
            deployment.dispose();
            return null;
        }
        List<String> output = ProcessOutputCollector.execute(process);
        monitor.worked(70);
        deployment.dispose();
        return output;
    }

    private static IFileHandle deploy(IDeployment deployment) {
        IFileHandle script;
        try {
            IPath path = deployment.add(TclPlugin.getDefault().getBundle(), DLTK_TCL);
            script = deployment.getFile(path);
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        return script;
    }

    private static boolean isElementName(Node nde, String name) {
        return nde != null && nde.getNodeType() == 1 && name.equalsIgnoreCase(nde.getNodeName());
    }

    public static boolean isValidName(String packageName) {
        return packageName != null && packageName.length() != 0 && packageName.indexOf(36) == -1 && packageName.indexOf(91) == -1 && packageName.indexOf(93) == -1;
    }

    public static synchronized List<TclModuleInfo> getProjectModules(String name) {
        TclProjectInfo info = TclPackagesManager.getTclProject(name);
        ArrayList<TclModuleInfo> results = new ArrayList<TclModuleInfo>();
        EList<TclModuleInfo> modules = info.getModules();
        for (TclModuleInfo tclModuleInfo : modules) {
            TclModuleInfo copy = (TclModuleInfo)EcoreUtil.copy((EObject)tclModuleInfo);
            results.add(copy);
        }
        return Collections.unmodifiableList(results);
    }

    public static synchronized void setProjectModules(String name, List<TclModuleInfo> modules) {
        TclProjectInfo info = TclPackagesManager.getTclProject(name);
        info.getModules().clear();
        info.getModules().addAll(modules);
        TclPackagesManager.save();
    }

    public static synchronized void removeInterpreterInfo(IInterpreterInstall install) {
        TclPackagesManager.initialize();
        TclInterpreterInfo info = TclPackagesManager.getTclInterpreter(install, false);
        if (info != null && (!info.getPackages().isEmpty() || info.isFetched() || info.getFetchedAt() != null)) {
            info.getPackages().clear();
            info.setFetched(false);
            info.setFetchedAt(null);
            TclPackagesManager.save();
        }
    }

    public static synchronized void markInterprterAsNotFetched(IInterpreterInstall install) {
        TclPackagesManager.initialize();
        TclInterpreterInfo info = TclPackagesManager.getTclInterpreter(install, false);
        if (info != null) {
            info.setFetched(false);
            info.setFetchedAt(null);
            TclPackagesManager.save();
        }
    }

    public static Set<String> getPackageInfosAsString(IInterpreterInstall install) {
        TclPackagesManager.initialize();
        HashSet<String> result = new HashSet<String>();
        List<TclPackageInfo> list = TclPackagesManager.getPackageInfos(install);
        for (TclPackageInfo tclPackageInfo : list) {
            result.add(tclPackageInfo.getName());
        }
        return result;
    }

    private static EMap<String, VariableValue> convertVariablesToEMap(Map<String, String> variables) {
        BasicEMap result = new BasicEMap();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            VariableValue value = TclPackagesFactory.eINSTANCE.createVariableValue();
            value.setValue(entry.getValue());
            result.put((Object)entry.getKey(), (Object)value);
        }
        return result;
    }

    private static Map<String, String> convertVariablesToMap(EMap<String, VariableValue> variables) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : variables.entrySet()) {
            result.put((String)entry.getKey(), ((VariableValue)entry.getValue()).getValue());
        }
        return result;
    }

    public static Map<String, String> getVariables(IInterpreterInstall install) {
        return TclPackagesManager.convertVariablesToMap(TclPackagesManager.getVariablesEMap(install));
    }

    public static EMap<String, VariableValue> getVariablesEMap(IInterpreterInstall install) {
        EObject variables = install.findExtension(TclPackagesPackage.Literals.VARIABLE_MAP);
        if (variables != null) {
            return ECollections.unmodifiableEMap(((VariableMap)variables).getVariables());
        }
        return ECollections.emptyEMap();
    }

    public static void setVariables(IInterpreterInstall install, Map<String, String> variables) {
        TclPackagesManager.setVariables(install, TclPackagesManager.convertVariablesToEMap(variables));
    }

    public static void setVariables(IInterpreterInstall install, EMap<String, VariableValue> variables) {
        if (variables != null && !variables.isEmpty()) {
            VariableMap variableMap = TclPackagesFactory.eINSTANCE.createVariableMap();
            variableMap.getVariables().putAll(variables);
            install.replaceExtension(TclPackagesPackage.Literals.VARIABLE_MAP, (EObject)variableMap);
        } else {
            install.replaceExtension(TclPackagesPackage.Literals.VARIABLE_MAP, null);
        }
    }

    public static Map<String, String> getVariables(String projectName) {
        return TclPackagesManager.convertVariablesToMap(TclPackagesManager.getVariablesEMap(projectName));
    }

    public static synchronized EMap<String, VariableValue> getVariablesEMap(String projectName) {
        TclProjectInfo projectInfo = TclPackagesManager.getTclProject(projectName);
        return ECollections.unmodifiableEMap(projectInfo.getVariables());
    }

    public static void setVariables(String projectName, Map<String, String> variables) {
        TclPackagesManager.setVariables(projectName, TclPackagesManager.convertVariablesToEMap(variables));
    }

    public static synchronized void setVariables(String projectName, EMap<String, VariableValue> variables) {
        TclProjectInfo projectInfo = TclPackagesManager.getTclProject(projectName);
        projectInfo.getVariables().clear();
        projectInfo.getVariables().putAll(variables);
        TclPackagesManager.save();
    }

    public static void fillPackagesFromContent(List<String> content, TclInterpreterInfo info) {
        String text = TclPackagesManager.getXMLContent(content);
        Document document = TclPackagesManager.getDocument(text);
        HashSet<TclPackageInfo> packages = new HashSet<TclPackageInfo>();
        if (document != null) {
            Element element = document.getDocumentElement();
            NodeList childNodes = element.getChildNodes();
            int len = childNodes.getLength();
            int i = 0;
            while (i < len) {
                Node nde = childNodes.item(i);
                if (TclPackagesManager.isElementName(nde, "path")) {
                    Element el = (Element)nde;
                    NodeList elChilds = el.getChildNodes();
                    int j = 0;
                    while (j < elChilds.getLength()) {
                        Node pkgNde = elChilds.item(j);
                        if (TclPackagesManager.isElementName(pkgNde, "package")) {
                            Element pkgElement = (Element)pkgNde;
                            String name = pkgElement.getAttribute("name");
                            TclPackageInfo pkg = TclPackagesManager.getCreatePackage(info, name);
                            TclPackagesManager.populatePackage(pkg, pkgNde, info);
                            packages.add(pkg);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TclPackageInfo getPackageInfo(InterpreterStandin install, String name, boolean fetch, TclInterpreterInfo info, IProgressMonitor monitor) {
        EList<TclPackageInfo> packages = info.getPackages();
        HashSet<TclPackageInfo> toFetch = new HashSet<TclPackageInfo>();
        TclPackageInfo result = null;
        Class<TclPackagesManager> clazz = TclPackagesManager.class;
        synchronized (TclPackagesManager.class) {
            for (TclPackageInfo tclPackageInfo : packages) {
                if (!name.equals(tclPackageInfo.getName())) continue;
                if (tclPackageInfo.isFetched()) {
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return tclPackageInfo;
                }
                toFetch.add(tclPackageInfo);
                TclPackagesManager.fetchSources(toFetch, (IInterpreterInstall)install, info, monitor);
                result = tclPackageInfo;
                break;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return result;
        }
    }

    private static class InterpreterInstallChangedListener
    implements IInterpreterInstallChangedListener {
        private InterpreterInstallChangedListener() {
        }

        public void defaultInterpreterInstallChanged(IInterpreterInstall previous, IInterpreterInstall current) {
        }

        public void interpreterAdded(IInterpreterInstall Interpreter) {
        }

        public void interpreterChanged(PropertyChangeEvent event) {
            if (IInterpreterInstallChangedListener.PROPERTY_EXTENSIONS.equals(event.getProperty())) {
                VariableMap oldVars = this.locateVariableMap(event.getOldValue());
                VariableMap newVars = this.locateVariableMap(event.getNewValue());
                if (oldVars != null || newVars != null) {
                    if (oldVars != null && newVars != null) {
                        if (!EcoreUtil.equals((EObject)oldVars, (EObject)newVars)) {
                            new RebuildProjectsJob((IInterpreterInstall)event.getSource()).schedule(500L);
                        }
                    } else {
                        new RebuildProjectsJob((IInterpreterInstall)event.getSource()).schedule(500L);
                    }
                }
            }
        }

        private VariableMap locateVariableMap(Object value) {
            if (value instanceof List) {
                for (Object item : (List)value) {
                    if (!(item instanceof VariableMap)) continue;
                    return (VariableMap)item;
                }
            }
            return null;
        }

        public void interpreterRemoved(IInterpreterInstall Interpreter) {
        }
    }
}

