/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.net.URI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.rse.Messages;
import org.eclipse.dltk.core.internal.rse.RSEFileHandle;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.efs.RSEFileSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RSEEnvironment
implements IEnvironment,
IAdaptable {
    private IRemoteFileSubSystem fs;
    private IHost host;

    public RSEEnvironment(IRemoteFileSubSystem fs) {
        this.fs = fs;
        this.host = fs.getConnectorService().getHost();
    }

    public boolean isLocal() {
        return false;
    }

    public IFileHandle getFile(IPath path) {
        if (Path.EMPTY.equals((Object)path)) {
            throw new RuntimeException(Messages.RSEEnvironment_EmptyFileNameError);
        }
        return new RSEFileHandle(this, RSEEnvironment.getURIFor(this.host, path.toString()));
    }

    public String getId() {
        return "org.eclipse.dltk.rse.rseEnvironment." + this.host.getAliasName();
    }

    public String getSeparator() {
        return this.fs.getSeparator();
    }

    public char getSeparatorChar() {
        return this.fs.getSeparatorChar();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RSEEnvironment) {
            RSEEnvironment other = (RSEEnvironment)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getName() {
        return String.valueOf(this.host.getName()) + Messages.RSEEnvironment_EnvironmentNameSuffix;
    }

    public IHost getHost() {
        return this.host;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public URI getURI(IPath location) {
        return RSEEnvironment.getURIFor(this.host, location.toString());
    }

    public String convertPathToString(IPath path) {
        if (this.host.getSystemType().isWindows()) {
            return path.toString().replace('/', '\\');
        }
        return path.toString();
    }

    public IFileHandle getFile(URI locationURI) {
        if ("rse".equalsIgnoreCase(locationURI.getScheme()) && locationURI.getHost().equals(this.host.getHostName())) {
            return new RSEFileHandle(this, locationURI);
        }
        return null;
    }

    public String getPathsSeparator() {
        return Character.toString(this.getPathsSeparatorChar());
    }

    public char getPathsSeparatorChar() {
        return this.host.getSystemType().isWindows() ? (char)';' : ':';
    }

    public String getCanonicalPath(IPath path) {
        return this.convertPathToString(path);
    }

    public static URI getURIFor(IHost host, String path) {
        return RSEFileSystem.getURIFor((String)host.getHostName(), (String)path);
    }
}

