/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.tests.indenting;

import junit.framework.TestCase;
import org.eclipse.dltk.tcl.internal.ui.text.TclAutoEditStrategy;
import org.eclipse.dltk.tcl.internal.ui.text.TclPartitionScanner;
import org.eclipse.dltk.tcl.ui.TclPreferenceConstants;
import org.eclipse.dltk.tcl.ui.tests.TclUITestsPlugin;
import org.eclipse.dltk.tcl.ui.tests.indenting.DocCmd;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class SimpleIndentingTest
extends TestCase {
    private IPreferenceStore fStore;
    private TclAutoEditStrategy strategy;

    private static void installStuff(Document document) {
        String[] types = new String[]{"__tcl_string", "__tcl_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new TclPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__tcl_partitioning", (IDocumentPartitioner)partitioner);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fStore = TclUITestsPlugin.getDefault().getPreferenceStore();
        TclPreferenceConstants.initializeDefaultValues((IPreferenceStore)this.fStore);
        String fPartitioning = "__tcl_partitioning";
        this.strategy = new TclAutoEditStrategy(this.fStore, fPartitioning);
    }

    public void testParts() throws Exception {
        String text = "#comment one\n\t#another comment\n\nproc foo{} {\n\tset a \"test\"\n}\n#another comment";
        Document temp = new Document(text);
        SimpleIndentingTest.installStuff(temp);
        String fPartitioning = "__tcl_partitioning";
        ITypedRegion region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)1, (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_comment", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)0, (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(1) + 10), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_comment", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)temp.getLineOffset(2), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(4) + 2), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(4) + 10), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_string", (String)region.getType());
    }

    public void testParts2() throws Exception {
        String text = "\"(\"\ndflt";
        Document temp = new Document(text);
        SimpleIndentingTest.installStuff(temp);
        String fPartitioning = "__tcl_partitioning";
        ITypedRegion region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)1, (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_string", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)0, (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)2, (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_string", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)5, (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
    }

    public void testParts3() throws Exception {
        String text = "#asdfasdfasdf \\\nasdfasdfasdf\nasdf  ;  #sdfasdf\n    #asdfasdf\nasdfasd #adfsad\n#sdfasdf\n";
        Document temp = new Document(text);
        SimpleIndentingTest.installStuff(temp);
        String fPartitioning = "__tcl_partitioning";
        ITypedRegion region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)1, (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_comment", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(1) + 2), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_comment", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(2) + 2), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(2) + 13), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_comment", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(3) + 10), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_comment", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(3) + 1), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(4) + 2), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(4) + 12), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(5) + 1), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__tcl_comment", (String)region.getType());
    }

    public void testIndent00() throws Exception {
        String text = "#comment one\n\t#another comment\n\nproc foo{} {\n\tset a \"test\"\n}\n#another comment";
        Document temp = new Document(text);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        SimpleIndentingTest.installStuff(temp);
        int offset = temp.getLineOffset(3) + temp.getLineLength(3) - 1;
        DocumentCommand c = new DocumentCommand(){};
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = offset;
        c.text = "\n";
        this.strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        int newOffset = c.offset + (c.text == null ? 0 : c.text.length());
        if (c.caretOffset != -1) {
            newOffset = c.caretOffset;
        }
        temp.stopRewriteSession(session);
        String correct = "#comment one\n\t#another comment\n\nproc foo{} {\n\t\n\tset a \"test\"\n}\n#another comment";
        String result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
        SimpleIndentingTest.assertEquals((int)(offset + 2), (int)newOffset);
    }

    public void testIndent01() throws Exception {
        String text = "#comment one\n\t#another comment\n\nproc foo{} ";
        Document temp = new Document(text);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        SimpleIndentingTest.installStuff(temp);
        int offset = temp.getLineOffset(3) + temp.getLineLength(3);
        DocumentCommand c = new DocumentCommand(){};
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = offset;
        c.text = "{";
        this.strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        int newOffset = c.offset + (c.text == null ? 0 : c.text.length());
        if (c.caretOffset != -1) {
            newOffset = c.caretOffset;
        }
        temp.stopRewriteSession(session);
        String correct = "#comment one\n\t#another comment\n\nproc foo{} {}";
        String result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
        SimpleIndentingTest.assertEquals((int)(temp.getLineOffset(3) + 12), (int)newOffset);
        session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = newOffset;
        c.text = "\n";
        this.strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        newOffset = c.offset + (c.text == null ? 0 : c.text.length());
        if (c.caretOffset != -1) {
            newOffset = c.caretOffset;
        }
        temp.stopRewriteSession(session);
        correct = "#comment one\n\t#another comment\n\nproc foo{} {\n\t\n}";
        result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
        SimpleIndentingTest.assertEquals((int)(temp.getLineOffset(4) + 1), (int)newOffset);
    }

    public void testIndent02() throws Exception {
        String text = "#comment (one";
        Document temp = new Document(text);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        SimpleIndentingTest.installStuff(temp);
        int offset = temp.getLineOffset(0) + temp.getLineLength(0);
        DocumentCommand c = new DocumentCommand(){};
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = offset;
        c.text = "\n";
        this.strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        int newOffset = c.offset + (c.text == null ? 0 : c.text.length());
        if (c.caretOffset != -1) {
            newOffset = c.caretOffset;
        }
        temp.stopRewriteSession(session);
        String correct = "#comment (one\n";
        String result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
        SimpleIndentingTest.assertEquals((int)temp.getLineOffset(1), (int)newOffset);
    }

    public void testIndent03() throws Exception {
        String text = "set a = \"asdfasdf(ssdf\"";
        Document temp = new Document(text);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        SimpleIndentingTest.installStuff(temp);
        int offset = temp.getLineOffset(0) + temp.getLineLength(0);
        DocumentCommand c = new DocumentCommand(){};
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = offset;
        c.text = "\n";
        this.strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        int newOffset = c.offset + (c.text == null ? 0 : c.text.length());
        if (c.caretOffset != -1) {
            newOffset = c.caretOffset;
        }
        temp.stopRewriteSession(session);
        String correct = "set a = \"asdfasdf(ssdf\"\n";
        String result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
        SimpleIndentingTest.assertEquals((int)temp.getLineOffset(1), (int)newOffset);
    }

    public void testIndent04() throws Exception {
        String text = "set c {a, b, \n\td, e}";
        Document temp = new Document(text);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        SimpleIndentingTest.installStuff(temp);
        DocumentCommand c = new DocumentCommand(temp){
            {
                this.doit = true;
                this.caretOffset = -1;
                this.shiftsCaret = true;
                this.length = 0;
                this.offset = document.getLineOffset(1) + document.getLineLength(1);
                this.text = "\n";
            }
        };
        this.strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        int newOffset = c.offset + (c.text == null ? 0 : c.text.length());
        if (c.caretOffset != -1) {
            newOffset = c.caretOffset;
        }
        temp.stopRewriteSession(session);
        String correct = "set c {a, b, \n\td, e}\n";
        String result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
        SimpleIndentingTest.assertEquals((int)temp.getLineOffset(2), (int)newOffset);
    }

    public void testIndent06_pasting_hard() throws Exception {
        String text0 = TclUITestsPlugin.getDefault().getPluginFileContent("/tcls/interp.tcl");
        Document temp = new Document("");
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        SimpleIndentingTest.installStuff(temp);
        DocumentCommand c = new DocumentCommand(text0){
            {
                this.doit = true;
                this.caretOffset = -1;
                this.shiftsCaret = true;
                this.length = 0;
                this.offset = 0;
                this.text = string;
            }
        };
        this.fStore.setValue("smartPasteMode", 2);
        this.strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        temp.stopRewriteSession(session);
        SimpleIndentingTest.assertEquals((char)'#', (char)temp.getChar(0));
        SimpleIndentingTest.assertEquals((char)'i', (char)temp.getChar(temp.getLineOffset(2944) + 1));
        SimpleIndentingTest.assertEquals((char)'a', (char)temp.getChar(temp.getLineOffset(1990) + 1));
    }

    public void testIndent06_jumping() throws Exception {
        String text = "proc foo{} {\n\tproc doo {} {\n\t\t";
        Document temp = new Document(text);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        SimpleIndentingTest.installStuff(temp);
        DocumentCommand c = new DocumentCommand(temp){
            {
                this.doit = true;
                this.caretOffset = -1;
                this.shiftsCaret = true;
                this.length = 0;
                this.offset = document.getLineOffset(2);
                this.text = "\t";
            }
        };
        this.strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        int newOffset = c.offset + (c.text == null ? 0 : c.text.length());
        if (c.caretOffset != -1) {
            newOffset = c.caretOffset;
        }
        temp.stopRewriteSession(session);
        String correct = "proc foo{} {\n\tproc doo {} {\n\t\t";
        String result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
        SimpleIndentingTest.assertEquals((int)(temp.getLineOffset(2) + 2), (int)newOffset);
    }

    public void testIndent06_autoclose() throws Exception {
        String text = "proc foo{} {\n\tproc doo {} { set b 5\n\t\t\n#}";
        Document temp = new Document(text);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        SimpleIndentingTest.installStuff(temp);
        DocumentCommand c = new DocumentCommand(temp){
            {
                this.doit = true;
                this.caretOffset = -1;
                this.shiftsCaret = true;
                this.length = 0;
                this.offset = document.getLineOffset(1) + 15;
                this.text = "\n";
            }
        };
        this.strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        int newOffset = c.offset + (c.text == null ? 0 : c.text.length());
        if (c.caretOffset != -1) {
            newOffset = c.caretOffset;
        }
        temp.stopRewriteSession(session);
        String correct = "proc foo{} {\n\tproc doo {} { \n\t\tset b 5\n\t}\n\t\t\n#}";
        String result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
        SimpleIndentingTest.assertEquals((int)(temp.getLineOffset(2) + 2), (int)newOffset);
    }

    public void testAutoCloseWithNewLine() throws Exception {
        Document doc = new Document("{}");
        DocCmd cmd = new DocCmd(1, 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"\n\t\n", (String)cmd.text);
    }

    public void testAutoCloseWithNewLine2() throws Exception {
        Document doc = new Document("()");
        DocCmd cmd = new DocCmd(1, 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"\n \n", (String)cmd.text);
    }

    public void testAutoCloseWithNewLine3() throws Exception {
        Document doc = new Document("(");
        DocCmd cmd = new DocCmd(1, 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"\n \n)", (String)cmd.text);
    }

    public void testAutoCloseWithNewLine4() throws Exception {
        Document doc = new Document("{");
        DocCmd cmd = new DocCmd(1, 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"\n\t\n}", (String)cmd.text);
    }

    public void testAutoCloseCommon() throws Exception {
        DocCmd cmd = new DocCmd(0, 0, "{");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"{}", (String)cmd.text);
        SimpleIndentingTest.assertEquals((int)1, (int)cmd.caretOffset);
        cmd = new DocCmd(0, 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"()", (String)cmd.text);
        SimpleIndentingTest.assertEquals((int)1, (int)cmd.caretOffset);
        cmd = new DocCmd(0, 0, "[");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"[]", (String)cmd.text);
        SimpleIndentingTest.assertEquals((int)1, (int)cmd.caretOffset);
        cmd = new DocCmd(0, 0, "\"");
        this.strategy.customizeDocumentCommand((IDocument)new Document("\""), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"", (String)cmd.text);
        cmd = new DocCmd(0, 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document("("), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"(", (String)cmd.text);
        cmd = new DocCmd(1, 0, ")");
        this.strategy.customizeDocumentCommand((IDocument)new Document("()"), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"", (String)cmd.text);
        cmd = new DocCmd(1, 0, "\"");
        this.strategy.customizeDocumentCommand((IDocument)new Document("\"\""), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"\"", (String)cmd.text);
    }

    public void testAutoCloseSmart() throws Exception {
        DocCmd cmd = new DocCmd(0, 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document(")"), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"(", (String)cmd.text);
        cmd = new DocCmd(0, 0, "{");
        this.strategy.customizeDocumentCommand((IDocument)new Document("\n\thi!!!\n}"), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"{", (String)cmd.text);
    }

    public void testNewLine0() throws Exception {
        DocCmd cmd = new DocCmd("proc foo { ".length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document("proc foo { doo"), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"\n\tdoo\n}", (String)cmd.text);
    }

    public void testNewLine1() throws Exception {
        DocCmd cmd = new DocCmd("proc foo { ".length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document("proc foo { doo"), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"\n\tdoo\n}", (String)cmd.text);
    }

    public void testCloseBrace() throws Exception {
        String text = "\tproc foo {\n\t\tdoo\n\t\t";
        DocCmd cmd = new DocCmd(text.length(), 0, "}");
        this.strategy.customizeDocumentCommand((IDocument)new Document(text), (DocumentCommand)cmd);
        SimpleIndentingTest.assertEquals((String)"\t}", (String)cmd.text);
        SimpleIndentingTest.assertEquals((int)(text.length() - 2), (int)cmd.offset);
    }

    public void testSmartPaste2() throws Exception {
        Document d = new Document("proc foo{} {\n\t\n");
        DocCmd cmd = new DocCmd("proc foo{} {\n\t".length(), 0, "\t\tset a 5\n\t\tset b 6\n\t}\n");
        this.fStore.setValue("smartPasteMode", 1);
        this.strategy.customizeDocumentCommand((IDocument)d, (DocumentCommand)cmd);
        d.replace(cmd.offset, cmd.length, cmd.text);
        SimpleIndentingTest.assertEquals((String)"proc foo{} {\n\tset a 5\n\tset b 6\n}\n\n", (String)d.get());
    }
}

