/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.debug.tests.Activator;

public class MyDebugTests
extends SuiteOfTestCases {
    public MyDebugTests(String name) {
        super(name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    protected IProject getProject(String project) {
        return this.getWorkspaceRoot().getProject(project);
    }

    protected IProject createProject(String projectName) throws CoreException {
        final IProject project = this.getProject(projectName);
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(null);
                project.open(null);
            }
        };
        this.getWorkspace().run(create, null);
        return project;
    }

    protected File getPluginDirectoryPath() {
        try {
            URL url = Activator.getDefault().getBundle().getEntry("/");
            return new File(FileLocator.toFileURL((URL)url).getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public File getSourceWorkspacePath() {
        return new File(this.getPluginDirectoryPath(), "workspace");
    }

    protected IProject createProjectWithContent(String projectName) throws CoreException, IOException {
        File source = this.getSourceWorkspacePath();
        File target = this.getWorkspaceRoot().getLocation().toFile();
        FileHelper.copyDirectory(new File(source, projectName), new File(target, projectName));
        return this.createProject(projectName);
    }

    protected IScriptProject createScriptProject(final String projectName, final String[] natureIds) throws CoreException {
        final IScriptProject[] result = new IScriptProject[1];
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = MyDebugTests.this.createProject(projectName);
                IProjectDescription description = project.getDescription();
                description.setNatureIds(natureIds);
                project.setDescription(description, null);
                result[0] = DLTKCore.create((IProject)project);
            }
        };
        this.getWorkspace().run(create, null);
        return result[0];
    }

    private static class FileHelper {
        private FileHelper() {
        }

        public static byte[] readFile(File file) throws IOException {
            int fileLength = (int)file.length();
            byte[] fileBytes = new byte[fileLength];
            FileInputStream stream = new FileInputStream(file);
            int bytesRead = 0;
            int lastReadSize = 0;
            while (lastReadSize != -1 && bytesRead != fileLength) {
                lastReadSize = stream.read(fileBytes, bytesRead, fileLength - bytesRead);
                bytesRead += lastReadSize;
            }
            stream.close();
            return fileBytes;
        }

        public static void copyDirectory(File source, File target) throws IOException {
            File[] files;
            if (!target.exists()) {
                target.mkdirs();
            }
            if ((files = source.listFiles()) == null) {
                return;
            }
            int i = 0;
            while (i < files.length) {
                File sourceChild = files[i];
                String name = sourceChild.getName();
                if (!name.equals("CVS")) {
                    File targetChild = new File(target, name);
                    if (sourceChild.isDirectory()) {
                        FileHelper.copyDirectory(sourceChild, targetChild);
                    } else {
                        FileHelper.copyFile(sourceChild, targetChild);
                    }
                }
                ++i;
            }
        }

        public static void copyFile(File source, File target) throws IOException {
            byte[] srcBytes = FileHelper.readFile(source);
            FileOutputStream out = new FileOutputStream(target);
            out.write(srcBytes);
            out.close();
        }
    }
}

