/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerMessageFilter;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblem;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblemDescription;
import org.eclipse.jface.preference.IPreferenceStore;

public final class TclCheckerHelper {
    private static final String REGEX = "(\\w+):(\\d+)\\s+\\((\\w+)\\)\\s+(.*)";
    private static final String QUIET_OPTION = "-quiet";
    private static final String W1_OPTION = "-W1";
    private static final String W2_OPTION = "-W2";
    private static final String W3_OPTION = "-W3";
    private static final String SUPPRESS_OPTION = "-suppress";
    private static final Pattern pattern = Pattern.compile("(\\w+):(\\d+)\\s+\\((\\w+)\\)\\s+(.*)");

    private TclCheckerHelper() {
    }

    private static String[] makeTclCheckerCmdLine(IPreferenceStore store) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(store.getString("tclchecker.path"));
        cmdLine.add(QUIET_OPTION);
        int mode = store.getInt("tclchecker.mode");
        if (mode == 0) {
            cmdLine.add(W1_OPTION);
        } else if (mode == 1) {
            cmdLine.add(W2_OPTION);
        } else if (mode == 2) {
            cmdLine.add(W3_OPTION);
        }
        List problems = TclCheckerProblemDescription.getProblemIdentifiers();
        Iterator it = problems.iterator();
        while (it.hasNext()) {
            String warningName = (String)it.next();
            if (!store.getBoolean(warningName)) continue;
            cmdLine.add(SUPPRESS_OPTION);
            cmdLine.add(warningName);
        }
        return cmdLine.toArray(new String[cmdLine.size()]);
    }

    public static boolean canExecuteTclChecker(IPreferenceStore store) {
        File file = new File(store.getString("tclchecker.path"));
        return file.exists();
    }

    public static TclCheckerProblem parseProblem(String problem, TclCheckerMessageFilter filter) {
        Matcher matcher = pattern.matcher(problem);
        if (!matcher.find()) {
            return null;
        }
        String file = matcher.group(1);
        int lineNumber = Integer.parseInt(matcher.group(2));
        String messageID = matcher.group(3);
        String message = matcher.group(4);
        if (filter != null && !filter.accept(messageID)) {
            return null;
        }
        return new TclCheckerProblem(file, lineNumber, messageID, message);
    }

    /*
     * Exception decompiling
     */
    public static String[] execTclChecker(String code, IPreferenceStore store) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 51->54)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

