/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptBreakpointListener;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.ScriptEvaluationContextManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;

public class ScriptDebugOptionsManager
implements IDebugEventSetListener,
IPropertyChangeListener,
IScriptBreakpointListener,
ILaunchListener,
IBreakpointsListener {
    private static ScriptDebugOptionsManager instance;
    private static ILabelProvider fLabelProvider;

    static {
        fLabelProvider = DebugUITools.newDebugModelPresentation();
    }

    protected void updateBreakpointHitCounts(IBreakpoint[] breakpoints, IScriptThread thread) {
        int j = 0;
        while (j < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[j];
            if (breakpoint instanceof IScriptBreakpoint) {
                IScriptBreakpoint scriptBreakpoint = (IScriptBreakpoint)breakpoint;
                try {
                    String id = scriptBreakpoint.getIdentifier();
                    IDbgpBreakpoint br = thread.getDbgpBreakpoint(id);
                    int hitCount = br.getHitCount();
                    scriptBreakpoint.setHitCount(hitCount);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++j;
        }
    }

    protected void updateBreakpoinHitCountsToDefualt(IBreakpoint[] breakpoints) {
        int j = 0;
        while (j < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[j];
            if (breakpoint instanceof IScriptBreakpoint) {
                try {
                    ((IScriptBreakpoint)breakpoint).setHitCount(-1);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++j;
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IBreakpoint[] breakpoints;
            DebugEvent event = events[i];
            int kind = event.getKind();
            Object source = event.getSource();
            if (kind == 2) {
                if (source instanceof IScriptThread) {
                    IScriptThread thread = (IScriptThread)source;
                    breakpoints = thread.getBreakpoints();
                    this.updateBreakpointHitCounts(breakpoints, thread);
                    this.updateBreakpointMessages(breakpoints);
                }
            } else if (kind == 8 && source instanceof IScriptDebugTarget) {
                String debugModelId = ((IScriptDebugTarget)source).getModelIdentifier();
                breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(debugModelId);
                this.updateBreakpoinHitCountsToDefualt(breakpoints);
                this.updateBreakpointMessages(breakpoints);
            }
            ++i;
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        ArrayList<IBreakpoint> update = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            try {
                if (breakpoint instanceof IScriptBreakpoint && breakpoint.getMarker().getAttribute("message") == null) {
                    update.add(breakpoint);
                }
            }
            catch (CoreException e) {
                DLTKDebugUIPlugin.log(e);
            }
            ++i;
        }
        if (!update.isEmpty()) {
            this.updateBreakpointMessages(update.toArray(new IBreakpoint[update.size()]));
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.updateBreakpointMessages(breakpoints);
    }

    private void updateBreakpointMessages(final IBreakpoint[] breakpoints) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < breakpoints.length) {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (breakpoint instanceof IScriptBreakpoint) {
                        String info = fLabelProvider.getText((Object)breakpoint);
                        breakpoint.getMarker().setAttribute("message", (Object)info);
                    }
                    ++i;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.log(e);
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public static ScriptDebugOptionsManager getDefault() {
        if (instance == null) {
            instance = new ScriptDebugOptionsManager();
        }
        return instance;
    }

    public void startup() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
        debugPlugin.getLaunchManager().addLaunchListener((ILaunchListener)this);
        debugPlugin.getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        ScriptEvaluationContextManager.startup();
    }

    public void shutdown() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        debugPlugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
        debugPlugin.getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        if (!DLTKDebugUIPlugin.getDefault().isShuttingDown()) {
            DLTKDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        System.getProperties().remove(String.valueOf(DLTKDebugUIPlugin.getUniqueIdentifier()) + ".debuggerActive");
    }

    public void propertyChange(PropertyChangeEvent event) {
    }
}

