/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference.evaluators;

import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.typeinference.ConstantTypeGoal;
import org.eclipse.dltk.ruby.typeinference.DefaultRubyEvaluatorFactory;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ruby.typeinference.goals.NonTypeConstantTypeGoal;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class ConstantReferenceEvaluator
extends GoalEvaluator {
    private IEvaluatedType result;
    private IGoal helperGoal;

    public ConstantReferenceEvaluator(IGoal goal) {
        super(goal);
    }

    private ConstantTypeGoal getTypedGoal() {
        return (ConstantTypeGoal)DefaultRubyEvaluatorFactory.translateGoal(this.goal);
    }

    private ISourceModuleContext getTypedContext() {
        return (ISourceModuleContext)this.goal.getContext();
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] init() {
        this.helperGoal = null;
        ISourceModuleContext typedContext = this.getTypedContext();
        ConstantTypeGoal typedGoal = this.getTypedGoal();
        String constantName = typedGoal.getName();
        int calculationOffset = typedGoal.getOffset();
        String elementKey = RubyTypeInferencingUtils.searchConstantElement(typedContext.getRootNode(), calculationOffset, constantName);
        IMixinElement constantElement = null;
        if (elementKey != null) {
            constantElement = RubyMixinModel.getRawInstance().get(elementKey);
        }
        if (constantElement == null) {
            return IGoal.NO_GOALS;
        }
        Object[] realObjs = constantElement.getAllObjects();
        int i = 0;
        while (i < realObjs.length) {
            RubyMixinElementInfo realObj = (RubyMixinElementInfo)realObjs[i];
            if (realObj != null) {
                if (realObj.getKind() == 0 || realObj.getKind() == 1) {
                    this.result = new RubyClassType(constantElement.getKey());
                    break;
                }
                if (realObj.getKind() != 3) break;
                constantElement.getAllObjects();
                this.helperGoal = new NonTypeConstantTypeGoal(this.goal.getContext(), constantElement);
                break;
            }
            ++i;
        }
        if (this.helperGoal != null) {
            return new IGoal[]{this.helperGoal};
        }
        return IGoal.NO_GOALS;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        this.result = (IEvaluatedType)result;
        return IGoal.NO_GOALS;
    }
}

