/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.screenreader.windoweyes.engine;

import org.eclipse.actf.ai.screenreader.windoweyes.engine.IGWSpeak;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.util.win32.COMUtil;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.widgets.Display;

public class GWSpeak
implements ITTSEngine {
    private IGWSpeak dispGWSpeak = null;
    private IVoiceEventListener eventListener = null;
    private boolean notifyEndOfSpeech = false;
    private long lastNotificationTime = 0L;
    private static final int DELAY_FIRST = 500;
    private static final int DELAY_NEXT = 1000;
    private static final String GWM_WINDOW_CLASS = "GWMExternalControl";
    private static final String GWM_WINDOW_NAME = "External Control";
    private boolean isDisposed = false;

    public GWSpeak() {
        int pv;
        if (WindowUtil.FindWindow((String)GWM_WINDOW_CLASS, (String)GWM_WINDOW_NAME) != 0 && (pv = COMUtil.createDispatch((GUID)IGWSpeak.IID)) != 0) {
            this.dispGWSpeak = new IGWSpeak(pv);
            Display.getCurrent().disposeExec(new Runnable(){

                public void run() {
                    GWSpeak.this.dispose();
                }
            });
        }
    }

    public void dispose() {
        this.isDisposed = true;
        if (this.dispGWSpeak != null) {
            this.eventListener = null;
            this.stop();
            this.dispGWSpeak.Release();
            this.dispGWSpeak = null;
        }
    }

    public boolean isAvailable() {
        return this.dispGWSpeak != null;
    }

    public void setEventListener(IVoiceEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void speak(String text, int flags, int index) {
        boolean flushBeforeSpeak;
        if (this.dispGWSpeak == null) {
            return;
        }
        boolean bl = flushBeforeSpeak = (1 & flags) != 0;
        if (flushBeforeSpeak && 0L != this.lastNotificationTime) {
            flushBeforeSpeak = index >= 0 ? false : System.currentTimeMillis() - this.lastNotificationTime > 200L;
        }
        char[] data = (String.valueOf(text) + "\u0000").toCharArray();
        int bstrText = MemoryUtil.SysAllocString((char[])data);
        try {
            if (flushBeforeSpeak) {
                this.dispGWSpeak.Silence();
            }
            this.dispGWSpeak.SpeakString(bstrText);
            if (index >= 0 && this.eventListener != null) {
                this.eventListener.indexReceived(index);
                this.notifyEndOfSpeech = true;
                int delay = 0L == this.lastNotificationTime ? 500 : 1000;
                Display.getCurrent().timerExec(delay, new Runnable(){

                    public void run() {
                        if (GWSpeak.this.eventListener != null && GWSpeak.this.notifyEndOfSpeech) {
                            GWSpeak.this.eventListener.indexReceived(-1);
                            GWSpeak.this.lastNotificationTime = System.currentTimeMillis();
                        }
                        GWSpeak.this.notifyEndOfSpeech = false;
                    }
                });
            }
            this.lastNotificationTime = 0L;
        }
        finally {
            MemoryUtil.SysFreeString((int)bstrText);
        }
    }

    public void stop() {
        if (this.dispGWSpeak == null) {
            return;
        }
        this.notifyEndOfSpeech = false;
        this.lastNotificationTime = 0L;
        this.dispGWSpeak.Silence();
    }

    public int getSpeed() {
        return 50;
    }

    public void setGender(String gender) {
    }

    public void setLanguage(String language) {
    }

    public void setSpeed(int speed) {
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

