/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.impl;

import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import org.eclipse.actf.ai.audio.io.AudioFactory;
import org.eclipse.actf.ai.audio.io.IAudioPipe;
import org.eclipse.actf.ai.audio.io.IAudioReader;
import org.eclipse.actf.ai.audio.io.IAudioWriter;
import org.eclipse.actf.ai.fennec.IFennecEntry;
import org.eclipse.actf.ai.fennec.IFennecMediator;
import org.eclipse.actf.ai.fennec.treemanager.IAccessKeyList;
import org.eclipse.actf.ai.fennec.treemanager.ILocation;
import org.eclipse.actf.ai.fennec.treemanager.IMediaSyncEventListener;
import org.eclipse.actf.ai.fennec.treemanager.ISoundControl;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.fennec.treemanager.ITreeManager;
import org.eclipse.actf.ai.fennec.treemanager.IVideoControl;
import org.eclipse.actf.ai.fennec.treemanager.TreeManagerException;
import org.eclipse.actf.ai.fennec.treemanager.TreeManagerInterruptedException;
import org.eclipse.actf.ai.internal.navigator.NavigatorPlugin;
import org.eclipse.actf.ai.navigator.IManipulator;
import org.eclipse.actf.ai.navigator.IMediaControl;
import org.eclipse.actf.ai.navigator.INavigatorUI;
import org.eclipse.actf.ai.navigator.extension.ManipulatorExtension;
import org.eclipse.actf.ai.navigator.extension.MediaControlExtension;
import org.eclipse.actf.ai.navigator.extension.ScreenReaderExtension;
import org.eclipse.actf.ai.navigator.impl.AccessKeyListDialog;
import org.eclipse.actf.ai.navigator.impl.FormInputDialog;
import org.eclipse.actf.ai.navigator.impl.FormSelectDialog;
import org.eclipse.actf.ai.navigator.impl.SearchDialog;
import org.eclipse.actf.ai.navigator.impl.WebEventListener;
import org.eclipse.actf.ai.navigator.util.MessageFormatter;
import org.eclipse.actf.ai.navigator.views.NavigatorTreeView;
import org.eclipse.actf.ai.navigator.voice.VoiceManager;
import org.eclipse.actf.ai.voice.IVoice;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.ui.util.BrowserLaunch;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.util.ApplicationArgumentUtil;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.IProposition;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class NavigatorImpl
implements INavigatorUI,
IVoiceEventListener {
    private static boolean isDemo = ApplicationArgumentUtil.isAvailable((String)"-demo");
    private IWebBrowserACTF webBrowser;
    private IFennecMediator fennecMediator;
    private ITreeManager treeManager;
    private final int maxRetry;
    private final int retryInterval;
    private Display display;
    private IManipulator.Mode mode;
    private static IAudioPipe audio;
    private final VoiceManager voiceManager = new VoiceManager(this);
    private boolean speakAllMode = false;
    private int vcCount;
    private int scCount;
    private ITreeItem lastHighlighted;
    private boolean listJumping = false;
    private int currentFennecIdx = 1;
    private IFennecEntry currentEntry = null;
    private ILocation locationToBeRestored;
    private MediaControlHandle handle = new MediaControlHandle();
    MovieStartListener listener = null;
    private long progressTimer = 0L;
    private static final int progressInterval = 2000;
    private int prevPercent = -4;

    static {
        URL url = NavigatorPlugin.getDefault().getBundle().getResource("waiting.wav");
        IAudioReader reader = AudioFactory.createAudioReader((URL)url);
        IAudioWriter writer = AudioFactory.createDefaultWriter();
        audio = AudioFactory.createLoopedAudioPipe((IAudioReader)reader, (IAudioWriter)writer);
        audio.setBufferSize(100);
        audio.setInterval(1);
        audio.prepare();
    }

    public NavigatorImpl(WebEventListener webEventListener, IWebBrowserACTF webBrowser, int maxRetry, int retryInterval) {
        this.webBrowser = webBrowser;
        this.maxRetry = maxRetry;
        this.retryInterval = retryInterval;
        this.display = Display.getCurrent();
    }

    public ITreeManager getTreeManager() {
        return this.treeManager;
    }

    private NavigatorTreeView getNavigatorTreeView() {
        return NavigatorPlugin.getDefault().getNavigatorTreeView();
    }

    private void sleep(int interval) {
        long startTime = System.currentTimeMillis();
        do {
            boolean busy;
            if (busy = this.display.readAndDispatch()) continue;
            this.display.sleep();
        } while (System.currentTimeMillis() - startTime <= (long)interval);
    }

    private void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    private void startProgress() {
        this.startProgress(2000);
    }

    private void startProgress(int msec) {
        audio.start(msec);
    }

    private void endProgress() {
        audio.stop();
    }

    protected MessageFormatter getMessageFormatter() {
        return this.voiceManager.getMessageFormatter();
    }

    private VoiceManager getVoiceManager() {
        return this.voiceManager;
    }

    public void indexReceived(int index) {
        if (this.speakAllMode && index == -1) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    NavigatorImpl.this.traverseDownAll();
                }
            });
        } else if (index == -2) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    NavigatorImpl.this.stopSpeak();
                }
            });
        }
    }

    protected void speakWithFormat(String str) {
        this.speakWithFormat(str, false);
    }

    protected void speakWithFormat(String str, boolean flush) {
        this.speak(this.getMessageFormatter().mes(str), flush, true);
    }

    protected void speak(String str, boolean flush) {
        this.speak(str, flush, true);
    }

    protected void speak(String str, boolean flush, boolean maleVoice) {
        if (this.speakAllMode) {
            this.getVoiceManager().speakWithCallback(str, flush, maleVoice);
        } else {
            this.getVoiceManager().speak(str, flush, maleVoice);
        }
    }

    private void stopSpeakAll() {
        this.speakAllMode = false;
    }

    public void speakAll() {
        this.speakAllMode = true;
        try {
            this.speakActiveItem(true, false, JumpMode.NONE);
        }
        catch (TreeManagerException e) {
            e.printStackTrace();
        }
    }

    public void traverseDownAll() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                return NavigatorImpl.this.treeManager.traverse(false);
            }

            public void after(int st) throws TreeManagerException {
                NavigatorImpl.this.afterMoveForSpeakAll(st, "Navigator.BOTTOM");
            }
        });
    }

    private void afterMoveForSpeakAll(int st, String notMoved) throws TreeManagerException {
        if ((st & 8) != 0) {
            this.speakWithFormat("Navigator.CLICK");
        }
        if ((st & 1) != 0) {
            this.speakActiveItem(true, false, JumpMode.NONE);
            this.sayLevel();
        } else {
            this.speakAllMode = false;
            this.sayLevel(notMoved);
        }
    }

    public void stopSpeak() {
        this.endProgress();
        this.stopSpeakAll();
        this.getVoiceManager().stop();
    }

    private void sayMode(IManipulator.Mode mode) {
        this.speakWithFormat(String.valueOf(mode.name) + " mode");
    }

    private void sayLevel(String prefix) throws TreeManagerException {
        String mes = this.getMessageFormatter().mes(prefix);
        this.speak(String.valueOf(mes) + " " + this.getLevelMessage(), true, true);
    }

    private String getLevelMessage() throws TreeManagerException {
        int level = this.treeManager.getLevel();
        String mesLv = level > 0 ? this.getMessageFormatter().mes("Navigator.LEVEL", new Object[]{new Integer(level)}) : this.getMessageFormatter().mes("Navigator.TOP_LEVEL");
        return mesLv;
    }

    private void sayLevel() throws TreeManagerException {
    }

    private void sayRetrial() {
        this.speak(this.getMessageFormatter().mes("Navigator.UNDONE"), true, true);
    }

    private void speakVideoInfo(boolean flag) throws TreeManagerException {
        IVideoControl vc = this.treeManager.getVideoControl();
        if (flag || this.vcCount != vc.getCount()) {
            this.vcCount = vc.getCount();
            if (this.vcCount == 0) {
                this.speakWithFormat("Navigator.NOVIDEO");
            } else if (this.vcCount == 1) {
                this.speakWithFormat("Navigator.SINGLEVIDEO");
            } else {
                String text = this.getMessageFormatter().mes("Navigator.VIDEOCOUNT", new Object[]{this.vcCount});
                this.speak(text, false, false);
            }
        }
    }

    private void speakSoundInfo(boolean flag) throws TreeManagerException {
        ISoundControl sc = this.treeManager.getSoundControl();
        if (flag || this.scCount != sc.getCount()) {
            this.scCount = sc.getCount();
            if (this.scCount == 0) {
                this.speakWithFormat("Navigator.NOSOUND");
            } else if (this.scCount == 1) {
                this.speakWithFormat("Navigator.SINGLESOUND");
            } else {
                String text = this.getMessageFormatter().mes("Navigator.SOUNDCOUNT", new Object[]{this.scCount});
                this.speak(text, false, false);
            }
        }
    }

    private void speakMediaInfo() throws TreeManagerException {
        IVideoControl vc = this.treeManager.getVideoControl();
        StringBuffer buf = new StringBuffer();
        if (vc.getCount() > 0) {
            buf.append(this.getMessageFormatter().mes("Navigator.VIDEO_AT", this.formatTime(vc.getCurrentPosition())));
        }
        if (vc.getTotalLength() > 0.0) {
            buf.append(this.getMessageFormatter().mes("Navigator.VIDEO_TOTAL", this.formatTime(vc.getTotalLength())));
        }
        this.vcCount = vc.getCount();
        if (this.vcCount == 0) {
            this.speakWithFormat("Navigator.NOVIDEO");
        } else if (this.vcCount == 1) {
            this.speakWithFormat("Navigator.SINGLEVIDEO");
        } else {
            int index = vc.getIndex();
            String text = this.getMessageFormatter().mes("Navigator.VIDEOINDEX", new Object[]{index, this.vcCount});
            this.speak(text, false, false);
        }
        this.speak(buf.toString(), false, false);
    }

    private String formatTime(double currentPosition) {
        int s = (int)currentPosition;
        int m = s / 60;
        int h = (s %= 60) / 60;
        m %= 60;
        if (h > 0) {
            return this.getMessageFormatter().mes("Navigator.HH_MM_SS", new Object[]{s, m, h});
        }
        if (m > 0) {
            return this.getMessageFormatter().mes("Navigator.MM_SS", new Object[]{s, m});
        }
        return this.getMessageFormatter().mes("Navigator.SS", new Object[]{s});
    }

    private void speakPageInfo() {
        try {
            this.speakVideoInfo(false);
            this.speakSoundInfo(false);
            MediaControlExtension.speakInfo(false);
        }
        catch (TreeManagerException treeManagerException) {}
    }

    private void sayFennecName(String fennecName, boolean flag) {
        String text = this.getMessageFormatter().mes("Navigator.FENNEC_NAME", new Object[]{fennecName});
        this.speak(text, flag, true);
    }

    private void sayNoFennec(boolean flag) {
        this.speakWithFormat("Navigator.NO_FENNEC", flag);
    }

    public void speakCurrentStatus() {
        this.sayMode(this.mode);
        try {
            this.speakActiveItem(false, true, JumpMode.NONE);
            this.speakPageInfo();
        }
        catch (TreeManagerException treeManagerException) {}
    }

    public void speakMediaStatus() {
        try {
            this.speakMediaInfo();
        }
        catch (TreeManagerException treeManagerException) {}
    }

    public void speakTab(boolean flush) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        IEditorReference[] erefs = page.getEditorReferences();
        boolean found = false;
        int index = 0;
        int total = 0;
        int i = 0;
        while (i < erefs.length) {
            if (!found) {
                ++index;
            }
            ++total;
            if (erefs[i].getEditor(false).equals(editor)) {
                found = true;
            }
            ++i;
        }
        String buf = "";
        buf = total == 1 ? editor.getTitle() : this.getMessageFormatter().mes("Navigator.MOVE_TAB", editor.getTitle(), index, total);
        this.speak(buf, flush, false);
        this.stopSpeakAll();
    }

    private void highlight(ITreeItem item) {
        if (this.lastHighlighted != null) {
            try {
                this.lastHighlighted.unhighlight();
            }
            catch (TreeManagerException treeManagerException) {}
        }
        try {
            item.highlight();
        }
        catch (TreeManagerException treeManagerException) {}
        this.lastHighlighted = item;
        this.sleep(1);
    }

    private void speakActiveItem(boolean flush, boolean verbose, JumpMode jumpMode) throws TreeManagerException {
        String desc;
        this.endProgress();
        ITreeItem item = this.treeManager.getActiveItem();
        ITreeItem[] siblings = this.treeManager.getSiblings();
        MessageFormatter mf = this.getMessageFormatter();
        if (item == null) {
            return;
        }
        this.highlight(item);
        this.getNavigatorTreeView().showItem(item);
        int idx = item.getNth();
        int st = this.intervalStart(siblings, idx);
        int end = this.intervalEnd(siblings, idx);
        StringBuffer bufUIStr = new StringBuffer();
        int i = st;
        while (i <= end) {
            if (i < siblings.length) {
                bufUIStr.append(siblings[i].getUIString());
            } else {
                System.err.println("st " + st + ", end " + end + ", siblings.length " + siblings.length);
            }
            ++i;
        }
        char accessKey = item.getAccessKey();
        String uiStr = bufUIStr.toString();
        String label = item.getFormLabel();
        String speak = uiStr;
        boolean isLink = Vocabulary.isLink().eval((IEvalTarget)item);
        short hl = item.getHeadingLevel();
        boolean isHeading = hl > 0;
        boolean isListItem = Vocabulary.isListItem().eval((IEvalTarget)item);
        boolean isListTop = Vocabulary.isListTop().eval((IEvalTarget)item);
        boolean isCheckbox = Vocabulary.isCheckbox().eval((IEvalTarget)item);
        boolean isRadio = Vocabulary.isRadio().eval((IEvalTarget)item);
        boolean isCombobox = Vocabulary.isCombobox().eval((IEvalTarget)item);
        boolean isButton = Vocabulary.isButton().eval((IEvalTarget)item);
        boolean isPassword = Vocabulary.isPassword().eval((IEvalTarget)item);
        boolean isTextbox = Vocabulary.isTextbox().eval((IEvalTarget)item);
        boolean isTextarea = Vocabulary.isMultilineEdit().eval((IEvalTarget)item);
        boolean isFileEdit = Vocabulary.isFileEdit().eval((IEvalTarget)item);
        boolean isChecked = Vocabulary.isChecked().eval((IEvalTarget)item);
        boolean isClickable = Vocabulary.isClickable().eval((IEvalTarget)item);
        boolean isFlashTopNode = Vocabulary.isFlashTopNode().eval((IEvalTarget)item);
        boolean isFlashLastNode = Vocabulary.isFlashLastNode().eval((IEvalTarget)item);
        boolean isMedia = Vocabulary.isMedia().eval((IEvalTarget)item);
        if (isButton) {
            String widget = mf.mes("Navigator.BUTTON");
            speak = uiStr.matches("[0-9]+") ? mf.concat(widget, uiStr) : mf.concat(uiStr, widget);
        } else if (isLink) {
            boolean isVisitedLink = Vocabulary.isVisitedLink().eval((IEvalTarget)item);
            String widget = mf.mes(isVisitedLink ? "Navigator.VISITED_LINK" : "Navigator.LINK");
            speak = jumpMode == JumpMode.LINK ? mf.concat(uiStr, widget) : mf.concat(widget, uiStr);
        } else if (isPassword) {
            if (uiStr.length() > 0) {
                uiStr = mf.mes("Navigator.PASSWORD_STAR3");
            }
            String widget = mf.mes("Navigator.PASSWORD");
            speak = jumpMode == JumpMode.LINK ? mf.concat(label, widget, uiStr) : mf.concat(uiStr, widget);
        } else if (isFileEdit) {
            String widget = mf.mes("Navigator.FILE_UPLOAD");
            speak = jumpMode == JumpMode.LINK ? mf.concat(label, widget, uiStr) : mf.concat(widget, uiStr);
        } else if (isTextarea) {
            String widget = mf.mes(uiStr.length() == 0 ? "Navigator.TEXTAREA_EMPTY" : "Navigator.TEXTAREA");
            speak = jumpMode == JumpMode.LINK ? mf.concat(label, widget) : widget;
        } else if (isTextbox) {
            String widget = mf.mes("Navigator.TEXTBOX");
            speak = jumpMode == JumpMode.LINK ? mf.concat(label, widget, uiStr) : mf.concat(widget, uiStr);
        } else if (isCheckbox) {
            String widget = mf.mes("Navigator.CHECKBOX");
            String checked = mf.mes(isChecked ? "Navigator.CHECKED" : "Navigator.NOT_CHECKED");
            speak = jumpMode == JumpMode.LINK ? mf.concat(label, widget, checked) : mf.concat(widget, checked, label);
        } else if (isRadio) {
            String widget = mf.mes("Navigator.RADIO");
            String checked = mf.mes(isChecked ? "Navigator.CHECKED" : "Navigator.NOT_CHECKED");
            int index = item.getRadioIndex();
            int total = item.getRadioTotal();
            String nm = "";
            if (index != 0 && total != 0) {
                nm = mf.mes("Navigator.N_OF_M", index, total);
            }
            speak = jumpMode == JumpMode.LINK ? mf.concat(label, widget, checked, nm) : mf.concat(widget, checked, nm, label);
        } else if (isCombobox) {
            int[] indices = item.getSelectedIndices();
            int total = item.getOptionsCount();
            if (indices.length > 0) {
                StringBuffer sb = new StringBuffer();
                int i2 = 0;
                while (i2 < indices.length) {
                    sb.append(String.valueOf(mf.mes("Navigator.COMBO_BOX")) + " ");
                    sb.append(item.getOptionTextAt(indices[i2]));
                    sb.append(" " + mf.mes("Navigator.N_OF_M", indices[i2] + 1, total) + " ");
                    ++i2;
                }
                speak = mf.concat(uiStr, sb.toString());
            } else {
                speak = mf.concat(uiStr, mf.mes("Navigator.NO_SELECTION"));
            }
            if (jumpMode == JumpMode.LINK) {
                speak = mf.concat(label, uiStr);
            }
        } else if (isFlashTopNode) {
            boolean isMSAAFlash = Vocabulary.isMSAAFlash().eval((IEvalTarget)item);
            speak = isMSAAFlash ? mf.concat(speak, mf.mes("Navigator.MSAA_FLASH_CONTENT")) : mf.concat(speak, mf.mes("Navigator.FLASH_CONTENT"));
        } else if (isFlashLastNode) {
            speak = mf.mes("Navigator.FLASH_END");
        }
        if (speak.length() == 0 && isClickable) {
            speak = "Clickable";
        }
        if (isHeading) {
            String widget = mf.mes("Navigator.HEADING");
            String level = mf.mes("Navigator.LEVEL", hl);
            speak = jumpMode == JumpMode.HEADING ? mf.concat(speak, widget, level) : mf.concat(widget, level, speak);
        }
        if (isMedia) {
            String media = mf.mes("Navigator.MEDIA");
            speak = mf.concat(media, speak);
        }
        if (isListItem) {
            int index = item.getListIndex();
            int total = item.getListTotal();
            if (total > 1) {
                String nm = mf.mes("Navigator.N_OF_M", index, total);
                speak = mf.concat(speak, nm);
                if (this.listJumping && (jumpMode == JumpMode.LISTITEM_TOP && index == 1 || jumpMode == JumpMode.LISTITEM_BOTTOM && index == total)) {
                    this.beep();
                }
                this.listJumping = true;
            }
        } else {
            this.listJumping = false;
        }
        if (isListTop) {
            ITreeItem[] children = item.getChildItems();
            int n = 0;
            int i3 = 0;
            while (i3 < children.length) {
                if (Vocabulary.isListItem().eval((IEvalTarget)children[i3])) {
                    ++n;
                }
                ++i3;
            }
            speak = mf.concat(speak, uiStr, mf.mes("Navigator.LIST_TOP", n));
        }
        if (accessKey != '\u0000') {
            speak = mf.concat(speak, mf.mes("Navigator.ACCESSKEY_GUIDE", Character.valueOf(accessKey)));
        }
        if (verbose && (desc = item.getDescription()) != null && desc.length() > 0) {
            speak = mf.concat(speak, desc);
        }
        this.speak(speak, flush, !isLink);
    }

    private int intervalStart(ITreeItem[] siblings, int st) {
        if (siblings == null) {
            return 0;
        }
        --st;
        while (st >= 0 && siblings.length > st) {
            if (!Vocabulary.isConnectable().eval((IEvalTarget)siblings[st])) {
                return st + 1;
            }
            --st;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int intervalEnd(ITreeItem[] siblings, int end) {
        if (siblings != null) ** GOTO lbl6
        return 0;
lbl-1000:
        // 1 sources

        {
            if (!Vocabulary.isConnectable().eval((IEvalTarget)siblings[end])) {
                return end;
            }
            ++end;
lbl6:
            // 2 sources

            ** while (end < siblings.length)
        }
lbl7:
        // 1 sources

        return end - 1;
    }

    protected void setMode(IManipulator.Mode mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        ManipulatorExtension.setMode(mode);
        this.getNavigatorTreeView().setMode(mode);
        switch (mode.code) {
            case 0: {
                ScreenReaderExtension.screenReaderOff();
                if (!ScreenReaderExtension.isAvailable()) break;
                this.webBrowser.showAddressText(false);
                break;
            }
            default: {
                ScreenReaderExtension.screenReaderOn();
            }
        }
    }

    private void enterFormInputMode(ITreeItem item) {
        this.setMode(IManipulator.FORM_INPUT_MODE);
        item.setFocus();
    }

    private void enterFormInputMode() {
        this.setMode(IManipulator.FORM_INPUT_MODE);
    }

    protected IFennecEntry getCurrentEntry() {
        return this.currentEntry;
    }

    private void selectFennec(boolean next, boolean flush) {
        this.selectFennec(next, flush, true);
    }

    private void selectFennec(boolean next, boolean flush, boolean sayFlag) {
        if (this.lastHighlighted != null) {
            try {
                this.lastHighlighted.unhighlight();
            }
            catch (TreeManagerException treeManagerException) {}
        }
        IFennecEntry[] entries = this.fennecMediator.getFennecEntries();
        if (next) {
            if (entries.length == 0) {
                this.speakWithFormat("Navigator.NO_OTHER_FENNEC", true);
                return;
            }
            ++this.currentFennecIdx;
        }
        if (this.currentFennecIdx > entries.length) {
            this.currentFennecIdx = 0;
        }
        try {
            this.restoreLocation(this.getLocation());
            if (this.currentFennecIdx == 0) {
                this.initFennec(null, flush, sayFlag);
            } else {
                this.initFennec(entries[this.currentFennecIdx - 1], flush, sayFlag);
            }
            this.speakActiveItem(false, false, JumpMode.NONE);
        }
        catch (TreeManagerException treeManagerException) {}
    }

    protected void selectUserFennec() {
        if (this.lastHighlighted != null) {
            try {
                this.lastHighlighted.unhighlight();
            }
            catch (TreeManagerException treeManagerException) {}
        }
        IFennecEntry[] entries = this.fennecMediator.getFennecEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isUserEntry()) {
                try {
                    this.restoreLocation(this.getLocation());
                    this.initFennec(entries[i], true, true);
                    this.speakActiveItem(false, false, JumpMode.NONE);
                }
                catch (TreeManagerException treeManagerException) {}
                return;
            }
            ++i;
        }
        this.speakWithFormat("Navigator.NO_OTHER_FENNEC", true);
    }

    public void selectNextFennec() {
        this.selectFennec(true, true);
    }

    void setFennecMediator(IFennecMediator fennecMediator) {
        if (this.fennecMediator != null) {
            this.fennecMediator.release();
        }
        this.fennecMediator = fennecMediator;
        this.treeManager = null;
        this.lastHighlighted = null;
        this.getNavigatorTreeView().clearItem();
    }

    private String getFennecName(IFennecEntry entry) {
        if (entry == null) {
            return this.getMessageFormatter().mes("Navigator.NO_FENNEC_MESSAGE");
        }
        String text = entry.getDocumentation();
        if (text != null && text.length() > 0) {
            return text;
        }
        return this.getMessageFormatter().mes("Navigator.NO_FENNEC_NAME");
    }

    private void initFennec(IFennecEntry entry, boolean flag, boolean sayFlag) throws TreeManagerException {
        block9: {
            this.currentEntry = entry;
            this.treeManager = this.fennecMediator.newTreeManager(entry);
            String fennecName = this.getFennecName(entry);
            if (sayFlag) {
                if (entry == null) {
                    this.sayNoFennec(flag);
                } else {
                    this.sayFennecName(fennecName, flag);
                }
            }
            this.getNavigatorTreeView().showFennecName(fennecName);
            this.setMode(IManipulator.TREE_NAVIGATION_MODE);
            try {
                this.treeManager.initialize();
                if (sayFlag) {
                    this.speakPageInfo();
                }
            }
            catch (TreeManagerException e) {
                if (!sayFlag) break block9;
                this.speakWithFormat(e.getMessage());
            }
        }
        if (!this.skipToAnchor(this.webBrowser.getURL()) && this.locationToBeRestored != null) {
            try {
                this.treeManager.moveToLocation(this.locationToBeRestored);
            }
            catch (TreeManagerException treeManagerException) {}
            this.locationToBeRestored = null;
        }
    }

    public void startNavigation(IWebBrowserACTF webBrowser) {
        this.startNavigation(webBrowser, true);
    }

    public void startNavigation(IWebBrowserACTF webBrowser, boolean sayFlag) {
        this.endProgress();
        if (ScreenReaderExtension.isAvailable() && this.isLeftViewsShown() && !isDemo) {
            this.toggleLeftViewsShowing();
        }
        if (sayFlag) {
            this.speakWithFormat("Navigator.STARTNAVIGATION");
        }
        try {
            this.initFennec(this.fennecMediator.getDefaultFennecEntry(), false, sayFlag);
            this.currentFennecIdx = 1;
            if (sayFlag) {
                this.speakActiveItem(false, false, JumpMode.NONE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ManipulatorExtension.setNavigator(this);
        this.initializeMovieStartListener();
    }

    public void endNavigation() {
        ManipulatorExtension.disposeExtensions();
    }

    private ISoundControl prepareSoundControl() throws TreeManagerException {
        ISoundControl sc = this.treeManager.getSoundControl();
        if (sc.getCount() == 0) {
            this.treeManager.analyze();
            sc = this.treeManager.getSoundControl();
        }
        return sc;
    }

    private IVideoControl prepareVideoControl() throws TreeManagerException {
        IVideoControl vc = this.treeManager.getVideoControl();
        if (vc.getCount() == 0) {
            this.treeManager.analyze();
            vc = this.treeManager.getVideoControl();
        }
        return vc;
    }

    public void muteMedia() {
        ISoundControl sc;
        try {
            sc = this.prepareSoundControl();
        }
        catch (TreeManagerException treeManagerException) {
            return;
        }
        if (sc == null) {
            return;
        }
        if (sc.getCount() == 0) {
            this.speakWithFormat("Navigator.NOSOUND", true);
            return;
        }
        sc.muteMedia();
        if (sc.getVolumeState() == ISoundControl.VolumeState.MUTE) {
            this.speakWithFormat("Navigator.MUTEON", true);
        } else {
            this.speakWithFormat("Navigator.MUTEOFF", true);
        }
    }

    public void volumeDownMedia() {
        ISoundControl sc;
        try {
            sc = this.prepareSoundControl();
        }
        catch (TreeManagerException treeManagerException) {
            return;
        }
        if (sc == null) {
            return;
        }
        if (sc.getCount() == 0) {
            this.speakWithFormat("Navigator.NOSOUND", true);
            return;
        }
        sc.volumeDownMedia();
        if (sc.getVolumeState() == ISoundControl.VolumeState.MIN || sc.getVolumeState() == ISoundControl.VolumeState.MUTE) {
            this.speakWithFormat("Navigator.VOLUMEMIN", true);
        } else {
            this.speakWithFormat("Navigator.VOLUMEDOWN", true);
        }
    }

    public void minimalVolumeDownMedia() {
        ISoundControl sc;
        try {
            sc = this.prepareSoundControl();
        }
        catch (TreeManagerException treeManagerException) {
            return;
        }
        if (sc == null) {
            return;
        }
        if (sc.getCount() == 0) {
            this.speakWithFormat("Navigator.NOSOUND", true);
            return;
        }
        sc.minimalVolumeDownMedia();
        if (sc.getVolumeState() == ISoundControl.VolumeState.MIN || sc.getVolumeState() == ISoundControl.VolumeState.MUTE) {
            this.speakWithFormat("Navigator.VOLUMEMIN", true);
        } else {
            this.speakWithFormat("Navigator.VOLUMEDOWN", true);
        }
    }

    public void volumeUpMedia() {
        ISoundControl sc;
        try {
            sc = this.prepareSoundControl();
        }
        catch (TreeManagerException treeManagerException) {
            return;
        }
        if (sc == null) {
            return;
        }
        if (sc.getCount() == 0) {
            this.speakWithFormat("Navigator.NOSOUND", true);
            return;
        }
        sc.volumeUpMedia();
        if (sc.getVolumeState() == ISoundControl.VolumeState.MAX) {
            this.speakWithFormat("Navigator.VOLUMEMAX", true);
        } else {
            this.speakWithFormat("Navigator.VOLUMEUP", true);
        }
    }

    public void minimalVolumeUpMedia() {
        ISoundControl sc;
        try {
            sc = this.prepareSoundControl();
        }
        catch (TreeManagerException treeManagerException) {
            return;
        }
        if (sc == null) {
            return;
        }
        if (sc.getCount() == 0) {
            this.speakWithFormat("Navigator.NOSOUND", true);
            return;
        }
        sc.minimalVolumeUpMedia();
        if (sc.getVolumeState() == ISoundControl.VolumeState.MAX) {
            this.speakWithFormat("Navigator.VOLUMEMAX", true);
        } else {
            this.speakWithFormat("Navigator.VOLUMEUP", true);
        }
    }

    private void sayVideoState(IVideoControl vc, boolean doPause, IVideoControl.VideoState oldSt) {
        IVideoControl.VideoState st = vc.getVideoState();
        switch (st) {
            case STATE_PLAY: {
                if (doPause) {
                    if (oldSt == IVideoControl.VideoState.STATE_PAUSE) {
                        this.speakWithFormat("Navigator.RESUMEMEDIA");
                        break;
                    }
                    if (oldSt != IVideoControl.VideoState.STATE_PLAY) break;
                    this.speakWithFormat("Navigator.CANNOT_PAUSE");
                    break;
                }
                this.speakWithFormat("Navigator.PLAYMEDIA");
                break;
            }
            case STATE_STOP: {
                this.speakWithFormat("Navigator.STOPMEDIA");
                break;
            }
            case STATE_PAUSE: {
                this.speakWithFormat("Navigator.PAUSEMEDIA");
                break;
            }
            case STATE_WAITING: {
                this.speakWithFormat("Navigator.WAITINGMEDIA");
                break;
            }
            case STATE_FASTFORWARD: {
                this.speakWithFormat("Navigator.FASTFORWARDMEDIA");
                break;
            }
            case STATE_FASTREVERSE: {
                this.speakWithFormat("Navigator.FASTREVERSEMEDIA");
                break;
            }
            case STATE_OTHER: {
                this.speakWithFormat("Navigator.NOT_AVAILABEL");
            }
        }
    }

    public void previousTrack() {
    }

    public void nextTrack() {
    }

    public void stopMedia() {
        try {
            IVideoControl vc = this.prepareVideoControl();
            IVideoControl.VideoState st = vc.getVideoState();
            vc.stopMedia();
            this.sayVideoState(vc, false, st);
        }
        catch (TreeManagerException treeManagerException) {}
    }

    public void playMedia() {
        try {
            IVideoControl vc = this.prepareVideoControl();
            IVideoControl.VideoState st = vc.getVideoState();
            vc.playMedia();
            this.sayVideoState(vc, false, st);
        }
        catch (TreeManagerException treeManagerException) {}
    }

    public void pauseMedia() {
        try {
            IVideoControl vc = this.prepareVideoControl();
            IVideoControl.VideoState st = vc.getVideoState();
            vc.pauseMedia();
            this.sayVideoState(vc, true, st);
        }
        catch (TreeManagerException treeManagerException) {}
    }

    public void fastReverse() {
    }

    public void fastForward() {
    }

    private void afterMove(int st, String notMoved) throws TreeManagerException {
        this.afterMove(st, notMoved, null);
    }

    private void afterMove(int st, String notMoved, JumpMode jumpMode) throws TreeManagerException {
        if ((st & 8) != 0) {
            this.speakWithFormat("Navigator.CLICK");
        } else if ((st & 1) != 0) {
            this.speakActiveItem(true, false, jumpMode);
            this.sayLevel();
        } else {
            this.sayLevel(notMoved);
        }
        this.speakAllMode = false;
    }

    private void moveCmd(Command cmd) {
        if (this.treeManager == null) {
            return;
        }
        int i = 0;
        while (i < this.maxRetry) {
            try {
                int st = cmd.run(i);
                cmd.after(st);
                return;
            }
            catch (TreeManagerInterruptedException treeManagerInterruptedException) {
                this.sayRetrial();
                this.sleep(this.retryInterval);
            }
            catch (TreeManagerException treeManagerException) {}
            ++i;
        }
    }

    private boolean skipToAnchor(String url) throws TreeManagerException {
        int hashIdx = url.lastIndexOf(35);
        if (hashIdx < 0) {
            return false;
        }
        if (++hashIdx >= url.length()) {
            return false;
        }
        String target = url.substring(hashIdx);
        this.treeManager.skipToAnchor(target);
        return true;
    }

    public void treeLeft() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                return NavigatorImpl.this.treeManager.gotoParent();
            }

            public void after(int st) throws TreeManagerException {
                NavigatorImpl.this.afterMove(st, "Navigator.TOP");
            }
        });
    }

    public void treeRight() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                return NavigatorImpl.this.treeManager.gotoFirstChild();
            }

            public void after(int st) throws TreeManagerException {
                NavigatorImpl.this.afterMove(st, "Navigator.NO_SUBITEMS");
            }
        });
    }

    public void treeUp() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                return NavigatorImpl.this.treeManager.gotoPreviousSibling();
            }

            public void after(int st) throws TreeManagerException {
                NavigatorImpl.this.afterMove(st, "Navigator.TOP");
            }
        });
    }

    public void treeDown() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                return NavigatorImpl.this.treeManager.gotoNextSibling();
            }

            public void after(int st) throws TreeManagerException {
                NavigatorImpl.this.afterMove(st, "Navigator.BOTTOM");
            }
        });
    }

    public void treeTop() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                return NavigatorImpl.this.treeManager.gotoStartOfPage();
            }

            public void after(int st) throws TreeManagerException {
                NavigatorImpl.this.speakTab();
                NavigatorImpl.this.listJumping = false;
            }
        });
    }

    public void treeBottom() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                return NavigatorImpl.this.treeManager.gotoEndOfPage();
            }

            public void after(int st) throws TreeManagerException {
                NavigatorImpl.this.afterMove(st, "Navigator.BOTTOM");
            }
        });
    }

    public void traverseNodeDown() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                int moved;
                int rFlag = 0;
                do {
                    moved = NavigatorImpl.this.treeManager.traverse(false);
                    rFlag |= moved;
                } while ((moved & 2) == 0 && (moved & 1) != 0);
                return moved | rFlag;
            }

            public void after(int st) throws TreeManagerException {
                NavigatorImpl.this.afterMove(st, "Navigator.BOTTOM");
            }
        });
    }

    public void traverseNodeUp() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                int moved;
                int rFlag = 0;
                do {
                    moved = NavigatorImpl.this.treeManager.traverse(true);
                    rFlag |= moved;
                } while ((moved & 2) == 0 && (moved & 1) != 0);
                return moved | rFlag;
            }

            public void after(int st) throws TreeManagerException {
                NavigatorImpl.this.afterMove(st, "Navigator.TOP");
            }
        });
    }

    public void traverseDown() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                return NavigatorImpl.this.treeManager.traverse(false);
            }

            public void after(int st) throws TreeManagerException {
                if ((st & 1) == 0) {
                    NavigatorImpl.this.beep();
                    NavigatorImpl.this.speak(NavigatorImpl.this.getMessageFormatter().mes("Navigator.BOTTOM"), true, false);
                    NavigatorImpl.this.speakActiveItem(false, false, JumpMode.NONE);
                } else {
                    NavigatorImpl.this.afterMove(st, "Navigator.BOTTOM");
                }
            }
        });
    }

    public void traverseUp() {
        this.moveCmd(new Command(){

            public int run(int r) throws TreeManagerException {
                return NavigatorImpl.this.treeManager.traverse(true);
            }

            public void after(int st) throws TreeManagerException {
                if ((st & 1) == 0) {
                    NavigatorImpl.this.beep();
                    NavigatorImpl.this.speak(NavigatorImpl.this.getMessageFormatter().mes("Navigator.TOP"), true, false);
                    NavigatorImpl.this.speakTab(false);
                } else {
                    NavigatorImpl.this.afterMove(st, "Navigator.TOP");
                }
            }
        });
    }

    public void click() {
        try {
            ITreeItem item = this.treeManager.getActiveItem();
            if (item == null) {
                return;
            }
            item.unhighlight();
            if (Vocabulary.isFileEdit().eval((IEvalTarget)item) || Vocabulary.isCheckbox().eval((IEvalTarget)item) || Vocabulary.isRadio().eval((IEvalTarget)item) || !Vocabulary.isInputable().eval((IEvalTarget)item) && !Vocabulary.isSelectable().eval((IEvalTarget)item)) {
                this.moveCmd(new Command(){

                    public int run(int r) throws TreeManagerException {
                        if (r == 0) {
                            return NavigatorImpl.this.treeManager.click(true);
                        }
                        return NavigatorImpl.this.treeManager.click(false);
                    }

                    public void after(int st) throws TreeManagerException {
                        NavigatorImpl.this.afterMove(st, "Navigator.CLICK");
                    }
                });
                return;
            }
            this.setMode(IManipulator.KEYHOOK_DISABLED_MODE);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean combo = Vocabulary.isCombobox().eval((IEvalTarget)item);
            if (combo) {
                boolean multiple = Vocabulary.isMultiSelectable().eval((IEvalTarget)item);
                FormSelectDialog dialog = new FormSelectDialog(shell, item, multiple);
                if (dialog.open() == 0) {
                    int[] indices = dialog.getSelectedIndices();
                    int total = dialog.getLength();
                    if (indices != null) {
                        item.setSelectedIndices(indices);
                        if (indices.length > 0) {
                            StringBuffer sb = new StringBuffer();
                            int i = 0;
                            while (i < indices.length) {
                                String text = dialog.getTextAt(indices[i]);
                                sb.append(String.valueOf(text) + " " + this.getMessageFormatter().mes("Navigator.N_OF_M", indices[i] + 1, total) + " ");
                                ++i;
                            }
                            this.speak(sb.toString(), true);
                        } else {
                            this.speakWithFormat("Navigator.COMBO_BOX_NOSELECTION");
                        }
                    }
                }
            } else {
                String result;
                boolean multiline = Vocabulary.isMultilineEdit().eval((IEvalTarget)item);
                boolean pass = Vocabulary.isPassword().eval((IEvalTarget)item);
                FormInputDialog dialog = new FormInputDialog(shell, item.getText(), multiline, pass);
                if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
                    item.setText(dialog.getResult());
                    if (pass) {
                        if (item.getText().length() > 0) {
                            this.speakWithFormat(this.getMessageFormatter().mes("Navigator.PASSWORD_STAR3"));
                        }
                    } else {
                        this.speakWithFormat(item.getText());
                    }
                }
            }
            this.setMode(IManipulator.TREE_NAVIGATION_MODE);
            item.highlight();
        }
        catch (TreeManagerException e) {
            e.printStackTrace();
        }
    }

    protected void findNext(final IProposition p, final JumpMode jumpMode) {
        this.moveCmd(new Command(){
            ILocation current;

            public int run(int r) throws TreeManagerException {
                NavigatorImpl.this.startProgress();
                this.current = NavigatorImpl.this.getLocation();
                return NavigatorImpl.this.treeManager.findNext(p);
            }

            public void after(int st) throws TreeManagerException {
                if ((st & 1) == 0) {
                    if (jumpMode != JumpMode.LISTITEM_TOP) {
                        NavigatorImpl.this.beep();
                    }
                    NavigatorImpl.this.speak(NavigatorImpl.this.getMessageFormatter().mes("Navigator.WRAPPING_TO_TOP"), true, false);
                    NavigatorImpl.this.moveCmd(new Command(){

                        public int run(int r) throws TreeManagerException {
                            NavigatorImpl.this.treeManager.gotoStartOfPage();
                            return NavigatorImpl.this.treeManager.findNext(p);
                        }

                        public void after(int st) throws TreeManagerException {
                            if ((st & 1) == 0) {
                                NavigatorImpl.this.treeManager.moveToLocation(current);
                            }
                            NavigatorImpl.this.afterFind(st, jumpMode);
                            NavigatorImpl.this.endProgress();
                        }
                    });
                } else {
                    NavigatorImpl.this.afterMove(st, "Navigator.BOTTOM", jumpMode);
                    NavigatorImpl.this.endProgress();
                }
            }
        });
    }

    private void afterFind(int st, JumpMode jumpMode) throws TreeManagerException {
        this.afterFind(st, jumpMode, null);
    }

    private void afterFind(int st, JumpMode jumpMode, Object arg) throws TreeManagerException {
        if ((st & 1) != 0) {
            this.speakActiveItem(false, false, jumpMode);
        } else {
            String buf = "";
            if (jumpMode == JumpMode.HEADING) {
                buf = this.getMessageFormatter().mes("Navigator.NO_HEADING");
            } else if (jumpMode == JumpMode.BLOCK) {
                buf = this.getMessageFormatter().mes("Navigator.NO_BLOCK");
            } else if (jumpMode == JumpMode.INPUT) {
                buf = this.getMessageFormatter().mes("Navigator.NO_INPUT");
            } else if (jumpMode == JumpMode.LINK) {
                buf = this.getMessageFormatter().mes("Navigator.NO_LINK");
            } else if (jumpMode == JumpMode.LISTITEM_TOP || jumpMode == JumpMode.LISTITEM_BOTTOM) {
                buf = this.getMessageFormatter().mes("Navigator.NO_LISTITEM");
            } else if (jumpMode == JumpMode.OBJECT) {
                buf = this.getMessageFormatter().mes("Navigator.NO_OBJECT");
            } else if (jumpMode == JumpMode.MEDIA) {
                buf = this.getMessageFormatter().mes("Navigator.NO_MEDIA");
            } else if (jumpMode == JumpMode.ACCESSKEY) {
                buf = this.getMessageFormatter().mes("Navigator.NO_ACCESSKEY", arg);
            } else if (jumpMode == JumpMode.ALTALABLE) {
                buf = this.getMessageFormatter().mes("Navigator.NO_ALTALABLE");
            }
            this.speak(buf, true, false);
        }
        this.speakAllMode = false;
    }

    protected void findPrevious(final IProposition p, final JumpMode jumpMode) {
        this.moveCmd(new Command(){
            private ILocation current;

            public int run(int r) throws TreeManagerException {
                NavigatorImpl.this.startProgress();
                this.current = NavigatorImpl.this.getLocation();
                return NavigatorImpl.this.treeManager.findPrevious(p);
            }

            public void after(int st) throws TreeManagerException {
                if ((st & 1) == 0) {
                    if (jumpMode != JumpMode.LISTITEM_BOTTOM) {
                        NavigatorImpl.this.beep();
                    }
                    NavigatorImpl.this.speak(NavigatorImpl.this.getMessageFormatter().mes("Navigator.WRAPPING_TO_BOTTOM"), true, false);
                    NavigatorImpl.this.moveCmd(new Command(){

                        public int run(int r) throws TreeManagerException {
                            NavigatorImpl.this.treeManager.gotoEndOfPageForFind();
                            return NavigatorImpl.this.treeManager.findPrevious(p);
                        }

                        public void after(int st) throws TreeManagerException {
                            if ((st & 1) == 0) {
                                NavigatorImpl.this.treeManager.moveToLocation(current);
                            }
                            NavigatorImpl.this.afterFind(st, jumpMode);
                            NavigatorImpl.this.endProgress();
                        }
                    });
                } else {
                    NavigatorImpl.this.afterMove(st, "Navigator.TOP", jumpMode);
                    NavigatorImpl.this.endProgress();
                }
            }
        });
    }

    public void nextHeader() {
        this.findNext(Vocabulary.isHeading(), JumpMode.HEADING);
    }

    public void previousHeader() {
        this.findPrevious(Vocabulary.isHeading(), JumpMode.HEADING);
    }

    public void nextInputable() {
        this.findNext(Vocabulary.or((IProposition[])new IProposition[]{Vocabulary.isInputable(), Vocabulary.isSelectable()}), JumpMode.INPUT);
    }

    public void previousInputable() {
        this.findPrevious(Vocabulary.or((IProposition[])new IProposition[]{Vocabulary.isInputable(), Vocabulary.isSelectable()}), JumpMode.INPUT);
    }

    public void nextLink() {
        this.findNext(Vocabulary.or((IProposition[])new IProposition[]{Vocabulary.isClickable(), Vocabulary.isInputable(), Vocabulary.isSelectable()}), JumpMode.LINK);
    }

    public void previousLink() {
        this.findPrevious(Vocabulary.or((IProposition[])new IProposition[]{Vocabulary.isClickable(), Vocabulary.isInputable(), Vocabulary.isSelectable()}), JumpMode.LINK);
    }

    public void nextObject() {
        this.findNext(Vocabulary.isEmbeddedObject(), JumpMode.OBJECT);
    }

    public void previousObject() {
        this.findPrevious(Vocabulary.isEmbeddedObject(), JumpMode.OBJECT);
    }

    public void nextListItem() {
        this.findNext(Vocabulary.isListItem(), JumpMode.LISTITEM_TOP);
    }

    public void previousListItem() {
        this.findPrevious(Vocabulary.isListItem(), JumpMode.LISTITEM_BOTTOM);
    }

    public void nextBlock() {
        this.findNext(Vocabulary.isBlockJumpPointF(), JumpMode.BLOCK);
    }

    public void previousBlock() {
        this.findPrevious(Vocabulary.isBlockJumpPointB(), JumpMode.BLOCK);
    }

    public void nextMedia() {
        this.findNext(Vocabulary.isMedia(), JumpMode.MEDIA);
    }

    public void previousMedia() {
        this.findPrevious(Vocabulary.isMedia(), JumpMode.MEDIA);
    }

    public void nextHeader1() {
        this.findNext(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading1()}), JumpMode.HEADING);
    }

    public void nextHeader2() {
        this.findNext(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading2()}), JumpMode.HEADING);
    }

    public void nextHeader3() {
        this.findNext(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading3()}), JumpMode.HEADING);
    }

    public void nextHeader4() {
        this.findNext(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading4()}), JumpMode.HEADING);
    }

    public void nextHeader5() {
        this.findNext(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading5()}), JumpMode.HEADING);
    }

    public void nextHeader6() {
        this.findNext(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading6()}), JumpMode.HEADING);
    }

    public void previousHeader1() {
        this.findPrevious(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading1()}), JumpMode.HEADING);
    }

    public void previousHeader2() {
        this.findPrevious(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading2()}), JumpMode.HEADING);
    }

    public void previousHeader3() {
        this.findPrevious(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading3()}), JumpMode.HEADING);
    }

    public void previousHeader4() {
        this.findPrevious(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading4()}), JumpMode.HEADING);
    }

    public void previousHeader5() {
        this.findPrevious(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading5()}), JumpMode.HEADING);
    }

    public void previousHeader6() {
        this.findPrevious(Vocabulary.and((IProposition[])new IProposition[]{Vocabulary.isHeading(), Vocabulary.isHeading6()}), JumpMode.HEADING);
    }

    public void jumpToAccessKey(final char key) {
        this.moveCmd(new Command(){
            ILocation current;

            public int run(int r) throws TreeManagerException {
                NavigatorImpl.this.startProgress();
                this.current = NavigatorImpl.this.getLocation();
                return NavigatorImpl.this.treeManager.findNext(Vocabulary.isAccessKey((char)key));
            }

            public void after(int st) throws TreeManagerException {
                if ((st & 1) == 0) {
                    NavigatorImpl.this.moveCmd(new Command(){

                        public int run(int r) throws TreeManagerException {
                            NavigatorImpl.this.treeManager.gotoStartOfPage();
                            return NavigatorImpl.this.treeManager.findNext(Vocabulary.isAccessKey((char)key));
                        }

                        public void after(int st) throws TreeManagerException {
                            if ((st & 1) == 0) {
                                NavigatorImpl.this.treeManager.moveToLocation(current);
                                NavigatorImpl.this.afterFind(st, JumpMode.ACCESSKEY, Character.valueOf(key));
                            } else {
                                NavigatorImpl.this.afterAccessKeyJump(st);
                            }
                            NavigatorImpl.this.endProgress();
                        }
                    });
                } else {
                    NavigatorImpl.this.afterAccessKeyJump(st);
                    NavigatorImpl.this.endProgress();
                }
            }
        });
    }

    private void afterAccessKeyJump(int st) throws TreeManagerException {
        ITreeItem item = this.treeManager.getActiveItem();
        boolean isCheckbox = Vocabulary.isCheckbox().eval((IEvalTarget)item);
        boolean isRadio = Vocabulary.isRadio().eval((IEvalTarget)item);
        if (isRadio || isCheckbox) {
            this.click();
            this.speakActiveItem(true, false, JumpMode.NONE);
        } else {
            this.afterMove(st, "Navigator.BOTTOM", JumpMode.ACCESSKEY);
        }
    }

    public void showAccessKeyList() {
        try {
            char key;
            this.setMode(IManipulator.KEYHOOK_DISABLED_MODE);
            IAccessKeyList list = this.treeManager.getAccessKeyList();
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            AccessKeyListDialog dialog = new AccessKeyListDialog(shell, list);
            if (dialog.open() == 0 && (key = dialog.getSelectedKey()) != '\u0000') {
                this.jumpToAccessKey(key);
            }
            this.setMode(IManipulator.TREE_NAVIGATION_MODE);
        }
        catch (TreeManagerException e) {
            e.printStackTrace();
        }
    }

    public void searchNext() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SearchDialog dialog = new SearchDialog(shell);
        dialog.setForward(true);
        if (dialog.open() == 1 || dialog.getString() == null || dialog.getString().length() == 0) {
            return;
        }
        this.moveCmd(new FindCommand(dialog.getString(), dialog.isForward(), dialog.isExact()));
    }

    public void searchPrevious() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SearchDialog dialog = new SearchDialog(shell);
        dialog.setForward(false);
        if (dialog.open() == 1 || dialog.getString() == null || dialog.getString().length() == 0) {
            return;
        }
        this.moveCmd(new FindCommand(dialog.getString(), dialog.isForward(), dialog.isExact()));
    }

    public void cellLeft() {
    }

    public void cellRight() {
    }

    public void cellUp() {
    }

    public void cellDown() {
    }

    private void saySpeechSpeed(int speed) {
        String mes = this.getMessageFormatter().mes("Navigator.SPEECHSPEED", new Object[]{new Integer(speed)});
        this.speakWithFormat(mes, true);
    }

    public void speechSpeedUp() {
        int nextSpeed = this.getVoiceManager().getSpeed() + 10;
        if (100 < nextSpeed) {
            this.speakWithFormat("Navigator.SPEECHSPEEDMAX", true);
        } else {
            this.getVoiceManager().setSpeed(nextSpeed);
            this.saySpeechSpeed(nextSpeed);
        }
    }

    public void speechSpeedDown() {
        int nextSpeed = this.getVoiceManager().getSpeed() - 10;
        if (nextSpeed < 0) {
            this.speakWithFormat("Navigator.SPEECHSPEEDMIN", true);
        } else {
            this.getVoiceManager().setSpeed(nextSpeed);
            this.saySpeechSpeed(nextSpeed);
        }
    }

    public void exitFormMode() {
        this.setMode(IManipulator.TREE_NAVIGATION_MODE);
    }

    public void submitForm() {
    }

    public ILocation getLocation() {
        if (this.treeManager == null) {
            return null;
        }
        try {
            return this.treeManager.getCurrentLocation();
        }
        catch (TreeManagerException treeManagerException) {
            return null;
        }
    }

    public void restoreLocation(ILocation location) {
        this.locationToBeRestored = location;
    }

    IMediaControl.IHandle getMediaControlHandle() {
        return this.handle;
    }

    public void toggleDescriptionEnable() {
        int result = MediaControlExtension.toggleEnable();
        switch (result) {
            case 1: {
                this.speakWithFormat("AudioDescription.noExtension");
                break;
            }
            case 2: {
                this.speakWithFormat("AudioDescription.on");
                break;
            }
            case 4: {
                this.speakWithFormat("AudioDescription.off");
                break;
            }
            case 8: {
                this.speakWithFormat("AudioDescription.notAvailable");
            }
        }
    }

    private void initializeMovieStartListener() {
        IMediaControl.IHandle mediaControlHandle = this.getMediaControlHandle();
        IVideoControl video = mediaControlHandle.getVideoControl();
        if (this.listener != null) {
            this.listener.stop();
        }
        this.listener = new MovieStartListener(video);
        if (video != null) {
            video.addEventListener((IMediaSyncEventListener)this.listener);
        }
    }

    public FocusTabResult focusTab() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorReference[] erefs = page.getEditorReferences();
        IEditorPart editor = page.getActiveEditor();
        int i = 0;
        while (i < erefs.length) {
            IEditorPart part = erefs[i].getEditor(false);
            IModelServiceHolder modelServiceHolder = (IModelServiceHolder)part;
            IWebBrowserACTF wb = (IWebBrowserACTF)modelServiceHolder.getModelService();
            if (wb == this.webBrowser) {
                if (editor != part) {
                    page.activate((IWorkbenchPart)part);
                    return FocusTabResult.CHANGED;
                }
                return FocusTabResult.STAY;
            }
            ++i;
        }
        return FocusTabResult.NOTFOUND;
    }

    public boolean isFocused() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorReference[] erefs = page.getEditorReferences();
        IEditorPart editor = page.getActiveEditor();
        int i = 0;
        while (i < erefs.length) {
            IEditorPart part = erefs[i].getEditor(false);
            IModelServiceHolder modelServiceHolder = (IModelServiceHolder)part;
            IWebBrowserACTF wb = (IWebBrowserACTF)modelServiceHolder.getModelService();
            if (wb == this.webBrowser) {
                return editor == part;
            }
            ++i;
        }
        System.err.println("Internal Error: WebBrowser:" + this.webBrowser + " is not managed in the editor");
        return false;
    }

    public String getCurrentURL() {
        return this.webBrowser.getURL();
    }

    public void enterBrowserAddress() {
        if (PlatformUIUtil.getActiveEditor() == null) {
            this.speakWithFormat("Navigator.THERE_ARE_NO_TAB");
            return;
        }
        this.webBrowser.setFocusAddressText(true);
        this.speakWithFormat("Navigator.ENTERBROWSERADDRESS", false);
        this.enterFormInputMode();
    }

    public void forceRestart(boolean flush) {
        this.selectFennec(false, flush);
        MediaControlExtension.doDispose(this.getMediaControlHandle());
        MediaControlExtension.start(this.getMediaControlHandle());
        this.initializeMovieStartListener();
    }

    public void forceRestart() {
        this.forceRestart(true);
    }

    public void navigateRefresh() {
        this.startProgress();
        String buf = this.getMessageFormatter().mes("Navigator.REFRESH");
        this.speak(buf, true, false);
        this.webBrowser.navigateRefresh();
    }

    public void closeTab() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (editor != null && editor instanceof IModelServiceHolder) {
            ManipulatorExtension.setNavigator(null);
            page.closeEditor(editor, false);
        }
    }

    public void nextTab() {
        this.gotoTab(1);
    }

    public void prevTab() {
        this.gotoTab(-1);
    }

    private void gotoTab(int n) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorReference[] erefs = page.getEditorReferences();
        IEditorPart editor = page.getActiveEditor();
        int i = 0;
        while (i < erefs.length) {
            IEditorPart part;
            if (erefs[i].getEditor(false).equals(editor) && (part = (n += i) >= erefs.length ? erefs[0].getEditor(false) : (n < 0 ? erefs[erefs.length - 1].getEditor(false) : erefs[n].getEditor(false))) != null) {
                page.activate((IWorkbenchPart)part);
            }
            ++i;
        }
        this.speakTab();
    }

    public void goBackward() {
        this.webBrowser.goBackward();
    }

    public void goForward() {
        this.webBrowser.goForward();
    }

    public boolean gotoUrl(String url) {
        this.webBrowser.navigate(url);
        return true;
    }

    public void launchBrowser() {
        BrowserLaunch.launch((String)this.webBrowser.getURL());
        String buf = this.getMessageFormatter().mes("Navigator.LAUNCH_DEFAULT_BROWSER", this.webBrowser.getURL());
        this.speak(buf, true, false);
    }

    public boolean isLeftViewsShown() {
        return this.getNavigatorTreeView().isShown();
    }

    public void toggleLeftViewsShowing() {
        boolean result = this.getNavigatorTreeView().toggleViewShowing();
        boolean result2 = MediaControlExtension.toggleViewShowing();
        while (result != result2) {
            result2 = MediaControlExtension.toggleViewShowing();
        }
        if (result) {
            this.speakWithFormat("Navigator.VIEWS_ARE_OPEND", true);
        } else {
            this.speakWithFormat("Navigator.VIEWS_ARE_CLOSED", true);
        }
    }

    public void exportMetadata() {
        if (this.getCurrentEntry() == null) {
            this.speakWithFormat("Navigator.NO_ANNOTATION");
            return;
        }
        String[] ext = new String[]{"*.fnc"};
        this.speakWithFormat("Navigator.EXPORT_ANNOTATION");
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setFilterExtensions(ext);
        String path = fileDialog.open();
        if (path != null) {
            String message;
            String title;
            boolean ret;
            File dest;
            if (!path.endsWith(".fnc")) {
                path = String.valueOf(path) + ".fnc";
            }
            if ((dest = new File(path)).exists() && !(ret = MessageDialog.openQuestion((Shell)shell, (String)(title = this.getMessageFormatter().mes("Navigator.OVERWRITE_CONFIRM")), (String)(message = this.getMessageFormatter().mes("Navigator.OVERWRITE_MESSAGE", dest.getName()))))) {
                return;
            }
            if (this.getCurrentEntry().isUserEntry()) {
                if (this.getCurrentEntry().export(dest)) {
                    this.speakWithFormat("Navigator.EXPORT_IS_SUCCEEDED");
                } else {
                    this.speakWithFormat("Navigator.EXPORT_IS_FAILED");
                }
            }
        }
    }

    public void repairFlash() {
        this.startProgress(0);
        try {
            this.treeManager.repairFlash();
            this.speakWithFormat("Navigator.REPAIR_FINISHED");
            this.restoreLocation(this.getLocation());
            this.selectFennec(false, false, false);
        }
        catch (TreeManagerException e) {
            e.printStackTrace();
        }
        this.endProgress();
    }

    public void speakTitle(String title) {
        try {
            this.speak(title, true, true);
        }
        catch (Exception exception) {}
    }

    public void speakTab() {
        this.speakTab(true);
    }

    public void speakOpenTab() {
        this.speakWithFormat(this.getMessageFormatter().mes("Navigator.NEW_TAB"));
    }

    public void navigateComplete() {
        this.startProgress();
    }

    public void speakCloseTab(String title) {
        this.speak(this.getMessageFormatter().mes("Navigator.CLOSE_TAB", title), true, true);
    }

    void beforeNavigation(String uri) {
        this.prevPercent = -4;
    }

    void progressChange(int progress, int progressMax) {
        if (progressMax == 0) {
            return;
        }
        if (progress == -1) {
            this.progressTimer = 0L;
            return;
        }
        long current = System.currentTimeMillis();
        if (current - this.progressTimer > 10000L) {
            this.prevPercent = -4;
        }
        if (progressMax < 10000) {
            progressMax = 1000;
        }
        progressMax = (int)Math.pow(10.0, (int)Math.log10(progressMax) + 1);
        int percent = progress * 100 / progressMax;
        if (progress * 10 == progressMax) {
            percent = 100;
        }
        if (!(this.progressTimer != 0L && current - this.progressTimer < 2000L || 5 >= percent || percent >= 100 || percent - this.prevPercent < 5 && this.prevPercent - percent <= 10)) {
            this.sayProgress(percent);
            this.prevPercent = percent;
            this.progressTimer = current;
        }
    }

    private void sayProgress(int percent) {
        if (percent < 0) {
            percent = 0;
        } else if (percent > 100) {
            percent = 100;
        }
        String mes = this.getMessageFormatter().mes("Navigator.PROGRESS", new Object[]{new Integer(percent)});
        this.speak(mes, true, true);
    }

    static interface Command {
        public int run(int var1) throws TreeManagerException;

        public void after(int var1) throws TreeManagerException;
    }

    class FindCommand
    implements Command {
        private String str;
        private boolean direction;
        private boolean exact;

        FindCommand(String str, boolean direction, boolean exact) {
            this.str = str;
            this.direction = direction;
            this.exact = exact;
        }

        public int run(int r) throws TreeManagerException {
            if (this.direction) {
                return NavigatorImpl.this.treeManager.findNext(Vocabulary.find((String)this.str, (boolean)this.exact));
            }
            return NavigatorImpl.this.treeManager.findPrevious(Vocabulary.find((String)this.str, (boolean)this.exact));
        }

        public void after(int st) throws TreeManagerException {
            if (this.direction) {
                NavigatorImpl.this.afterMove(st, "Navigator.BOTTOM");
            } else {
                NavigatorImpl.this.afterMove(st, "Navigator.TOP");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FocusTabResult {
        STAY,
        CHANGED,
        NOTFOUND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum JumpMode {
        HEADING,
        LISTITEM_TOP,
        LINK,
        OBJECT,
        BLOCK,
        INPUT,
        LISTITEM_BOTTOM,
        ACCESSKEY,
        MEDIA,
        ALTALABLE,
        NONE;

    }

    private class MediaControlHandle
    implements IMediaControl.IHandle {
        private MediaControlHandle() {
        }

        public ISoundControl getSoundControl() {
            if (NavigatorImpl.this.treeManager == null) {
                return null;
            }
            try {
                return NavigatorImpl.this.treeManager.getSoundControl();
            }
            catch (TreeManagerException treeManagerException) {
                return null;
            }
        }

        public IVideoControl getVideoControl() {
            if (NavigatorImpl.this.treeManager == null) {
                return null;
            }
            try {
                return NavigatorImpl.this.treeManager.getVideoControl();
            }
            catch (TreeManagerException treeManagerException) {
                return null;
            }
        }

        public IVoice getVoice() {
            return NavigatorImpl.this.getVoiceManager();
        }

        public IWebBrowserACTF getWebBrowser() {
            return NavigatorImpl.this.webBrowser;
        }
    }

    class MovieStartListener
    implements IMediaSyncEventListener {
        IVideoControl video;
        private boolean stopFlag = false;
        private boolean topFlag = true;

        public MovieStartListener(IVideoControl video) {
            this.video = video;
        }

        public void stop() {
            this.stopFlag = true;
        }

        public double getInterval() {
            return 0.1;
        }

        public void run() {
            if (this.stopFlag) {
                return;
            }
            double time = this.video.getCurrentPosition();
            if (this.topFlag) {
                if (0.1 < time && time < 3.0) {
                    NavigatorImpl.this.speakWithFormat("Navigator.MOVIE_START");
                    this.topFlag = false;
                }
            } else if (time < 0.1) {
                this.topFlag = true;
            }
        }
    }
}

