/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.extension;

import java.util.ArrayList;
import org.eclipse.actf.ai.navigator.IMediaControl;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class MediaControlExtension {
    private static final String TAG_CONTROLLER = "controller";
    private static final String ATTR_CLASS = "class";
    private static MediaControlExtension[] cachedExtensions;
    private final IConfigurationElement configElement;
    private IMediaControl controller;

    public static MediaControlExtension[] getExtensions() {
        if (cachedExtensions != null) {
            return cachedExtensions;
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.ai.navigator", "MediaControl").getExtensions();
        ArrayList<MediaControlExtension> l = new ArrayList<MediaControlExtension>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                MediaControlExtension ex = MediaControlExtension.parseExtension(configElements[j], l.size());
                if (ex != null) {
                    l.add(ex);
                }
                ++j;
            }
            ++i;
        }
        cachedExtensions = l.toArray(new MediaControlExtension[l.size()]);
        return cachedExtensions;
    }

    private static MediaControlExtension parseExtension(IConfigurationElement configElement, int idx) {
        if (!configElement.getName().equals(TAG_CONTROLLER)) {
            return null;
        }
        try {
            return new MediaControlExtension(configElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void disposeExtensions() {
        if (cachedExtensions == null) {
            return;
        }
        int i = 0;
        while (i < cachedExtensions.length) {
            cachedExtensions[i].dispose();
            ++i;
        }
        cachedExtensions = null;
    }

    public static void start(IMediaControl.IHandle handle) {
        MediaControlExtension[] exs = MediaControlExtension.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getMediaControl().start(handle);
            ++i;
        }
    }

    public static void doDispose(IMediaControl.IHandle handle) {
        MediaControlExtension[] exs = MediaControlExtension.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getMediaControl().dispose(handle);
            ++i;
        }
    }

    private MediaControlExtension(IConfigurationElement configElement) {
        this.configElement = configElement;
    }

    private IMediaControl getMediaControl() {
        if (this.controller != null) {
            return this.controller;
        }
        try {
            this.controller = (IMediaControl)this.configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.controller;
    }

    private void dispose() {
        if (this.controller == null) {
            return;
        }
        this.controller = null;
    }

    public static int toggleEnable() {
        MediaControlExtension[] exs = MediaControlExtension.getExtensions();
        int result = 0;
        if (exs == null) {
            return 1;
        }
        int i = 0;
        while (i < exs.length) {
            result |= exs[i].getMediaControl().toggleEnabled();
            ++i;
        }
        return result;
    }

    public static boolean isAvailable() {
        MediaControlExtension[] exs = MediaControlExtension.getExtensions();
        if (exs == null) {
            return false;
        }
        boolean ret = false;
        int i = 0;
        while (i < exs.length) {
            ret |= exs[i].getMediaControl().isAvailable();
            ++i;
        }
        return ret;
    }

    public static boolean toggleViewShowing() {
        MediaControlExtension[] exs = MediaControlExtension.getExtensions();
        boolean result = true;
        int i = 0;
        while (i < exs.length) {
            result = exs[i].getMediaControl().toggleViewShowing() && result;
            ++i;
        }
        return result;
    }

    public static boolean isEnabled() {
        MediaControlExtension[] exs = MediaControlExtension.getExtensions();
        if (exs == null) {
            return false;
        }
        boolean ret = false;
        int i = 0;
        while (i < exs.length) {
            ret |= exs[i].getMediaControl().isEnabled();
            ++i;
        }
        return ret;
    }

    public static void speakInfo(boolean flush) {
        MediaControlExtension[] exs = MediaControlExtension.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getMediaControl().speakInfo(flush);
            ++i;
        }
    }
}

